/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.editor.highlights;

import com.mathworks.matlab.api.editor.EditorRegion;
import com.mathworks.matlab.api.editor.highlighting.EditorHighlighter;
import com.mathworks.widgets.editor.EditorRegionImpl;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.BaseDocument;

public abstract class AbstractEditorHighlighter
implements EditorHighlighter {
    private final List<EditorHighlighter.HighlighterUpdateListener> fListeners = new ArrayList<EditorHighlighter.HighlighterUpdateListener>();
    private final List<EditorRegion> fRegions = new ArrayList<EditorRegion>();
    private BaseDocument fDocument;
    private boolean fIsEnabled;
    private Color fColor;

    public AbstractEditorHighlighter(Color color) {
        Validate.notNull((Object)color, (String)"The Color should not be null");
        this.fColor = color;
    }

    public final void setDocument(BaseDocument baseDocument) {
        this.fDocument = baseDocument;
    }

    protected final BaseDocument getDocument() {
        return this.fDocument;
    }

    public EditorRegion addRegion(int n, int n2) {
        EditorRegion editorRegion = EditorRegionImpl.createEditorRegion(this.fDocument, n, n2);
        return this.addRegion(editorRegion);
    }

    protected EditorRegion addRegion(EditorRegion editorRegion) {
        this.fRegions.add(editorRegion);
        this.fireUpdate();
        return editorRegion;
    }

    public void removeRegion(EditorRegion editorRegion) {
        this.removeRegions(Arrays.asList(editorRegion), true);
    }

    public void removeRegions(List<EditorRegion> list, boolean bl) {
        this.fRegions.removeAll(list);
        if (bl) {
            this.fireUpdate();
        }
    }

    protected final void setEnabled(boolean bl) {
        this.fIsEnabled = bl;
        this.fireUpdate();
    }

    public final boolean isEnabled() {
        return this.fIsEnabled;
    }

    public final void addListener(EditorHighlighter.HighlighterUpdateListener highlighterUpdateListener) {
        this.fListeners.add(highlighterUpdateListener);
    }

    public final void removeListener(EditorHighlighter.HighlighterUpdateListener highlighterUpdateListener) {
        this.fListeners.remove(highlighterUpdateListener);
    }

    private void fireUpdate() {
        for (EditorHighlighter.HighlighterUpdateListener highlighterUpdateListener : this.fListeners) {
            highlighterUpdateListener.highlightsUpdated();
        }
    }

    public final List<EditorRegion> getEditorRegions() {
        return Collections.unmodifiableList(this.fRegions);
    }

    public final Color getHighlightColor() {
        return this.fColor;
    }

    protected final void setHighlightingColor(Color color) {
        this.fColor = color;
        this.fireUpdate();
    }

    public final void dispose() {
        this.doDispose();
        for (EditorRegion editorRegion : this.getEditorRegions()) {
            editorRegion.dispose();
        }
        this.fListeners.clear();
    }

    protected abstract void doDispose();
}

