/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable;

import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.NativeJava;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.grouptable.GroupingTable;
import com.mathworks.widgets.grouptable.NonRectangularCellRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;

public class DragToSelectHandler {
    private final JTable fTable;
    private final MulticastChangeListener fChangeListeners;
    private final MouseListener fMouseListener;
    private SelectionBox fSelectionBox;
    private Timer fDragDetector;
    private SelectionPolicy fPolicy;
    private int fMouseButtonStateAtDragStart;
    private boolean fPressedOnAlreadySelectedRow;

    public DragToSelectHandler(JTable jTable) {
        this.fTable = jTable;
        this.fChangeListeners = new MulticastChangeListener();
        this.fPolicy = new ToggleSelectionPolicy(false);
        this.fMouseListener = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                DragToSelectHandler.this.drop();
            }
        };
        this.fTable.addMouseListener(this.fMouseListener);
    }

    public void dispose() {
        this.fTable.removeMouseListener(this.fMouseListener);
    }

    public void setPressedOnAlreadySelectedRow(boolean bl) {
        this.fPressedOnAlreadySelectedRow = bl;
    }

    protected boolean allowDragStart(Point point) {
        if (!PlatformInfo.isMacintosh() && this.fPressedOnAlreadySelectedRow) {
            return false;
        }
        int n = this.fTable.rowAtPoint(point);
        int n2 = this.fTable.columnAtPoint(point);
        if (n == -1 || n2 == -1) {
            return true;
        }
        TableCellRenderer tableCellRenderer = this.fTable instanceof GroupingTable ? ((GroupingTable)((Object)this.fTable)).setupRenderer(n, n2) : this.fTable.getCellRenderer(n, n2);
        Component component = tableCellRenderer.getTableCellRendererComponent(this.fTable, this.fTable.getValueAt(n, n2), false, true, n, n2);
        Rectangle rectangle = this.fTable.getCellRect(n, n2, true);
        if (tableCellRenderer instanceof NonRectangularCellRenderer) {
            int n3 = 0;
            if (n2 < 1) {
                n3 = (((GroupingTable)((Object)this.fTable)).getRowAt(n).getLevel() + 1) * ((GroupingTable)((Object)this.fTable)).getIndent();
            }
            point.setLocation((int)(point.getX() - rectangle.getX() - (double)n3), (int)(point.getY() - rectangle.getY()));
            return !((NonRectangularCellRenderer)tableCellRenderer).allowRightClickSelection(point);
        }
        Dimension dimension = component.getPreferredSize();
        return point.getX() - rectangle.getX() <= dimension.getWidth() && point.getY() - rectangle.getY() <= dimension.getHeight();
    }

    public boolean startDragging(Point point, boolean bl, boolean bl2) {
        if (this.allowDragStart(new Point(point))) {
            this.fMouseButtonStateAtDragStart = DragToSelectHandler.captureMouseButtonState();
            this.fSelectionBox = new SelectionBox(point);
            this.fPolicy = this.determineSelectionPolicy(bl, bl2);
            int n = this.fTable.rowAtPoint(point);
            if (this.fPolicy.isCleanSlateRequired()) {
                this.fTable.clearSelection();
                if (n != -1) {
                    this.fTable.getSelectionModel().addSelectionInterval(n, n);
                }
            } else if (bl && !PlatformInfo.isMacintosh() && n != -1 && !this.fTable.getSelectionModel().isSelectedIndex(n)) {
                this.toggleRow(n);
            }
            this.fChangeListeners.stateChanged(new ChangeEvent(this));
            return true;
        }
        return false;
    }

    public void drag(Point point) {
        if (this.fSelectionBox != null) {
            SelectionBox selectionBox = new SelectionBox(this.fSelectionBox, point);
            this.fPolicy.notifyChange(this.fSelectionBox, selectionBox);
            this.fSelectionBox = selectionBox;
            this.fTable.revalidate();
            this.fTable.repaint();
            this.fChangeListeners.stateChanged(new ChangeEvent(this));
            this.startDragDetectorIfNecessary();
        }
    }

    public void drop() {
        this.fSelectionBox = null;
        this.fTable.revalidate();
        this.fTable.repaint();
        this.fChangeListeners.stateChanged(new ChangeEvent(this));
        this.stopDragDetector();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }

    public boolean isSelecting() {
        return this.fSelectionBox != null;
    }

    public void paintSelection(Graphics graphics) {
        if (this.fSelectionBox != null && !PlatformInfo.isMacintosh()) {
            Border border = UIManager.getBorder("Table.focusCellHighlightBorder");
            Point point = this.fSelectionBox.getUpperLeftPoint();
            Point point2 = this.fSelectionBox.getLowerRightPoint();
            border.paintBorder(this.fTable, graphics, (int)point.getX(), (int)point.getY(), (int)(point2.getX() - point.getX() - 1.0), (int)(point2.getY() - point.getY() - 1.0));
        }
    }

    private void startDragDetectorIfNecessary() {
        if (this.fDragDetector == null) {
            this.fDragDetector = new Timer(10, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = DragToSelectHandler.captureMouseButtonState();
                    if (n != DragToSelectHandler.this.fMouseButtonStateAtDragStart) {
                        DragToSelectHandler.this.drop();
                    } else {
                        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                        if (pointerInfo != null) {
                            Point point = pointerInfo.getLocation();
                            if (point == null) {
                                DragToSelectHandler.this.drop();
                            } else {
                                SwingUtilities.convertPointFromScreen(point, DragToSelectHandler.this.fTable);
                                if (!(PlatformInfo.isWindows() || PlatformInfo.isMacintosh() || DragToSelectHandler.this.fTable.contains(point))) {
                                    DragToSelectHandler.this.drop();
                                } else {
                                    DragToSelectHandler.this.drag(point);
                                }
                            }
                        }
                    }
                }
            });
            this.fDragDetector.setRepeats(true);
            this.fDragDetector.start();
        }
    }

    private void stopDragDetector() {
        if (this.fDragDetector != null) {
            this.fDragDetector.stop();
            this.fDragDetector = null;
        }
    }

    private void runAndPreserveLeadSelection(ParameterRunnable<ListSelectionModel> parameterRunnable) {
        ListSelectionModel listSelectionModel = this.fTable.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        int n = listSelectionModel.getLeadSelectionIndex();
        parameterRunnable.run((Object)listSelectionModel);
        if (listSelectionModel.isSelectedIndex(n)) {
            listSelectionModel.removeSelectionInterval(n, n);
            listSelectionModel.addSelectionInterval(n, n);
        }
        listSelectionModel.setValueIsAdjusting(false);
    }

    private void toggleRow(final int n) {
        this.runAndPreserveLeadSelection(new ParameterRunnable<ListSelectionModel>(){

            public void run(ListSelectionModel listSelectionModel) {
                if (listSelectionModel.isSelectedIndex(n)) {
                    listSelectionModel.removeSelectionInterval(n, n);
                } else {
                    listSelectionModel.addSelectionInterval(n, n);
                }
            }
        });
    }

    private SelectionPolicy determineSelectionPolicy(boolean bl, boolean bl2) {
        if (bl2 && !bl && !PlatformInfo.isMacintosh()) {
            return new AddSelectionPolicy();
        }
        if (bl2 && PlatformInfo.isMacintosh() || bl) {
            return new ToggleSelectionPolicy(false);
        }
        return new ToggleSelectionPolicy(true);
    }

    private static int captureMouseButtonState() {
        return PlatformInfo.isWindows() || PlatformInfo.isMacintosh() ? NativeJava.getMouseButtonState() : 1;
    }

    private final class ToggleSelectionPolicy
    implements SelectionPolicy {
        private final boolean iCleanSlateRequired;

        ToggleSelectionPolicy(boolean bl) {
            this.iCleanSlateRequired = bl;
        }

        @Override
        public void notifyChange(SelectionBox selectionBox, SelectionBox selectionBox2) {
            int n;
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (n = Math.min(selectionBox.getLowRow(), selectionBox2.getLowRow()); n <= Math.max(selectionBox.getLowRow(), selectionBox2.getLowRow()); ++n) {
                hashSet.add(n);
            }
            for (n = Math.min(selectionBox.getHighRow(), selectionBox2.getHighRow()); n <= Math.max(selectionBox.getHighRow(), selectionBox2.getHighRow()); ++n) {
                hashSet.add(n);
            }
            for (Integer n2 : hashSet) {
                this.changeRowSelectionIfNecessary(selectionBox, selectionBox2, n2);
            }
        }

        private void changeRowSelectionIfNecessary(SelectionBox selectionBox, SelectionBox selectionBox2, int n) {
            if (selectionBox.containsRow(n) ^ selectionBox2.containsRow(n)) {
                DragToSelectHandler.this.toggleRow(n);
            }
        }

        @Override
        public boolean isCleanSlateRequired() {
            return this.iCleanSlateRequired;
        }
    }

    private final class AddSelectionPolicy
    implements SelectionPolicy {
        private final Set<Integer> iOriginalRows = new TreeSet<Integer>();

        AddSelectionPolicy() {
            int[] nArray = DragToSelectHandler.this.fTable.getSelectedRows();
            if (nArray != null) {
                for (int n : nArray) {
                    this.iOriginalRows.add(n);
                }
            }
        }

        @Override
        public void notifyChange(SelectionBox selectionBox, SelectionBox selectionBox2) {
            final TreeSet<Integer> treeSet = new TreeSet<Integer>(this.iOriginalRows);
            for (int i = selectionBox2.getLowRow(); i <= selectionBox2.getHighRow(); ++i) {
                treeSet.add(i);
            }
            DragToSelectHandler.this.runAndPreserveLeadSelection((ParameterRunnable<ListSelectionModel>)((ParameterRunnable)new ParameterRunnable<ListSelectionModel>(){

                public void run(ListSelectionModel listSelectionModel) {
                    listSelectionModel.clearSelection();
                    Iterator iterator = treeSet.iterator();
                    while (iterator.hasNext()) {
                        int n = (Integer)iterator.next();
                        listSelectionModel.addSelectionInterval(n, n);
                    }
                }
            }));
        }

        @Override
        public boolean isCleanSlateRequired() {
            return false;
        }
    }

    private static interface SelectionPolicy {
        public void notifyChange(SelectionBox var1, SelectionBox var2);

        public boolean isCleanSlateRequired();
    }

    private class SelectionBox {
        private final Point fStartPoint;
        private final Point fEndPoint;
        private final Point fUpperLeftPoint;
        private final Point fLowerRightPoint;
        private final Rectangle fRect;
        private final int fLowRow;
        private final int fHighRow;

        SelectionBox(Point point) {
            this.fStartPoint = new Point(point);
            this.fEndPoint = new Point(this.fStartPoint);
            this.fUpperLeftPoint = new Point(this.fStartPoint);
            this.fLowerRightPoint = new Point(this.fStartPoint);
            this.fRect = new Rectangle(this.fStartPoint, new Dimension(0, 0));
            int[] nArray = this.calculateRowRange();
            this.fLowRow = nArray[0];
            this.fHighRow = nArray[1];
        }

        SelectionBox(SelectionBox selectionBox, Point point) {
            this.fStartPoint = new Point(selectionBox.getStartPoint());
            this.fEndPoint = new Point(point);
            this.fUpperLeftPoint = new Point(this.constrainToWidth((int)Math.min(this.fStartPoint.getX(), this.fEndPoint.getX())), this.constrainToHeight((int)Math.min(this.fStartPoint.getY(), this.fEndPoint.getY())));
            this.fLowerRightPoint = new Point(this.constrainToWidth((int)Math.max(this.fStartPoint.getX(), this.fEndPoint.getX())), this.constrainToHeight((int)Math.max(this.fStartPoint.getY(), this.fEndPoint.getY())));
            this.fRect = new Rectangle(this.fUpperLeftPoint, new Dimension((int)(this.fLowerRightPoint.getX() - this.fUpperLeftPoint.getX() - 1.0), (int)(this.fLowerRightPoint.getY() - this.fUpperLeftPoint.getY() - 1.0)));
            int[] nArray = this.calculateRowRange();
            this.fLowRow = nArray[0];
            this.fHighRow = nArray[1];
        }

        public Point getStartPoint() {
            return new Point(this.fStartPoint);
        }

        public Point getEndPoint() {
            return new Point(this.fEndPoint);
        }

        public Point getUpperLeftPoint() {
            return new Point(this.fUpperLeftPoint);
        }

        public Point getLowerRightPoint() {
            return new Point(this.fLowerRightPoint);
        }

        public Rectangle getRect() {
            return new Rectangle(this.fRect);
        }

        private int constrainToWidth(int n) {
            return Math.max(0, Math.min(DragToSelectHandler.this.fTable.getWidth() - 1, n));
        }

        private int constrainToHeight(int n) {
            return Math.max(0, Math.min(DragToSelectHandler.this.fTable.getHeight() - 1, n));
        }

        private int[] calculateRowRange() {
            int[] nArray = new int[2];
            int n = DragToSelectHandler.this.fTable.rowAtPoint(this.fUpperLeftPoint);
            if (n < 0) {
                nArray[0] = -1;
                nArray[1] = -1;
            } else {
                nArray[0] = n;
                int n2 = DragToSelectHandler.this.fTable.rowAtPoint(this.fLowerRightPoint);
                nArray[1] = n2 == -1 ? DragToSelectHandler.this.fTable.getRowCount() - 1 : n2;
            }
            return nArray;
        }

        public int getLowRow() {
            return this.fLowRow;
        }

        public int getHighRow() {
            return this.fHighRow;
        }

        public boolean containsRow(int n) {
            return this.fLowRow <= n && this.fHighRow >= n;
        }
    }
}

