/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable;

import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.SpanTableModel;
import com.jidesoft.grid.TreeTableModel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingException;
import com.mathworks.services.settings.SettingNotFoundException;
import com.mathworks.services.settings.SettingPath;
import com.mathworks.services.settings.SettingTypeException;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.ShutdownRuntimeException;
import com.mathworks.widgets.WorkMonitor;
import com.mathworks.widgets.grouptable.CombinedExpansionContext;
import com.mathworks.widgets.grouptable.ExpansionChangeListener;
import com.mathworks.widgets.grouptable.ExpansionContext;
import com.mathworks.widgets.grouptable.FlatExpansionContext;
import com.mathworks.widgets.grouptable.Group;
import com.mathworks.widgets.grouptable.GroupingTableCellSpan;
import com.mathworks.widgets.grouptable.GroupingTableColumn;
import com.mathworks.widgets.grouptable.GroupingTableConfiguration;
import com.mathworks.widgets.grouptable.GroupingTablePair;
import com.mathworks.widgets.grouptable.GroupingTablePopulator;
import com.mathworks.widgets.grouptable.GroupingTableResources;
import com.mathworks.widgets.grouptable.GroupingTableRow;
import com.mathworks.widgets.grouptable.GroupingTableTransaction;
import com.mathworks.widgets.grouptable.GroupingTableUtils;
import com.mathworks.widgets.grouptable.RowListTransactionTarget;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GroupingTableModel<T>
extends TreeTableModel<GroupingTableRow<T>>
implements SpanTableModel {
    private ExpansionContext<T> fRootContext;
    private ParameterRunnable<Runnable> fRefreshWrapper;
    private EditHandler<T> fEditHandler;
    private ExpansionChangeListener<T> fRootContextListener;
    private GroupingTableTransaction.Target<T> fCurrentTarget;
    private WorkMonitor.Task fLastSetLocationTask;
    private boolean fOverflowFlag;
    private final WorkMonitor fWorkMonitor;
    private final GroupingTablePopulator<T> fPopulator;
    private final GroupingTableConfiguration<T> fConfiguration;
    private final List<GroupingTableRow<T>> fRootLevelRows;
    private final MulticastChangeListener fOverflowListeners;
    private final MulticastChangeListener fLocationListeners;
    private final IntegerSettingRetriever fCurrentFolderSize;

    public GroupingTableModel(GroupingTableConfiguration<T> groupingTableConfiguration, WorkMonitor workMonitor) {
        this(groupingTableConfiguration, workMonitor, GroupingTableModel.getCurrentFolderSizeSetting());
    }

    public GroupingTableModel(GroupingTableConfiguration<T> groupingTableConfiguration, WorkMonitor workMonitor, IntegerSettingRetriever integerSettingRetriever) {
        this.fWorkMonitor = workMonitor == null ? new WorkMonitor() : workMonitor;
        this.fRootLevelRows = new ArrayList<GroupingTableRow<T>>();
        this.fRootContextListener = new RootContextChangeListener();
        this.fConfiguration = groupingTableConfiguration;
        this.fCurrentFolderSize = integerSettingRetriever;
        this.fPopulator = new GroupingTablePopulator(this);
        this.fConfiguration.addPropertyChangeListener(new ConfigurationListener());
        this.fLocationListeners = new MulticastChangeListener();
        this.fOverflowListeners = new MulticastChangeListener();
        this.setLocation(null, null, new FlatExpansionContext());
        this.setOriginalRows(this.fRootLevelRows);
    }

    GroupingTablePopulator<T> getPopulator() {
        return this.fPopulator;
    }

    public void setRenameHandler(EditHandler<T> editHandler) {
        this.fEditHandler = editHandler;
    }

    public void waitForPendingTransactions() {
        this.fPopulator.waitForPendingTransactions();
    }

    public GroupingTableConfiguration<T> getConfiguration() {
        return this.fConfiguration;
    }

    public WorkMonitor getWorkMonitor() {
        return this.fWorkMonitor;
    }

    public void change(final GroupingTableTransaction<T> groupingTableTransaction) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!FlatExpansionContext.class.isInstance(GroupingTableModel.this.fRootContext)) {
                    throw new IllegalArgumentException("Data changes cannot be made directly to the model when using expansion providers with a set location");
                }
                FlatExpansionContext flatExpansionContext = (FlatExpansionContext)GroupingTableModel.this.fRootContext;
                flatExpansionContext.change(groupingTableTransaction);
            }
        });
    }

    public void setLocation(final T t) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GroupingTableRow<Object> groupingTableRow = GroupingTableUtils.findRowRecursively(GroupingTableModel.this.fRootLevelRows, t);
                CombinedExpansionContext<Object> combinedExpansionContext = null;
                if (groupingTableRow != null) {
                    combinedExpansionContext = groupingTableRow.getExpansionContext();
                }
                if (combinedExpansionContext == null) {
                    combinedExpansionContext = new CombinedExpansionContext<Object>(t, GroupingTableModel.this.fConfiguration);
                }
                GroupingTableModel.this.setLocation(t, groupingTableRow, combinedExpansionContext);
            }
        });
    }

    public void refreshAllExpansionContexts() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GroupingTableModel.this.fRootContext.refresh();
                for (GroupingTableRow groupingTableRow : GroupingTableModel.this.fRootLevelRows) {
                    GroupingTableUtils.refreshRecursively(groupingTableRow);
                }
            }
        });
    }

    public void reset() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (GroupingTableModel.this.fRootContext != null) {
                    Object t = GroupingTableModel.this.fRootContext.getItem();
                    GroupingTableModel.this.fRootContext.removeListener(GroupingTableModel.this.fRootContextListener);
                    GroupingTableModel.this.fRootContext.close();
                    GroupingTableModel.this.fRootContext = null;
                    GroupingTableModel.this.setLocation(t);
                }
            }
        });
    }

    public void dispose() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (GroupingTableModel.this.fRootContext != null) {
                    GroupingTableModel.this.fRootContext.removeListener(GroupingTableModel.this.fRootContextListener);
                    GroupingTableModel.this.fRootContext.close();
                    GroupingTableModel.this.fRootContext = null;
                }
                for (GroupingTableRow groupingTableRow : GroupingTableModel.this.fRootLevelRows) {
                    groupingTableRow.dispose();
                }
                GroupingTableModel.this.fRootLevelRows.clear();
                GroupingTableModel.this.setOriginalRows(new ArrayList());
            }
        });
    }

    public void refreshExpansionContext(GroupingTableRow<T> groupingTableRow) {
        GroupingTableUtils.refreshRecursively(groupingTableRow);
    }

    public void addOverflowListener(ChangeListener changeListener) {
        this.fOverflowListeners.addChangeListener(changeListener);
    }

    public boolean inOverflowState() {
        return this.fOverflowFlag;
    }

    public void setOverflowState(boolean bl) {
        if (bl == this.fOverflowFlag) {
            return;
        }
        this.fOverflowFlag = bl;
        if (bl) {
            this.collapseChildren(this.fRootLevelRows);
            this.collapseAll();
            this.getConfiguration().addCollapsed();
            this.getConfiguration().clearExpanded();
            for (GroupingTableRow<T> groupingTableRow : this.fRootLevelRows) {
                groupingTableRow.dispose();
            }
            this.fRootLevelRows.clear();
            this.refresh();
        }
        this.fOverflowListeners.stateChanged(new ChangeEvent((Object)this));
    }

    public void collapseChildren(List<GroupingTableRow<T>> list) {
        if (list != null) {
            for (GroupingTableRow<T> groupingTableRow : list) {
                this.collapseChildren(groupingTableRow.getChildren());
                this.getConfiguration().setExpanded(groupingTableRow.getItem(), false);
            }
        }
    }

    public boolean detectOverflow(int n) {
        int n2 = this.getRowCount();
        if (!this.inOverflowState() && n2 + n >= this.getMaxTableEntries()) {
            this.setOverflowState(true);
            return true;
        }
        return this.inOverflowState();
    }

    public void addLocationListener(ChangeListener changeListener) {
        this.fLocationListeners.addChangeListener(changeListener);
    }

    public T getLocation() {
        return this.fRootContext == null ? null : (T)this.fRootContext.getItem();
    }

    private void setLocation(final T t, final GroupingTableRow<T> groupingTableRow, final ExpansionContext<T> expansionContext) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GroupingTableModel.this.setOverflowState(false);
                WorkMonitor.Task task = GroupingTableModel.this.fWorkMonitor.startTask(GroupingTableResources.getString("table.populating"));
                if (GroupingTableModel.this.fLastSetLocationTask != null) {
                    GroupingTableModel.this.fLastSetLocationTask.finished();
                }
                GroupingTableModel.this.fLastSetLocationTask = task;
                if (GroupingTableModel.this.fRootContext == expansionContext) {
                    return;
                }
                if (GroupingTableModel.this.fRootContext != null) {
                    GroupingTableModel.this.fRootContext.removeListener(GroupingTableModel.this.fRootContextListener);
                    GroupingTableModel.this.fRootContext.close();
                }
                GroupingTableModel.this.fRootContextListener = new RootContextChangeListener();
                ArrayList arrayList = new ArrayList(GroupingTableModel.this.fRootLevelRows);
                GroupingTableModel.this.fRootLevelRows.clear();
                if (t != null && groupingTableRow != null) {
                    groupingTableRow.detachExpansionContext();
                    while (groupingTableRow.getChildrenCount() > 0) {
                        GroupingTableRow groupingTableRow2 = (GroupingTableRow)((Object)groupingTableRow.getChildAt(0));
                        groupingTableRow.removeChild((Object)groupingTableRow2);
                        if (groupingTableRow2.isPlaceholder()) continue;
                        GroupingTableModel.this.fRootLevelRows.add(groupingTableRow2);
                    }
                    GroupingTableModel.this.ungroupOrRegroupRootLevelRows();
                }
                for (GroupingTableRow groupingTableRow3 : arrayList) {
                    groupingTableRow3.dispose();
                }
                GroupingTableModel.this.fRootContext = expansionContext;
                GroupingTableModel.this.fRootContext.addListener(GroupingTableModel.this.fRootContextListener);
                GroupingTableModel.this.fCurrentTarget = null;
                boolean bl = true;
                if (GroupingTableModel.this.fRootLevelRows.isEmpty()) {
                    GroupingTableUtils.populate(GroupingTableModel.this.fPopulator, GroupingTableModel.this.fRootContext, GroupingTableModel.this.getCurrentTarget(), GroupingTableModel.this.fWorkMonitor.createEdtFinisher(GroupingTableModel.this.fLastSetLocationTask));
                    bl = false;
                }
                GroupingTableModel.this.fLocationListeners.stateChanged(new ChangeEvent(this));
                GroupingTableModel.this.refresh();
                if (bl) {
                    GroupingTableModel.this.fLastSetLocationTask.finished();
                }
            }
        });
    }

    public void applyTransactionImmediately(GroupingTableTransaction<T> groupingTableTransaction) {
        assert (SwingUtilities.isEventDispatchThread());
        for (GroupingTableTransaction.Element<T> element : groupingTableTransaction) {
            int n;
            if (element.getData() == null || (n = this.rowIndexOf(element.getData())) <= -1) continue;
            Row row = this.getRowAt(n);
            if (!(row.getParent() instanceof GroupingTableRow)) {
                groupingTableTransaction.apply(this.getCurrentTarget());
                break;
            }
            groupingTableTransaction.apply(((GroupingTableRow)row.getParent()).createTransactionTarget());
            break;
        }
    }

    public Object getPairedValue(int n, int n2) {
        GroupingTableColumn groupingTableColumn = this.fConfiguration.getPairedColumn(n2);
        Object t = ((GroupingTableRow)this.getRowAt(n)).getItem();
        return groupingTableColumn == null || t == null ? null : groupingTableColumn.getValue(t);
    }

    public int rowIndexOf(T t) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            GroupingTableRow groupingTableRow = (GroupingTableRow)this.getRowAt(i);
            if (groupingTableRow.getItem() == null || !groupingTableRow.getItem().equals(t)) continue;
            return i;
        }
        return -1;
    }

    public boolean isGroup(Row row) {
        return row instanceof GroupingTableRow && ((GroupingTableRow)row).getGroup() != null;
    }

    public Group<T> getGroup(T t) {
        for (GroupingTableRow<T> groupingTableRow : this.fRootLevelRows) {
            if (groupingTableRow.getGroup() == null || !groupingTableRow.getGroup().getItems().contains(t)) continue;
            return groupingTableRow.getGroup();
        }
        return null;
    }

    public Map<Integer, Group<T>> getGroupRows() {
        HashMap<Integer, Group<T>> hashMap = new HashMap<Integer, Group<T>>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            GroupingTableRow groupingTableRow = (GroupingTableRow)this.getRowAt(i);
            if (groupingTableRow.getGroup() == null) continue;
            hashMap.put(i, groupingTableRow.getGroup());
        }
        return hashMap;
    }

    public void setValueAt(Object object, int n, int n2) {
        GroupingTableColumn<T> groupingTableColumn;
        assert (this.fEditHandler != null);
        GroupingTablePair<T> groupingTablePair = this.fConfiguration.getPair(n2);
        if (groupingTablePair != null) {
            groupingTableColumn = this.fConfiguration.getVisibleColumn(n2);
            if (groupingTablePair.getFirstColumn().getEditor() == null && groupingTableColumn.equals(groupingTablePair.getFirstColumn())) {
                ++n2;
            } else if (groupingTablePair.getSecondColumn().getEditor() == null && groupingTableColumn.equals(groupingTablePair.getSecondColumn())) {
                --n2;
            }
        }
        groupingTableColumn = ((GroupingTableRow)this.getRowAt(n)).getItem();
        GroupingTableColumn<T> groupingTableColumn2 = this.fConfiguration.getVisibleColumn(n2);
        this.fEditHandler.rename(groupingTableColumn, groupingTableColumn2, object.toString());
    }

    public int getMaxTableEntries() {
        return this.fCurrentFolderSize.getSetting();
    }

    private synchronized GroupingTableTransaction.Target<T> getCurrentTarget() {
        if (this.fCurrentTarget == null) {
            this.fCurrentTarget = new RowListTransactionTarget(new RowListTransactionTarget.Adapter<T>(){
                private final ExpansionContext<T> iRootContextAtCreationTime;
                {
                    this.iRootContextAtCreationTime = GroupingTableModel.this.fRootContext;
                }

                @Override
                public List<GroupingTableRow<T>> start() {
                    ArrayList arrayList = new ArrayList();
                    for (GroupingTableRow groupingTableRow : GroupingTableModel.this.fRootLevelRows) {
                        if (groupingTableRow.getGroup() != null) {
                            for (GroupingTableRow groupingTableRow2 : groupingTableRow.getChildren()) {
                                arrayList.add(groupingTableRow2);
                            }
                            continue;
                        }
                        arrayList.add(groupingTableRow);
                    }
                    return arrayList;
                }

                @Override
                public void commitRows(List<GroupingTableRow<T>> list, Map<T, Integer> map, boolean bl) {
                    if (this.iRootContextAtCreationTime != null && GroupingTableModel.this.fRootContext != null && GroupingTableModel.this.fRootContext.equals(this.iRootContextAtCreationTime)) {
                        if (bl) {
                            GroupingTableModel.this.setRootLevelRows(list, map);
                            GroupingTableModel.this.ungroupOrRegroupRootLevelRows();
                        }
                        GroupingTableModel.this.refresh();
                    }
                }

                @Override
                public GroupingTableRow<T> createRow(T t) {
                    return new GroupingTableRow(GroupingTableModel.this.fConfiguration, GroupingTableModel.this.fPopulator, t);
                }

                @Override
                public GroupingTableConfiguration<T> getConfiguration() {
                    return GroupingTableModel.this.fConfiguration;
                }

                @Override
                public boolean detectOverflow(int n) {
                    return GroupingTableModel.this.fPopulator.getModel().detectOverflow(n);
                }

                @Override
                public boolean inOverflowState() {
                    return GroupingTableModel.this.fPopulator.getModel().inOverflowState();
                }
            });
        }
        return this.fCurrentTarget;
    }

    private static IntegerSettingRetriever getCurrentFolderSizeSetting() {
        return new GroupingTableDefaultIntegerSettingRetriever();
    }

    private void ungroupOrRegroupRootLevelRows() {
        List<GroupingTableRow<T>> list = GroupingTableUtils.flattenGroups(this.fRootLevelRows);
        this.setRootLevelRows(list, GroupingTableUtils.getRowIndices(list));
        if (this.fConfiguration.getSortColumn() != null) {
            GroupingTableUtils.sortNonRecursively(this.fRootLevelRows, this.fConfiguration.getAscendingSortComparator(), this.fConfiguration.isSortedDescending());
        }
        this.refresh();
    }

    private void setRootLevelRows(List<GroupingTableRow<T>> list, Map<T, Integer> map) {
        this.fRootLevelRows.clear();
        if (this.fConfiguration.getGroupMode() != null) {
            List<Group<T>> list2 = this.fConfiguration.getGroupMode().getGroups(GroupingTableUtils.rowsToItems(list));
            for (Group<T> group : list2) {
                GroupingTableRow<Group<T>> groupingTableRow = new GroupingTableRow<Group<T>>(this.fConfiguration, this.fPopulator, group);
                ArrayList<GroupingTableRow<T>> arrayList = new ArrayList<GroupingTableRow<T>>(group.size());
                for (T t : group.getItems()) {
                    Integer n = map.get(t);
                    assert (n != null && n >= 0 && n < map.size());
                    GroupingTableRow<T> groupingTableRow2 = list.get(n);
                    if (groupingTableRow2.getParent() != null) {
                        groupingTableRow2.getParent().removeChild(groupingTableRow2);
                    }
                    arrayList.add(groupingTableRow2);
                }
                groupingTableRow.setChildren(arrayList);
                groupingTableRow.setExpanded(!this.fConfiguration.isGroupCollapsed(group));
                if (!this.fConfiguration.isGroupCollapsed(group) && !this.fConfiguration.isGroupExpanded(group)) {
                    this.fConfiguration.setExpanded(group, true);
                }
                this.fRootLevelRows.add(groupingTableRow);
            }
        } else {
            this.fRootLevelRows.clear();
            for (GroupingTableRow<T> groupingTableRow : list) {
                this.fRootLevelRows.add(groupingTableRow);
            }
        }
    }

    public Class<?> getColumnClass(int n) {
        GroupingTablePair<T> groupingTablePair;
        Class<?> clazz = this.fConfiguration.getVisibleColumns().get(n).getType();
        if (!clazz.equals(String.class) && (groupingTablePair = this.fConfiguration.getPair(n)) != null && (groupingTablePair.getFirstColumn().getType().equals(String.class) || groupingTablePair.getSecondColumn().getType().equals(String.class))) {
            return String.class;
        }
        return clazz;
    }

    public int getColumnCount() {
        return this.fConfiguration == null ? 0 : this.fConfiguration.getVisibleColumnCount();
    }

    public CellSpan getCellSpanAt(int n, int n2) {
        GroupingTableRow groupingTableRow;
        if (n == -1) {
            return new GroupingTableCellSpan(n, n2, 1);
        }
        if (this.fConfiguration.getGroupMode() != null && (groupingTableRow = (GroupingTableRow)this.getRowAt(n)).getGroup() != null) {
            return new GroupingTableCellSpan(n, 0, this.fConfiguration.getVisibleColumnCount());
        }
        return this.fConfiguration.getCellSpan(n, n2);
    }

    public boolean isCellSpanOn() {
        return true;
    }

    public boolean isCellEditable(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return false;
        }
        GroupingTablePair<T> groupingTablePair = this.fConfiguration.getPair(n2);
        return (this.fConfiguration.getVisibleColumns().get(n2).getEditor() != null || groupingTablePair != null && groupingTablePair.getFirstColumn().getEditor() != null || groupingTablePair != null && groupingTablePair.getSecondColumn().getEditor() != null) && ((GroupingTableRow)this.getRowAt(n)).getItem() != null;
    }

    public void setRefreshWrapper(ParameterRunnable<Runnable> parameterRunnable) {
        this.fRefreshWrapper = parameterRunnable;
    }

    public void refresh() {
        if (this.fRefreshWrapper != null) {
            this.fRefreshWrapper.run((Object)new Runnable(){

                @Override
                public void run() {
                    GroupingTableModel.super.refresh();
                }
            });
        } else {
            super.refresh();
        }
    }

    private class RootContextChangeListener
    implements ExpansionChangeListener<T> {
        private RootContextChangeListener() {
        }

        @Override
        public void childrenChanged(GroupingTableTransaction<T> groupingTableTransaction) {
            if (GroupingTableModel.this.fRootContextListener.equals(this)) {
                GroupingTableModel.this.fPopulator.requestTransaction(groupingTableTransaction, GroupingTableModel.this.getCurrentTarget());
            }
        }

        @Override
        public void hasChildrenChanged() {
        }
    }

    private class ConfigurationListener
    implements PropertyChangeListener {
        private ConfigurationListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("sort-column")) {
                GroupingTableUtils.sortRecursively(GroupingTableModel.this.fRootLevelRows, GroupingTableModel.this.fConfiguration.getAscendingSortComparator());
                if (GroupingTableModel.this.fConfiguration.isSortedDescending()) {
                    GroupingTableUtils.reverseOrderRecursively(GroupingTableModel.this.fRootLevelRows);
                }
                GroupingTableModel.this.refresh();
            } else if (propertyChangeEvent.getPropertyName().equals("sort-descending")) {
                GroupingTableUtils.reverseOrderRecursively(GroupingTableModel.this.fRootLevelRows);
                GroupingTableModel.this.refresh();
            } else if (propertyChangeEvent.getPropertyName().equals("group-mode")) {
                GroupingTableModel.this.ungroupOrRegroupRootLevelRows();
                GroupingTableModel.this.refresh();
            }
        }
    }

    public static interface IntegerSettingRetriever {
        public Integer getSetting();
    }

    public static class GroupingTableDefaultIntegerSettingRetriever
    implements IntegerSettingRetriever {
        @Override
        public Integer getSetting() {
            try {
                Setting<Integer> setting = this.getCurrentFolderSetting();
                return (Integer)setting.get();
            }
            catch (ShutdownRuntimeException | IllegalStateException throwable) {
                return 0;
            }
            catch (SettingException settingException) {
                throw new IllegalStateException(settingException);
            }
        }

        public Setting<Integer> getCurrentFolderSetting() throws SettingNotFoundException, SettingTypeException {
            SettingPath settingPath = new SettingPath(new String[]{"matlab", "desktop", "currentfolder"});
            return new Setting(settingPath, Integer.class, "CurrentFolderSize");
        }
    }

    public static interface EditHandler<T> {
        public void rename(T var1, GroupingTableColumn<T> var2, String var3);
    }
}

