/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.Converter;
import com.mathworks.widgets.grouptable.CombinedExpansionContext;
import com.mathworks.widgets.grouptable.ExpansionContext;
import com.mathworks.widgets.grouptable.Group;
import com.mathworks.widgets.grouptable.GroupingTableColumn;
import com.mathworks.widgets.grouptable.GroupingTableConfiguration;
import com.mathworks.widgets.grouptable.GroupingTablePopulator;
import com.mathworks.widgets.grouptable.GroupingTableRow;
import com.mathworks.widgets.grouptable.GroupingTableTransaction;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.table.TableColumn;

public final class GroupingTableUtils {
    private GroupingTableUtils() {
    }

    static <T> void refreshRecursively(GroupingTableRow<T> groupingTableRow) {
        if (groupingTableRow != null) {
            List list;
            CombinedExpansionContext<T> combinedExpansionContext = groupingTableRow.getExpansionContext();
            if (combinedExpansionContext != null) {
                combinedExpansionContext.refresh();
            }
            if ((list = groupingTableRow.getChildren()) != null) {
                for (GroupingTableRow groupingTableRow2 : list) {
                    GroupingTableUtils.refreshRecursively(groupingTableRow2);
                }
            }
        }
    }

    static <T> void populateFirstChild(ExpansionContext<T> expansionContext, GroupingTableTransaction.Target<T> target) {
        GroupingTableTransaction<T> groupingTableTransaction = new GroupingTableTransaction<T>();
        groupingTableTransaction.add(GroupingTableTransaction.Type.ADD, expansionContext.createChildPlaceholder());
        groupingTableTransaction.apply(target);
    }

    static <T> void populate(GroupingTablePopulator<T> groupingTablePopulator, ExpansionContext<T> expansionContext, GroupingTableTransaction.Target<T> target) {
        GroupingTableUtils.populate(groupingTablePopulator, expansionContext, target, null);
    }

    static <T> void populate(final GroupingTablePopulator<T> groupingTablePopulator, ExpansionContext<T> expansionContext, final GroupingTableTransaction.Target<T> target, final Runnable runnable) {
        expansionContext.getChildrenAsynchronously(new AsyncReceiver<T>(){
            int count = 0;

            public boolean receive(T t) {
                GroupingTableColumn groupingTableColumn;
                ++this.count;
                if (groupingTablePopulator.getModel().inOverflowState() || this.count > groupingTablePopulator.getModel().getMaxTableEntries()) {
                    if (runnable != null) {
                        runnable.run();
                    }
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            groupingTablePopulator.getModel().detectOverflow(count);
                        }
                    });
                    return false;
                }
                GroupingTableTransaction groupingTableTransaction = new GroupingTableTransaction();
                groupingTableTransaction.add(GroupingTableTransaction.Type.ADD, t);
                groupingTablePopulator.requestTransaction(groupingTableTransaction, target);
                GroupingTableColumn groupingTableColumn2 = groupingTablePopulator.getTable().getConfiguration().getSortColumn();
                if (groupingTableColumn2 != null) {
                    groupingTableColumn2.getValue(t);
                }
                if ((groupingTableColumn = groupingTablePopulator.getTable().getConfiguration().getGroupColumn()) != null) {
                    groupingTableColumn.getValue(t);
                }
                return true;
            }

            public void finished() {
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
    }

    public static GradientPaint getGroupHeaderGradient(Rectangle rectangle) {
        Color color;
        Color color2 = color = UIManager.getColor("control");
        Color color3 = color;
        if (!MJUtilities.isHighContrast()) {
            color2 = Color.WHITE;
            color3 = ColorUtils.convertToCurrentColorScheme((Color)new Color(242, 241, 246), (Color)color);
        }
        return new GradientPaint(new Point2D.Double(rectangle.getX(), rectangle.getY()), color2, new Point2D.Double(rectangle.getX(), rectangle.getY() + rectangle.getHeight()), color3);
    }

    public static <T> List<Group<T>> getNonEmptyGroups(List<Group<T>> list) {
        Vector<Group<T>> vector = new Vector<Group<T>>();
        for (Group<T> group : list) {
            if (group.size() <= 0) continue;
            vector.add(group);
        }
        return vector;
    }

    public static <T> List<Group<T>> generateDirectGrouping(List<T> list, Converter<T, String> converter) {
        return GroupingTableUtils.generateDirectGrouping(null, list, converter);
    }

    public static <T> List<Group<T>> generateDirectGrouping(Icon icon, List<T> list, Converter<T, String> converter) {
        TreeMap<String, Group<T>> treeMap = new TreeMap<String, Group<T>>(new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string.compareToIgnoreCase(string2);
            }
        });
        for (T t : list) {
            String string = (String)converter.convert(t);
            Group<T> group = (Group<T>)treeMap.get(string);
            if (group == null) {
                group = new Group<T>(string, string, icon);
                treeMap.put(string, group);
            }
            group.addItem(t);
        }
        return new Vector<Group<T>>(treeMap.values());
    }

    static <T> void restoreColumnSizes(Converter<String, Integer> converter, GroupingTableConfiguration<T> groupingTableConfiguration, Map<GroupingTableColumn<T>, TableColumn> map) {
        for (GroupingTableColumn<T> groupingTableColumn : map.keySet()) {
            int n;
            GroupingTableConfiguration.ColumnSize columnSize = groupingTableConfiguration.getColumnSize(groupingTableColumn);
            if (columnSize.isFixed()) {
                map.get(groupingTableColumn).setMinWidth(columnSize.getSize());
                map.get(groupingTableColumn).setMaxWidth(columnSize.getSize());
                map.get(groupingTableColumn).setPreferredWidth(columnSize.getSize());
                map.get(groupingTableColumn).setWidth(columnSize.getSize());
                continue;
            }
            if (columnSize.isConfigured() && groupingTableConfiguration.getIgnoreMinColWidth()) {
                n = columnSize.getSize();
            } else {
                int n2;
                n = n2 = (Integer)converter.convert((Object)groupingTableColumn.getName()) + (Integer)converter.convert((Object)"M");
                n = columnSize.isConfigured() ? Math.max(n2, columnSize.getSize()) : (n *= 2);
            }
            map.get(groupingTableColumn).setPreferredWidth(n);
            map.get(groupingTableColumn).setWidth(n);
        }
    }

    static <T> void reverseOrderRecursively(List<GroupingTableRow<T>> list) {
        Collections.reverse(list);
        for (GroupingTableRow<T> groupingTableRow : list) {
            GroupingTableUtils.reverseOrderRecursively(groupingTableRow);
        }
    }

    static <T> void reverseOrderRecursively(GroupingTableRow<T> groupingTableRow) {
        List list = groupingTableRow.getChildren();
        if (list != null) {
            Collections.reverse(list);
            groupingTableRow.setChildren(list);
            for (GroupingTableRow groupingTableRow2 : list) {
                GroupingTableUtils.reverseOrderRecursively(groupingTableRow2);
            }
        }
    }

    static <T> void sortRecursively(List<GroupingTableRow<T>> list, Comparator<T> comparator) {
        Collections.sort(list, GroupingTableUtils.createRowComparatorFromItemComparator(comparator));
        for (GroupingTableRow<T> groupingTableRow : list) {
            GroupingTableUtils.sortRecursively(groupingTableRow, comparator);
        }
    }

    static <T> void sortRecursively(GroupingTableRow<T> groupingTableRow, Comparator<T> comparator) {
        List list = groupingTableRow.getChildren();
        if (list != null) {
            Collections.sort(list, GroupingTableUtils.createRowComparatorFromItemComparator(comparator));
            groupingTableRow.setChildren(list);
            for (GroupingTableRow groupingTableRow2 : list) {
                GroupingTableUtils.sortRecursively(groupingTableRow2, comparator);
            }
        }
    }

    static <T> void sortNonRecursively(List<GroupingTableRow<T>> list, Comparator<T> comparator, boolean bl) {
        if (comparator != null) {
            Comparator<GroupingTableRow<GroupingTableRow<T>>> comparator2 = GroupingTableUtils.createRowComparatorFromItemComparator(comparator);
            Collections.sort(list, bl ? Collections.reverseOrder(comparator2) : comparator2);
        }
    }

    static <T> Comparator<GroupingTableRow<T>> createRowComparatorFromItemComparator(final Comparator<T> comparator) {
        return new Comparator<GroupingTableRow<T>>(){

            @Override
            public int compare(GroupingTableRow<T> groupingTableRow, GroupingTableRow<T> groupingTableRow2) {
                Object t = groupingTableRow.getItem();
                Object t2 = groupingTableRow2.getItem();
                if (t == null && t2 == null) {
                    return 0;
                }
                if (t == null || t2 == null) {
                    return t == null ? -1 : 1;
                }
                return comparator.compare(t, t2);
            }
        };
    }

    static <T> List<T> rowsToItems(List<GroupingTableRow<T>> list) {
        ArrayList<T> arrayList = new ArrayList<T>(list.size());
        for (GroupingTableRow<T> groupingTableRow : list) {
            if (groupingTableRow.getItem() == null) continue;
            arrayList.add(groupingTableRow.getItem());
        }
        return arrayList;
    }

    static <T> Map<T, Integer> getRowIndices(List<GroupingTableRow<T>> list) {
        HashMap<T, Integer> hashMap = new HashMap<T, Integer>();
        for (int i = 0; i < list.size(); ++i) {
            hashMap.put(list.get(i).getItem(), i);
        }
        return hashMap;
    }

    static <T> List<GroupingTableRow<T>> flattenGroups(List<GroupingTableRow<T>> list) {
        ArrayList<GroupingTableRow<T>> arrayList = new ArrayList<GroupingTableRow<T>>();
        for (GroupingTableRow<T> groupingTableRow : list) {
            if (groupingTableRow.getItem() != null) {
                arrayList.add(groupingTableRow);
                continue;
            }
            ArrayList arrayList2 = groupingTableRow.getChildren();
            if (arrayList2 == null) continue;
            arrayList2 = new ArrayList(arrayList2);
            groupingTableRow.removeAllChildren();
            for (GroupingTableRow groupingTableRow2 : arrayList2) {
                arrayList.add(groupingTableRow2);
            }
        }
        return arrayList;
    }

    static <T> GroupingTableRow<T> findRowRecursively(List<GroupingTableRow<T>> list, T t) {
        for (GroupingTableRow<T> groupingTableRow : list) {
            if (groupingTableRow.getItem() == null || !groupingTableRow.getItem().equals(t)) continue;
            return groupingTableRow;
        }
        for (GroupingTableRow<T> groupingTableRow : list) {
            GroupingTableRow<T> groupingTableRow2;
            List list2 = groupingTableRow.getChildren();
            if (list2 == null || (groupingTableRow2 = GroupingTableUtils.findRowRecursively(list2, t)) == null) continue;
            return groupingTableRow2;
        }
        return null;
    }

    static <T> List<GroupingTableRow<T>> withoutPlaceholders(List<GroupingTableRow<T>> list) {
        ArrayList<GroupingTableRow<T>> arrayList = new ArrayList<GroupingTableRow<T>>();
        for (GroupingTableRow<T> groupingTableRow : list) {
            if (groupingTableRow.isPlaceholder()) continue;
            arrayList.add(groupingTableRow);
        }
        return arrayList;
    }
}

