/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable;

import com.mathworks.util.Converter;
import com.mathworks.util.Holder;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.grouptable.Group;
import com.mathworks.widgets.grouptable.GroupingTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class SelectOnTypeHandler<T> {
    private final KeyListener fKeyListener;
    private final ListSelectionListener fSelectionListener;
    private final GroupingTable<T> fTable;
    private final Converter<T, String> fItemConverter;
    private Timer fTimer;
    private boolean fSuppressResetOnSelection;
    private final StringBuffer fState = new StringBuffer();

    public SelectOnTypeHandler(GroupingTable<T> groupingTable, Converter<T, String> converter) {
        this.fTable = groupingTable;
        this.fItemConverter = converter;
        this.fKeyListener = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (!(keyEvent.isAltDown() || keyEvent.isControlDown() || keyEvent.isMetaDown() && PlatformInfo.isMacintosh() || keyEvent.getKeyLocation() == 4 && (keyEvent.getKeyChar() == '+' || keyEvent.getKeyChar() == '-'))) {
                    SelectOnTypeHandler.this.process(keyEvent.getKeyChar());
                }
            }
        };
        this.fSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!SelectOnTypeHandler.this.fSuppressResetOnSelection) {
                    SelectOnTypeHandler.this.fState.setLength(0);
                }
            }
        };
        this.fTable.addKeyListener(this.fKeyListener);
        this.fTable.getSelectionModel().addListSelectionListener(this.fSelectionListener);
    }

    public void destroy() {
        this.fTable.removeKeyListener(this.fKeyListener);
        this.fTable.getSelectionModel().removeListSelectionListener(this.fSelectionListener);
    }

    private void process(char c) {
        if (this.fTimer != null) {
            this.fTimer.stop();
        }
        this.fSuppressResetOnSelection = true;
        int n = this.findRow(c);
        if (n != -1) {
            this.fState.append(c);
            this.fTable.getSelectionModel().clearSelection();
            this.fTable.getSelectionModel().addSelectionInterval(n, n);
            this.fTable.scrollRectToVisible(this.fTable.getCellRect(n, 0, true));
            final Holder holder = new Holder();
            holder.set((Object)new Timer(1200, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SelectOnTypeHandler.this.fTimer == holder.get()) {
                        SelectOnTypeHandler.this.fState.setLength(0);
                    }
                }
            }));
            this.fTimer = (Timer)holder.get();
            this.fTimer.setRepeats(false);
            this.fTimer.start();
        } else {
            this.fTimer = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectOnTypeHandler.this.fSuppressResetOnSelection = false;
            }
        });
    }

    private int findRow(char c) {
        String string;
        String string2;
        int n;
        int n2 = 0;
        if (this.fState.length() > 0) {
            n2 = this.fTable.getSelectedRow();
        }
        if (this.fState.length() == 0 || !this.isStateAll(c)) {
            for (n = n2; n < this.fTable.getRowCount(); ++n) {
                if (!this.isPossibleTargetRow(n) || !(string2 = ((String)this.fItemConverter.convert(this.fTable.getItem(n))).toUpperCase()).startsWith(string = (this.fState.toString() + c).toUpperCase())) continue;
                return n;
            }
            for (n = 0; n < n2; ++n) {
                if (!this.isPossibleTargetRow(n) || !(string2 = ((String)this.fItemConverter.convert(this.fTable.getItem(n))).toUpperCase()).startsWith(string = (this.fState.toString() + c).toUpperCase())) continue;
                return n;
            }
        }
        if (this.fState.length() == 0) {
            return -1;
        }
        for (n = n2 + 1; n < this.fTable.getRowCount(); ++n) {
            if (!this.isPossibleTargetRow(n) || !(string2 = ((String)this.fItemConverter.convert(this.fTable.getItem(n))).toUpperCase()).startsWith(string = String.valueOf(c).toUpperCase())) continue;
            this.clearStateIfNotAll(c);
            return n;
        }
        for (n = 0; n < n2; ++n) {
            if (!this.isPossibleTargetRow(n) || !(string2 = ((String)this.fItemConverter.convert(this.fTable.getItem(n))).toUpperCase()).startsWith(string = String.valueOf(c).toUpperCase())) continue;
            this.clearStateIfNotAll(c);
            return n;
        }
        return -1;
    }

    private boolean isStateAll(char c) {
        return Pattern.matches("\\Q" + c + "\\E*", this.fState.toString());
    }

    private void clearStateIfNotAll(char c) {
        if (!this.isStateAll(c)) {
            this.fState.setLength(0);
        }
    }

    private boolean isPossibleTargetRow(int n) {
        return this.fTable.getItem(n) != null && !(this.fTable.getItem(n) instanceof Group);
    }
}

