/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.login;

import com.mathworks.webproxy.PropertiesProxyConfiguration;
import com.mathworks.webproxy.ProxyConfiguration;
import com.mathworks.webproxy.ProxyConfigurationVisitor;
import com.mathworks.webproxy.SystemProxyConfiguration;
import com.mathworks.webproxy.SystemProxySettings;
import com.mathworks.webproxy.WebproxyFactory;
import com.mathworks.widgets.login.ProxyConfigurationToProxySettingsAdapter;
import com.mathworks.widgets.login.ProxySettings;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;

public class DefaultProxyConfigurationToProxySettingsAdapter
implements ProxyConfigurationToProxySettingsAdapter {
    private String fWsEndpoint;

    public DefaultProxyConfigurationToProxySettingsAdapter(String string) {
        this.fWsEndpoint = string;
    }

    @Override
    public ProxySettings adaptProxyConfiguration() {
        try {
            ProxyConfiguration proxyConfiguration = WebproxyFactory.createDefaultProxyConfiguration((SystemProxySettings)WebproxyFactory.createSystemProxySettings());
            LoginProxyConfigurationVisitor loginProxyConfigurationVisitor = new LoginProxyConfigurationVisitor(new URL(this.fWsEndpoint));
            proxyConfiguration.accept((ProxyConfigurationVisitor)loginProxyConfigurationVisitor);
            return loginProxyConfigurationVisitor.getProxySettings();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private class LoginProxyConfigurationVisitor
    implements ProxyConfigurationVisitor {
        private final URL iUurl;
        private ProxySettings iProxySettings;

        private LoginProxyConfigurationVisitor(URL uRL) {
            this.iUurl = uRL;
        }

        public void visit(PropertiesProxyConfiguration propertiesProxyConfiguration) {
            Proxy proxy = propertiesProxyConfiguration.findProxyForURL(this.iUurl);
            if (this.isProxy(proxy)) {
                this.iProxySettings = this.createProxySettingsWithCredentials(proxy, propertiesProxyConfiguration.getPasswordAuthentication());
            }
        }

        public void visit(SystemProxyConfiguration systemProxyConfiguration) {
            Proxy proxy = systemProxyConfiguration.findProxyForURL(this.iUurl);
            if (this.isProxy(proxy)) {
                this.iProxySettings = this.createProxySettings(proxy);
            }
        }

        private boolean isProxy(Proxy proxy) {
            return !proxy.equals(Proxy.NO_PROXY);
        }

        private ProxySettings createProxySettings(Proxy proxy) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)proxy.address();
            return new ProxySettings(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
        }

        private ProxySettings createProxySettingsWithCredentials(Proxy proxy, PasswordAuthentication passwordAuthentication) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)proxy.address();
            return new ProxySettings(inetSocketAddress.getHostName(), inetSocketAddress.getPort(), passwordAuthentication.getUserName(), String.valueOf(passwordAuthentication.getPassword()));
        }

        private ProxySettings getProxySettings() {
            return this.iProxySettings;
        }
    }
}

