/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.login;

public class ProxySettings {
    private final String fHost;
    private final int fPort;
    private final String fUsername;
    private final String fPassword;

    public ProxySettings(String string, String string2) {
        this(string, string2, null, null);
    }

    public ProxySettings(String string, int n) {
        this(string, n, null, null);
    }

    public ProxySettings(String string, String string2, String string3, String string4) {
        this(string, ProxySettings.parsePort(string2), string3, string4);
    }

    public ProxySettings(String string, int n, String string2, String string3) {
        this.fHost = string;
        this.fPort = n;
        this.fUsername = string2;
        this.fPassword = string3;
    }

    private static int parsePort(String string) {
        int n = -1;
        if (string != null && string.length() > 0) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public String getHost() {
        return this.fHost;
    }

    public int getPort() {
        return this.fPort;
    }

    public String getUsername() {
        return this.fUsername;
    }

    public String getPassword() {
        return this.fPassword;
    }

    public boolean hasValidProxySettings() {
        return this.getHost() != null && this.getHost().length() > 0 && this.getPort() != -1;
    }

    public boolean hasValidAuthenticationSettings() {
        return this.getUsername() != null && this.getUsername().length() > 0 && this.getPassword() != null && this.getPassword().length() > 0;
    }
}

