/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.messagepanel;

import com.mathworks.matlab.api.editor.EditorMessage;
import com.mathworks.util.Log;
import com.mathworks.util.StringUtils;
import com.mathworks.widgets.messagepanel.DefaultMessagePanelPainter;
import com.mathworks.widgets.messagepanel.MessageModel;
import com.mathworks.widgets.messagepanel.MessageModelListener;
import com.mathworks.widgets.messagepanel.MessagePanelListener;
import com.mathworks.widgets.messagepanel.MessagePanelPainter;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import org.apache.commons.lang.StringEscapeUtils;

public class MessagePanel
extends JComponent {
    public static final int PANEL_WIDTH = 15;
    private static final int PANEL_EDGE_GAP = 2;
    private static final int PANEL_TOP_EDGE_GAP = 0;
    private static final int SUMMARY_SQUARE_GAP = 5;
    public static final int MARKER_HEIGHT = 2;
    public static final int BASE_LAYER_MARKER_HEIGHT = 10;
    private static final int MAX_TOOLTIP_MESSAGES = 20;
    private static final Color DEFAULT_MESSAGE_BORDER_COLOR = new Color(128, 128, 128);
    public static final Paint INVALID_SUMMARY_PAINT = new GradientPaint(0.0f, 0.0f, Color.WHITE, 15.0f, 15.0f, UIManager.getColor("Panel.background"));
    public static final Color INVALID_COLOR = new Color(192, 192, 192);
    private final MessageModel<?> fModel;
    private final Set<MessagePanelListener<?>> fListeners;
    private final Shape fSummaryShape;
    private final boolean fMakeTips;
    private MessagePanelPainter fPainter;
    private boolean fValid;
    private TextAlignmentProvider fProvider;

    public MessagePanel(MessageModel<?> messageModel) {
        this(messageModel, new DefaultMessagePanelPainter(), true);
    }

    public MessagePanel(MessageModel<?> messageModel, MessagePanelPainter<?> messagePanelPainter) {
        this(messageModel, messagePanelPainter, true);
    }

    public MessagePanel(MessageModel<?> messageModel, MessagePanelPainter<?> messagePanelPainter, boolean bl) {
        if (messageModel == null) {
            throw new IllegalArgumentException("'model' cannot be null");
        }
        if (messagePanelPainter == null) {
            throw new IllegalArgumentException("'painter' cannot be null");
        }
        this.fMakeTips = bl;
        this.fModel = messageModel;
        this.fModel.addListener(new MessageModelListener(){

            @Override
            public void messagesUpdated() {
                MessagePanel.this.repaint();
            }
        });
        this.fPainter = messagePanelPainter;
        this.fListeners = new HashSet();
        this.fSummaryShape = new Rectangle(2, 0, 11, 11);
        this.setPreferredSize(new Dimension(15, 30));
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addListenerForCursor();
        this.addMouseClickListener();
    }

    public MessageModel<?> getModel() {
        return this.fModel;
    }

    public void setPanelValid(boolean bl) {
        if (this.fValid != bl) {
            this.fValid = bl;
            this.repaint();
        }
    }

    public boolean isPanelValid() {
        return this.fValid;
    }

    public void addListener(MessagePanelListener<?> messagePanelListener) {
        this.fListeners.add(messagePanelListener);
    }

    public void removeListener(MessagePanelListener<?> messagePanelListener) {
        this.fListeners.remove(messagePanelListener);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.isOverSummary(mouseEvent)) {
            return null;
        }
        if (this.fMakeTips) {
            return this.getToolTipTextForMessages(this.getIndicesUnder(mouseEvent));
        }
        return null;
    }

    private String getToolTipTextForMessages(Integer[] integerArray) {
        if (integerArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder("<html>");
            for (int i = 0; i < integerArray.length; ++i) {
                String string = this.fModel.getTextAt(integerArray[i]);
                string = StringEscapeUtils.escapeHtml((String)string);
                string = StringUtils.replaceAllStrings((String)string, (String)"\n", (String)"<br>&nbsp;");
                stringBuilder.append("&nbsp;").append(string);
                if (i >= integerArray.length - 1) continue;
                stringBuilder.append("<br>");
            }
            stringBuilder.append("</html>");
            return stringBuilder.toString();
        }
        return null;
    }

    public void setTextAlignmentProvider(TextAlignmentProvider textAlignmentProvider) {
        this.fProvider = textAlignmentProvider;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        this.paintSummary(graphics);
        if (this.fModel.getMessageCount() > 0) {
            if (this.fValid) {
                this.paintMessages((Graphics2D)graphics);
            } else {
                this.paintInvalid((Graphics2D)graphics);
            }
        }
    }

    private void paintMessages(Graphics2D graphics2D) {
        this.paintMessagesBasedOnModelPriority(graphics2D, MessageModel.Priority.BASE_LAYER);
        this.paintMessagesBasedOnModelPriority(graphics2D, MessageModel.Priority.TRANSIENT_LAYER);
    }

    private void paintMessagesBasedOnModelPriority(Graphics2D graphics2D, MessageModel.Priority priority) {
        TreeMap treeMap = new TreeMap();
        for (int i = 0; i < this.fModel.getMessageCount(); ++i) {
            if (this.fModel.getModelPriority(i) != priority) continue;
            int n = this.fModel.getPriorityAt(i);
            if (!treeMap.containsKey(n)) {
                treeMap.put(n, new ArrayList());
            }
            ((List)treeMap.get(n)).add(i);
        }
        for (List list : treeMap.values()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                Rectangle rectangle = this.computeRectangleHeights(this.fModel.getLineNumberAt(n), this.fModel.getModelPriority(n), this.fModel.getMessageAt(n), this.fModel.getLineCount());
                graphics2D.setPaint(this.fPainter.getPaintForMessage(this.fModel.getMessageAt(n)));
                graphics2D.fill(rectangle);
            }
        }
    }

    private void paintInvalid(Graphics2D graphics2D) {
        graphics2D.setColor(INVALID_COLOR);
        for (int i = 0; i < this.fModel.getMessageCount(); ++i) {
            Rectangle rectangle = this.computeRectangleHeights(this.fModel.getLineNumberAt(i), this.fModel.getModelPriority(i), this.fModel.getMessageAt(i), this.fModel.getLineCount());
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private void paintSummary(Graphics graphics) {
        Paint paint = this.fValid ? this.fPainter.getPaintForSummary(this.fModel) : INVALID_SUMMARY_PAINT;
        if (paint != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(paint);
            graphics2D.fill(this.fSummaryShape);
            graphics2D.setColor(DEFAULT_MESSAGE_BORDER_COLOR);
            graphics2D.draw(this.fSummaryShape);
        }
    }

    protected boolean isOverSummary(MouseEvent mouseEvent) {
        return this.fSummaryShape.contains(mouseEvent.getX(), mouseEvent.getY());
    }

    private Rectangle initializeRectangle(MessageModel.Priority priority) {
        Rectangle rectangle = new Rectangle();
        rectangle.x = priority == MessageModel.Priority.BASE_LAYER ? 0 : 2;
        rectangle.y = 0;
        rectangle.width = (this.isValid() ? this.getWidth() : 15) - (priority == MessageModel.Priority.BASE_LAYER ? 0 : 4);
        rectangle.height = 0;
        return rectangle;
    }

    private Rectangle computeRectangleHeights(int n, MessageModel.Priority priority, Object object, int n2) {
        int n3 = 2;
        if (priority == MessageModel.Priority.BASE_LAYER) {
            double d = (double)(object instanceof EditorMessage ? ((EditorMessage)object).getNumberOfLines() : 1) / (double)n2;
            n3 = Math.max(10, this.getMessageBarPercentage(d));
        }
        Rectangle rectangle = this.initializeRectangle(priority);
        rectangle.height = n3;
        if (this.fProvider == null || !this.fProvider.isFullTextShowing()) {
            double d = (double)n / (double)this.fModel.getLineCount();
            rectangle.y = this.getMessageBarPercentage(d) + 15 + 5;
        } else {
            try {
                Rectangle rectangle2 = this.fProvider.getRectangleAtLine(n);
                if (rectangle2 != null) {
                    rectangle.y = Math.max(20, rectangle2.y + rectangle2.height / 2);
                } else {
                    rectangle.height = -1;
                }
            }
            catch (BadLocationException badLocationException) {
                Log.logException((Exception)badLocationException);
            }
        }
        return rectangle;
    }

    public int getMessageBarPercentage(double d) {
        return (int)((double)(this.getHeight() - 15 - 47) * d);
    }

    public List<?> getMessagesUnder(MouseEvent mouseEvent) {
        assert (mouseEvent != null) : "event cannot be null";
        Integer[] integerArray = this.getIndicesUnder(mouseEvent);
        ArrayList arrayList = integerArray.length == 0 ? Collections.emptyList() : new ArrayList(integerArray.length);
        Integer[] integerArray2 = integerArray;
        int n = integerArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2 = integerArray2[i];
            arrayList.add(this.fModel.getMessageAt(n2));
        }
        return arrayList;
    }

    public Integer[] getIndicesUnder(MouseEvent mouseEvent) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>(new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                int n3 = Integer.valueOf(MessagePanel.this.fModel.getLineNumberAt(n)).compareTo(MessagePanel.this.fModel.getLineNumberAt(n2));
                int n4 = Integer.valueOf(MessagePanel.this.fModel.getPriorityAt(n2)).compareTo(MessagePanel.this.fModel.getPriorityAt(n));
                return n3 == 0 ? (n4 == 0 ? n.compareTo(n2) : n4) : n3;
            }
        });
        for (int i = 0; i < this.fModel.getMessageCount(); ++i) {
            Rectangle rectangle = this.computeRectangleHeights(this.fModel.getLineNumberAt(i), this.fModel.getModelPriority(i), this.fModel.getMessageAt(i), this.fModel.getLineCount());
            rectangle.y -= 2;
            rectangle.height += 4;
            if (rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) {
                treeSet.add(i);
            }
            if (treeSet.size() >= 20) break;
        }
        return treeSet.toArray(new Integer[treeSet.size()]);
    }

    private void addListenerForCursor() {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                boolean bl = MessagePanel.this.isOverSummary(mouseEvent) && MessagePanel.this.fPainter.getPaintForSummary(MessagePanel.this.fModel) != null || !MessagePanel.this.getMessagesUnder(mouseEvent).isEmpty();
                MessagePanel.this.setCursor(bl ? Cursor.getPredefinedCursor(12) : null);
            }
        });
    }

    private void addMouseClickListener() {
        this.addMouseListener(new MouseAdapter(){
            private int fOriginalToolTipDelay;

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (MessagePanel.this.fValid && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    Integer[] integerArray = MessagePanel.this.getIndicesUnder(mouseEvent);
                    if (integerArray.length > 0) {
                        MessagePanel.this.notifyListeners(MessagePanel.this.getFirstHighestPriorityMessage(integerArray));
                    } else if (MessagePanel.this.isOverSummary(mouseEvent)) {
                        MessagePanel.this.notifyListenersOfSummary(mouseEvent);
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.fOriginalToolTipDelay = ToolTipManager.sharedInstance().getInitialDelay();
                ToolTipManager.sharedInstance().setInitialDelay(0);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ToolTipManager.sharedInstance().setInitialDelay(this.fOriginalToolTipDelay);
                MessagePanel.this.repaint();
            }
        });
    }

    private Object getFirstHighestPriorityMessage(Integer[] integerArray) {
        int n = integerArray[0];
        int n2 = this.fModel.getPriorityAt(n);
        for (int i = 1; i < integerArray.length; ++i) {
            int n3 = this.fModel.getPriorityAt(integerArray[i]);
            if (n3 <= n2) continue;
            n2 = n3;
            n = integerArray[i];
        }
        return this.fModel.getMessageAt(n);
    }

    public List<Rectangle> getAllStripes() {
        Vector<Rectangle> vector = new Vector<Rectangle>();
        for (int i = 0; i < this.fModel.getMessageCount(); ++i) {
            Rectangle rectangle = this.computeRectangleHeights(this.fModel.getLineNumberAt(i), this.fModel.getModelPriority(i), this.fModel.getMessageAt(i), this.fModel.getLineCount());
            vector.add(rectangle);
        }
        return vector;
    }

    private void notifyListeners(Object object) {
        for (MessagePanelListener<?> messagePanelListener : this.fListeners) {
            messagePanelListener.messageClicked(object);
        }
    }

    private void notifyListenersOfSummary(MouseEvent mouseEvent) {
        for (MessagePanelListener<?> messagePanelListener : this.fListeners) {
            messagePanelListener.summarySquareClicked(!mouseEvent.isShiftDown());
        }
    }

    public void clickSummary() {
        this.notifyListenersOfSummary(new MouseEvent(this, 0, 0L, 0, (int)this.fSummaryShape.getBounds().getCenterX(), (int)this.fSummaryShape.getBounds().getCenterY(), 1, false));
    }

    public static interface TextAlignmentProvider {
        public Rectangle getRectangleAtLine(int var1) throws BadLocationException;

        public boolean isFullTextShowing();
    }
}

