/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.prefs;

import com.mathworks.util.tree.TreeUtils;
import com.mathworks.util.tree.Visitor;
import com.mathworks.widgets.prefs.PrefsModelEvent;
import com.mathworks.widgets.prefs.PrefsModelListener;
import com.mathworks.widgets.prefs.PrefsNode;
import com.mathworks.widgets.prefs.PrefsUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;

public final class PrefsModel {
    private final PrefsNode fRoot;
    private final Set<PrefsModelListener> fListeners;

    public PrefsModel() {
        this(PrefsNode.createRootNode(new Vector<PrefsNode>(0)));
    }

    public PrefsModel(Iterable<PrefsNode> iterable) {
        this(PrefsNode.createRootNode(iterable));
    }

    private PrefsModel(PrefsNode prefsNode) {
        this.fRoot = prefsNode;
        this.fRoot.install(this);
        this.fListeners = new HashSet<PrefsModelListener>();
    }

    public PrefsNode getRoot() {
        return this.fRoot;
    }

    public Collection<PrefsNode> getDirtyNodes() {
        final HashSet<PrefsNode> hashSet = new HashSet<PrefsNode>();
        TreeUtils.visit(PrefsUtils.toTree(this.getRoot()), (Visitor)new Visitor<PrefsNode>(){

            public void visit(PrefsNode prefsNode) {
                if (prefsNode.isDirty()) {
                    hashSet.add(prefsNode);
                }
            }
        });
        return hashSet;
    }

    public Iterable<PrefsNode> getAllNodesWithComponents() {
        final LinkedList<PrefsNode> linkedList = new LinkedList<PrefsNode>();
        TreeUtils.visit(PrefsUtils.toTree(this.getRoot()), (Visitor)new Visitor<PrefsNode>(){

            public void visit(PrefsNode prefsNode) {
                if (prefsNode.isEditable()) {
                    linkedList.add(prefsNode);
                }
            }
        });
        return linkedList;
    }

    public void addPrefsModelListener(PrefsModelListener prefsModelListener) {
        this.fListeners.add(prefsModelListener);
    }

    public void removePrefsModelListener(PrefsModelListener prefsModelListener) {
        this.fListeners.remove(prefsModelListener);
    }

    void fireNodeTurnedOn(PrefsNode prefsNode) {
        PrefsModelEvent prefsModelEvent = new PrefsModelEvent(this, prefsNode);
        for (PrefsModelListener prefsModelListener : this.fListeners) {
            prefsModelListener.nodeTurnedOn(prefsModelEvent);
        }
    }

    void fireNodeTurnedOff(PrefsNode prefsNode) {
        PrefsModelEvent prefsModelEvent = new PrefsModelEvent(this, prefsNode);
        for (PrefsModelListener prefsModelListener : this.fListeners) {
            prefsModelListener.nodeTurnedOff(prefsModelEvent);
        }
    }
}

