/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet;

import com.mathworks.mwswing.AppearanceFocusDispatcher;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.MInputMap;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.ArrayUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.spreadsheet.CellLocation;
import com.mathworks.widgets.spreadsheet.HeaderRenderer;
import com.mathworks.widgets.spreadsheet.IDataBoundsSupplier;
import com.mathworks.widgets.spreadsheet.IHeaderRenderer;
import com.mathworks.widgets.spreadsheet.ISelectionOpProvider;
import com.mathworks.widgets.spreadsheet.ISpreadsheetNavPrefControl;
import com.mathworks.widgets.spreadsheet.ISpreadsheetSelectionController;
import com.mathworks.widgets.spreadsheet.RangeSelectionModel;
import com.mathworks.widgets.spreadsheet.ResizingTableModelWrapper;
import com.mathworks.widgets.spreadsheet.SelectionHider;
import com.mathworks.widgets.spreadsheet.SpreadsheetUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public abstract class AbstractSpreadsheetTable
extends MJTable
implements ISelectionOpProvider,
ISpreadsheetSelectionController,
ISpreadsheetNavPrefControl,
SelectionHider {
    protected MInputMap fInputMap = MInputMap.createMInputMap((JComponent)((Object)this));
    protected SelectAllAction fSelectAllAction;
    protected MJPopupMenu fSelectionPopupMenu;
    protected IHeaderRenderer fHeaderRenderer = null;
    protected boolean fMotionOnEnter;
    protected int fMotionOnEnterDirection;
    protected boolean fEditable;
    protected int fHAlignmentOverrideDir = 2;
    protected boolean fHAlignmentOverride = false;
    private int fRowHeight = -1;
    private static final int ROW_HEIGHT_ADJUSTMENT;
    protected boolean fIsPrimaryFocusOwner = false;
    protected MJAbstractAction fStopEditingAction;
    private boolean fSelectionModeByHeader = false;
    protected AppearanceFocusDispatcher fAFD;
    protected boolean fSelectionHidden;
    private RangeSelectionModel fRestrictedRowSelectionModel;
    private RangeSelectionModel fRestrictedColumnSelectionModel;
    private boolean fIsDragSelectionEnabled = true;
    private int fStartSelectionIndex = -1;
    private int fPrevSelectionIndex = -1;
    public static final int ROWS = 0;
    public static final int COLUMNS = 1;
    public static final int SCHEME_MATLAB = 0;
    public static final int SCHEME_SPREADSHEET = 1;
    public static final int SCHEME_VALUE = 2;
    private static final int NONE = 0;
    private static final int UPPER_LEFT = 1;
    private static final int UPPER_RIGHT = 2;
    private static final int LOWER_RIGHT = 3;
    private static final int LOWER_LEFT = 4;
    protected static int HEADER_HEIGHT;
    protected static final int COLUMN_RESIZE_TOLERANCE = 2;
    private AbstractTableHeaderMouseEventListener fAThmel;

    public abstract void selectEntireColumns();

    public abstract void selectEntireRows();

    public void arrowRight() {
    }

    public void arrowLeft() {
    }

    public void arrowUp() {
    }

    public void arrowDown() {
    }

    public void pageDown() {
    }

    public void pageUp() {
    }

    public void selectUp() {
    }

    public void selectDown() {
    }

    public void selectRight() {
    }

    public void selectLeft() {
    }

    void startEditingWithAppend() {
    }

    public AbstractSpreadsheetTable(TableModel tableModel) {
        super(tableModel);
        this.setupSelectionAsPerSpreadsheet();
        this.setMotionOnEnter(true);
        this.setMotionOnEnterDirection(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.fAThmel = new AbstractTableHeaderMouseEventListener();
        this.getTableHeader().addMouseListener(this.fAThmel);
        this.getTableHeader().addMouseMotionListener(this.fAThmel);
        this.bindKeysAsPerSpreadsheet();
        if (PlatformInfo.isXWindows()) {
            this.setMiddleSelectionEnabled(true);
        }
        this.setHorizontalAutoScrollEnabled(true);
        this.fIsPrimaryFocusOwner = true;
        this.fAFD = new AppearanceFocusDispatcher();
        this.addFocusListener((FocusListener)this.fAFD);
    }

    protected JTableHeader createDefaultTableHeader() {
        return new SpreadsheetTableHeader(this.columnModel);
    }

    protected void setupSelectionAsPerSpreadsheet() {
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.setRightSelectionEnabled(true);
    }

    private static void logException(Exception exception) {
        exception.printStackTrace();
    }

    protected void bindKeysAsPerSpreadsheet() {
        this.registerWithInputMap(new AnonNavigationAction("SelectZeroZero", 36, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK, true, "selectZeroZero"));
        this.registerWithInputMap(new AnonNavigationAction("SelectEntireColumns", 32, 2, false, "selectEntireColumns"));
        this.registerWithInputMap(new AnonNavigationAction("SelectEntireRows", 32, 1, false, "selectEntireRows"));
        this.registerWithInputMap(new AnonNavigationAction("SelectToBottomRight", 35, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK | 1, true, "selectToBottomRight"));
        this.registerWithInputMap(new AnonNavigationAction("SelectCurrentRegion", 56, 3, false, "selectCurrentRegion"));
        this.registerWithInputMap(new AnonNavigationAction("SelectToColumnTop", 38, 3, false, "selectToColumnTop"));
        this.registerWithInputMap(new AnonNavigationAction("SelectToColumnBottom", 40, 3, false, "selectToColumnBottom"));
        this.registerWithInputMap(new AnonNavigationAction("SelectToLeftmostRow", 37, 3, false, "selectToLeftmostRow"));
        this.registerWithInputMap(new AnonNavigationAction("SelectToRightmostRow", 39, 3, false, "selectToRightmostRow"));
        this.registerWithInputMap(new AnonNavigationAction("RotateAnchorLocation", 46, 2, false, "rotateAnchorLocation"));
        this.registerWithInputMap(new AnonNavigationAction("SelectColumnTop", 38, 2, false, "selectColumnTop"));
        this.registerWithInputMap(new AnonNavigationAction("SelectColumnBottom", 40, 2, false, "selectColumnBottom"));
        this.registerWithInputMap(new AnonNavigationAction("SelectRowLeftmost", 37, 2, false, "selectRowLeftmost"));
        this.registerWithInputMap(new AnonNavigationAction("SelectRowRightmost", 39, 2, false, "selectRowRightmost"));
        this.getActionMap().put("selectPreviousColumnCell", (Action)((Object)new ModifiedWrapAction(1)));
        this.getActionMap().put("selectPreviousRowCell", (Action)((Object)new ModifiedWrapAction(0)));
    }

    public void setScheme(int n) {
        this.setHeaderRenderer(n);
    }

    protected void setHeaderRenderer(int n) {
        IHeaderRenderer iHeaderRenderer = this.fHeaderRenderer;
        this.fHeaderRenderer = new HeaderRenderer(0, n);
        this.getTableHeader().setDefaultRenderer(this.fHeaderRenderer);
        if (iHeaderRenderer != null) {
            iHeaderRenderer.cleanup();
        }
    }

    @Override
    public int getMotionOnEnterDirection() {
        return this.fMotionOnEnterDirection;
    }

    @Override
    public void setMotionOnEnterDirection(int n) {
        this.fMotionOnEnterDirection = n;
    }

    @Override
    public boolean isMotionOnEnter() {
        return this.fMotionOnEnter;
    }

    @Override
    public void setMotionOnEnter(boolean bl) {
        this.fMotionOnEnter = bl;
    }

    public boolean isEditable() {
        return false;
    }

    public boolean isDragSelectionEnabled() {
        return this.fIsDragSelectionEnabled;
    }

    public void setDragSelectionEnabled(boolean bl) {
        this.fIsDragSelectionEnabled = bl;
    }

    protected boolean mayAutoStartEdit(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (keyStroke.getKeyCode() == 0) {
            return false;
        }
        return super.mayAutoStartEdit(keyStroke, keyEvent, n, bl) && !keyEvent.isControlDown() && !keyEvent.isMetaDown() && (!keyEvent.isAltDown() || PlatformInfo.isMacintosh()) && keyEvent.getKeyCode() != 27;
    }

    public boolean processPossiblePopup(MouseEvent mouseEvent) {
        Object object;
        boolean bl = false;
        if (mouseEvent.isPopupTrigger() && (object = mouseEvent.getSource()) instanceof Component) {
            this.fSelectionPopupMenu.show((Component)object, mouseEvent.getX(), mouseEvent.getY());
            mouseEvent.consume();
            bl = true;
        }
        return bl;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.setTableRowHeight();
    }

    public void addNotify() {
        super.addNotify();
        if (this.fRowHeight == -1) {
            this.setTableRowHeight();
        }
    }

    private void setTableRowHeight() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            int n = graphics.getFontMetrics().getHeight() + AbstractSpreadsheetTable.getRowHeightAdjustment();
            if (this.fRowHeight != n) {
                this.setRowHeight(n);
                this.fRowHeight = n;
            }
            graphics.dispose();
        }
    }

    static int getRowHeightAdjustment() {
        return ROW_HEIGHT_ADJUSTMENT;
    }

    boolean isPrimaryFocusOwner() {
        return this.fIsPrimaryFocusOwner;
    }

    public boolean isSelectionModeByHeader() {
        return this.fSelectionModeByHeader;
    }

    public void setSelectionModeByHeader(boolean bl) {
        this.fSelectionModeByHeader = bl;
        if (!bl) {
            this.setCellSelectionEnabled(true);
        }
    }

    void selectZeroZero() {
        this.selectSingleCell(0, 0);
    }

    void selectToZeroZero() {
        CellLocation cellLocation = this.getAnchorLocation();
        this.setRowSelectionInterval(0, cellLocation.getRow());
        this.setColumnSelectionInterval(0, cellLocation.getColumn());
        this.setAnchorLocation(cellLocation);
        this.scrollRectToVisible(new Rectangle(0, 0));
    }

    private boolean isInDataRegion(CellLocation cellLocation) {
        return cellLocation.getColumn() <= this.getLastDataCell(1) && cellLocation.getRow() <= this.getLastDataCell(0);
    }

    void selectCurrentRegion() {
        CellLocation cellLocation = this.getAnchorLocation();
        if (this.isInDataRegion(cellLocation)) {
            this.setRowSelectionInterval(0, this.getLastDataCell(0));
            this.setColumnSelectionInterval(0, this.getLastDataCell(1));
            this.setAnchorLocation(cellLocation);
        } else {
            this.selectActiveCell();
        }
    }

    void selectActiveCell() {
        CellLocation cellLocation = this.getAnchorLocation();
        this.setRowSelectionInterval(cellLocation.getRow(), cellLocation.getRow());
        this.setColumnSelectionInterval(cellLocation.getColumn(), cellLocation.getColumn());
    }

    void selectColumnTop() {
        this.selectSingleCell(0, this.getAnchorLocation().getColumn());
    }

    void selectRowLeftmost() {
        this.selectSingleCell(this.getAnchorLocation().getRow(), 0);
    }

    void selectColumnBottom() {
        this.selectSingleCell(this.getLastDataCell(0), this.getAnchorLocation().getColumn());
    }

    void selectRowRightmost() {
        this.selectSingleCell(this.getAnchorLocation().getRow(), this.getLastDataCell(1));
    }

    private void selectSingleCell(int n, int n2) {
        this.setRowSelectionInterval(n, n);
        this.setColumnSelectionInterval(n2, n2);
        this.setAnchorLocation(CellLocation.getInstance(n, n2));
        this.scrollCellToVisible(n, n2);
    }

    void selectToColumnTop() {
        this.setRowSelectionInterval(0, this.getAnchorLocation().getRow());
    }

    void selectToColumnBottom() {
        this.setRowSelectionInterval(this.getAnchorLocation().getRow(), this.getLastDataCell(0));
    }

    void selectToLeftmostRow() {
        this.setColumnSelectionInterval(0, this.getAnchorLocation().getColumn());
    }

    void selectToRightmostRow() {
        this.setColumnSelectionInterval(this.getAnchorLocation().getColumn(), this.getLastDataCell(1));
    }

    public void scrollCellToVisible(int n, int n2) {
        this.scrollRectToVisible(this.getCellRect(n, n2, true));
    }

    private int whichCornerOfSelection(CellLocation cellLocation) {
        int[] nArray = this.getSelectedRows();
        int[] nArray2 = this.getSelectedColumns();
        if (nArray.length == 0 || nArray2.length == 0) {
            return 0;
        }
        if (nArray[0] == cellLocation.getRow()) {
            if (nArray2[0] == cellLocation.getColumn()) {
                return 1;
            }
            if (nArray2[nArray2.length - 1] == cellLocation.getColumn()) {
                return 2;
            }
        } else if (nArray[nArray.length - 1] == cellLocation.getRow()) {
            if (nArray2[0] == cellLocation.getColumn()) {
                return 4;
            }
            if (nArray2[nArray2.length - 1] == cellLocation.getColumn()) {
                return 3;
            }
        }
        return 0;
    }

    void rotateAnchorLocation() {
        int[] nArray = this.getSelectedRows();
        int[] nArray2 = this.getSelectedColumns();
        if (nArray.length == 0 || nArray2.length == 0) {
            return;
        }
        CellLocation cellLocation = this.getAnchorLocation();
        int n = this.whichCornerOfSelection(cellLocation);
        CellLocation cellLocation2 = CellLocation.getInstance(0, 0);
        if (n == 0 || n == 4) {
            cellLocation2 = CellLocation.getInstance(nArray[0], nArray2[0]);
        }
        if (n == 1) {
            cellLocation2 = CellLocation.getInstance(nArray[0], nArray2[nArray2.length - 1]);
        }
        if (n == 0 || n == 2) {
            cellLocation2 = CellLocation.getInstance(nArray[nArray.length - 1], nArray2[nArray2.length - 1]);
        }
        if (n == 0 || n == 3) {
            cellLocation2 = CellLocation.getInstance(nArray[nArray.length - 1], nArray2[0]);
        }
        this.setAnchorLocation(cellLocation2);
    }

    public void setAutoGrowthTemporarilyDisabled(boolean bl) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof ResizingTableModelWrapper) {
            ((ResizingTableModelWrapper)tableModel).setAutoGrowthTemporarilyDisabled(bl);
        }
    }

    public boolean getAutoGrowthTemporarilyDisabled() {
        TableModel tableModel = this.getModel();
        return !(tableModel instanceof ResizingTableModelWrapper) || ((ResizingTableModelWrapper)tableModel).getAutoGrowthTemporarilyDisabled();
    }

    void selectToBottomRight() {
        CellLocation cellLocation = this.getAnchorLocation();
        int n = this.getLastDataCell(0);
        int n2 = this.getLastDataCell(1);
        this.setRowSelectionInterval(cellLocation.getRow(), n);
        this.setColumnSelectionInterval(cellLocation.getColumn(), n2);
        this.setAnchorLocation(cellLocation);
    }

    public CellLocation getAnchorLocation() {
        return CellLocation.getInstance(this.getSelectionModel().getAnchorSelectionIndex(), this.getColumnModel().getSelectionModel().getAnchorSelectionIndex());
    }

    public void setAnchorLocation(CellLocation cellLocation) {
        this.getSelectionModel().setAnchorSelectionIndex(cellLocation.getRow());
        this.getColumnModel().getSelectionModel().setAnchorSelectionIndex(cellLocation.getColumn());
    }

    protected void registerWithInputMap(MJAbstractAction mJAbstractAction) {
        this.registerWithInputMapNoKeyBindingManager(mJAbstractAction.getAccelerator(), (Action)mJAbstractAction);
    }

    protected void registerWithInputMapNoKeyBindingManager(KeyStroke keyStroke, Action action) {
        this.fInputMap.put(keyStroke, action.getValue("Name"));
        if (PlatformInfo.isMacintosh() && action instanceof MSAbstractAction && ((MSAbstractAction)((Object)action)).getDualMacRegistration()) {
            int n = keyStroke.getModifiers();
            int n2 = n ^ KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK ^ 0x100 | 2;
            this.fInputMap.put(KeyStroke.getKeyStroke(keyStroke.getKeyCode(), n2), action.getValue("Name"));
        }
        this.getActionMap().put(action.getValue("Name"), action);
    }

    protected void registerWithMapsUsingKeyBindingManager(MJAbstractAction mJAbstractAction) {
        assert (MatlabKeyBindings.getManager().containsActionAndContext((Action)mJAbstractAction)) : "Action is not registered in keybinding manager";
        MatlabKeyBindings.getManager().addKeyBindings((ExtendedAction)mJAbstractAction, (ExtendedInputMap)this.fInputMap);
        MatlabKeyBindings.getManager().addToActionMap((ExtendedAction)mJAbstractAction, this.getActionMap());
    }

    public int[] restrictRowColumnSpecToValidRegion(int[] nArray, int n) {
        int n2;
        int n3;
        Object object;
        TableModel tableModel = this.getModel();
        if (tableModel instanceof IDataBoundsSupplier) {
            object = (IDataBoundsSupplier)((Object)tableModel);
            if (n == 0) {
                n3 = object.getFirstDataRow();
                n2 = object.getLastDataRow();
            } else {
                n3 = object.getFirstDataColumn();
                n2 = object.getLastDataColumn();
            }
        } else {
            n3 = 0;
            n2 = n == 0 ? tableModel.getRowCount() - 1 : tableModel.getColumnCount() - 1;
        }
        object = new boolean[nArray.length];
        int n4 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] > n2 || nArray[i] < n3) continue;
            object[i] = true;
            ++n4;
        }
        int[] nArray2 = new int[n4];
        int n5 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (object[i] == false) continue;
            nArray2[n5] = nArray[i];
            ++n5;
        }
        return nArray2;
    }

    private int getLastDataCell(int n) {
        int n2;
        TableModel tableModel = this.getModel();
        if (tableModel instanceof IDataBoundsSupplier) {
            IDataBoundsSupplier iDataBoundsSupplier = (IDataBoundsSupplier)((Object)tableModel);
            n2 = n == 0 ? iDataBoundsSupplier.getLastDataRow() : iDataBoundsSupplier.getLastDataColumn();
        } else {
            n2 = n == 0 ? tableModel.getRowCount() - 1 : tableModel.getColumnCount() - 1;
        }
        return n2;
    }

    public void selectAll() {
        CellLocation cellLocation = this.getAnchorLocation();
        super.selectAll();
        this.setAnchorLocation(cellLocation);
    }

    @Override
    public Action getSelectAllAction() {
        if (this.fSelectAllAction == null) {
            this.fSelectAllAction = new SelectAllAction();
        }
        return this.fSelectAllAction;
    }

    @Override
    public RangeSelectionModel getSpreadsheetRowSelectionModel() {
        if (this.fRestrictedRowSelectionModel == null) {
            this.fRestrictedRowSelectionModel = new RestrictedSelectionModel(0);
        }
        return this.fRestrictedRowSelectionModel;
    }

    @Override
    public RangeSelectionModel getSpreadsheetColumnSelectionModel() {
        if (this.fRestrictedColumnSelectionModel == null) {
            this.fRestrictedColumnSelectionModel = new RestrictedSelectionModel(1);
        }
        return this.fRestrictedColumnSelectionModel;
    }

    @Override
    public void setSelectionHidden(boolean bl) {
        this.fSelectionHidden = bl;
    }

    @Override
    public boolean isSelectionHidden() {
        return this.fSelectionHidden;
    }

    protected boolean useDeprecatedKeybindingManager() {
        return this.useKeyBindingManager();
    }

    protected void doKeybindingSetup(MJAbstractAction mJAbstractAction, String string) {
        MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("SpreadsheetTable", string, (ExtendedAction)mJAbstractAction);
        this.registerWithMapsUsingKeyBindingManager(mJAbstractAction);
    }

    protected void clearKeybindingSetup(MJAbstractAction mJAbstractAction) {
        if (mJAbstractAction.getActionID() != null && mJAbstractAction.getContextID() != null) {
            MatlabKeyBindings.getManager().clearKeyBinding((ExtendedAction)mJAbstractAction);
        }
    }

    public static List<int[]> getSelectionIntervals(int[] nArray) {
        return SpreadsheetUtils.getSelectionIntervals(nArray);
    }

    protected void doDeprecatedKeybindingSetup(MJAbstractAction mJAbstractAction, KeyStroke keyStroke, KeyStroke keyStroke2) {
        mJAbstractAction.setAccelerator(keyStroke);
        this.registerWithInputMapNoKeyBindingManager(keyStroke, (Action)mJAbstractAction);
        if (keyStroke2 != null && PlatformInfo.isMacintosh()) {
            this.registerWithInputMapNoKeyBindingManager(keyStroke2, (Action)mJAbstractAction);
        }
    }

    protected void doDeprecatedKeybindingSetup(MJAbstractAction mJAbstractAction, int n, boolean bl) {
        this.doDeprecatedKeybindingSetup(mJAbstractAction, KeyStroke.getKeyStroke(n, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK), bl ? KeyStroke.getKeyStroke(n, 2) : null);
    }

    @Deprecated
    protected boolean useKeyBindingManager() {
        return true;
    }

    static {
        HEADER_HEIGHT = 24;
        ROW_HEIGHT_ADJUSTMENT = PlatformInfo.isWindows() ? 4 : (PlatformInfo.isMacintosh() ? 4 : 4);
    }

    protected class AbstractTableHeaderMouseEventListener
    extends MouseAdapter {
        protected AbstractTableHeaderMouseEventListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            JTableHeader jTableHeader = AbstractSpreadsheetTable.this.getTableHeader();
            TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
            Point point = mouseEvent.getPoint();
            int n = jTableHeader.columnAtPoint(point);
            if (n == -1) {
                return;
            }
            Point point2 = new Point(point.x - 2, point.y);
            Point point3 = new Point(point.x + 2, point.y);
            int n2 = jTableHeader.columnAtPoint(point2);
            int n3 = jTableHeader.columnAtPoint(point3);
            if (n3 != n) {
                return;
            }
            if (n2 != n && n2 != -1) {
                return;
            }
            if (AbstractSpreadsheetTable.this.isDragSelectionEnabled() && mouseEvent.getButton() == 1) {
                AbstractSpreadsheetTable.this.fStartSelectionIndex = n;
                AbstractSpreadsheetTable.this.fPrevSelectionIndex = n;
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            Rectangle rectangle;
            super.mouseDragged(mouseEvent);
            if (AbstractSpreadsheetTable.this.fStartSelectionIndex < 0 || AbstractSpreadsheetTable.this.fStartSelectionIndex < 0) {
                return;
            }
            JTableHeader jTableHeader = AbstractSpreadsheetTable.this.getTableHeader();
            TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
            ListSelectionModel listSelectionModel = tableColumnModel.getSelectionModel();
            listSelectionModel.setValueIsAdjusting(true);
            Point point = mouseEvent.getPoint();
            int n2 = jTableHeader.columnAtPoint(point);
            if (n2 < 0) {
                listSelectionModel.setValueIsAdjusting(true);
                if (point.x >= AbstractSpreadsheetTable.this.getVisibleRect().width - AbstractSpreadsheetTable.this.getVisibleRect().x) {
                    n2 = AbstractSpreadsheetTable.this.getColumnCount() - 1;
                } else if (point.x <= AbstractSpreadsheetTable.this.getVisibleRect().x) {
                    n2 = 0;
                }
                if (AbstractSpreadsheetTable.this.fPrevSelectionIndex == n2) {
                    return;
                }
                Rectangle rectangle2 = AbstractSpreadsheetTable.this.getCellRect(0, n2, true);
                AbstractSpreadsheetTable.this.scrollRectToVisible(rectangle2);
                AbstractSpreadsheetTable.this.removeColumnSelectionInterval(AbstractSpreadsheetTable.this.fPrevSelectionIndex, n2);
                AbstractSpreadsheetTable.this.removeColumnSelectionInterval(AbstractSpreadsheetTable.this.fPrevSelectionIndex, AbstractSpreadsheetTable.this.fStartSelectionIndex);
                AbstractSpreadsheetTable.this.removeColumnSelectionInterval(AbstractSpreadsheetTable.this.fStartSelectionIndex, n2);
                AbstractSpreadsheetTable.this.addColumnSelectionInterval(AbstractSpreadsheetTable.this.fStartSelectionIndex, n2);
                AbstractSpreadsheetTable.this.fPrevSelectionIndex = n2;
                return;
            }
            if (AbstractSpreadsheetTable.this.fStartSelectionIndex != -1 && AbstractSpreadsheetTable.this.isDragSelectionEnabled() && !(rectangle = AbstractSpreadsheetTable.this.getVisibleRect()).contains(point) && (n = AbstractSpreadsheetTable.this.getColumnModel().getColumnIndexAtX(point.x)) >= 0) {
                Rectangle rectangle3 = AbstractSpreadsheetTable.this.getCellRect(0, n, true);
                AbstractSpreadsheetTable.this.scrollRectToVisible(rectangle3);
            }
            if (AbstractSpreadsheetTable.this.fStartSelectionIndex != -1 && AbstractSpreadsheetTable.this.isDragSelectionEnabled()) {
                if (AbstractSpreadsheetTable.this.fStartSelectionIndex <= n2 && n2 < AbstractSpreadsheetTable.this.fPrevSelectionIndex || AbstractSpreadsheetTable.this.fStartSelectionIndex >= n2 && n2 > AbstractSpreadsheetTable.this.fPrevSelectionIndex || n2 >= AbstractSpreadsheetTable.this.fStartSelectionIndex && AbstractSpreadsheetTable.this.fStartSelectionIndex > AbstractSpreadsheetTable.this.fPrevSelectionIndex || n2 <= AbstractSpreadsheetTable.this.fStartSelectionIndex && AbstractSpreadsheetTable.this.fStartSelectionIndex < AbstractSpreadsheetTable.this.fPrevSelectionIndex) {
                    AbstractSpreadsheetTable.this.removeColumnSelectionInterval(AbstractSpreadsheetTable.this.fPrevSelectionIndex, n2);
                    AbstractSpreadsheetTable.this.removeColumnSelectionInterval(AbstractSpreadsheetTable.this.fPrevSelectionIndex, AbstractSpreadsheetTable.this.fStartSelectionIndex);
                    AbstractSpreadsheetTable.this.removeColumnSelectionInterval(AbstractSpreadsheetTable.this.fStartSelectionIndex, n2);
                    AbstractSpreadsheetTable.this.addColumnSelectionInterval(AbstractSpreadsheetTable.this.fStartSelectionIndex, n2);
                }
                if (n2 != AbstractSpreadsheetTable.this.fStartSelectionIndex) {
                    if (n2 != AbstractSpreadsheetTable.this.fPrevSelectionIndex && n2 >= 0) {
                        if (!AbstractSpreadsheetTable.this.getColumnModel().getSelectionModel().isSelectedIndex(n2)) {
                            AbstractSpreadsheetTable.this.addColumnSelectionInterval(AbstractSpreadsheetTable.this.fStartSelectionIndex, n2);
                        }
                        AbstractSpreadsheetTable.this.fPrevSelectionIndex = n2;
                    }
                    AbstractSpreadsheetTable.this.getTableHeader().repaint();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            JTableHeader jTableHeader = AbstractSpreadsheetTable.this.getTableHeader();
            TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
            ListSelectionModel listSelectionModel = tableColumnModel.getSelectionModel();
            listSelectionModel.setValueIsAdjusting(false);
            AbstractSpreadsheetTable.this.fStartSelectionIndex = -1;
            AbstractSpreadsheetTable.this.fPrevSelectionIndex = -1;
        }
    }

    private class RestrictedSelectionModel
    implements RangeSelectionModel,
    ListSelectionListener {
        private final int iType;
        private List<ChangeListener> iListenerList = new ArrayList<ChangeListener>();

        private RestrictedSelectionModel(int n) {
            this.iType = n;
            AbstractSpreadsheetTable.this.getSelectionModel().addListSelectionListener(this);
            AbstractSpreadsheetTable.this.getColumnModel().getSelectionModel().addListSelectionListener(this);
        }

        @Override
        public String getSelectionRangeString() {
            if (this.iType == 0) {
                return this.getSelectedRowRange();
            }
            return this.getSelectedColumnRange();
        }

        @Override
        public int getSelectionUpperLimit() {
            return AbstractSpreadsheetTable.this.getLastDataCell(this.iType);
        }

        @Override
        public void addSelectionRangeListener(ChangeListener changeListener) {
            this.iListenerList.add(changeListener);
        }

        @Override
        public void removeSelectionRangeListener(ChangeListener changeListener) {
            this.iListenerList.remove(changeListener);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (ChangeListener changeListener : this.iListenerList) {
                changeListener.stateChanged(changeEvent);
            }
        }

        private String getSelectedRowRange() {
            int[] nArray = AbstractSpreadsheetTable.this.restrictRowColumnSpecToValidRegion(AbstractSpreadsheetTable.this.getSelectedRows(), 0);
            List<int[]> list = AbstractSpreadsheetTable.getSelectionIntervals(nArray);
            if (AbstractSpreadsheetTable.this.getModel() instanceof IDataBoundsSupplier) {
                IDataBoundsSupplier iDataBoundsSupplier = (IDataBoundsSupplier)((Object)AbstractSpreadsheetTable.this.getModel());
                return SpreadsheetUtils.getSelectionString(list, iDataBoundsSupplier.getLastDataRow() + 1);
            }
            return SpreadsheetUtils.getSelectionString(list, -1);
        }

        private String getSelectedColumnRange() {
            int[] nArray = AbstractSpreadsheetTable.this.restrictRowColumnSpecToValidRegion(AbstractSpreadsheetTable.this.getSelectedColumns(), 1);
            List<int[]> list = AbstractSpreadsheetTable.getSelectionIntervals(nArray);
            if (AbstractSpreadsheetTable.this.getModel() instanceof IDataBoundsSupplier) {
                IDataBoundsSupplier iDataBoundsSupplier = (IDataBoundsSupplier)((Object)AbstractSpreadsheetTable.this.getModel());
                return SpreadsheetUtils.getSelectionString(list, iDataBoundsSupplier.getLastDataColumn() + 1);
            }
            return SpreadsheetUtils.getSelectionString(list, -1);
        }

        @Override
        public void setSelectionIntervals(List<int[]> list) {
            int n = 0;
            if (this.iType == 0) {
                for (int[] nArray : list) {
                    int n2 = nArray[1];
                    if (n2 == Integer.MAX_VALUE) {
                        n2 = this.getSelectionUpperLimit();
                    }
                    if (n == 0) {
                        AbstractSpreadsheetTable.this.setRowSelectionInterval(nArray[0], n2);
                    } else {
                        AbstractSpreadsheetTable.this.addRowSelectionInterval(nArray[0], n2);
                    }
                    ++n;
                }
            } else {
                for (int[] nArray : list) {
                    int n3 = nArray[1];
                    if (n3 == Integer.MAX_VALUE) {
                        n3 = this.getSelectionUpperLimit();
                    }
                    if (n == 0) {
                        AbstractSpreadsheetTable.this.setColumnSelectionInterval(nArray[0], n3);
                    } else {
                        AbstractSpreadsheetTable.this.addColumnSelectionInterval(nArray[0], n3);
                    }
                    ++n;
                }
            }
        }
    }

    protected static class SpreadsheetTableHeader
    extends JTableHeader {
        protected SpreadsheetTableHeader(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(super.getPreferredSize().width, HEADER_HEIGHT);
        }
    }

    private class ModifiedWrapAction
    extends MJAbstractAction {
        private int fType;
        private Action fOriginalAction = null;

        ModifiedWrapAction(int n) {
            if (n != 1 && n != 0) {
                throw new IllegalArgumentException("Invalid argument " + n + " passed to ModifiedWrapAction constructor.");
            }
            this.fType = n;
            this.fOriginalAction = n == 1 ? AbstractSpreadsheetTable.this.getActionMap().get("selectPreviousColumnCell") : AbstractSpreadsheetTable.this.getActionMap().get("selectPreviousRowCell");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = AbstractSpreadsheetTable.this.getSelectedRows();
            int[] nArray2 = AbstractSpreadsheetTable.this.getSelectedColumns();
            if (nArray.length == 1 && nArray2.length == 1 && (this.fType == 1 && nArray2[0] == 0 || this.fType == 0 && nArray[0] == 0)) {
                if (AbstractSpreadsheetTable.this.fStopEditingAction != null) {
                    AbstractSpreadsheetTable.this.fStopEditingAction.actionPerformed(actionEvent);
                }
                return;
            }
            this.fOriginalAction.actionPerformed(actionEvent);
        }
    }

    public class AnonNavigationAction
    extends MSAbstractAction {
        private Method iMethod;

        public AnonNavigationAction(String string, int n, int n2, boolean bl, String string2) {
            super(string, bl);
            this.iMethod = null;
            this.setAccelerator(KeyStroke.getKeyStroke(n, n2));
            this.setComponentName(string);
            try {
                this.iMethod = AbstractSpreadsheetTable.class.getDeclaredMethod(string2, ArrayUtils.EmptyObjects.CLASS);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                AbstractSpreadsheetTable.logException(noSuchMethodException);
            }
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.iMethod.invoke((Object)AbstractSpreadsheetTable.this, ArrayUtils.EmptyObjects.OBJECT);
            }
            catch (IllegalAccessException illegalAccessException) {
                AbstractSpreadsheetTable.logException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                AbstractSpreadsheetTable.logException(invocationTargetException);
            }
        }
    }

    private static abstract class MSAbstractAction
    extends MJAbstractAction {
        private boolean fDualMacReg;

        MSAbstractAction(String string, boolean bl) {
            super(string);
            this.fDualMacReg = bl;
        }

        public boolean getDualMacRegistration() {
            return this.fDualMacReg;
        }
    }

    public class SelectAllAction
    extends MJAbstractAction {
        public SelectAllAction() {
            if (AbstractSpreadsheetTable.this.useDeprecatedKeybindingManager()) {
                AbstractSpreadsheetTable.this.doKeybindingSetup(this, "select-all");
            } else {
                MatlabKeyBindings.getManager().addActionInfoOnly("SpreadsheetTable", "select-all", (ExtendedAction)this);
                AbstractSpreadsheetTable.this.doDeprecatedKeybindingSetup((MJAbstractAction)this, 65, false);
                AbstractSpreadsheetTable.this.registerWithInputMapNoKeyBindingManager(KeyStroke.getKeyStroke(32, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK | 1), (Action)((Object)this));
                if (PlatformInfo.isMacintosh()) {
                    AbstractSpreadsheetTable.this.registerWithInputMapNoKeyBindingManager(KeyStroke.getKeyStroke(32, 3), (Action)((Object)this));
                }
            }
            this.setComponentName("SelectAll");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractSpreadsheetTable.this.selectAll();
        }
    }

    public static class TableModelChangeEvent
    extends ChangeEvent {
        private Throwable fIncident;

        public TableModelChangeEvent(Object object) {
            this(object, null);
        }

        public TableModelChangeEvent(Object object, Throwable throwable) {
            super(object);
            this.fIncident = throwable;
        }

        Throwable getIncident() {
            return this.fIncident;
        }

        boolean incidentOccured() {
            return this.fIncident != null;
        }
    }
}

