/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet;

import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuBar;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.widgets.desk.DTMenuBoundary;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.spreadsheet.IClipboardOpProvider;
import com.mathworks.widgets.spreadsheet.IUndoOpProvider;
import com.mathworks.widgets.spreadsheet.SpreadsheetActions;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class SpreadsheetDTMenuBar
extends MJMenuBar {
    protected MJMenu fFileMenu;
    protected MJMenu fEditMenu;

    public SpreadsheetDTMenuBar(Object object, IUndoOpProvider iUndoOpProvider, IClipboardOpProvider iClipboardOpProvider) {
        this.setupBasics();
        this.setupFileMenu(object);
        this.setupEditUndoRedo(iUndoOpProvider);
        this.setupEditCCP(iClipboardOpProvider);
        this.setupEditRemainder(object);
    }

    private void setupBasics() {
        this.fFileMenu = new MJMenu();
        this.fEditMenu = new MJMenu();
        this.add((JMenu)this.fFileMenu);
        this.add((JMenu)this.fEditMenu);
        DTMenuMergeTag.FILE.setTag((JMenuItem)this.fFileMenu);
        DTMenuMergeTag.EDIT.setTag((JMenuItem)this.fEditMenu);
    }

    private void setupFileMenu(Object object) {
        this.fFileMenu.add((JMenuItem)((Object)new DTMenuBoundary(DTMenuMergeTag.OPEN)));
        SpreadsheetDTMenuBar.addActionToMenuWithTag(SpreadsheetActions.getSaveAction(object), this.fFileMenu, DTMenuMergeTag.SAVE);
        this.fFileMenu.add((JMenuItem)((Object)new DTMenuBoundary(DTMenuMergeTag.CLOSE)));
        SpreadsheetDTMenuBar.addActionToMenuWithTag(SpreadsheetActions.getPrintAction(object), this.fFileMenu, DTMenuMergeTag.PRINT);
        SpreadsheetDTMenuBar.addActionToMenuWithTag(SpreadsheetActions.getPrintSelectionAction(object), this.fFileMenu, DTMenuMergeTag.PRINT_SELECTION);
        SpreadsheetDTMenuBar.addActionToMenuWithTag(SpreadsheetActions.getPageSetupAction(object), this.fFileMenu, DTMenuMergeTag.PAGE_SETUP);
    }

    private void setupEditUndoRedo(IUndoOpProvider iUndoOpProvider) {
        SpreadsheetDTMenuBar.addActionToMenuWithTag(SpreadsheetActions.getUndoAction(iUndoOpProvider), this.fEditMenu, DTMenuMergeTag.UNDO);
        SpreadsheetDTMenuBar.addActionToMenuWithTag(SpreadsheetActions.getRedoAction(iUndoOpProvider), this.fEditMenu, DTMenuMergeTag.REDO);
    }

    private void setupEditCCP(IClipboardOpProvider iClipboardOpProvider) {
        SpreadsheetDTMenuBar.addActionToMenuWithTag(SpreadsheetActions.getCutAction(iClipboardOpProvider), this.fEditMenu, DTMenuMergeTag.CUT);
        SpreadsheetDTMenuBar.addActionToMenuWithTag(SpreadsheetActions.getCopyAction(iClipboardOpProvider), this.fEditMenu, DTMenuMergeTag.COPY);
        SpreadsheetDTMenuBar.addActionToMenuWithTag(SpreadsheetActions.getPasteAction(iClipboardOpProvider), this.fEditMenu, DTMenuMergeTag.PASTE);
        SpreadsheetDTMenuBar.addActionToMenu(SpreadsheetActions.getExcelPasteAction(iClipboardOpProvider), this.fEditMenu);
    }

    private void setupEditRemainder(Object object) {
        SpreadsheetDTMenuBar.addActionToMenuWithTag(SpreadsheetActions.getSelectAllAction(object), this.fEditMenu, DTMenuMergeTag.SELECT_ALL);
        SpreadsheetDTMenuBar.addActionToMenu(SpreadsheetActions.getInsertAction(object), this.fEditMenu);
        SpreadsheetDTMenuBar.addActionToMenuWithTag(SpreadsheetActions.getDeleteAction(object), this.fEditMenu, DTMenuMergeTag.DELETE);
        SpreadsheetDTMenuBar.addActionToMenu(SpreadsheetActions.getClearContentsAction(object), this.fEditMenu);
    }

    private static void addActionToMenuWithTag(Action action, MJMenu mJMenu, DTMenuMergeTag dTMenuMergeTag) {
        MJMenuItem mJMenuItem = new MJMenuItem(action);
        dTMenuMergeTag.setTag((JMenuItem)mJMenuItem);
        mJMenu.add((JMenuItem)mJMenuItem);
    }

    private static void addActionToMenu(Action action, MJMenu mJMenu) {
        mJMenu.add((JMenuItem)new MJMenuItem(action));
    }

    public void cleanup() {
        this.fFileMenu = null;
        this.fEditMenu = null;
        this.dispose();
    }
}

