/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet;

import com.mathworks.mwswing.AppearanceFocusEvent;
import com.mathworks.mwswing.AppearanceFocusListener;
import com.mathworks.mwswing.ClipboardMonitor;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MInputMap;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.mwswing.datatransfer.MJClipboard;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.action.AbstractPasteAction;
import com.mathworks.widgets.spreadsheet.AbstractSpreadsheetTable;
import com.mathworks.widgets.spreadsheet.CellLocation;
import com.mathworks.widgets.spreadsheet.IBlockValueSetter;
import com.mathworks.widgets.spreadsheet.IClipboardOpProvider;
import com.mathworks.widgets.spreadsheet.IColumnController;
import com.mathworks.widgets.spreadsheet.IDataBoundsSupplier;
import com.mathworks.widgets.spreadsheet.IDataClearer;
import com.mathworks.widgets.spreadsheet.IMixedTypeDataHandler;
import com.mathworks.widgets.spreadsheet.IMultipleBlockValueSetter;
import com.mathworks.widgets.spreadsheet.IRegionController;
import com.mathworks.widgets.spreadsheet.IRegionOpProvider;
import com.mathworks.widgets.spreadsheet.IRowController;
import com.mathworks.widgets.spreadsheet.IRowHeaderPopupMenuSource;
import com.mathworks.widgets.spreadsheet.IUndoManagerProvider;
import com.mathworks.widgets.spreadsheet.IUndoOpProvider;
import com.mathworks.widgets.spreadsheet.SpreadsheetCellEditor;
import com.mathworks.widgets.spreadsheet.SpreadsheetCellRenderer;
import com.mathworks.widgets.spreadsheet.SpreadsheetColor;
import com.mathworks.widgets.spreadsheet.SpreadsheetPrefs;
import com.mathworks.widgets.spreadsheet.SpreadsheetTableEvent;
import com.mathworks.widgets.spreadsheet.SpreadsheetTableModelEvent;
import com.mathworks.widgets.spreadsheet.SpreadsheetUtils;
import com.mathworks.widgets.spreadsheet.UndoActionFactory;
import com.mathworks.widgets.spreadsheet.color.CompositeColorArrayTableModel;
import com.mathworks.widgets.spreadsheet.data.ComplexScalar;
import com.mathworks.widgets.spreadsheet.format.FormatIdentifier;
import com.mathworks.widgets.spreadsheet.format.FormattableDisplay;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SpreadsheetTable
extends AbstractSpreadsheetTable
implements IClipboardOpProvider,
IRowHeaderPopupMenuSource,
IRegionOpProvider,
IUndoOpProvider,
FormattableDisplay {
    private IRowController fRowController;
    private IColumnController fColumnController;
    private IRegionController fRegionController;
    private IDataClearer fDataClearer;
    private CutAction fCutAction;
    private MJAbstractAction fCopyAction;
    private PasteAction fPasteAction;
    private PasteExcelAction fPasteExcelAction;
    private MJAbstractAction fUndoAction;
    private MJAbstractAction fRedoAction;
    protected Map<IRegionOpProvider.Scope, InsertAction> fInsertActions;
    protected Map<IRegionOpProvider.Scope, DeleteAction> fDeleteActions;
    private IRegionOpProvider.Scope fActiveScope;
    private ClearContentsAction fClearContentsAction;
    private transient MouseListener fTmel;
    private transient MouseListener fThmel;
    private transient ListSelectionListener fCSL;
    private transient ListSelectionListener fRSL;
    private PrefListener fPL;
    private SpreadsheetColor fSpreadsheetColor;
    private SpreadsheetCellRenderer fCellRenderer;
    private SpreadsheetCellEditor fCellEditor;
    private CompositeColorArrayTableModel fCompositeColorModelCell;
    private CompositeColorArrayTableModel fCompositeColorModelBorder;
    private transient ChangeListener fCompositeColorModelCL;
    private boolean fFullySelectedRows = false;
    private boolean fFullySelectedColumns = false;
    private Rectangle fPasteSelectionRectangle = null;
    private FormatIdentifier fFormatID = FormatIdentifier.getDefaultInstance();
    protected int fInsertDeleteStartIndex = 0;
    protected int fNumInsertDeleteItemsAdded = 0;
    protected JSeparator fInsertDeleteSeparator;

    public SpreadsheetTable() {
        this(new DefaultTableModel());
    }

    public SpreadsheetTable(int n, int n2) {
        this(new DefaultTableModel(n, n2));
    }

    public SpreadsheetTable(Object[][] objectArray, Object[] objectArray2) {
        this(new DefaultTableModel(objectArray, objectArray2));
        this.setScheme(2);
    }

    public SpreadsheetTable(Vector vector, Vector vector2) {
        this(new DefaultTableModel(vector, vector2));
        this.setScheme(2);
    }

    public SpreadsheetTable(TableModel tableModel) {
        super(tableModel);
        this.fInputMap = MInputMap.createMInputMap((JComponent)((Object)this));
        this.fEditable = true;
        this.fCompositeColorModelCell = new CompositeColorArrayTableModel();
        this.fCompositeColorModelBorder = new CompositeColorArrayTableModel();
        this.setRowColumnInterfaces(tableModel);
        this.fCellEditor = null;
        this.fCellRenderer = null;
        this.installEditorsAndRenderersForFormat();
        this.setupColorHandlers();
        this.initActions();
        this.initUndoManagement();
        this.bindKeysAsPerSpreadsheet();
        this.setupContextMenu();
        this.installHeaderMouseListeners();
        this.fCSL = new ColumnSelectionListener();
        this.fRSL = new RowSelectionListener();
        this.getColumnModel().getSelectionModel().addListSelectionListener(this.fCSL);
        this.getSelectionModel().addListSelectionListener(this.fRSL);
        this.fAFD.addAppearanceFocusListener((AppearanceFocusListener)new AppFocusL());
        this.fCompositeColorModelCL = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SpreadsheetTable.this.repaint();
            }
        };
        this.fCompositeColorModelCell.addColorArrayTableModelListener(this.fCompositeColorModelCL);
        this.fCompositeColorModelBorder.addColorArrayTableModelListener(this.fCompositeColorModelCL);
    }

    private void installHeaderMouseListeners() {
        this.fThmel = new TableHeaderMouseEventListener();
        this.getTableHeader().addMouseListener(this.fThmel);
        this.getTableHeader().addMouseMotionListener((MouseMotionListener)((Object)this.fThmel));
    }

    @Override
    protected void setupSelectionAsPerSpreadsheet() {
        this.setSelectionMode(1);
        super.setupSelectionAsPerSpreadsheet();
    }

    protected void restoreSelection(int[] nArray, int[] nArray2) {
        this.setRowSelectionInterval(nArray[0], nArray[nArray.length - 1]);
        this.setColumnSelectionInterval(nArray2[0], nArray2[nArray2.length - 1]);
    }

    public void setColumnModel(TableColumnModel tableColumnModel) {
        if (this.getColumnModel() != null && this.getColumnModel().getSelectionModel() != null) {
            this.getColumnModel().getSelectionModel().removeListSelectionListener(this.fCSL);
        }
        super.setColumnModel(tableColumnModel);
        this.getColumnModel().getSelectionModel().addListSelectionListener(this.fCSL);
    }

    protected void doRegionCut(ActionEvent actionEvent) {
        this.getCopyAction().actionPerformed(actionEvent);
        this.fClearContentsAction.actionPerformed(actionEvent);
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        JTableHeader jTableHeader2 = this.getTableHeader();
        if (jTableHeader2 != null && this.fThmel != null) {
            jTableHeader2.removeMouseListener(this.fThmel);
        }
        super.setTableHeader(jTableHeader);
        if (this.fThmel != null) {
            jTableHeader.addMouseListener(this.fThmel);
            jTableHeader.addMouseMotionListener((MouseMotionListener)((Object)this.fThmel));
        }
    }

    @Override
    public void setFormat(FormatIdentifier formatIdentifier) {
        this.fFormatID = formatIdentifier;
        this.installEditorsAndRenderersForFormat();
        this.repaint();
    }

    @Override
    public FormatIdentifier getFormat() {
        return this.fFormatID;
    }

    protected void installEditorsAndRenderersForFormat() {
        this.cleanupCellEditorsAndRenderers();
        this.fCellEditor = new SpreadsheetCellEditor((JTextField)new MJTextField(), this.fFormatID.getEditorIdentifier());
        this.setDefaultEditor(Object.class, this.fCellEditor);
        this.fCellRenderer = new SpreadsheetCellRenderer(this.fFormatID);
        this.setDefaultRenderer(Object.class, this.fCellRenderer);
    }

    private void cleanupCellEditorsAndRenderers() {
        if (this.fCellEditor != null) {
            this.fCellEditor.cleanup();
        }
        this.fCellEditor = null;
        if (this.fCellRenderer != null) {
            this.fCellRenderer.cleanup();
        }
        this.fCellRenderer = null;
    }

    private void setupColorHandlers() {
        this.fSpreadsheetColor = new SpreadsheetColor((JTable)((Object)this));
        this.fSpreadsheetColor.registerColorInterests();
        this.setHeaderRenderer(1);
        this.fPL = new PrefListener(){

            public void prefChanged(PrefEvent prefEvent) {
                SpreadsheetTable.this.recalculateColors();
            }
        };
        SpreadsheetColor.addColorListener(this.fPL);
        this.recalculateColors();
    }

    private void initActions() {
        this.fCutAction = new CutAction();
        this.fCopyAction = (MJAbstractAction)this.getCopyAction();
        this.fPasteAction = new PasteAction();
        this.fPasteExcelAction = new PasteExcelAction();
        this.fSelectAllAction = new AbstractSpreadsheetTable.SelectAllAction();
        this.fClearContentsAction = new ClearContentsAction();
        this.fStopEditingAction = new StopEditingAction();
        this.fInsertActions = new TreeMap<IRegionOpProvider.Scope, InsertAction>();
        this.fInsertActions.put(IRegionOpProvider.Scope.COLUMNS, new InsertAction(IRegionOpProvider.Scope.COLUMNS));
        this.fInsertActions.put(IRegionOpProvider.Scope.COLUMNS_TO_THE_RIGHT, new InsertAction(IRegionOpProvider.Scope.COLUMNS_TO_THE_RIGHT));
        this.fInsertActions.put(IRegionOpProvider.Scope.ROWS, new InsertAction(IRegionOpProvider.Scope.ROWS));
        this.fInsertActions.put(IRegionOpProvider.Scope.ROWS_BELOW, new InsertAction(IRegionOpProvider.Scope.ROWS_BELOW));
        this.fDeleteActions = new TreeMap<IRegionOpProvider.Scope, DeleteAction>();
        this.fDeleteActions.put(IRegionOpProvider.Scope.COLUMNS, new DeleteAction(IRegionOpProvider.Scope.COLUMNS));
        this.fDeleteActions.put(IRegionOpProvider.Scope.ROWS, new DeleteAction(IRegionOpProvider.Scope.ROWS));
    }

    private void initUndoManagement() {
        if (this.dataModel instanceof IUndoManagerProvider) {
            this.fUndoAction = UndoActionFactory.getUndoAction((IUndoManagerProvider)((Object)this.dataModel));
            this.fRedoAction = UndoActionFactory.getRedoAction((IUndoManagerProvider)((Object)this.dataModel));
        } else {
            this.fUndoAction = UndoActionFactory.getUndoAction((IUndoManagerProvider)null);
            this.fRedoAction = UndoActionFactory.getRedoAction((IUndoManagerProvider)null);
        }
        MatlabKeyBindings.getManager().clearKeyBinding((ExtendedAction)this.fUndoAction);
        MatlabKeyBindings.getManager().clearKeyBinding((ExtendedAction)this.fRedoAction);
        if (this.useDeprecatedKeybindingManager()) {
            this.doKeybindingSetup(this.fUndoAction, "undo");
            this.fUndoAction.setComponentName("Undo");
            this.doKeybindingSetup(this.fRedoAction, "redo");
            this.fRedoAction.setComponentName("Redo");
        } else {
            this.doDeprecatedKeybindingSetup(this.fUndoAction, 90, true);
            this.doDeprecatedKeybindingSetup(this.fRedoAction, 89, true);
        }
    }

    @Override
    protected void bindKeysAsPerSpreadsheet() {
        int n;
        int n2;
        super.bindKeysAsPerSpreadsheet();
        this.registerWithInputMap(new AbstractSpreadsheetTable.AnonNavigationAction("SelectToZeroZero", 36, 3, false, "selectToZeroZero"));
        this.registerWithInputMap(new AbstractSpreadsheetTable.AnonNavigationAction("SelectActiveCell", 8, 1, false, "selectActiveCell"));
        if (PlatformInfo.isMacintosh()) {
            n2 = 85;
            n = 2;
        } else {
            n2 = 113;
            n = 0;
        }
        AbstractSpreadsheetTable.AnonNavigationAction anonNavigationAction = new AbstractSpreadsheetTable.AnonNavigationAction("StartEditingWithAppend", n2, n, false, "startEditingWithAppend");
        this.registerWithInputMap(anonNavigationAction);
    }

    protected void setupContextMenu() {
        this.fSelectionPopupMenu = new MJPopupMenu();
        this.fSelectionPopupMenu.setFocusable(false);
        boolean bl = this.fRowController != null || this.fColumnController != null || this.fRegionController == null;
        this.fSelectionPopupMenu.add((Action)((Object)this.fCutAction));
        ++this.fInsertDeleteStartIndex;
        this.fSelectionPopupMenu.add(this.getCopyAction());
        ++this.fInsertDeleteStartIndex;
        this.fSelectionPopupMenu.add((Action)((Object)this.fPasteAction));
        ++this.fInsertDeleteStartIndex;
        this.fSelectionPopupMenu.add((Action)((Object)this.fPasteExcelAction));
        ++this.fInsertDeleteStartIndex;
        if (bl) {
            this.fInsertDeleteSeparator = new JSeparator();
            this.fSelectionPopupMenu.add((Component)this.fInsertDeleteSeparator);
            ++this.fInsertDeleteStartIndex;
            Set<IRegionOpProvider.Scope> set = this.fInsertActions.keySet();
            for (IRegionOpProvider.Scope scope : set) {
                this.fSelectionPopupMenu.add((Action)((Object)this.fInsertActions.get((Object)scope)));
                ++this.fNumInsertDeleteItemsAdded;
            }
            set = this.fDeleteActions.keySet();
            for (IRegionOpProvider.Scope scope : set) {
                this.fSelectionPopupMenu.add((Action)((Object)this.fDeleteActions.get((Object)scope)));
                ++this.fNumInsertDeleteItemsAdded;
            }
        }
        this.addClearContentsItem();
        this.addContextMenuMouseListener();
    }

    protected void addClearContentsItem() {
        this.fSelectionPopupMenu.add((Component)new JSeparator());
        this.fSelectionPopupMenu.add((Action)((Object)this.fClearContentsAction));
    }

    protected void addContextMenuMouseListener() {
        this.fTmel = new TableMouseEventListener();
        this.addMouseListener(this.fTmel);
    }

    public void setEditable(boolean bl) {
        this.fEditable = bl;
        this.reexamineEditingActions();
    }

    protected void reexamineEditingActions() {
        boolean bl = this.areAllSelectedCellsEditable();
        this.fCutAction.setEnabled(this.fEditable && bl);
        this.reexamineInsertDeleteEnablement();
        this.fClearContentsAction.setEnabled(this.fEditable && bl);
        if (this.fEditable && bl) {
            this.fPasteAction.startAutoUpdate();
            this.fPasteExcelAction.startAutoUpdate();
        } else {
            this.fPasteAction.stopAutoUpdate();
            this.fPasteAction.setEnabled(false);
            this.fPasteExcelAction.stopAutoUpdate();
            this.fPasteExcelAction.setEnabled(false);
        }
        this.fUndoAction.setEnabled(this.fEditable);
        this.fRedoAction.setEnabled(this.fEditable);
    }

    protected void reexamineInsertDeleteEnablement() {
        boolean bl;
        MJAbstractAction mJAbstractAction;
        for (int i = 0; i < this.fNumInsertDeleteItemsAdded; ++i) {
            this.fSelectionPopupMenu.remove(this.fInsertDeleteStartIndex);
        }
        this.fNumInsertDeleteItemsAdded = 0;
        IRegionOpProvider.Scope scope = IRegionOpProvider.Scope.ROWS;
        IRegionOpProvider.Scope scope2 = IRegionOpProvider.Scope.COLUMNS;
        boolean bl2 = false;
        Set<IRegionOpProvider.Scope> set = this.fInsertActions.keySet();
        int n = this.fInsertDeleteStartIndex;
        for (IRegionOpProvider.Scope scope3 : set) {
            mJAbstractAction = this.fInsertActions.get((Object)scope3);
            bl = mJAbstractAction.reexamineActionEnabled();
            if (scope3 == scope) {
                if (bl) {
                    this.doKeybindingSetup(mJAbstractAction, "generic-insert");
                    bl2 = true;
                    this.fActiveScope = scope3;
                } else {
                    this.clearKeybindingSetup(mJAbstractAction);
                }
            } else if (scope3 == scope2) {
                if (bl && !bl2) {
                    this.doKeybindingSetup(mJAbstractAction, "generic-insert");
                    this.fActiveScope = scope3;
                } else {
                    this.clearKeybindingSetup(mJAbstractAction);
                }
            }
            if (!bl) continue;
            this.fSelectionPopupMenu.insert((Action)mJAbstractAction, n++);
            mJAbstractAction.initNameAndTip();
            ++this.fNumInsertDeleteItemsAdded;
        }
        set = this.fDeleteActions.keySet();
        bl2 = false;
        for (IRegionOpProvider.Scope scope3 : set) {
            mJAbstractAction = this.fDeleteActions.get((Object)scope3);
            bl = mJAbstractAction.reexamineActionEnabled();
            if (scope3 == scope) {
                if (bl) {
                    this.doKeybindingSetup(mJAbstractAction, "generic-delete");
                    bl2 = true;
                } else {
                    this.clearKeybindingSetup(mJAbstractAction);
                }
            } else if (scope3 == scope2) {
                if (bl && !bl2) {
                    this.doKeybindingSetup(mJAbstractAction, "generic-delete");
                } else {
                    this.clearKeybindingSetup(mJAbstractAction);
                }
            }
            if (!bl) continue;
            this.fSelectionPopupMenu.insert((Action)mJAbstractAction, n++);
            mJAbstractAction.initNameAndTip();
            ++this.fNumInsertDeleteItemsAdded;
        }
    }

    protected boolean areAllSelectedCellsEditable() {
        int[] nArray = this.getSelectedRows();
        int[] nArray2 = this.getSelectedColumns();
        for (int n : nArray) {
            for (int n2 : nArray2) {
                if (this.isCellEditable(n, n2)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isEditable() {
        return this.fEditable;
    }

    public void stopEditing() {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
    }

    public boolean isCellEditable(int n, int n2) {
        return this.fEditable && super.isCellEditable(n, n2);
    }

    private static int[] accumulateDiscontiguousSelection(int[] nArray, boolean bl) {
        int n;
        if (nArray.length == nArray[nArray.length - 1] - nArray[0] + 1) {
            if (bl) {
                int n2 = 0;
                while (n2 < nArray.length) {
                    int n3 = n2++;
                    nArray[n3] = nArray[n3] + nArray.length;
                }
            }
            return nArray;
        }
        int n4 = 0;
        int n5 = 0;
        for (n = 1; n < nArray.length; ++n) {
            if (nArray[n] - nArray[n - 1] <= 1) continue;
            int n6 = nArray[n - 1] - nArray[n4] + 1;
            if (bl) {
                n5 += n6;
            }
            int n7 = n4;
            while (n7 <= n - 1) {
                int n8 = n7++;
                nArray[n8] = nArray[n8] + n5;
            }
            n4 = n;
            if (bl) continue;
            n5 += n6;
        }
        if (bl) {
            n5 += nArray[nArray.length - 1] - nArray[n4] + 1;
        }
        n = n4;
        while (n <= nArray.length - 1) {
            int n9 = n++;
            nArray[n9] = nArray[n9] + n5;
        }
        return nArray;
    }

    private void showOutOfMemoryDialogDuringCopy() {
        MJOptionPane.showMessageDialog((Component)MJOptionPane.getFrameForComponent((Component)((Object)this)), (Object)SpreadsheetUtils.getResource("error.OutOfMemoryErrorOnCopy.msg"), (String)SpreadsheetUtils.getResource("error.OutOfMemoryError.title"), (int)0);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        KeyEvent keyEvent2 = keyEvent;
        if (keyEvent.getKeyCode() == 10) {
            if (!(keyEvent.isControlDown() || keyEvent.isAltDown() || keyEvent.isMetaDown())) {
                if (!this.fMotionOnEnter) {
                    keyEvent.consume();
                    this.editingStopped(new ChangeEvent(this));
                    return;
                }
                int n = keyEvent.getModifiers();
                if (this.fMotionOnEnterDirection == 2 || this.fMotionOnEnterDirection == 3) {
                    n = keyEvent.isShiftDown() ? 0 : 1;
                }
                int n2 = this.fMotionOnEnterDirection == 3 || this.fMotionOnEnterDirection == 1 ? 9 : 10;
                keyEvent2 = new KeyEvent(keyEvent.getComponent(), keyEvent.getID(), keyEvent.getWhen(), n, n2, keyEvent.getKeyChar());
                keyEvent.consume();
            }
        } else if (!keyEvent.isConsumed() && keyEvent.getID() == 401 && keyEvent.getKeyCode() == 109 && (keyEvent.getModifiersEx() & 0x80) == 128) {
            this.getDeleteAction(this.fActiveScope).actionPerformed(null);
            keyEvent.consume();
        } else if (!keyEvent.isConsumed() && keyEvent.getID() == 401 && keyEvent.getKeyCode() == 107 && (keyEvent.getModifiersEx() & 0x80) == 128) {
            this.getInsertAction(this.fActiveScope).actionPerformed(null);
            keyEvent.consume();
        }
        super.processKeyEvent(keyEvent2);
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        this.readjustViewPort();
        return super.prepareEditor(tableCellEditor, n, n2);
    }

    private void readjustViewPort() {
        int n = this.getSelectionModel().getLeadSelectionIndex();
        int n2 = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        if (n >= 0 && n2 >= 0) {
            this.scrollRectToVisible(this.getCellRect(n, n2, true));
        }
    }

    private void setIsPrimaryFocusOwner(boolean bl) {
        this.fIsPrimaryFocusOwner = bl;
        this.setSelectionBackground(bl ? this.fSpreadsheetColor.getCellSelectedBackground() : this.fSpreadsheetColor.getSecondaryCellSelectedBackground());
    }

    private void clearSpecialSelectionTrackingData() {
        this.setSelectedRowsFullySelected(false);
        this.setSelectedColumnsFullySelected(false);
        this.fPasteSelectionRectangle = null;
    }

    public void setRowSelectionInterval(int n, int n2) {
        this.clearSpecialSelectionTrackingData();
        try {
            super.setRowSelectionInterval(n, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Trying to select rows " + n + " to " + n2 + " with only " + this.getRowCount() + " rows available.");
            throw illegalArgumentException;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.showOutOfMemoryDialog();
        }
    }

    public void setColumnSelectionInterval(int n, int n2) {
        this.clearSpecialSelectionTrackingData();
        try {
            super.setColumnSelectionInterval(n, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Trying to select columns " + n + " to " + n2 + " with only " + this.getColumnCount() + " columns available.");
            throw illegalArgumentException;
        }
    }

    public void addRowSelectionInterval(int n, int n2) {
        if (!this.getSelectionModel().getValueIsAdjusting()) {
            this.clearSpecialSelectionTrackingData();
        }
        super.addRowSelectionInterval(n, n2);
    }

    public void addColumnSelectionInterval(int n, int n2) {
        if (!this.getColumnModel().getSelectionModel().getValueIsAdjusting()) {
            this.clearSpecialSelectionTrackingData();
        }
        super.addColumnSelectionInterval(n, n2);
    }

    public void removeRowSelectionInterval(int n, int n2) {
        this.clearSpecialSelectionTrackingData();
        super.removeRowSelectionInterval(n, n2);
    }

    public void removeColumnSelectionInterval(int n, int n2) {
        this.clearSpecialSelectionTrackingData();
        super.removeColumnSelectionInterval(n, n2);
    }

    public void clearSelection() {
        this.clearSpecialSelectionTrackingData();
        super.clearSelection();
    }

    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        this.clearSpecialSelectionTrackingData();
        super.changeSelection(n, n2, bl, bl2);
    }

    @Override
    void startEditingWithAppend() {
        TableCellEditor tableCellEditor = this.getDefaultEditor(Object.class);
        if (tableCellEditor instanceof SpreadsheetCellEditor) {
            ((SpreadsheetCellEditor)tableCellEditor).lockNextEditMode(1);
        }
        this.getActionMap().get("startEditing").actionPerformed(new ActionEvent(this, 0, "startEditingWithAppend"));
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent instanceof SpreadsheetTableEvent && ((SpreadsheetTableEvent)tableModelEvent).getScope() == SpreadsheetTableEvent.SCOPE.REPAINT) {
            this.repaint();
            return;
        }
        int[] nArray = this.getSelectedRows();
        int[] nArray2 = this.getSelectedColumns();
        CellLocation cellLocation = this.getAnchorLocation();
        boolean bl = this.getSelectedRowsFullySelected();
        boolean bl2 = this.getSelectedColumnsFullySelected();
        Rectangle rectangle = this.fPasteSelectionRectangle;
        this.fPasteSelectionRectangle = null;
        if (tableModelEvent instanceof SpreadsheetTableModelEvent && ((SpreadsheetTableModelEvent)tableModelEvent).isColumnsAddedEvent()) {
            this.createDefaultColumnsFromModel();
        } else {
            super.tableChanged(tableModelEvent);
        }
        if (bl || bl2) {
            if (bl) {
                this.selectEntireRows();
            }
            if (bl2) {
                this.selectEntireColumns();
            }
        }
        if (nArray.length > 0 && nArray2.length > 0) {
            if (this.dataModel.getRowCount() >= nArray[nArray.length - 1] + 1 && this.dataModel.getColumnCount() >= nArray2[nArray2.length - 1] + 1) {
                this.restoreSelection(nArray, nArray2);
                this.setAnchorLocation(cellLocation);
            } else if (this.getRowCount() > 0 && this.getColumnCount() > 0) {
                this.selectZeroZero();
            }
        } else if (this.getRowCount() > 0 && this.getColumnCount() > 0) {
            this.selectZeroZero();
        }
        if (rectangle != null && this.getRowCount() > 0 && this.getColumnCount() > 0 && this.getSelectionModel().getMaxSelectionIndex() - this.getSelectionModel().getMinSelectionIndex() + 1 == this.getSelectedRowCount() && this.getColumnModel().getSelectionModel().getMaxSelectionIndex() - this.getColumnModel().getSelectionModel().getMinSelectionIndex() + 1 == this.getSelectedColumnCount()) {
            this.setRowSelectionInterval((int)rectangle.getY(), Math.min((int)rectangle.getY() + (int)rectangle.getHeight() - 1, this.getRowCount() - 1));
            this.setColumnSelectionInterval((int)rectangle.getX(), Math.min((int)rectangle.getX() + (int)rectangle.getWidth() - 1, this.getColumnCount() - 1));
        }
    }

    @Override
    public void selectEntireColumns() {
        int[] nArray = this.getSelectedColumns();
        if (nArray.length == 0) {
            return;
        }
        int n = this.getRowCount();
        if (n != 0) {
            if (this.isSelectionModeByHeader()) {
                this.setColumnSelectionAllowed(true);
                this.setRowSelectionAllowed(false);
            }
            CellLocation cellLocation = this.getAnchorLocation();
            List<int[]> list = SpreadsheetTable.getSelectionIntervals(nArray);
            for (int[] nArray2 : list) {
                this.addColumnSelectionInterval(nArray2[0], nArray2[1]);
            }
            this.setAnchorLocation(cellLocation);
            this.setRowSelectionInterval(n - 1, 0);
        }
        this.setSelectedRowsFullySelected(false);
        this.setSelectedColumnsFullySelected(true);
    }

    @Override
    public void selectEntireRows() {
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        int n = this.getColumnCount();
        if (n != 0) {
            if (this.isSelectionModeByHeader()) {
                this.setColumnSelectionAllowed(false);
                this.setRowSelectionAllowed(true);
            }
            CellLocation cellLocation = this.getAnchorLocation();
            List<int[]> list = SpreadsheetTable.getSelectionIntervals(nArray);
            for (int[] nArray2 : list) {
                this.addRowSelectionInterval(nArray2[0], nArray2[1]);
            }
            this.setAnchorLocation(cellLocation);
            this.setColumnSelectionInterval(n - 1, 0);
        }
        this.setSelectedRowsFullySelected(true);
        this.setSelectedColumnsFullySelected(false);
    }

    @Override
    public void setAnchorLocation(CellLocation cellLocation) {
        this.getSelectionModel().setAnchorSelectionIndex(cellLocation.getRow());
        this.getColumnModel().getSelectionModel().setAnchorSelectionIndex(cellLocation.getColumn());
    }

    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        this.setRowColumnInterfaces(tableModel);
    }

    private void setRowColumnInterfaces(TableModel tableModel) {
        this.fRowController = tableModel instanceof IRowController ? (IRowController)((Object)tableModel) : null;
        this.fColumnController = tableModel instanceof IColumnController ? (IColumnController)((Object)tableModel) : null;
        this.fRegionController = tableModel instanceof IRegionController ? (IRegionController)((Object)tableModel) : null;
        this.fDataClearer = tableModel instanceof IDataClearer ? (IDataClearer)((Object)tableModel) : null;
    }

    public boolean areOnlyEntireRowsSelected() {
        return this.getSelectedColumns().length == this.getColumnCount();
    }

    public boolean areOnlyEntireColumnsSelected() {
        return this.getSelectedRows().length == this.getRowCount();
    }

    public void setSelectedRowsFullySelected(boolean bl) {
        this.fFullySelectedRows = bl;
    }

    public void setSelectedColumnsFullySelected(boolean bl) {
        this.fFullySelectedColumns = bl;
    }

    protected boolean getSelectedRowsFullySelected() {
        return this.fFullySelectedRows;
    }

    private boolean getSelectedColumnsFullySelected() {
        return this.fFullySelectedColumns;
    }

    protected Object[][] getSelectionAsArray(boolean bl) {
        char c = SpreadsheetPrefs.getDecimalSeparator();
        boolean bl2 = bl && c != '.';
        int[] nArray = this.restrictRowColumnSpecToValidRegion(this.getSelectedRows(), 0);
        int[] nArray2 = this.restrictRowColumnSpecToValidRegion(this.getSelectedColumns(), 1);
        Object[][] objectArray = new Object[nArray.length][nArray2.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            for (int j = 0; j < nArray2.length; ++j) {
                Object object = this.getValueAt(n, nArray2[j]);
                if (object instanceof ComplexScalar) {
                    object = FormatIdentifier.getDefaultInstance().getFormatter().format((ComplexScalar)object);
                }
                if (bl2 && object instanceof String && this.isCellNumeric(i, j)) {
                    object = ((String)object).replace('.', c);
                }
                objectArray[i][j] = object;
            }
        }
        return objectArray;
    }

    protected void doRegionCopy(ActionEvent actionEvent) {
        Object[][] objectArray = this.getSelectionAsArray(true);
        String string = SpreadsheetUtils.arrayToTabbedValues(objectArray);
        if (PlatformInfo.isXWindows()) {
            MJClipboard.getMJClipboard().setXSelectionContents(string);
        }
        MJClipboard.getMJClipboard().setContents(string, null);
    }

    protected void doPaste(int n) {
        Object object = null;
        object = this.getDataToPaste();
        if (object != null) {
            try {
                Object[][] objectArray = SpreadsheetUtils.tabbedValuesToArray((String)object);
                this.pasteObjectArray(objectArray, n);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                object = null;
                this.showOutOfMemoryDialogDuringPaste();
            }
        }
    }

    protected Object getDataToPaste() {
        Object object = null;
        if (PlatformInfo.isXWindows()) {
            MJClipboard mJClipboard = MJClipboard.getMJClipboard();
            try {
                if (mJClipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                    object = MJClipboard.getMJClipboard().getXSelectionData(DataFlavor.stringFlavor);
                }
            }
            catch (NullPointerException nullPointerException) {
                object = null;
                this.showAlertDialogDuringPaste();
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                object = null;
                this.showAlertDialogDuringPaste();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                object = null;
                this.showOutOfMemoryDialogDuringPaste();
            }
        } else {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            try {
                if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                    object = clipboard.getData(DataFlavor.stringFlavor);
                }
            }
            catch (NullPointerException nullPointerException) {
                object = null;
                this.showAlertDialogDuringPaste();
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                object = null;
                this.showAlertDialogDuringPaste();
            }
            catch (IllegalStateException illegalStateException) {
                object = null;
                this.showOutOfMemoryDialogDuringPaste();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                object = null;
                this.showOutOfMemoryDialogDuringPaste();
            }
        }
        return object;
    }

    private void showAlertDialogDuringPaste() {
        MJOptionPane.showMessageDialog((Component)MJOptionPane.getFrameForComponent((Component)((Object)this)), (Object)SpreadsheetUtils.getResource("alert.PasteTextIncompatabilityMessage"), (String)"", (int)0);
    }

    private void showOutOfMemoryDialogDuringPaste() {
        MJOptionPane.showMessageDialog((Component)MJOptionPane.getFrameForComponent((Component)((Object)this)), (Object)SpreadsheetUtils.getResource("error.OutOfMemoryError.msg"), (String)SpreadsheetUtils.getResource("error.OutOfMemoryError.title"), (int)0);
    }

    private void showOutOfMemoryDialog() {
        MJOptionPane.showMessageDialog((Component)MJOptionPane.getFrameForComponent((Component)((Object)this)), (Object)SpreadsheetUtils.getResource("error.OutOfMemoryErrorNavigate.msg"), (String)SpreadsheetUtils.getResource("error.OutOfMemoryError.title"), (int)0);
    }

    protected Action getEditorAction(String string) {
        Component component;
        Action action = null;
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor instanceof DefaultCellEditor && (component = ((DefaultCellEditor)tableCellEditor).getComponent()) instanceof JComponent) {
            action = ((JComponent)component).getActionMap().get(string);
        }
        return action;
    }

    protected boolean isCellNumeric(int n, int n2) {
        return false;
    }

    private void pasteObjectArray(Object[][] objectArray, int n) {
        if (SpreadsheetUtils.isValidPasteSource(objectArray)) {
            assert (objectArray != null);
            int[] nArray = this.getSelectedRows();
            if (nArray.length > 0) {
                char c = SpreadsheetPrefs.getDecimalSeparator();
                boolean bl = c != '.';
                int n2 = Math.min(nArray[0], nArray[nArray.length - 1]);
                int[] nArray2 = this.getSelectedColumns();
                int n3 = Math.min(nArray2[0], nArray2[nArray2.length - 1]);
                Object[][] objectArray2 = this.getSelectedRowsFullySelected() || this.getSelectedColumnsFullySelected() ? (Object[][])objectArray.clone() : SpreadsheetUtils.replicateArrayToSize(objectArray, nArray.length, nArray2.length);
                this.fPasteSelectionRectangle = n3 == 0 && n2 == 0 && this.getSelectedColumnsFullySelected() && this.getSelectedRowsFullySelected() ? new Rectangle(n3, n2, this.getColumnCount(), this.getRowCount()) : (n2 == 0 && this.getSelectedColumnsFullySelected() ? new Rectangle(n3, n2, objectArray2[0].length, this.getRowCount()) : (n3 == 0 && this.getSelectedRowsFullySelected() ? new Rectangle(n3, n2, this.getColumnCount(), objectArray2.length) : new Rectangle(n3, n2, objectArray2[0].length, objectArray2.length)));
                int n4 = objectArray2.length;
                int n5 = objectArray2[0].length;
                if (!(this.getModel() instanceof IDataBoundsSupplier)) {
                    n4 = Math.min(n4, this.getRowCount() - n2);
                    n5 = Math.min(n5, this.getColumnCount() - n3);
                }
                if (this.dataModel instanceof IBlockValueSetter) {
                    TableModel tableModel;
                    if (bl) {
                        for (int i = 0; i < n4; ++i) {
                            for (int j = 0; j < n5; ++j) {
                                Object object = objectArray2[i][j];
                                if (!(object instanceof String)) continue;
                                objectArray2[i][j] = ((String)object).replace(c, '.');
                            }
                        }
                    }
                    if ((tableModel = this.dataModel) instanceof IMixedTypeDataHandler && n == 1) {
                        ((IMixedTypeDataHandler)((Object)tableModel)).setMixedTypeValuesAt(objectArray2, SpreadsheetTable.getSelectionIntervals(nArray), SpreadsheetTable.getSelectionIntervals(nArray2));
                    } else if (this.dataModel instanceof IMultipleBlockValueSetter) {
                        ((IMultipleBlockValueSetter)((Object)this.dataModel)).setValuesAt(objectArray2, SpreadsheetTable.getSelectionIntervals(nArray), SpreadsheetTable.getSelectionIntervals(nArray2));
                    } else {
                        ((IBlockValueSetter)((Object)this.dataModel)).setValuesAt(objectArray2, n2, n3);
                    }
                } else {
                    for (int i = 0; i < n4; ++i) {
                        for (int j = 0; j < n5; ++j) {
                            Object object = objectArray2[i][j];
                            if (bl && object instanceof String && this.isCellNumeric(i, j)) {
                                object = ((String)object).replace(c, '.');
                            }
                            if (this.dataModel instanceof IMixedTypeDataHandler && n == 1) {
                                ((IMixedTypeDataHandler)((Object)this.dataModel)).setMixedTypeValueAt(object, n2 + i, n3 + j);
                                continue;
                            }
                            this.setValueAt(object, n2 + i, n3 + j);
                        }
                    }
                }
            }
        }
    }

    public Action getInsertAction(IRegionOpProvider.Scope scope) {
        return this.getInsertAction(scope, 0);
    }

    @Override
    public Action getInsertAction(IRegionOpProvider.Scope scope, int n) {
        Object object = scope == IRegionOpProvider.Scope.SELECTION ? new DefaultInsertAction() : (Action)((Object)this.fInsertActions.get((Object)scope));
        return object;
    }

    public Action getDeleteAction(IRegionOpProvider.Scope scope) {
        return this.getDeleteAction(scope, 0);
    }

    @Override
    public Action getDeleteAction(IRegionOpProvider.Scope scope, int n) {
        Object object = scope == IRegionOpProvider.Scope.SELECTION ? new DefaultDeleteAction() : (Action)((Object)this.fDeleteActions.get((Object)scope));
        return object;
    }

    private void deleteRegion(int[] nArray, int[] nArray2, int n) {
        if (this.fRegionController == null) {
            return;
        }
        int[] nArray3 = this.restrictRowColumnSpecToValidRegion(nArray, 0);
        int[] nArray4 = this.restrictRowColumnSpecToValidRegion(nArray2, 1);
        this.fRegionController.deleteRegion(nArray3, nArray4, n);
    }

    private void insertRegion(int[] nArray, int[] nArray2, int n) {
        if (this.fRegionController == null) {
            return;
        }
        int[] nArray3 = this.restrictRowColumnSpecToValidRegion(nArray, 0);
        int[] nArray4 = this.restrictRowColumnSpecToValidRegion(nArray2, 1);
        this.fRegionController.insertRegion(nArray3, nArray4, n);
    }

    private void deleteEntireRowsOrColumns(int[] nArray, int n) {
        if (n == 0 && this.fRowController == null || n == 1 && this.fColumnController == null) {
            return;
        }
        int[] nArray2 = this.restrictRowColumnSpecToValidRegion(nArray, n);
        if (n == 0) {
            this.fRowController.deleteRows(nArray2);
        } else {
            this.fColumnController.deleteColumns(nArray2);
        }
    }

    private void insertEntireRowsOrColumns(int[] nArray, int n) {
        if (n == 0 && this.fRowController == null || n == 1 && this.fColumnController == null) {
            return;
        }
        if (n == 0) {
            this.fRowController.insertRows(nArray);
        } else {
            this.fColumnController.insertColumns(nArray);
        }
    }

    @Override
    public Action getCutAction() {
        return this.fCutAction;
    }

    @Override
    public Action getCopyAction() {
        if (this.fCopyAction == null) {
            this.fCopyAction = new SpreadsheetCopyAction();
        }
        return this.fCopyAction;
    }

    @Override
    public final Action getPasteAction() {
        return this.fPasteAction;
    }

    @Override
    public final Action getExcelPasteAction() {
        return this.fPasteExcelAction;
    }

    @Override
    public Action getSelectAllAction() {
        return this.fSelectAllAction;
    }

    @Override
    public MJPopupMenu getRowHeaderPopupMenu() {
        return this.fSelectionPopupMenu;
    }

    @Override
    public final Action getInsertAction() {
        return (Action)((Object)this.fInsertActions.get((Object)IRegionOpProvider.Scope.COLUMNS));
    }

    @Override
    public final Action getDeleteAction() {
        return (Action)((Object)this.fDeleteActions.get((Object)IRegionOpProvider.Scope.COLUMNS));
    }

    @Override
    public final Action getClearContentsAction() {
        return this.fClearContentsAction;
    }

    public void cleanup() {
        this.getTableHeader().setDefaultRenderer(new DefaultTableCellRenderer());
        if (this.fCompositeColorModelCell != null) {
            this.fCompositeColorModelCell.removeColorArrayTableModelListener(this.fCompositeColorModelCL);
            this.fCompositeColorModelBorder.removeColorArrayTableModelListener(this.fCompositeColorModelCL);
        }
        this.fCompositeColorModelCell = null;
        this.fCompositeColorModelBorder = null;
        this.cleanupCellEditorsAndRenderers();
        this.removeMouseListener(this.fTmel);
        this.fTmel = null;
        this.getTableHeader().removeMouseListener(this.fThmel);
        this.getTableHeader().removeMouseMotionListener((MouseMotionListener)((Object)this.fThmel));
        this.fThmel = null;
        this.getColumnModel().getSelectionModel().removeListSelectionListener(this.fCSL);
        this.fCSL = null;
        this.getSelectionModel().removeListSelectionListener(this.fRSL);
        this.fRSL = null;
        this.removeFocusListener((FocusListener)this.fAFD);
        this.fAFD = null;
        this.getActionMap().clear();
        if (this.fSelectionPopupMenu != null) {
            this.fSelectionPopupMenu.dispose();
        }
        this.fSelectionPopupMenu = null;
        this.fCutAction = null;
        this.fCopyAction = null;
        this.fPasteAction = null;
        this.fPasteExcelAction = null;
        this.fSelectAllAction = null;
        if (this.fInsertActions != null) {
            this.fInsertActions.clear();
        }
        this.fInsertActions = null;
        if (this.fDeleteActions != null) {
            this.fDeleteActions.clear();
        }
        this.fDeleteActions = null;
        this.fClearContentsAction = null;
        this.fStopEditingAction = null;
        this.fRowController = null;
        this.fColumnController = null;
        this.fRegionController = null;
        this.fDataClearer = null;
        SpreadsheetColor.removeColorListener(this.fPL);
        if (this.fSpreadsheetColor != null) {
            this.fSpreadsheetColor.setBaseTable(null);
            this.fSpreadsheetColor.unregisterColorInterests();
        }
        this.fSpreadsheetColor = null;
        this.fUndoAction = null;
        this.fRedoAction = null;
        if (this.fHeaderRenderer != null) {
            this.fHeaderRenderer.cleanup();
        }
        this.fHeaderRenderer = null;
    }

    private void recalculateColors() {
        if (this.fIsPrimaryFocusOwner) {
            this.setSelectionBackground(this.fSpreadsheetColor.getCellSelectedBackground());
        } else {
            this.setSelectionBackground(this.fSpreadsheetColor.getSecondaryCellSelectedBackground());
        }
        this.setSelectionForeground(this.fSpreadsheetColor.getCellSelectedForeground());
        this.setGridColor(this.fHeaderRenderer.getPreferredGridColor());
    }

    public CompositeColorArrayTableModel getCellColorArrayTableModel() {
        return this.fCompositeColorModelCell;
    }

    public CompositeColorArrayTableModel getBorderColorArrayTableModel() {
        return this.fCompositeColorModelBorder;
    }

    @Override
    public final Action getUndoAction() {
        return this.fUndoAction;
    }

    @Override
    public final Action getRedoAction() {
        return this.fRedoAction;
    }

    @Override
    @Deprecated
    protected boolean useKeyBindingManager() {
        return true;
    }

    @Override
    public List<IRegionOpProvider.Scope> getScopeSupportedForSelection() {
        return null;
    }

    private class StopEditingAction
    extends MJAbstractAction {
        StopEditingAction() {
            if (SpreadsheetTable.this.useDeprecatedKeybindingManager()) {
                SpreadsheetTable.this.doKeybindingSetup(this, "stop-editing-spreadsheet");
            } else {
                MatlabKeyBindings.getManager().addActionInfoOnly("SpreadsheetTable", "stop-editing-spreadsheet", (ExtendedAction)this);
                SpreadsheetTable.this.doDeprecatedKeybindingSetup((MJAbstractAction)this, KeyStroke.getKeyStroke(35, 0), null);
            }
            this.setComponentName("StopEditing");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SpreadsheetTable.this.stopEditing();
        }
    }

    private class ClearContentsAction
    extends MJAbstractAction {
        ClearContentsAction() {
            if (SpreadsheetTable.this.useDeprecatedKeybindingManager()) {
                SpreadsheetTable.this.doKeybindingSetup(this, "delete-next");
            }
            this.setName(SpreadsheetUtils.getResource("menu.clearContents"));
            this.setTip(SpreadsheetUtils.getResource("tip.clearContents"));
            if (!SpreadsheetTable.this.useDeprecatedKeybindingManager()) {
                SpreadsheetTable.this.doDeprecatedKeybindingSetup((MJAbstractAction)this, KeyStroke.getKeyStroke(127, 0), null);
            }
            this.setComponentName("ClearContents");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = SpreadsheetTable.this.restrictRowColumnSpecToValidRegion(SpreadsheetTable.this.getSelectedRows(), 0);
            int[] nArray2 = SpreadsheetTable.this.restrictRowColumnSpecToValidRegion(SpreadsheetTable.this.getSelectedColumns(), 1);
            if (SpreadsheetTable.this.fDataClearer != null) {
                SpreadsheetTable.this.fDataClearer.clearRegion(nArray, nArray2);
            } else {
                for (int n : nArray) {
                    for (int n2 : nArray2) {
                        SpreadsheetTable.this.setValueAt("", n, n2);
                    }
                }
            }
        }
    }

    private class DefaultDeleteAction
    extends MJAbstractAction {
        private DefaultDeleteAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SpreadsheetTable.this.areOnlyEntireRowsSelected()) {
                SpreadsheetTable.this.deleteEntireRowsOrColumns(SpreadsheetTable.this.getSelectedRows(), 0);
            } else if (SpreadsheetTable.this.areOnlyEntireColumnsSelected()) {
                SpreadsheetTable.this.deleteEntireRowsOrColumns(SpreadsheetTable.this.getSelectedColumns(), 1);
            } else {
                SpreadsheetTable.this.deleteRegion(SpreadsheetTable.this.getSelectedRows(), SpreadsheetTable.this.getSelectedColumns(), 1);
            }
        }
    }

    private class DefaultInsertAction
    extends MJAbstractAction {
        private DefaultInsertAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SpreadsheetTable.this.areOnlyEntireRowsSelected()) {
                SpreadsheetTable.this.insertEntireRowsOrColumns(SpreadsheetTable.this.getSelectedRows(), 0);
            } else if (SpreadsheetTable.this.areOnlyEntireColumnsSelected()) {
                SpreadsheetTable.this.insertEntireRowsOrColumns(SpreadsheetTable.this.getSelectedColumns(), 1);
            } else {
                SpreadsheetTable.this.insertRegion(SpreadsheetTable.this.getSelectedRows(), SpreadsheetTable.this.getSelectedColumns(), 1);
            }
        }
    }

    private class DeleteAction
    extends MJAbstractAction {
        IRegionOpProvider.Scope fScope = null;

        private DeleteAction(IRegionOpProvider.Scope scope) {
            this.fScope = scope;
            this.setName(SpreadsheetUtils.getResource("delete" + scope.getLabel() + ".Label"));
            if (SpreadsheetTable.this.useDeprecatedKeybindingManager()) {
                SpreadsheetTable.this.doKeybindingSetup(this, "generic-delete");
                this.initNameAndTip();
            } else {
                SpreadsheetTable.this.doDeprecatedKeybindingSetup((MJAbstractAction)this, KeyStroke.getKeyStroke(45, 2), null);
            }
            this.setComponentName("Delete_" + (Object)((Object)this.fScope));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.fScope) {
                case ROWS: {
                    SpreadsheetTable.this.deleteEntireRowsOrColumns(SpreadsheetTable.this.getSelectedRows(), 0);
                    break;
                }
                case COLUMNS: {
                    SpreadsheetTable.this.deleteEntireRowsOrColumns(SpreadsheetTable.this.getSelectedColumns(), 1);
                }
            }
        }

        public boolean reexamineActionEnabled() {
            boolean bl = false;
            if (SpreadsheetTable.this.fEditable && SpreadsheetTable.this.fRegionController != null) {
                int[] nArray = SpreadsheetTable.this.restrictRowColumnSpecToValidRegion(SpreadsheetTable.this.getSelectedRows(), 0);
                int[] nArray2 = SpreadsheetTable.this.restrictRowColumnSpecToValidRegion(SpreadsheetTable.this.getSelectedColumns(), 1);
                boolean bl2 = SpreadsheetTable.this.fRegionController.isRegionDeletable(nArray, nArray2, 0);
                boolean bl3 = SpreadsheetTable.this.fRegionController.isRegionDeletable(nArray, nArray2, 1);
                if (SpreadsheetTable.this.areOnlyEntireRowsSelected()) {
                    if (this.fScope == IRegionOpProvider.Scope.ROWS && bl2) {
                        bl = true;
                    }
                } else if (SpreadsheetTable.this.areOnlyEntireColumnsSelected()) {
                    if (this.fScope == IRegionOpProvider.Scope.COLUMNS && bl3) {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
            }
            this.setEnabled(bl);
            return bl;
        }

        protected void initNameAndTip() {
            this.setName(this.getName(), true);
            this.setTip(this.getName());
            this.setComponentName("Delete_" + (Object)((Object)this.fScope));
        }

        public String getName() {
            String string = SpreadsheetUtils.getResource("delete" + this.fScope.getLabel() + ".Label");
            if (string.startsWith("&")) {
                string = string.substring(1);
            }
            return string;
        }
    }

    private class InsertAction
    extends MJAbstractAction {
        IRegionOpProvider.Scope fScope = null;

        private InsertAction(IRegionOpProvider.Scope scope) {
            this.fScope = scope;
            this.setName(SpreadsheetUtils.getResource("insert" + scope.getLabel() + ".Label"));
            if (SpreadsheetTable.this.useDeprecatedKeybindingManager()) {
                if (scope == IRegionOpProvider.Scope.ROWS) {
                    SpreadsheetTable.this.doKeybindingSetup(this, "generic-insert");
                }
                this.initNameAndTip();
            } else if (scope == IRegionOpProvider.Scope.ROWS) {
                SpreadsheetTable.this.doDeprecatedKeybindingSetup((MJAbstractAction)this, KeyStroke.getKeyStroke(521, 2), null);
                SpreadsheetTable.this.registerWithInputMapNoKeyBindingManager(KeyStroke.getKeyStroke(61, 3), (Action)((Object)this));
            }
            this.setComponentName("Insert_" + (Object)((Object)this.fScope));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.fScope) {
                case ROWS: {
                    SpreadsheetTable.this.insertEntireRowsOrColumns(SpreadsheetTable.accumulateDiscontiguousSelection(SpreadsheetTable.this.getSelectedRows(), false), 0);
                    break;
                }
                case COLUMNS: {
                    SpreadsheetTable.this.insertEntireRowsOrColumns(SpreadsheetTable.accumulateDiscontiguousSelection(SpreadsheetTable.this.getSelectedColumns(), false), 1);
                    break;
                }
                case COLUMNS_TO_THE_RIGHT: {
                    int[] nArray = SpreadsheetTable.accumulateDiscontiguousSelection(SpreadsheetTable.this.getSelectedColumns(), true);
                    SpreadsheetTable.this.insertEntireRowsOrColumns(nArray, 1);
                    break;
                }
                case ROWS_BELOW: {
                    int[] nArray = SpreadsheetTable.accumulateDiscontiguousSelection(SpreadsheetTable.this.getSelectedRows(), true);
                    SpreadsheetTable.this.insertEntireRowsOrColumns(nArray, 0);
                }
            }
        }

        public boolean reexamineActionEnabled() {
            boolean bl = false;
            if (SpreadsheetTable.this.areOnlyEntireRowsSelected()) {
                if (this.fScope == IRegionOpProvider.Scope.ROWS || this.fScope == IRegionOpProvider.Scope.ROWS_BELOW) {
                    bl = SpreadsheetTable.this.fRowController != null;
                }
            } else if (SpreadsheetTable.this.areOnlyEntireColumnsSelected()) {
                if (this.fScope == IRegionOpProvider.Scope.COLUMNS || this.fScope == IRegionOpProvider.Scope.COLUMNS_TO_THE_RIGHT) {
                    bl = SpreadsheetTable.this.fColumnController != null;
                }
            } else if (SpreadsheetTable.this.fColumnController != null && SpreadsheetTable.this.fRowController != null) {
                bl = true;
            }
            this.setEnabled(bl);
            return bl;
        }

        protected void initNameAndTip() {
            this.setName(this.getName());
            this.setComponentName("Insert_" + (Object)((Object)this.fScope));
        }

        public String getName() {
            String string = SpreadsheetUtils.getResource("insert" + this.fScope.getLabel() + ".Label");
            if (string.startsWith("&")) {
                string = string.substring(1);
            }
            return string;
        }
    }

    private class PasteExcelAction
    extends PasteAction {
        PasteExcelAction() {
            this.iPasteStyle = 1;
            this.setName(SpreadsheetUtils.getPasteDataMenuResource());
            this.setTip(SpreadsheetUtils.getPasteDataToolTipResource());
        }

        @Override
        protected void initKeyBindings() {
            if (SpreadsheetTable.this.useDeprecatedKeybindingManager()) {
                SpreadsheetTable.this.doKeybindingSetup(this, "paste-excel-data");
            } else {
                MatlabKeyBindings.getManager().addActionInfoOnly("SpreadsheetTable", "paste-excel-data", (ExtendedAction)this);
                this.setName(SpreadsheetUtils.getPasteDataMenuResource());
                SpreadsheetTable.this.doDeprecatedKeybindingSetup((MJAbstractAction)this, KeyStroke.getKeyStroke(86, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK | 1), KeyStroke.getKeyStroke(86, 3));
            }
            this.setComponentName("PasteSpreadsheetData");
        }
    }

    private class PasteAction
    extends AbstractPasteAction {
        private boolean fShouldNotHonorEnabled;
        protected int iPasteStyle;

        PasteAction() {
            super(true);
            this.iPasteStyle = 0;
            this.clearKeyBinding();
            this.initKeyBindings();
        }

        protected void initKeyBindings() {
            if (SpreadsheetTable.this.useDeprecatedKeybindingManager()) {
                SpreadsheetTable.this.doKeybindingSetup(this, "paste-from-clipboard");
            } else {
                SpreadsheetTable.this.doDeprecatedKeybindingSetup((MJAbstractAction)this, 86, true);
                SpreadsheetTable.this.registerWithInputMapNoKeyBindingManager(KeyStroke.getKeyStroke(155, 1), (Action)((Object)this));
            }
            this.setComponentName("Paste");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!SpreadsheetTable.this.isEditing()) {
                this.doRegionPaste();
            } else {
                Action action = SpreadsheetTable.this.getEditorAction("paste-from-clipboard");
                if (action != null) {
                    action.actionPerformed(actionEvent);
                } else {
                    this.doRegionPaste();
                }
            }
        }

        private void doRegionPaste() {
            SpreadsheetTable.this.doPaste(this.iPasteStyle);
        }

        public void stopAutoUpdate() {
            if (PlatformInfo.isWindows()) {
                this.fShouldNotHonorEnabled = true;
            }
        }

        public void startAutoUpdate() {
            if (PlatformInfo.isWindows()) {
                this.fShouldNotHonorEnabled = false;
                this.clipboardContentTypeChanged(ClipboardMonitor.getFlavors());
            } else {
                super.setEnabled(true);
            }
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(!this.fShouldNotHonorEnabled && bl);
        }
    }

    private class SpreadsheetCopyAction
    extends CopyAction {
        private SpreadsheetCopyAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!SpreadsheetTable.this.isEditing()) {
                SpreadsheetTable.this.doRegionCopy(actionEvent);
            } else {
                Action action = SpreadsheetTable.this.getEditorAction("copy-to-clipboard");
                if (action != null) {
                    action.actionPerformed(actionEvent);
                } else {
                    SpreadsheetTable.this.doRegionCopy(actionEvent);
                }
            }
        }
    }

    protected abstract class CopyAction
    extends MJAbstractAction {
        protected CopyAction() {
            if (SpreadsheetTable.this.useDeprecatedKeybindingManager()) {
                SpreadsheetTable.this.doKeybindingSetup(this, "copy-to-clipboard");
            } else {
                MatlabKeyBindings.getManager().addActionInfoOnly("SpreadsheetTable", "copy-to-clipboard", (ExtendedAction)this);
                SpreadsheetTable.this.doDeprecatedKeybindingSetup((MJAbstractAction)this, 67, true);
                SpreadsheetTable.this.registerWithInputMapNoKeyBindingManager(KeyStroke.getKeyStroke(155, 2), (Action)((Object)this));
            }
            this.setComponentName("Copy");
        }
    }

    private class CutAction
    extends MJAbstractAction {
        CutAction() {
            if (SpreadsheetTable.this.useDeprecatedKeybindingManager()) {
                SpreadsheetTable.this.doKeybindingSetup(this, "cut-to-clipboard");
            } else {
                MatlabKeyBindings.getManager().addActionInfoOnly("SpreadsheetTable", "cut-to-clipboard", (ExtendedAction)this);
                SpreadsheetTable.this.doDeprecatedKeybindingSetup((MJAbstractAction)this, 88, true);
            }
            this.setComponentName("Cut");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!SpreadsheetTable.this.isEditing()) {
                SpreadsheetTable.this.doRegionCut(actionEvent);
            } else {
                Action action = SpreadsheetTable.this.getEditorAction("cut-to-clipboard");
                if (action != null) {
                    action.actionPerformed(actionEvent);
                } else {
                    SpreadsheetTable.this.doRegionCut(actionEvent);
                }
            }
        }
    }

    public class TableHeaderMouseEventListener
    extends AbstractSpreadsheetTable.AbstractTableHeaderMouseEventListener {
        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            SpreadsheetTable.this.requestFocus();
            TableCellEditor tableCellEditor = SpreadsheetTable.this.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            int n = SpreadsheetTable.this.getTableHeader().columnAtPoint(mouseEvent.getPoint());
            TableColumnModel tableColumnModel = SpreadsheetTable.this.getTableHeader().getColumnModel();
            boolean bl = SpreadsheetTable.this.processPossiblePopup(mouseEvent);
            boolean bl2 = false;
            if (!bl) {
                int n2 = SpreadsheetTable.this.getRowCount();
                if (n2 != 0 && SpreadsheetTable.this.isSelectionModeByHeader()) {
                    SpreadsheetTable.this.setColumnSelectionAllowed(true);
                    SpreadsheetTable.this.setRowSelectionAllowed(false);
                }
                ListSelectionModel listSelectionModel = tableColumnModel.getSelectionModel();
                if (mouseEvent.isShiftDown()) {
                    int n3 = listSelectionModel.getAnchorSelectionIndex();
                    int n4 = listSelectionModel.getLeadSelectionIndex();
                    if (n3 != -1) {
                        boolean bl3 = listSelectionModel.getValueIsAdjusting();
                        listSelectionModel.setValueIsAdjusting(true);
                        boolean bl4 = listSelectionModel.isSelectedIndex(n3);
                        if (n4 != -1) {
                            if (bl4) {
                                listSelectionModel.removeSelectionInterval(n3, n4);
                            } else {
                                listSelectionModel.addSelectionInterval(n3, n4);
                            }
                        }
                        if (bl4) {
                            listSelectionModel.addSelectionInterval(n3, n);
                        } else {
                            listSelectionModel.removeSelectionInterval(n3, n);
                        }
                        bl2 = true;
                        listSelectionModel.setValueIsAdjusting(bl3);
                    } else {
                        listSelectionModel.setSelectionInterval(n, n);
                        bl2 = true;
                    }
                } else if (mouseEvent.isControlDown() || PlatformInfo.isMacintosh() && mouseEvent.isMetaDown()) {
                    if (listSelectionModel.isSelectedIndex(n)) {
                        listSelectionModel.removeSelectionInterval(n, n);
                    } else {
                        listSelectionModel.addSelectionInterval(n, n);
                    }
                } else if (!SwingUtilities.isRightMouseButton(mouseEvent) && !mouseEvent.isPopupTrigger() || !listSelectionModel.isSelectedIndex(n)) {
                    listSelectionModel.setSelectionInterval(n, n);
                    bl2 = true;
                }
            }
            if (bl2) {
                SpreadsheetTable.this.selectEntireColumns();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            super.mouseDragged(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            SpreadsheetTable.this.processPossiblePopup(mouseEvent);
        }
    }

    private class RowSelectionListener
    implements ListSelectionListener {
        private RowSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            SpreadsheetTable.this.reexamineInsertDeleteEnablement();
            SpreadsheetTable.this.reexamineEditingActions();
        }
    }

    private class ColumnSelectionListener
    implements ListSelectionListener {
        private ColumnSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            try {
                SpreadsheetTable.this.getTableHeader().repaint();
                SpreadsheetTable.this.reexamineInsertDeleteEnablement();
                SpreadsheetTable.this.reexamineEditingActions();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                SpreadsheetTable.this.showOutOfMemoryDialog();
            }
        }
    }

    protected class TableMouseEventListener
    extends MouseAdapter {
        protected TableMouseEventListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            SpreadsheetTable.this.processPossiblePopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            SpreadsheetTable.this.processPossiblePopup(mouseEvent);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            super.mouseClicked(mouseEvent);
            if (!mouseEvent.isPopupTrigger() && PlatformInfo.isXWindows() && mouseEvent.getButton() == 2) {
                SpreadsheetTable.this.doPaste(0);
            }
        }
    }

    private class AppFocusL
    implements AppearanceFocusListener {
        private AppFocusL() {
        }

        public void appearanceFocusLost(AppearanceFocusEvent appearanceFocusEvent) {
            SpreadsheetTable.this.setIsPrimaryFocusOwner(false);
        }

        public void appearanceFocusGained(AppearanceFocusEvent appearanceFocusEvent) {
            SpreadsheetTable.this.setIsPrimaryFocusOwner(true);
        }
    }

    public class CopyChangeListener
    implements ChangeListener {
        private Cursor iCursor;

        public CopyChangeListener(Cursor cursor) {
            this.iCursor = cursor;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            SpreadsheetTable.this.setCursor(this.iCursor);
            if (changeEvent instanceof AbstractSpreadsheetTable.TableModelChangeEvent && ((AbstractSpreadsheetTable.TableModelChangeEvent)changeEvent).incidentOccured() && ((AbstractSpreadsheetTable.TableModelChangeEvent)changeEvent).getIncident() instanceof OutOfMemoryError) {
                SpreadsheetTable.this.showOutOfMemoryDialogDuringCopy();
            }
        }
    }
}

