/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text;

import com.mathworks.mwswing.datatransfer.DragAndDropUtilities;
import com.mathworks.mwswing.datatransfer.MJDragCursorUtilities;
import com.mathworks.mwswing.datatransfer.MWMouseDragGestureRecognizer;
import com.mathworks.util.Log;
import com.mathworks.widgets.text.MWCaret;
import com.mathworks.widgets.text.MWKit;
import com.mathworks.widgets.text.STPBaseModelInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.TooManyListenersException;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

class TextDragAndDrop
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private int fOldVerticalLinePos = -1;
    private JTextComponent fPane;
    private boolean fLocalDrop = false;
    private boolean fIsDragSource = false;
    private DragSource fDragSource;
    private TextMWMouseDragGestureRecognizer fTextMWMouseDragGestureRecognizer;
    private boolean fIsRegistered = true;

    TextDragAndDrop(JTextComponent jTextComponent) {
        this.fPane = jTextComponent;
        this.fDragSource = DragSource.getDefaultDragSource();
        DropTarget dropTarget = new DropTarget(this.fPane, this);
        this.fPane.setDropTarget(dropTarget);
        MWCaret mWCaret = (MWCaret)((Object)jTextComponent.getCaret());
        this.fTextMWMouseDragGestureRecognizer = new TextMWMouseDragGestureRecognizer(this.fDragSource, jTextComponent, 3, this, mWCaret);
    }

    private void removeDragGestureRecognizer() {
        this.fTextMWMouseDragGestureRecognizer.removeDragGestureListener(this);
        MWCaret mWCaret = (MWCaret)((Object)this.fPane.getCaret());
        this.fPane.addMouseListener((MouseListener)((Object)mWCaret));
        this.fPane.addMouseMotionListener((MouseMotionListener)((Object)mWCaret));
    }

    private void restoreDragGestureRecognizer() {
        try {
            this.fTextMWMouseDragGestureRecognizer.addDragGestureListener(this);
            MWCaret mWCaret = (MWCaret)((Object)this.fPane.getCaret());
            this.fTextMWMouseDragGestureRecognizer.setForwardingListener((MouseListener)((Object)mWCaret), (MouseMotionListener)((Object)mWCaret), this.fPane);
        }
        catch (TooManyListenersException tooManyListenersException) {
            System.out.println("Too many listeners");
        }
    }

    public void changeDragRecognizerRegistration(boolean bl) {
        if (this.fIsRegistered != bl) {
            if (bl) {
                this.restoreDragGestureRecognizer();
            } else {
                this.removeDragGestureRecognizer();
            }
        }
        this.fIsRegistered = bl;
    }

    public void setDragAndDropEnabled(boolean bl) {
        this.fTextMWMouseDragGestureRecognizer.enableDragAndDrop(bl);
    }

    public boolean isDragAndDropEnabled() {
        if (!this.fIsRegistered) {
            return false;
        }
        return this.fTextMWMouseDragGestureRecognizer.isDragAndDropEnabled();
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Cursor cursor;
        if (!this.fPane.isEditable() || !this.isDragAndDropEnabled()) {
            return;
        }
        int n = dragGestureEvent.getDragAction();
        if (n != 1 && n != 2) {
            return;
        }
        switch (n) {
            case 1: {
                cursor = MJDragCursorUtilities.getCursor((int)1);
                break;
            }
            case 2: {
                cursor = MJDragCursorUtilities.getCursor((int)2);
                break;
            }
            default: {
                return;
            }
        }
        Transferable transferable = MWKit.getTransferable(this.fPane, this);
        try {
            dragGestureEvent.startDrag(cursor, transferable, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        this.fIsDragSource = true;
        this.fLocalDrop = false;
        Cursor cursor = null;
        Cursor cursor2 = dragSourceDragEvent.getDragSourceContext().getCursor();
        switch (dragSourceDragEvent.getUserAction()) {
            case 1: {
                if (cursor2.equals(MJDragCursorUtilities.getCursor((int)1))) break;
                cursor = MJDragCursorUtilities.getCursor((int)1);
                break;
            }
            case 2: {
                if (cursor2.equals(MJDragCursorUtilities.getCursor((int)2))) break;
                cursor = MJDragCursorUtilities.getCursor((int)2);
                break;
            }
            default: {
                cursor = MJDragCursorUtilities.getCursor((int)1);
            }
        }
        if (cursor != null) {
            dragSourceDragEvent.getDragSourceContext().setCursor(cursor);
        }
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.getDragSourceContext().setCursor(MJDragCursorUtilities.getCursor((int)7563));
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        if (dragSourceDropEvent.getDropSuccess() && dragSourceDropEvent.getDropAction() == 3 && !this.fLocalDrop && this.fIsDragSource) {
            this.fPane.replaceSelection("");
        }
        this.fIsDragSource = false;
        DragAndDropUtilities.dragDropEndSendEvent((JTextComponent)this.fPane);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        Cursor cursor = null;
        Cursor cursor2 = dragSourceDragEvent.getDragSourceContext().getCursor();
        switch (dragSourceDragEvent.getUserAction()) {
            case 1: {
                if (cursor2.equals(MJDragCursorUtilities.getCursor((int)1))) break;
                cursor = MJDragCursorUtilities.getCursor((int)1);
                break;
            }
            case 2: {
                if (cursor2.equals(MJDragCursorUtilities.getCursor((int)2))) break;
                cursor = MJDragCursorUtilities.getCursor((int)2);
                break;
            }
            default: {
                cursor = MJDragCursorUtilities.getCursor((int)1);
            }
        }
        if (cursor != null) {
            dragSourceDragEvent.getDragSourceContext().setCursor(cursor);
        }
    }

    private void clearVerticalLine() {
        try {
            if (this.fOldVerticalLinePos != -1) {
                Rectangle rectangle = this.fPane.modelToView(this.fOldVerticalLinePos);
                if (rectangle != null) {
                    this.fPane.repaint(rectangle);
                } else {
                    Log.logException((Exception)new IllegalArgumentException("Null repaint rectangle in clearVerticalLine-- please geck."));
                }
            }
            this.fOldVerticalLinePos = -1;
        }
        catch (BadLocationException badLocationException) {
            this.fOldVerticalLinePos = -1;
        }
    }

    private void drawVerticalLine(Point point) {
        int n = this.fPane.viewToModel(point);
        if (this.fOldVerticalLinePos == n) {
            return;
        }
        try {
            Rectangle rectangle = this.fPane.modelToView(n);
            Graphics graphics = this.fPane.getGraphics();
            this.clearVerticalLine();
            if (rectangle == null || graphics == null) {
                return;
            }
            Color color = graphics.getColor();
            graphics.setColor(this.fPane.getCaretColor());
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
            if (color != null) {
                graphics.setColor(color);
            }
            graphics.dispose();
            this.fOldVerticalLinePos = n;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.fPane.isEditable()) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        if (!this.isDragAndDropEnabled()) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            dropTargetDragEvent.acceptDrag(3);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.clearVerticalLine();
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.clearVerticalLine();
        if (!this.fPane.isEditable()) {
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        this.fLocalDrop = true;
        String string = this.getDropString(dropTargetDropEvent);
        if (string == null) {
            return;
        }
        Point point = dropTargetDropEvent.getLocation();
        int n = this.fPane.viewToModel(point);
        boolean bl = this.dropIt(string, n, dropTargetDropEvent.getDropAction());
        dropTargetDropEvent.dropComplete(bl);
    }

    private String getDropString(DropTargetDropEvent dropTargetDropEvent) {
        String string;
        Transferable transferable = dropTargetDropEvent.getTransferable();
        if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            if (dropTargetDropEvent.getDropAction() == 2) {
                dropTargetDropEvent.acceptDrop(2);
            } else if (dropTargetDropEvent.getDropAction() == 1) {
                dropTargetDropEvent.acceptDrop(1);
            } else if (dropTargetDropEvent.getDropAction() == 3) {
                dropTargetDropEvent.acceptDrop(3);
            } else {
                dropTargetDropEvent.rejectDrop();
                return null;
            }
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                dropTargetDropEvent.dropComplete(false);
                return null;
            }
            catch (IOException iOException) {
                dropTargetDropEvent.dropComplete(false);
                return null;
            }
        } else {
            dropTargetDropEvent.rejectDrop();
            return null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean dropIt(String var1_1, int var2_2, int var3_3) {
        var4_4 = this.fPane.getSelectionStart();
        var5_5 = this.fPane.getSelectionEnd();
        var6_6 = true;
        if (!this.fIsDragSource) {
            var3_3 = 1;
        }
        try {
            if (var3_3 == 2) {
                if (this.fPane instanceof STPBaseModelInterface) {
                    ((STPBaseModelInterface)this.fPane).startBlockEdit();
                }
                try {
                    this.fPane.setCaretPosition(var2_2);
                    if (var2_2 > var5_5) {
                        this.fPane.getDocument().insertString(var2_2, var1_1, null);
                        this.fPane.getDocument().remove(var4_4, var5_5 - var4_4);
                    }
                    if (var2_2 >= var4_4) ** GOTO lbl27
                    this.fPane.getDocument().remove(var4_4, var5_5 - var4_4);
                    this.fPane.getDocument().insertString(var2_2, var1_1, null);
                }
                finally {
                    if (this.fPane instanceof STPBaseModelInterface) {
                        ((STPBaseModelInterface)this.fPane).endBlockEdit();
                    }
                }
            } else if (!this.fIsDragSource || var2_2 >= var5_5 || var2_2 < var4_4) {
                this.fPane.setCaretPosition(var2_2);
                this.fPane.getDocument().insertString(var2_2, var1_1, null);
            }
lbl27:
            // 6 sources

            if ((var7_8 = SwingUtilities.getWindowAncestor(this.fPane)) != null) {
                var7_8.toFront();
            }
            this.fPane.requestFocus();
        }
        catch (BadLocationException var7_9) {
            var6_6 = false;
        }
        finally {
            this.fPane.repaint();
        }
        return var6_6;
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.drawVerticalLine(dropTargetDragEvent.getLocation());
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    private class TextMWMouseDragGestureRecognizer
    extends MWMouseDragGestureRecognizer {
        TextMWMouseDragGestureRecognizer(DragSource dragSource, JTextComponent jTextComponent, int n, DragGestureListener dragGestureListener, MWCaret mWCaret) {
            super(dragSource, (Component)jTextComponent, n, dragGestureListener, (MouseListener)((Object)mWCaret), (MouseMotionListener)((Object)mWCaret));
        }

        public boolean isClickInSelection(MouseEvent mouseEvent) {
            return MWCaret.isClickInSelection(mouseEvent);
        }

        public boolean doSelectWordAction(MouseEvent mouseEvent) {
            return ((MWCaret)((Object)TextDragAndDrop.this.fPane.getCaret())).doSelectWordAction(mouseEvent);
        }

        public boolean doSelectLineAction(MouseEvent mouseEvent) {
            return ((MWCaret)((Object)TextDragAndDrop.this.fPane.getCaret())).doSelectLineAction(mouseEvent);
        }

        public int getOffsetFromEvent(MouseEvent mouseEvent) {
            return MWCaret.getOffsetFromEvent(mouseEvent);
        }

        public int getWordStart(Object object, int n) {
            return MWCaret.getWordStart(object, n);
        }

        public int getWordEnd(Object object, int n) {
            return MWCaret.getWordEnd(object, n);
        }

        public int getLineStart(Object object, int n) {
            return MWCaret.getLineStart(object, n);
        }

        public int getLineEnd(Object object, int n) {
            return MWCaret.getLineEnd(object, n);
        }
    }
}

