/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import com.mathworks.matlab.api.debug.Breakpoint;
import com.mathworks.matlab.api.debug.BreakpointMargin;
import com.mathworks.matlab.api.debug.BreakpointModel;
import com.mathworks.matlab.api.debug.ContextMenuListener;
import com.mathworks.matlab.api.debug.ViewProvider;
import com.mathworks.matlab.api.debug.ViewProviderKey;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorEvent;
import com.mathworks.matlab.api.editor.EditorEventListener;
import com.mathworks.widgets.SyntaxTextPaneMultiView;
import com.mathworks.widgets.editor.breakpoints.BreakpointAdjustmentUtils;
import com.mathworks.widgets.editor.breakpoints.BreakpointView;
import com.mathworks.widgets.text.STPInterface;
import com.mathworks.widgets.text.ViewHierarchyChangeEvent;
import com.mathworks.widgets.text.ViewHierarchyChangeListener;
import com.mathworks.widgets.text.mcode.CmdManager;
import java.awt.Component;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import org.apache.commons.lang.Validate;

public abstract class AbstractMBreakpointMargin<T extends Breakpoint>
implements BreakpointMargin<T> {
    private final SyntaxTextPaneMultiView fSyntaxPane;
    private final CmdManager fCmdManager;
    private final Editor fEditor;
    private final Map<ViewProviderKey, BreakpointView<T>> fBreakpointViews = new HashMap<ViewProviderKey, BreakpointView<T>>();
    private EventList<T> fViewBreakpoints;
    private final BreakpointModel<T> fBreakpointModel = this.createBreakpointModel();
    private final CmdManager.CmdLineListener fCommandLineListener = this.createCommandLineListener();
    private final EditorEventListener fEditorEventListener = this.createEditorEventListener();
    private final ContextMenuListener fContextMenuListener = this.createContextMenuListener();
    private ViewProvider fBreakpointMarginViewProvider;
    private final ViewHierarchyChangeListener fViewHierarchyChangeListener = this.createViewHierarchyListener();

    public AbstractMBreakpointMargin(Editor editor, SyntaxTextPaneMultiView syntaxTextPaneMultiView, CmdManager cmdManager) {
        Validate.notNull((Object)editor, (String)"The Editor should not be null");
        Validate.notNull((Object)syntaxTextPaneMultiView, (String)"The SyntaxTextPaneMultiView should not be null");
        Validate.notNull((Object)cmdManager, (String)"The CmdManager should not be null");
        this.fSyntaxPane = syntaxTextPaneMultiView;
        this.fEditor = editor;
        this.getSyntaxPane().addViewHierarchyChangeListener(this.fViewHierarchyChangeListener);
        this.fCmdManager = cmdManager;
        this.fBreakpointMarginViewProvider = this.createViewProvider();
        this.fEditor.addEventListener(this.fEditorEventListener);
        this.fCmdManager.addListener(this.fCommandLineListener);
        this.fSyntaxPane.addToLeftPanel(this.fBreakpointMarginViewProvider, "West");
    }

    public void dispose() {
        this.fSyntaxPane.removeFromLeftPanel(this.fBreakpointMarginViewProvider);
        this.fBreakpointMarginViewProvider = null;
        this.fEditor.removeEventListener(this.fEditorEventListener);
        this.fCmdManager.removeListener(this.fCommandLineListener);
        this.fCmdManager.dispose();
        this.disposeBreakpointViews();
        this.getSyntaxPane().removeViewHierarchyChangeListener(this.fViewHierarchyChangeListener);
    }

    private void disposeBreakpointViews() {
        for (BreakpointView<T> breakpointView : this.getBreakpointViews().values()) {
            breakpointView.dispose();
        }
    }

    private ViewProvider createViewProvider() {
        return new ViewProvider(){

            public Component getView(ViewProviderKey viewProviderKey) {
                AbstractMBreakpointMargin.this.createAndAddBreakpointMarginIfNecessary(viewProviderKey);
                return AbstractMBreakpointMargin.this.getBreakpointViews().get(viewProviderKey).getComponent();
            }

            public Component clearView(ViewProviderKey viewProviderKey) {
                BreakpointView breakpointView = (BreakpointView)AbstractMBreakpointMargin.this.fBreakpointViews.remove(viewProviderKey);
                if (breakpointView != null) {
                    breakpointView.dispose();
                }
                return breakpointView == null ? null : breakpointView.getComponent();
            }
        };
    }

    private void createAndAddBreakpointMarginIfNecessary(ViewProviderKey viewProviderKey) {
        if (this.getBreakpointViews().get(viewProviderKey) == null) {
            BreakpointView<T> breakpointView = this.createBreakpointView(viewProviderKey);
            this.fBreakpointViews.put(viewProviderKey, breakpointView);
        }
    }

    protected abstract BreakpointView<T> createBreakpointView(ViewProviderKey var1);

    protected abstract BreakpointModel<T> createBreakpointModel();

    protected abstract ContextMenuListener createContextMenuListener();

    protected ContextMenuListener getContextMenuListener() {
        return this.fContextMenuListener;
    }

    protected BreakpointModel<T> getBreakpointModel() {
        return this.fBreakpointModel;
    }

    protected Map<ViewProviderKey, BreakpointView<T>> getBreakpointViews() {
        return Collections.unmodifiableMap(this.fBreakpointViews);
    }

    public final boolean isActive() {
        return true;
    }

    public STPInterface getSyntaxPane() {
        return this.fSyntaxPane;
    }

    public CmdManager getCmdManager() {
        return this.fCmdManager;
    }

    public Editor getEditor() {
        return this.fEditor;
    }

    private EditorEventListener createEditorEventListener() {
        return new EditorEventListener(){

            public void eventOccurred(EditorEvent editorEvent) {
                if (editorEvent.equals((Object)EditorEvent.DIRTY_STATE_CHANGED)) {
                    if (!AbstractMBreakpointMargin.this.fEditor.isDirty()) {
                        AbstractMBreakpointMargin.this.fCmdManager.pause();
                        AbstractMBreakpointMargin.this.fCmdManager.restart();
                    }
                    AbstractMBreakpointMargin.this.setLive(!AbstractMBreakpointMargin.this.getEditor().isDirty());
                }
            }
        };
    }

    protected CmdManager.CmdLineListener createCommandLineListener() {
        return new CmdManager.CmdLineListener(){

            @Override
            public void commandLineChanged(int n, int n2, DocumentEvent documentEvent, boolean bl) {
                if (documentEvent != null && !documentEvent.getType().equals(DocumentEvent.EventType.CHANGE)) {
                    AbstractMBreakpointMargin.this.adjustAndRepaintBreakpoints(documentEvent, bl);
                }
            }
        };
    }

    protected void adjustAndRepaintBreakpoints(DocumentEvent documentEvent, boolean bl) {
        this.adjustBreakpoints(documentEvent, bl);
        this.repaintAll();
    }

    private void adjustBreakpoints(DocumentEvent documentEvent, boolean bl) {
        int n = this.getSyntaxPane().getMinLineFromDocEvent(documentEvent);
        int n2 = this.getSyntaxPane().getMaxLineFromDocEvent(documentEvent);
        BreakpointAdjustmentUtils.EventType eventType = bl ? BreakpointAdjustmentUtils.EventType.INSERT : BreakpointAdjustmentUtils.EventType.REMOVE;
        this.fViewBreakpoints = GlazedLists.eventList(BreakpointAdjustmentUtils.adjustBreakpoints(this.fViewBreakpoints, n, n2, this.getCmdManager(), eventType));
    }

    protected void repaintAll() {
        for (BreakpointView<T> breakpointView : this.getBreakpointViews().values()) {
            breakpointView.getComponent().repaint();
        }
    }

    protected EventList<T> getViewBreakpointList() {
        return this.fViewBreakpoints;
    }

    protected void setViewBreakpointList(EventList<T> eventList) {
        this.fViewBreakpoints = eventList;
    }

    protected ListEventListener<T> createBreakpointsRepaintListener() {
        return new ListEventListener<T>(){

            public void listChanged(ListEvent<T> listEvent) {
                AbstractMBreakpointMargin.this.repaintAll();
            }
        };
    }

    private ViewHierarchyChangeListener createViewHierarchyListener() {
        return new ViewHierarchyChangeListener(){

            @Override
            public void viewHierarchyChanged(ViewHierarchyChangeEvent viewHierarchyChangeEvent) {
                ViewProviderKey viewProviderKey = (ViewProviderKey)viewHierarchyChangeEvent.getSource();
                BreakpointView breakpointView = AbstractMBreakpointMargin.this.getBreakpointViews().get(viewProviderKey);
                if (breakpointView != null) {
                    breakpointView.getComponent().repaint();
                }
            }
        };
    }
}

