/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode;

import com.mathworks.util.Log;
import com.mathworks.widgets.text.mcode.MTree;
import java.lang.ref.WeakReference;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;

public final class BaseDocumentMTreeProvider {
    private volatile MTree fLastTree;
    private final WeakReference<BaseDocument> fDoc;
    private boolean fChanged = false;
    private final DocumentListener fDocumentListener;

    public BaseDocumentMTreeProvider(BaseDocument baseDocument) {
        this.fDoc = new WeakReference<BaseDocument>(baseDocument);
        this.fDocumentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                BaseDocumentMTreeProvider.this.fChanged = true;
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                BaseDocumentMTreeProvider.this.fChanged = true;
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        DocumentUtilities.addDocumentListener((Document)baseDocument, (DocumentListener)this.fDocumentListener, (DocumentListenerPriority)DocumentListenerPriority.BEFORE_FOLD_UPDATE);
    }

    public MTree getMTree() {
        if (this.fLastTree == null || this.fChanged) {
            this.fLastTree = MTree.parse(this.getTextFromDocument());
            this.fChanged = false;
        }
        return this.fLastTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTextFromDocument() {
        BaseDocument baseDocument = (BaseDocument)this.fDoc.get();
        assert (baseDocument != null) : "Attempt to read from document after garbage collection.";
        baseDocument.readLock();
        String string = null;
        try {
            string = baseDocument.getText(0, baseDocument.getLength());
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        finally {
            baseDocument.readUnlock();
        }
        return string;
    }

    void cleanup() {
        BaseDocument baseDocument = (BaseDocument)this.fDoc.get();
        if (baseDocument != null) {
            DocumentUtilities.removeDocumentListener((Document)baseDocument, (DocumentListener)this.fDocumentListener, (DocumentListenerPriority)DocumentListenerPriority.BEFORE_FOLD_UPDATE);
        }
    }
}

