/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode;

import com.mathworks.widgets.text.mcode.MLanguage;
import com.mathworks.widgets.text.mcode.MLint;
import com.mathworks.widgets.text.mcode.MTreeUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;

public final class CodeAnalyzerUtilities {
    private static final Comparator<MLint.Message> LINE_NUMBER_COMPARATOR = new Comparator<MLint.Message>(){

        @Override
        public int compare(MLint.Message message, MLint.Message message2) {
            return message.getLineNumber() < message2.getLineNumber() ? -1 : (message.getLineNumber() > message2.getLineNumber() ? 1 : 0);
        }
    };

    private CodeAnalyzerUtilities() {
    }

    public static synchronized void modifyMessages(String string, List<MLint.Message> list) throws BadLocationException {
        BaseDocument baseDocument = new BaseDocument(((Object)((Object)new MLanguage().createDefaultKit())).getClass(), false);
        baseDocument.insertString(0, string, null);
        CodeAnalyzerUtilities.modifyMessages(baseDocument, list);
    }

    public static void modifyMessages(BaseDocument baseDocument, List<MLint.Message> list) throws BadLocationException {
        for (MLint.Message message : list) {
            CodeAnalyzerUtilities.modifyMessage(baseDocument, message);
        }
        Collections.sort(list, LINE_NUMBER_COMPARATOR);
    }

    public static int getEndPosition(Document document, MLint.Message message) throws BadLocationException {
        return CodeAnalyzerUtilities.getEndPosition(document, message.getLineNumber(), message.getEndColumn());
    }

    public static int getEndPosition(Document document, int n, int n2) throws BadLocationException {
        return MTreeUtils.convertBytePositionToStringPosition((BaseDocument)document, n - 1, n2);
    }

    public static int getStartPosition(Document document, MLint.Message message) throws BadLocationException {
        return CodeAnalyzerUtilities.getStartPosition(document, message.getLineNumber(), message.getStartColumn());
    }

    public static int getStartPosition(Document document, int n, int n2) throws BadLocationException {
        return MTreeUtils.convertBytePositionToStringPosition((BaseDocument)document, n - 1, n2 - 1);
    }

    private static void setToLastNonWhite(BaseDocument baseDocument, MLint.Message message, int n) throws BadLocationException {
        int n2 = Utilities.getFirstNonWhiteBwd((BaseDocument)baseDocument, (int)n);
        int n3 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n2);
        message.setLineNumber(n3 + 1);
        int n4 = n2 - Utilities.getRowStart((BaseDocument)baseDocument, (int)n2) + 1;
        message.setStartColumn(n4);
        message.setEndColumn(n4);
    }

    private static void modifyMessage(BaseDocument baseDocument, MLint.Message message) throws BadLocationException {
        if (message.getStartColumn() == 0) {
            CodeAnalyzerUtilities.setToLastNonWhite(baseDocument, message, baseDocument.getLength());
        } else if (message.getStartColumn() > message.getEndColumn()) {
            int n = CodeAnalyzerUtilities.getEndPosition((Document)baseDocument, message);
            if (Character.isWhitespace(baseDocument.getChars(n, 1)[0])) {
                CodeAnalyzerUtilities.setToLastNonWhite(baseDocument, message, n);
            } else {
                message.setEndColumn(message.getStartColumn());
            }
        } else if (message.getStartColumn() == message.getEndColumn() && baseDocument.getChars(CodeAnalyzerUtilities.getStartPosition((Document)baseDocument, message), 1)[0] == '\n') {
            CodeAnalyzerUtilities.setToLastNonWhite(baseDocument, message, CodeAnalyzerUtilities.getEndPosition((Document)baseDocument, message));
        }
    }
}

