/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.widgets.STPStateManagerFactory;
import com.mathworks.widgets.StateConstants;
import com.mathworks.widgets.StateManager;
import com.mathworks.widgets.text.EditorPrefsAccessor;
import com.mathworks.widgets.text.ErrorLogger;
import com.mathworks.widgets.text.fold.FoldInfo;
import com.mathworks.widgets.text.fold.FoldState;
import com.mathworks.widgets.text.fold.FoldStateManager;
import com.mathworks.widgets.text.mcode.MFoldType;
import com.mathworks.widgets.text.mcode.MTree;
import com.mathworks.widgets.text.mcode.MTreeBaseDocumentCache;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldOperation;

public class MFoldManager
implements FoldManager {
    private Map<MFoldType, List<Fold>> fCachedFolds;
    private Map<MFoldType, List<Fold>> fObsoleteFolds;
    private SettingsChangeListener fFoldSettingsListener;
    private FoldOperation fOperation;
    private Timer fUpdateTimer;
    private boolean fDocModified;
    private static final int UPDATE_TIMER_DELAY = 150;
    private final boolean fUpdateSynchronously;
    private final List<MFoldType> fSupportedFoldTypes;
    private final MFoldType.Priority fPriority;
    private static final ErrorLogger LOGGER = ErrorLogger.getLogger();
    private List<FoldState> fFoldStates;
    private static final String LAST_VALID_FOLDSINFO = "LastValidFoldsInfo";
    private static final String IGNORE_LAST_VALID_FOLDS = "IgnoreLastValidFoldsInfo";

    public MFoldManager(boolean bl, MFoldType.Priority priority) {
        this.fUpdateSynchronously = bl;
        this.fSupportedFoldTypes = Collections.unmodifiableList(MFoldType.getFoldTypesWithPriority(priority));
        this.fPriority = priority;
    }

    public void init(FoldOperation foldOperation) {
        this.fOperation = foldOperation;
        this.fCachedFolds = new EnumMap<MFoldType, List<Fold>>(MFoldType.class);
        this.fObsoleteFolds = new EnumMap<MFoldType, List<Fold>>(MFoldType.class);
        for (MFoldType mFoldType : this.fSupportedFoldTypes) {
            this.fCachedFolds.put(mFoldType, new ArrayList());
            this.fObsoleteFolds.put(mFoldType, new ArrayList());
        }
        this.fFoldSettingsListener = new FoldSettingsListener();
        Settings.addSettingsChangeListener((SettingsChangeListener)this.fFoldSettingsListener);
    }

    public void initFolds(FoldHierarchyTransaction foldHierarchyTransaction) {
        StateManager stateManager = STPStateManagerFactory.getInstance().getStateManager(StateConstants.Module.CODE_FOLDS);
        if (stateManager instanceof FoldStateManager) {
            this.fFoldStates = ((FoldStateManager)stateManager).getFoldStates(this.getOperation().getHierarchy());
        }
        this.createFolds(foldHierarchyTransaction, true);
        this.fUpdateTimer = new Timer(150, new DocUpdateHandler());
        this.fUpdateTimer.setRepeats(false);
    }

    public void insertUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
        this.documentModified(foldHierarchyTransaction);
    }

    public void removeDamagedNotify(Fold fold) {
        this.removeFromCache(fold);
    }

    public void removeEmptyNotify(Fold fold) {
        this.removeFromCache(fold);
    }

    public void removeUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
        this.documentModified(foldHierarchyTransaction);
    }

    private void documentModified(FoldHierarchyTransaction foldHierarchyTransaction) {
        this.fDocModified = true;
        if (!this.fUpdateSynchronously) {
            this.fUpdateTimer.restart();
        } else {
            this.updateFolds(foldHierarchyTransaction);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
    }

    public void expandNotify(Fold fold) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        block9: {
            this.fUpdateTimer.stop();
            BaseDocument baseDocument = this.getBaseDocument();
            baseDocument.readLock();
            try {
                if (this.getOperation() == null || this.getOperation().getHierarchy() == null) break block9;
                FoldHierarchy foldHierarchy = this.getOperation().getHierarchy();
                foldHierarchy.lock();
                try {
                    FoldHierarchyTransaction foldHierarchyTransaction = this.getOperation().openTransaction();
                    try {
                        this.removeAllFolds(foldHierarchyTransaction);
                    }
                    finally {
                        foldHierarchyTransaction.commit();
                    }
                }
                finally {
                    foldHierarchy.unlock();
                }
            }
            finally {
                baseDocument.readUnlock();
            }
        }
        this.fCachedFolds.clear();
        this.fObsoleteFolds.clear();
        Settings.removeSettingsChangeListener((SettingsChangeListener)this.fFoldSettingsListener);
        this.fOperation = null;
        this.fFoldSettingsListener = null;
        this.fUpdateTimer = null;
        this.fFoldStates = null;
    }

    private List<Fold> getCachedFolds(MFoldType mFoldType) {
        return this.fCachedFolds.get((Object)mFoldType);
    }

    private List<Fold> getCachedFoldsForTypeName(String string) {
        for (MFoldType mFoldType : this.fSupportedFoldTypes) {
            if (!string.equals(mFoldType.toString())) continue;
            return this.getCachedFolds(mFoldType);
        }
        return null;
    }

    private List<Fold> getObsoleteFolds(MFoldType mFoldType) {
        return this.fObsoleteFolds.get((Object)mFoldType);
    }

    private Document getDocument() {
        if (this.getOperation() != null && this.getOperation().getHierarchy() != null) {
            return this.getOperation().getHierarchy().getComponent().getDocument();
        }
        return null;
    }

    private BaseDocument getBaseDocument() {
        Document document = this.getDocument();
        assert (document instanceof BaseDocument);
        return (BaseDocument)document;
    }

    private FoldOperation getOperation() {
        return this.fOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFolds(FoldHierarchyTransaction foldHierarchyTransaction, boolean bl) {
        block8: {
            if (this.getDocument() instanceof BaseDocument) {
                BaseDocument baseDocument = this.getBaseDocument();
                if (foldHierarchyTransaction != null) {
                    FoldsInfo foldsInfo = this.getInitialFoldsInfo(baseDocument, bl);
                    baseDocument.readLock();
                    try {
                        FoldHierarchy foldHierarchy;
                        FoldHierarchy foldHierarchy2 = foldHierarchy = this.getOperation() != null ? this.getOperation().getHierarchy() : null;
                        if (foldHierarchy == null) break block8;
                        foldHierarchy.lock();
                        try {
                            this.createFoldsFromInfo(foldsInfo, (AbstractDocument)baseDocument, foldHierarchyTransaction);
                        }
                        finally {
                            foldHierarchy.unlock();
                        }
                    }
                    finally {
                        baseDocument.readUnlock();
                    }
                }
            }
        }
    }

    private void reInitFoldsInNewTransaction() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block10: {
                    Document document = MFoldManager.this.getDocument();
                    if (document instanceof BaseDocument) {
                        ((BaseDocument)document).readLock();
                        try {
                            if (MFoldManager.this.getOperation() == null || MFoldManager.this.getOperation().getHierarchy() == null) break block10;
                            FoldHierarchy foldHierarchy = MFoldManager.this.getOperation().getHierarchy();
                            foldHierarchy.lock();
                            try {
                                FoldHierarchyTransaction foldHierarchyTransaction = MFoldManager.this.getOperation().openTransaction();
                                try {
                                    MFoldManager.this.removeAllFolds(foldHierarchyTransaction);
                                    MFoldManager.this.createFolds(foldHierarchyTransaction, false);
                                }
                                finally {
                                    foldHierarchyTransaction.commit();
                                }
                            }
                            finally {
                                foldHierarchy.unlock();
                            }
                        }
                        finally {
                            ((BaseDocument)document).readUnlock();
                        }
                    }
                }
            }
        };
        MJUtilities.runOnEventDispatchThread((Runnable)runnable);
    }

    private void removeAllObsoleteFolds(FoldHierarchyTransaction foldHierarchyTransaction) {
        for (MFoldType mFoldType : this.fSupportedFoldTypes) {
            List<Fold> list = this.getObsoleteFolds(mFoldType);
            this.removeObsoleteFolds(list, foldHierarchyTransaction);
            list.clear();
        }
    }

    private void removeObsoleteFolds(List<Fold> list, FoldHierarchyTransaction foldHierarchyTransaction) {
        if (list != null && !list.isEmpty()) {
            FoldOperation foldOperation = this.getOperation();
            for (Fold fold : list) {
                List<Fold> list2;
                if (foldOperation == null || fold == null) continue;
                try {
                    foldOperation.removeFromHierarchy(fold, foldHierarchyTransaction);
                }
                catch (IllegalStateException illegalStateException) {
                    LOGGER.nbDebugLog(illegalStateException);
                }
                if ((list2 = this.getCachedFoldsForTypeName(fold.getType().toString())) == null) continue;
                list2.remove(fold);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFolds(FoldHierarchyTransaction foldHierarchyTransaction) {
        block7: {
            FoldsInfo foldsInfo;
            if (foldHierarchyTransaction != null && (foldsInfo = this.createFoldsFromMTree(false)) != null) {
                BaseDocument baseDocument = this.getBaseDocument();
                this.updateCachedLastFoldsObject(baseDocument, foldsInfo);
                this.reconcileOldFolds(foldsInfo);
                baseDocument.readLock();
                try {
                    if (this.getOperation() == null || this.getOperation().getHierarchy() == null) break block7;
                    FoldHierarchy foldHierarchy = this.getOperation().getHierarchy();
                    foldHierarchy.lock();
                    try {
                        this.removeAllObsoleteFolds(foldHierarchyTransaction);
                        this.createFoldsFromInfo(foldsInfo, (AbstractDocument)baseDocument, foldHierarchyTransaction);
                    }
                    finally {
                        foldHierarchy.unlock();
                    }
                }
                finally {
                    baseDocument.readUnlock();
                }
            }
        }
    }

    static void putEmptyIgnoreLastValidFoldsProperty(BaseDocument baseDocument) {
        baseDocument.putProperty((Object)IGNORE_LAST_VALID_FOLDS, new ArrayList());
    }

    private FoldsInfo possiblyGetCachedFolds(BaseDocument baseDocument) {
        Collection collection = (Collection)baseDocument.getProperty((Object)IGNORE_LAST_VALID_FOLDS);
        FoldsInfo foldsInfo = null;
        if (collection != null && !collection.contains((Object)this.fPriority)) {
            Map map = (Map)baseDocument.getProperty((Object)LAST_VALID_FOLDSINFO);
            foldsInfo = map != null && map.containsKey((Object)this.fPriority) ? (FoldsInfo)map.get((Object)this.fPriority) : null;
            collection.add(this.fPriority);
        }
        return foldsInfo;
    }

    private void updateCachedLastFoldsObject(BaseDocument baseDocument, FoldsInfo foldsInfo) {
        HashMap<MFoldType.Priority, FoldsInfo> hashMap = (HashMap<MFoldType.Priority, FoldsInfo>)baseDocument.getProperty((Object)LAST_VALID_FOLDSINFO);
        if (hashMap == null) {
            hashMap = new HashMap<MFoldType.Priority, FoldsInfo>();
            baseDocument.putProperty((Object)LAST_VALID_FOLDSINFO, hashMap);
        }
        hashMap.put(this.fPriority, foldsInfo.copy());
    }

    private FoldsInfo getInitialFoldsInfo(BaseDocument baseDocument, boolean bl) {
        assert (baseDocument != null);
        FoldsInfo foldsInfo = this.possiblyGetCachedFolds(baseDocument);
        if (foldsInfo == null) {
            foldsInfo = this.createFoldsFromMTree(bl);
            if (foldsInfo == null) {
                foldsInfo = new FoldsInfo((Document)baseDocument);
            }
            this.updateCachedLastFoldsObject(baseDocument, foldsInfo);
        }
        return foldsInfo;
    }

    private void removeFromCache(Fold fold) {
        List<Fold> list;
        if (fold != null && (list = this.getCachedFoldsForTypeName(fold.getType().toString())) != null && !list.isEmpty()) {
            list.remove(fold);
        }
    }

    private void reconcileOldFolds(FoldsInfo foldsInfo) {
        for (MFoldType mFoldType : this.fSupportedFoldTypes) {
            Iterator<Fold> iterator = this.getCachedFolds(mFoldType).iterator();
            while (iterator.hasNext()) {
                Fold fold = iterator.next();
                boolean bl = true;
                List<Fold> list = foldsInfo.getFoldInfo(mFoldType).iterator();
                while (list.hasNext()) {
                    FoldInfo foldInfo = list.next();
                    if (foldInfo.getStartOffset() != fold.getStartOffset() || foldInfo.getEndOffset() != fold.getEndOffset()) continue;
                    list.remove();
                    bl = false;
                }
                if (!bl) continue;
                iterator.remove();
                list = this.getObsoleteFolds(mFoldType);
                if (list.contains(fold)) continue;
                list.add(fold);
            }
        }
    }

    private void removeAllFolds(FoldHierarchyTransaction foldHierarchyTransaction) {
        for (MFoldType mFoldType : this.fSupportedFoldTypes) {
            this.removeCachedFolds(this.getCachedFolds(mFoldType), foldHierarchyTransaction);
            this.getObsoleteFolds(mFoldType).clear();
        }
    }

    private void removeCachedFolds(List<Fold> list, FoldHierarchyTransaction foldHierarchyTransaction) {
        if (list != null && !list.isEmpty() && foldHierarchyTransaction != null) {
            Iterator<Fold> iterator = list.iterator();
            FoldOperation foldOperation = this.getOperation();
            while (iterator.hasNext()) {
                Fold fold = iterator.next();
                if (foldOperation == null) continue;
                foldOperation.removeFromHierarchy(fold, foldHierarchyTransaction);
                iterator.remove();
            }
        }
    }

    private FoldsInfo createFoldInfo(FoldsInfo foldsInfo, BaseDocument baseDocument, boolean bl, MFoldType mFoldType, List<MTree.Node> list) {
        if (baseDocument.getLength() > 0) {
            List<FoldInfo> list2 = mFoldType.collectFolds(baseDocument, list);
            if (bl) {
                for (FoldInfo foldInfo : list2) {
                    foldInfo.setCollapsed(mFoldType.isFoldedUponOpen());
                    this.setCollapsedFromState(foldInfo, mFoldType);
                }
            }
            foldsInfo.setFoldInfo(mFoldType, list2);
        }
        return foldsInfo;
    }

    private void setCollapsedFromState(FoldInfo foldInfo, MFoldType mFoldType) {
        if (this.fFoldStates != null && foldInfo != null && mFoldType != null) {
            if (this.fFoldStates.isEmpty()) {
                foldInfo.setCollapsed(false);
                return;
            }
            for (FoldState foldState : this.fFoldStates) {
                if (!foldState.getTypeName().equals(mFoldType.toString()) || foldState.getStartOffset() != foldInfo.getStartOffset() || foldState.getEndOffset() != foldInfo.getEndOffset()) continue;
                foldInfo.setCollapsed(foldState.isCollapsed());
                return;
            }
            foldInfo.setCollapsed(false);
        }
    }

    private FoldsInfo createFoldsFromMTree(boolean bl) {
        BaseDocument baseDocument = this.getBaseDocument();
        MTree mTree = MTreeBaseDocumentCache.getMTree(baseDocument);
        if (mTree.isValid()) {
            FoldsInfo foldsInfo = new FoldsInfo((Document)baseDocument);
            MTree.NodeType[] nodeTypeArray = MFoldType.getNodesNeededForFolds();
            if (nodeTypeArray.length > 0) {
                List<MTree.Node> list = Collections.unmodifiableList(mTree.findAsList(nodeTypeArray));
                for (MFoldType mFoldType : this.fSupportedFoldTypes) {
                    if (!mFoldType.isFoldEnabled()) continue;
                    this.createFoldInfo(foldsInfo, baseDocument, bl, mFoldType, list);
                }
            }
            return foldsInfo;
        }
        return null;
    }

    private void createFoldsFromInfo(FoldsInfo foldsInfo, AbstractDocument abstractDocument, FoldHierarchyTransaction foldHierarchyTransaction) {
        if (foldsInfo != null && foldsInfo.isValidDocument(abstractDocument) && abstractDocument.getLength() > 0) {
            for (MFoldType mFoldType : this.fSupportedFoldTypes) {
                if (!mFoldType.isFoldEnabled()) continue;
                this.createFoldForType(foldsInfo.getFoldInfo(mFoldType), mFoldType, foldHierarchyTransaction);
            }
        }
    }

    private void createFoldForType(List<FoldInfo> list, MFoldType mFoldType, FoldHierarchyTransaction foldHierarchyTransaction) {
        if (list != null && !list.isEmpty()) {
            for (FoldInfo foldInfo : list) {
                if (!FoldOperation.isBoundsValid((int)foldInfo.getStartOffset(), (int)foldInfo.getEndOffset(), (int)0, (int)0) || this.getOperation() == null) continue;
                try {
                    Fold fold = this.getOperation().addToHierarchy(mFoldType.getType(), mFoldType.getCollapsedRepresentation(), foldInfo.isCollapsed(), foldInfo.getStartOffset(), foldInfo.getEndOffset(), 0, 0, null, foldHierarchyTransaction);
                    if (fold == null) continue;
                    this.getCachedFolds(mFoldType).add(fold);
                }
                catch (BadLocationException badLocationException) {
                    LOGGER.nbDebugLog(badLocationException);
                }
            }
        }
    }

    private class DocUpdateHandler
    implements ActionListener {
        private DocUpdateHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block10: {
                BaseDocument baseDocument;
                if (MFoldManager.this.fDocModified && (baseDocument = MFoldManager.this.getBaseDocument()) != null) {
                    baseDocument.readLock();
                    try {
                        FoldHierarchy foldHierarchy;
                        FoldHierarchy foldHierarchy2 = foldHierarchy = MFoldManager.this.getOperation() != null ? MFoldManager.this.getOperation().getHierarchy() : null;
                        if (foldHierarchy == null) break block10;
                        foldHierarchy.lock();
                        try {
                            FoldHierarchyTransaction foldHierarchyTransaction = MFoldManager.this.getOperation().openTransaction();
                            try {
                                MFoldManager.this.updateFolds(foldHierarchyTransaction);
                            }
                            finally {
                                foldHierarchyTransaction.commit();
                            }
                        }
                        finally {
                            foldHierarchy.unlock();
                        }
                    }
                    finally {
                        baseDocument.readUnlock();
                    }
                }
            }
        }
    }

    private static class FoldsInfo {
        private final Document fOriginalDocument;
        private final Map<MFoldType, List<FoldInfo>> fFoldInfos;

        FoldsInfo(Document document) {
            this.fOriginalDocument = document;
            this.fFoldInfos = new EnumMap<MFoldType, List<FoldInfo>>(MFoldType.class);
        }

        public boolean isValidDocument(Document document) {
            return this.fOriginalDocument == document;
        }

        public List<FoldInfo> getFoldInfo(MFoldType mFoldType) {
            return this.fFoldInfos.get((Object)mFoldType);
        }

        public void setFoldInfo(MFoldType mFoldType, List<FoldInfo> list) {
            this.fFoldInfos.put(mFoldType, list);
        }

        public FoldsInfo copy() {
            FoldsInfo foldsInfo = new FoldsInfo(this.fOriginalDocument);
            for (MFoldType mFoldType : this.fFoldInfos.keySet()) {
                List<FoldInfo> list = this.fFoldInfos.get((Object)mFoldType);
                if (list == null) continue;
                foldsInfo.setFoldInfo(mFoldType, new ArrayList<FoldInfo>(list));
            }
            return foldsInfo;
        }
    }

    private class FoldSettingsListener
    implements SettingsChangeListener {
        private FoldSettingsListener() {
        }

        public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
            if (settingsChangeEvent != null && MFoldType.isFoldEnabledPrefKey(settingsChangeEvent.getSettingName()) && EditorPrefsAccessor.isCodeFoldingEnabled()) {
                MFoldManager.this.reInitFoldsInNewTransaction();
            }
        }
    }
}

