/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode;

import com.mathworks.widgets.text.matlab.AbstractStripEndWhitespaceLayer;
import com.mathworks.widgets.text.matlab.MatlabFormatSupport;
import com.mathworks.widgets.text.matlab.MatlabFormatter;
import com.mathworks.widgets.text.matlab.MatlabIndentingLayer;
import com.mathworks.widgets.text.mcode.MFormatSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.editor.ext.FormatSupport;
import org.netbeans.editor.ext.FormatWriter;

public class MFormatter
extends MatlabFormatter {
    private static final Map<String, String[]> TOKEN_MAP = new HashMap<String, String[]>();

    private static void addTokens(String string, String[] stringArray) {
        TOKEN_MAP.put(string, stringArray);
    }

    public MFormatter(Class<?> clazz) {
        super(clazz);
    }

    public static Map<String, String[]> getTokenMap() {
        return Collections.unmodifiableMap(TOKEN_MAP);
    }

    @Override
    protected String getIndentingLayerName() {
        return "m-layer";
    }

    @Override
    protected MatlabIndentingLayer createIndentingLayer() {
        return new MIndentingLayer();
    }

    @Override
    protected AbstractStripEndWhitespaceLayer createStripEndWhitespaceLayer() {
        return new StripEndWhitespaceLayer();
    }

    @Override
    protected boolean isStringAtEndOfToken(String string) {
        return TOKEN_MAP.keySet().contains(string);
    }

    @Override
    protected String[] getTokenImagesEndingInString(String string) {
        return TOKEN_MAP.get(string);
    }

    static {
        MFormatter.addTokens("e", new String[]{"else", "case", "otherwise"});
        MFormatter.addTokens("f", new String[]{"elseif"});
        MFormatter.addTokens("n", new String[]{"function"});
        MFormatter.addTokens("h", new String[]{"catch"});
        MFormatter.addTokens("d", new String[]{"end"});
    }

    private static class MIndentingLayer
    extends MatlabIndentingLayer {
        private static final String NAME = "m-layer";

        private MIndentingLayer() {
            super(NAME);
        }

        @Override
        protected MatlabFormatSupport createFormatSupport(FormatWriter formatWriter) {
            return new MFormatSupport(formatWriter);
        }
    }

    public static class StripEndWhitespaceLayer
    extends AbstractStripEndWhitespaceLayer {
        public StripEndWhitespaceLayer() {
            super("m-strip-whitespace-at-line-end");
        }

        @Override
        protected FormatSupport createFormatSupport(FormatWriter formatWriter) {
            return new MFormatSupport(formatWriter);
        }
    }
}

