/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode;

import com.mathworks.matlab.api.editor.EditorLanguage;
import com.mathworks.matlab.api.editor.EditorLanguagePriority;
import com.mathworks.services.Prefs;
import com.mathworks.services.mlx.MlxFileUtils;
import com.mathworks.widgets.text.EditorPreferences;
import com.mathworks.widgets.text.mcode.MKit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.io.IOCase;

public class MLanguage
implements EditorLanguage {
    public static final EditorLanguage INSTANCE = new MLanguage();
    public static final String M_MIME_TYPE = INSTANCE.getMimeType();
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(MLanguage.class.getPackage().getName() + ".resources.RES_mcode");
    private static final String MLX_FILE_EXTENSION = "mlx";
    public static final String HAS_APPENDED_MLX_TO_FILE_EXTENSIONS_KEY = "HasAppendedMlxToFileExtensionsKey";

    public boolean isMatchingExtension(String string) {
        if (MlxFileUtils.isMlxEnabled()) {
            MLanguage.appendMlxFileExtensionToPreferences();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(EditorPreferences.getFileExtensions(this));
        if (!arrayList.contains(MLX_FILE_EXTENSION)) {
            arrayList.add(MLX_FILE_EXTENSION);
        }
        for (String string2 : arrayList) {
            if (!IOCase.INSENSITIVE.checkEquals(string, string2)) continue;
            return true;
        }
        return false;
    }

    private static void appendMlxFileExtensionToPreferences() {
        List<String> list;
        assert (MlxFileUtils.isMlxEnabled()) : "appendMlxFileExtensionToPreferences should only be called when the MLX feature is on.";
        if (Prefs.getBooleanPref((String)HAS_APPENDED_MLX_TO_FILE_EXTENSIONS_KEY, (boolean)false)) {
            return;
        }
        String string = Prefs.getStringPref((String)EditorPreferences.generateFileExtensionsPrefKey(INSTANCE), null);
        if (string != null && !(list = Arrays.asList(string.split(";"))).contains(MLX_FILE_EXTENSION)) {
            ArrayList<String> arrayList = new ArrayList<String>(list);
            arrayList.add(MLX_FILE_EXTENSION);
            EditorPreferences.setFileExtensions(INSTANCE, arrayList);
        }
        Prefs.setBooleanPref((String)HAS_APPENDED_MLX_TO_FILE_EXTENSIONS_KEY, (boolean)true);
    }

    public String getInternalName() {
        return "MATLAB";
    }

    public List<String> getDefaultExtensions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("m");
        if (MlxFileUtils.isMlxEnabled()) {
            arrayList.add(MLX_FILE_EXTENSION);
        }
        return arrayList;
    }

    public EditorLanguagePriority getPriority() {
        return EditorLanguagePriority.PREFERRED;
    }

    public String getMimeType() {
        return "text/m-MATLAB";
    }

    public String getName() {
        return "MATLAB";
    }

    public String getDescription() {
        return BUNDLE.getString("description");
    }

    public MKit createDefaultKit() {
        return new MKit(){

            @Override
            public String getContentType() {
                return MLanguage.this.getMimeType();
            }

            @Override
            public boolean isModifiable() {
                return false;
            }
        };
    }
}

