/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode;

import com.mathworks.widgets.text.mcode.MLint;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public final class MLintConfiguration {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.widgets.text.mcode.resources.RES_mcode");
    private static final int UNUSED_SEVERITY = -1;
    private static final char DISABLED = '0';
    private static final char ENABLED = '1';
    private static final char COMMENT_CHAR = '#';
    private final Map fMessages;
    private final Set fEnabledCategories;
    private final Set fDisabledCategories;
    private final File fFile;

    public static MLintConfiguration createEmpty() {
        return new MLintConfiguration((File)null);
    }

    public static MLintConfiguration createEmpty(File file) {
        return new MLintConfiguration(file);
    }

    public static MLintConfiguration read(File file) throws IOException, FormatException {
        return MLintConfiguration.read(file, false);
    }

    public static MLintConfiguration read(File file, boolean bl) throws IOException, FormatException {
        if (file == null) {
            throw new IllegalArgumentException("'file' cannot be null");
        }
        MLintConfiguration mLintConfiguration = new MLintConfiguration(file);
        try (BufferedReader bufferedReader = null;){
            bufferedReader = new BufferedReader(new FileReader(file));
            int n = 0;
            while (bufferedReader.ready()) {
                MLintConfiguration.applyLine(bufferedReader.readLine(), ++n, mLintConfiguration, bl);
            }
            MLintConfiguration mLintConfiguration2 = mLintConfiguration;
            return mLintConfiguration2;
        }
    }

    private static void applyLine(String string, int n, MLintConfiguration mLintConfiguration, boolean bl) throws FormatException {
        String string2;
        if (string.trim().length() == 0 || string.startsWith(String.valueOf('#'))) {
            return;
        }
        char c = string.charAt(0);
        if (c != '0' && c != '1') {
            if (bl) {
                return;
            }
            throw new FormatException("mlintConfiguration.lineStart", n, null);
        }
        int n2 = -1;
        boolean bl2 = c == '1';
        int n3 = 1;
        if (bl2 && string.charAt(1) >= '0' && string.charAt(1) <= '9') {
            n2 = string.charAt(1) - 48;
            ++n3;
        }
        if (!(string2 = string.substring(n3).trim()).matches("[A-Z\\d]++")) {
            if (bl) {
                return;
            }
            throw new FormatException("mlintConfiguration.badTag", n, string2);
        }
        if (MLintConfiguration.isCategory(string2)) {
            mLintConfiguration.setCategoryEnabled(string2, bl2, !bl2);
        } else if (bl2) {
            if (n2 == -1) {
                if (bl) {
                    return;
                }
                throw new FormatException("mlintConfiguration.noSeverity", n, string);
            }
            mLintConfiguration.enableMessage(string2, n2, false);
        } else {
            mLintConfiguration.disableMessage(string2, true);
        }
    }

    private static boolean isCategory(String string) {
        List<MLint.Category> list = MLint.getCategories();
        for (MLint.Category category : list) {
            if (!category.getTag().equals(string)) continue;
            return true;
        }
        return false;
    }

    public File getFile() {
        return this.fFile;
    }

    public void save() throws IOException {
        if (this.fFile == null) {
            throw new IllegalStateException("Configuration was not created via read(File)");
        }
        this.saveTo(this.fFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTo(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("'file' cannot be null");
        }
        if (file.exists() && !file.canWrite()) {
            throw new IOException(sRes.getString("mlintConfiguration.readOnly"));
        }
        try (BufferedWriter bufferedWriter = null;){
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            int n = Calendar.getInstance().get(1);
            bufferedWriter.write("# Copyright " + n + " The MathWorks, Inc.");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write(this.getMessagesAsString());
        }
    }

    public boolean isEmpty() {
        return this.fMessages.isEmpty() && this.fEnabledCategories.isEmpty() && this.fDisabledCategories.isEmpty();
    }

    public boolean isEnabled(String string, boolean bl) {
        boolean bl2 = bl;
        ConfigEntry configEntry = (ConfigEntry)this.fMessages.get(string);
        if (configEntry != null) {
            bl2 = configEntry.fEnabled;
        }
        return bl2;
    }

    public String getMessagesAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = this.fEnabledCategories.iterator();
        while (object.hasNext()) {
            stringBuffer.append('1').append(object.next()).append(LINE_SEPARATOR);
        }
        object = new ArrayList(this.fMessages.keySet());
        Collections.sort(object);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ConfigEntry configEntry = (ConfigEntry)this.fMessages.get(string);
            stringBuffer.append(configEntry.getFormattedString(string));
            stringBuffer.append(LINE_SEPARATOR);
        }
        iterator = this.fDisabledCategories.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append('0').append(iterator.next()).append(LINE_SEPARATOR);
        }
        return stringBuffer.toString();
    }

    public void disableMessage(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("'tag' cannot be null");
        }
        if (!bl) {
            this.fMessages.remove(string);
        } else {
            this.fMessages.put(string, new ConfigEntry(false, -1));
        }
    }

    public void enableMessage(String string, int n, boolean bl) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("'tag' cannot be null");
        }
        if (bl) {
            this.fMessages.remove(string);
        } else {
            this.fMessages.put(string, new ConfigEntry(true, n));
        }
    }

    public void setCategoryEnabled(String string, boolean bl, boolean bl2) {
        if (bl == bl2) {
            this.fEnabledCategories.remove(string);
            this.fDisabledCategories.remove(string);
        } else if (bl) {
            this.fEnabledCategories.add(string);
            this.fDisabledCategories.remove(string);
        } else {
            this.fDisabledCategories.add(string);
            this.fEnabledCategories.remove(string);
        }
    }

    public boolean isCategoryEnabled(String string, boolean bl) {
        boolean bl2 = bl;
        if (this.fEnabledCategories.contains(string)) {
            bl2 = true;
        } else if (this.fDisabledCategories.contains(string)) {
            bl2 = false;
        }
        return bl2;
    }

    public boolean isReadOnly() {
        return this.fFile != null && this.fFile.exists() && !this.fFile.canWrite();
    }

    public MLintConfiguration copy() {
        return new MLintConfiguration(this);
    }

    private MLintConfiguration(MLintConfiguration mLintConfiguration) {
        this.fFile = mLintConfiguration.fFile;
        this.fMessages = new HashMap(mLintConfiguration.fMessages);
        this.fEnabledCategories = new HashSet(mLintConfiguration.fEnabledCategories);
        this.fDisabledCategories = new HashSet(mLintConfiguration.fDisabledCategories);
    }

    private MLintConfiguration(File file) {
        this.fFile = file;
        this.fMessages = new HashMap();
        this.fEnabledCategories = new HashSet();
        this.fDisabledCategories = new HashSet();
    }

    private static final class ConfigEntry {
        private final boolean fEnabled;
        private final int fSeverity;

        ConfigEntry(boolean bl, int n) {
            this.fEnabled = bl;
            this.fSeverity = n;
        }

        public String getFormattedString(String string) {
            String string2 = String.valueOf(this.fEnabled ? (char)'1' : '0');
            if (this.fSeverity != -1) {
                string2 = string2 + String.valueOf(this.fSeverity);
            }
            string2 = string2 + string;
            return string2;
        }
    }

    public static class FormatException
    extends RuntimeException {
        private final String fKey;
        private final int fLineNumber;

        public FormatException(String string, int n, String string2) {
            super(MessageFormat.format(sRes.getString(string), new Integer(n), string2));
            this.fKey = string;
            this.fLineNumber = n;
        }

        public int getLineNumber() {
            return this.fLineNumber;
        }

        public String getKey() {
            return this.fKey;
        }
    }
}

