/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode.cell;

import com.mathworks.widgets.text.mcode.MTree;
import com.mathworks.widgets.text.mcode.cell.Cell;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CellUtils {
    public static final String TITLE_SYMBOL = "%% ";
    public static final String BULLETED_LIST_SYMBOL = "* ";
    public static final String NUMBERED_LIST_SYMBOL = "# ";

    private CellUtils() {
    }

    public static int[] getCellLocations(String string) {
        List<Cell> list = CellUtils.getCellLocationsAsList(MTree.parse(string).findAsList(MTree.NodeType.CELL_TITLE), string);
        int[] nArray = new int[list.size() * 2];
        int n = 0;
        for (Cell cell : list) {
            nArray[n++] = cell.getStartLine();
            nArray[n++] = cell.getEndLine();
        }
        return nArray;
    }

    public static List<Cell> getCellLocationsAsList(List<MTree.Node> list, String string) {
        LinkedList<Cell> linkedList = new LinkedList<Cell>();
        List<Integer> list2 = CellUtils.findBlankLines(string);
        for (MTree.Node node : list) {
            Cell cell;
            assert (node.getType() == MTree.NodeType.CELL_TITLE);
            linkedList.add(CellUtils.createCell(node, list2));
            if (!CellUtils.isFirstCellBreakInBlock(node) || (cell = CellUtils.createImplicitCellAbove(node, list2)) == null) continue;
            linkedList.add(cell);
        }
        Collections.sort(linkedList);
        return linkedList;
    }

    private static Cell createImplicitCellAbove(MTree.Node node, List<Integer> list) {
        if (node.getPrevious() != MTree.NULL_NODE) {
            MTree.Node node2 = CellUtils.getFirstNodeInList(node);
            return CellUtils.createCell(node2, list);
        }
        if (list.contains(node.getStartLine() - 1)) {
            int n = node.getStartLine();
            while (list.contains(n - 1)) {
                --n;
            }
            return new Cell(n, node.getStartLine() - 1, true);
        }
        return null;
    }

    private static boolean isFirstCellBreakInBlock(MTree.Node node) {
        do {
            if ((node = node.getPrevious()) != MTree.NULL_NODE) continue;
            return true;
        } while (node.getType() != MTree.NodeType.CELL_TITLE);
        return false;
    }

    private static Cell createCell(MTree.Node node, List<Integer> list) {
        boolean bl = node.getType() != MTree.NodeType.CELL_TITLE;
        int n = node.getStartLine();
        if (bl) {
            if (node.getParent() != MTree.NULL_NODE && node.getParent().getStartLine() == n) {
                ++n;
            }
            while (list.contains(n - 1)) {
                --n;
            }
        }
        int n2 = CellUtils.getCellEnd(node, list);
        return new Cell(n, n2, bl);
    }

    private static MTree.Node getFirstNodeInList(MTree.Node node) {
        MTree.Node node2 = node;
        while (node != MTree.NULL_NODE) {
            node2 = node;
            node = node2.getPrevious();
        }
        return node2;
    }

    private static int getCellEnd(MTree.Node node, List<Integer> list) {
        MTree.Node node2 = node;
        while (node2.getNext() != MTree.NULL_NODE && node2.getNext().getType() != MTree.NodeType.CELL_TITLE) {
            node2 = node2.getNext();
        }
        int n = Math.max(node2.getStartLine(), node2.getEndLine());
        MTree.Node node3 = node2;
        while (node3.getType() == MTree.NodeType.COMMENT && node3.getPrevious() != MTree.NULL_NODE) {
            n = Math.max(node3.getPrevious().getEndLine(), n);
            node3 = node3.getPrevious();
        }
        while (list.contains(n + 1)) {
            ++n;
        }
        return n;
    }

    private static List<Integer> findBlankLines(String string) {
        Pattern pattern = Pattern.compile("^.*$", 8);
        Pattern pattern2 = Pattern.compile("^\\s*$");
        Matcher matcher = pattern.matcher(string);
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        int n = 0;
        while (matcher.find()) {
            ++n;
            if (!pattern2.matcher(matcher.group()).matches()) continue;
            linkedList.add(n);
        }
        return linkedList;
    }
}

