/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode.variables;

import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.widgets.text.mcode.MTree;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightUtils;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightingLayer;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.Action;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;

public class VariableHighlightActions {
    public static final String HIGHLIGHT_VARIABLE_ACTION = "highlight-variable-usages";

    private VariableHighlightActions() {
    }

    public static BaseAction createVariableHighlightAction() {
        return new HighlightVariableUsagesAction();
    }

    public static Action createHighlightVariableMenuAction(MTree.Node node) {
        return new HighlightMenuAction(node);
    }

    public static String getHighlightKeystroke() {
        return VariableHighlightActions.getKeystrokeString(HIGHLIGHT_VARIABLE_ACTION);
    }

    public static String getRenameKeyStroke() {
        return VariableHighlightActions.getKeystrokeString("shift-insert-break");
    }

    private static String getKeystrokeString(String string) {
        String string2 = "";
        KeyBindingManager keyBindingManager = MatlabKeyBindings.getManager();
        List list = keyBindingManager.getCurrentKeyBindingSet().getKeyBindings(keyBindingManager.getContext("MATLABEditor"), keyBindingManager.getActionData(string));
        if (!list.isEmpty()) {
            string2 = KeyStrokeUtils.translateKeyStrokes((KeyStrokeList)((KeyStrokeList)list.get(0)));
        }
        return string2;
    }

    private static class HighlightVariableUsagesAction
    extends BaseAction {
        private HighlightVariableUsagesAction() {
            super(VariableHighlightActions.HIGHLIGHT_VARIABLE_ACTION);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            VariableHighlightingLayer variableHighlightingLayer = VariableHighlightUtils.getVariableHighlightLayer(jTextComponent);
            if (variableHighlightingLayer.isEnabled()) {
                variableHighlightingLayer.highlightOrClear();
            }
        }
    }

    private static class HighlightMenuAction
    extends ChildAction {
        private HighlightMenuAction(MTree.Node node) {
            super((Action)((Object)new HighlightVariableUsagesAction()));
            String string = (String)this.getParent().getValue("Name");
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABEditor", string, (ExtendedAction)this);
            if (node != null) {
                this.setName(MessageFormat.format(VariableHighlightUtils.getBundle().getString("highlight.highlightUsages"), node.getText()));
            }
        }
    }
}

