/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode.variables;

import com.mathworks.util.Log;
import com.mathworks.widgets.text.MergeAttributeSet;
import com.mathworks.widgets.text.PrintableDocument;
import com.mathworks.widgets.text.STPBaseInterface;
import com.mathworks.widgets.text.mcode.variables.Variable;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;

class VariableRenameUtils {
    private VariableRenameUtils() {
    }

    static String getAdjustedNewVarName(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            boolean bl3 = bl2 = i >= string2.length() || i < string2.length() && string2.charAt(i) != string.charAt(i);
            if (!bl && bl2) {
                stringBuilder.append("<b>");
                bl = true;
            }
            stringBuilder.append(string.charAt(i));
        }
        if (bl) {
            stringBuilder.append("</b>");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void renameAllTo(STPBaseInterface sTPBaseInterface, Variable variable) {
        assert (sTPBaseInterface.getDocument() instanceof PrintableDocument);
        List<Position> list = variable.getOtherInstances();
        String string = variable.getOldName();
        String string2 = variable.getText();
        PrintableDocument printableDocument = (PrintableDocument)sTPBaseInterface.getDocument();
        sTPBaseInterface.startBlockEdit();
        try {
            Collections.sort(list, VariableRenameUtils.createPositionComparator());
            Collections.reverse(list);
            for (Position position : list) {
                if (!VariableHighlightUtils.variableExists(sTPBaseInterface, position.getOffset(), string)) continue;
                printableDocument.replace(position.getOffset(), string.length(), string2, new MergeAttributeSet());
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        finally {
            sTPBaseInterface.endBlockEdit();
        }
    }

    private static <T extends Position> Comparator<T> createPositionComparator() {
        return new Comparator<T>(){

            @Override
            public int compare(T t, T t2) {
                Integer n = t.getOffset();
                Integer n2 = t2.getOffset();
                return n.compareTo(n2);
            }
        };
    }
}

