/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.toolbars;

import com.mathworks.matlab.api.toolbars.ToolBarBuilder;
import com.mathworks.matlab.api.toolbars.ToolBarGroupID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class DefaultToolBarBuilder<T>
implements ToolBarBuilder<T> {
    private final Map<ToolBarGroupID, List<T>> fGroupMap;

    public DefaultToolBarBuilder(ToolBarGroupID ... toolBarGroupIDArray) {
        this(Arrays.asList(toolBarGroupIDArray));
    }

    public DefaultToolBarBuilder(List<? extends ToolBarGroupID> list) {
        Validate.notNull(list, (String)"groupIDs cannot be null");
        this.fGroupMap = new LinkedHashMap<ToolBarGroupID, List<T>>();
        for (ToolBarGroupID toolBarGroupID : list) {
            this.fGroupMap.put(toolBarGroupID, new ArrayList());
        }
    }

    public void add(ToolBarGroupID toolBarGroupID, T ... TArray) {
        this.getItems(toolBarGroupID).addAll(Arrays.asList(TArray));
    }

    public void addToFront(ToolBarGroupID toolBarGroupID, T ... TArray) {
        this.getItems(toolBarGroupID).addAll(0, Arrays.asList(TArray));
    }

    public List<T> getItems() {
        ArrayList arrayList = new ArrayList();
        for (ToolBarGroupID toolBarGroupID : this.fGroupMap.keySet()) {
            arrayList.addAll(this.fGroupMap.get(toolBarGroupID));
        }
        return arrayList;
    }

    public List<String> getSeparatedItems() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ToolBarGroupID toolBarGroupID : this.fGroupMap.keySet()) {
            List<T> list = this.fGroupMap.get(toolBarGroupID);
            if (list.isEmpty()) continue;
            if (!arrayList.isEmpty()) {
                arrayList.add("Tool Bar Separator Key");
            }
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private List<T> getItems(ToolBarGroupID toolBarGroupID) {
        List<T> list = this.fGroupMap.get(toolBarGroupID);
        Validate.notNull(list, (String)("Group " + toolBarGroupID + " is not in this builder's list"));
        return list;
    }
}

