/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.collection;

import com.sun.jini.collection.WeakKeyReference;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class WeakTable {
    private HashMap table = new HashMap();
    private ReferenceQueue refQueue = new ReferenceQueue();
    private static PrintStream DEBUG = null;
    private KeyGCHandler handler = null;

    public WeakTable() {
        if (DEBUG != null) {
            DEBUG.println("Creating WeakTable");
        }
        this.table = new HashMap();
        this.refQueue = new ReferenceQueue();
    }

    public WeakTable(KeyGCHandler keyGCHandler) {
        this();
        this.handler = keyGCHandler;
    }

    public synchronized Object getOrAdd(Object object, Object object2) {
        Object object3 = this.get(object);
        if (object3 != null) {
            if (DEBUG != null) {
                DEBUG.println("WeakTable.getOrAdd: found " + object3);
            }
            return object3;
        }
        if (DEBUG != null) {
            DEBUG.println("WeakTable.getOrAdd: adding " + object2);
        }
        this.table.put(new WeakKeyReference(object, this.refQueue), new WeakReference<Object>(object2, this.refQueue));
        return object2;
    }

    public synchronized Object get(Object object) {
        Object var4_4;
        this.removeBlanks();
        WeakKeyReference weakKeyReference = new WeakKeyReference(object);
        WeakReference weakReference = (WeakReference)this.table.get(weakKeyReference);
        Object v0 = var4_4 = weakReference == null ? null : weakReference.get();
        if (DEBUG != null) {
            DEBUG.println("WeakTable.get:ref = " + weakReference + ", existing = " + var4_4);
        }
        return var4_4;
    }

    public synchronized Object remove(Object object) {
        this.removeBlanks();
        WeakKeyReference weakKeyReference = new WeakKeyReference(object);
        WeakReference weakReference = (WeakReference)this.table.remove(weakKeyReference);
        if (weakReference == null) {
            return null;
        }
        return weakReference.get();
    }

    public synchronized void removeBlanks() {
        Reference reference;
        if (DEBUG != null) {
            DEBUG.println("WeakTable.removeBlanks: starting");
        }
        while ((reference = this.refQueue.poll()) != null) {
            if (reference instanceof WeakKeyReference) {
                WeakReference weakReference = (WeakReference)this.table.remove(reference);
                if (weakReference != null && this.handler != null && weakReference.get() != null) {
                    this.handler.keyGC(weakReference.get());
                }
                if (DEBUG == null) continue;
                boolean bl = weakReference != null;
                DEBUG.print("WeakTable.removeBlanks: key=" + reference);
                DEBUG.println(", " + (bl ? "" : "!") + "removed, " + this.table.size() + " remain");
                continue;
            }
            if (DEBUG == null) continue;
            DEBUG.println("WeakTable.removeBlanks: value=" + reference);
        }
        if (DEBUG != null) {
            DEBUG.println("WeakTable.removeBlanks: finished");
        }
    }

    public static interface KeyGCHandler {
        public void keyGC(Object var1);
    }
}

