/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import com.sun.jini.start.ServiceDescriptor;
import com.sun.jini.start.ServiceStarter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.MarshalledObject;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Logger;
import net.jini.config.Configuration;

public class SharedActivationGroupDescriptor
implements ServiceDescriptor {
    private final String policy;
    private final String classpath;
    private final String log;
    private final String serverCommand;
    private final String[] serverOptions;
    private final Properties serverProperties;
    private final String host;
    private final int port;
    private static final String GROUP_COOKIE_FILE = "cookie";
    private static final Logger logger = ServiceStarter.logger;

    public SharedActivationGroupDescriptor(String string, String string2, String string3, String string4, String[] stringArray, String[] stringArray2) {
        this(string, string2, string3, string4, stringArray, stringArray2, null, ServiceStarter.getActivationSystemPort());
    }

    public SharedActivationGroupDescriptor(String string, String string2, String string3, String string4, String[] stringArray, String[] stringArray2, String string5, int n) {
        if (string == null || string2 == null || string3 == null) {
            throw new NullPointerException("Policy, classpath, or log cannot be null");
        }
        this.policy = string;
        this.classpath = string2;
        this.log = string3;
        this.serverCommand = string4;
        this.serverOptions = SharedActivationGroupDescriptor.customizeSharedGroupOptions(string2, stringArray);
        Properties properties = SharedActivationGroupDescriptor.convertToProperties(stringArray2);
        this.serverProperties = SharedActivationGroupDescriptor.customizeSharedGroupProperties(string, properties);
        this.host = string5 == null ? "" : string5;
        this.port = n <= 0 ? ServiceStarter.getActivationSystemPort() : n;
    }

    public final String getPolicy() {
        return this.policy;
    }

    public final String getClasspath() {
        return this.classpath;
    }

    public final String getLog() {
        return this.log;
    }

    public final String getServerCommand() {
        return this.serverCommand;
    }

    public final String[] getServerOptions() {
        return (String[])this.serverOptions.clone();
    }

    public final Properties getServerProperties() {
        return (Properties)this.serverProperties.clone();
    }

    public final String getActivationSystemHost() {
        return this.host;
    }

    public final int getActivationSystemPort() {
        return this.port;
    }

    private static String[] customizeSharedGroupOptions(String string, String[] stringArray) {
        String[] stringArray2 = new String[]{"-cp", string};
        if (stringArray != null) {
            String[] stringArray3 = new String[stringArray2.length + stringArray.length];
            System.arraycopy(stringArray2, 0, stringArray3, 0, stringArray2.length);
            System.arraycopy(stringArray, 0, stringArray3, stringArray2.length, stringArray.length);
            stringArray2 = stringArray3;
        }
        return stringArray2;
    }

    private static Properties convertToProperties(String[] stringArray) {
        Properties properties = new Properties();
        if (stringArray == null || stringArray.length == 0) {
            return properties;
        }
        if (stringArray.length % 2 != 0) {
            throw new IllegalArgumentException("The service properties entry has an odd number of elements");
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            properties.setProperty(stringArray[i], stringArray[i + 1]);
        }
        return properties;
    }

    private static Properties customizeSharedGroupProperties(String string, Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        properties.put("java.security.policy", string);
        return properties;
    }

    public Object create(Configuration configuration) throws Exception {
        ServiceStarter.ensureSecurityManager();
        logger.entering(SharedActivationGroupDescriptor.class.getName(), "create", new Object[]{configuration});
        if (configuration == null) {
            throw new NullPointerException("Configuration argument cannot be null");
        }
        ActivationSystem activationSystem = ServiceStarter.getActivationSystem(this.getActivationSystemHost(), this.getActivationSystemPort(), configuration);
        ActivationGroupDesc.CommandEnvironment commandEnvironment = new ActivationGroupDesc.CommandEnvironment(this.getServerCommand(), this.getServerOptions());
        ActivationGroupID activationGroupID = null;
        try {
            activationGroupID = activationSystem.registerGroup(new ActivationGroupDesc(this.getServerProperties(), commandEnvironment));
            SharedActivationGroupDescriptor.storeGroupID(this.getLog(), activationGroupID);
        }
        catch (Exception exception) {
            try {
                if (activationGroupID != null) {
                    activationSystem.unregisterGroup(activationGroupID);
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof ActivationException) {
                throw (ActivationException)exception;
            }
            if (exception instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)exception;
            }
            throw new RuntimeException("Unexpected Exception", exception);
        }
        logger.exiting(SharedActivationGroupDescriptor.class.getName(), "create", activationGroupID);
        return activationGroupID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void storeGroupID(String string, ActivationGroupID activationGroupID) throws IOException {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        if (file.exists()) {
            throw new IOException("Log " + string2 + " exists." + " Please delete or select another path");
        }
        if (!file.mkdir()) {
            throw new IOException("Could not create directory: " + string2);
        }
        File file2 = new File(file, GROUP_COOKIE_FILE);
        ObjectOutputStream objectOutputStream = null;
        try {
            try {
                objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
                objectOutputStream.writeObject(new MarshalledObject<ActivationGroupID>(activationGroupID));
                objectOutputStream.flush();
            }
            catch (IOException iOException) {
                file2.delete();
                throw (IOException)iOException.fillInStackTrace();
            }
            Object var8_6 = null;
            if (objectOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (objectOutputStream == null) throw throwable;
            objectOutputStream.close();
            throw throwable;
        }
        objectOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ActivationGroupID restoreGroupID(String string) throws IOException, ClassNotFoundException {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        if (!file.exists() || !file.isDirectory()) {
            throw new IOException("Log directory [" + string2 + "] does not exist.");
        }
        File file2 = new File(file, GROUP_COOKIE_FILE);
        ObjectInputStream objectInputStream = null;
        ActivationGroupID activationGroupID = null;
        try {
            objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file2)));
            MarshalledObject marshalledObject = (MarshalledObject)objectInputStream.readObject();
            activationGroupID = (ActivationGroupID)marshalledObject.get();
            Object var8_7 = null;
            if (objectInputStream == null) return activationGroupID;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (objectInputStream == null) throw throwable;
            objectInputStream.close();
            throw throwable;
        }
        objectInputStream.close();
        return activationGroupID;
    }

    public String toString() {
        ArrayList<Object> arrayList = new ArrayList<Object>(8);
        arrayList.add(this.policy);
        arrayList.add(this.classpath);
        arrayList.add(this.log);
        arrayList.add(this.serverCommand);
        arrayList.add(Arrays.asList(this.serverOptions));
        arrayList.add(this.serverProperties);
        arrayList.add(this.host);
        arrayList.add(new Integer(this.port));
        return arrayList.toString();
    }
}

