/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor.fold;

import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.modules.editor.fold.FoldChildren;
import org.netbeans.modules.editor.fold.FoldOperationImpl;
import org.netbeans.modules.editor.fold.FoldUtilitiesImpl;
import org.openide.ErrorManager;

public final class Fold {
    private static final Fold[] EMPTY_FOLD_ARRAY = new Fold[0];
    private static final String DEFAULT_DESCRIPTION = "...";
    private final FoldOperationImpl operation;
    private final FoldType type;
    private boolean collapsed;
    private String description;
    private Fold parent;
    private FoldChildren children;
    private int rawIndex;
    private int startGuardedLength;
    private int endGuardedLength;
    private Position startPos;
    private Position endPos;
    private Position guardedEndPos;
    private Position guardedStartPos;
    private Object extraInfo;

    Fold(FoldOperationImpl foldOperationImpl, FoldType foldType, String string, boolean bl, Document document, int n, int n2, int n3, int n4, Object object) throws BadLocationException {
        if (n3 < 0) {
            throw new IllegalArgumentException("startGuardedLength=" + n3 + " < 0");
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("endGuardedLength=" + n4 + " < 0");
        }
        if (n == n2) {
            throw new IllegalArgumentException("startOffset == endOffset == " + n);
        }
        if (n2 - n < n3 + n4) {
            throw new IllegalArgumentException("(endOffset=" + n2 + " - startOffset=" + n + ") < " + "(startGuardedLength=" + n3 + " + endGuardedLength=" + n4 + ")");
        }
        this.operation = foldOperationImpl;
        this.type = foldType;
        this.collapsed = bl;
        this.description = string;
        this.startPos = document.createPosition(n);
        this.endPos = document.createPosition(n2);
        this.startGuardedLength = n3;
        this.endGuardedLength = n4;
        this.extraInfo = object;
        this.updateGuardedStartPos(document, n);
        this.updateGuardedEndPos(document, n2);
    }

    public FoldType getType() {
        return this.type;
    }

    public Fold getParent() {
        return this.parent;
    }

    void setParent(Fold fold) {
        if (this.isRootFold()) {
            throw new IllegalArgumentException("Cannot set parent on root");
        }
        this.parent = fold;
    }

    public FoldHierarchy getHierarchy() {
        return this.operation.getHierarchy();
    }

    FoldOperationImpl getOperation() {
        return this.operation;
    }

    boolean isRootFold() {
        return this.operation.getManager() == null;
    }

    public int getStartOffset() {
        return this.isRootFold() ? 0 : this.startPos.getOffset();
    }

    void setStartOffset(Document document, int n) throws BadLocationException {
        if (this.isRootFold()) {
            throw new IllegalStateException("Cannot set endOffset of root fold");
        }
        this.startPos = document.createPosition(n);
        this.updateGuardedStartPos(document, n);
    }

    public int getEndOffset() {
        return this.isRootFold() ? this.operation.getHierarchy().getComponent().getDocument().getLength() : this.endPos.getOffset();
    }

    void setEndOffset(Document document, int n) throws BadLocationException {
        if (this.isRootFold()) {
            throw new IllegalStateException("Cannot set endOffset of root fold");
        }
        this.endPos = document.createPosition(n);
        this.updateGuardedEndPos(document, n);
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    void setCollapsed(boolean bl) {
        if (this.isRootFold()) {
            throw new IllegalStateException("Cannot set collapsed flag on root fold.");
        }
        this.collapsed = bl;
    }

    public String getDescription() {
        return this.description != null ? this.description : DEFAULT_DESCRIPTION;
    }

    void setDescription(String string) {
        this.description = string;
    }

    public int getFoldCount() {
        return this.children != null ? this.children.getFoldCount() : 0;
    }

    public Fold getFold(int n) {
        if (this.children != null) {
            return this.children.getFold(n);
        }
        throw new IndexOutOfBoundsException("index=" + n + " but no children exist.");
    }

    Fold[] foldsToArray(int n, int n2) {
        if (this.children != null) {
            return this.children.foldsToArray(n, n2);
        }
        if (n2 == 0) {
            return EMPTY_FOLD_ARRAY;
        }
        throw new IndexOutOfBoundsException("No children but count=" + n2);
    }

    void extractToChildren(int n, int n2, Fold fold) {
        if (fold.getFoldCount() != 0 || fold.getParent() != null) {
            throw new IllegalStateException();
        }
        if (n2 != 0) {
            fold.setChildren(this.children.extractToChildren(n, n2, fold));
        } else {
            if (this.children == null) {
                this.children = new FoldChildren(this);
            }
            this.children.insert(n, fold);
        }
    }

    Fold replaceByChildren(int n) {
        Fold fold = this.getFold(n);
        FoldChildren foldChildren = fold.getChildren();
        fold.setChildren(null);
        this.children.replaceByChildren(n, foldChildren);
        return fold;
    }

    private FoldChildren getChildren() {
        return this.children;
    }

    private void setChildren(FoldChildren foldChildren) {
        this.children = foldChildren;
    }

    Object getExtraInfo() {
        return this.extraInfo;
    }

    public int getFoldIndex(Fold fold) {
        return this.children != null ? this.children.getFoldIndex(fold) : -1;
    }

    private void updateGuardedStartPos(Document document, int n) throws BadLocationException {
        if (!this.isRootFold()) {
            int n2 = this.isZeroStartGuardedLength() ? n + 1 : n + this.startGuardedLength;
            this.guardedStartPos = document.createPosition(n2);
        }
    }

    private void updateGuardedEndPos(Document document, int n) throws BadLocationException {
        if (!this.isRootFold()) {
            int n2 = this.isZeroEndGuardedLength() ? n - 1 : n - this.endGuardedLength;
            this.guardedEndPos = document.createPosition(n2);
        }
    }

    private boolean isZeroStartGuardedLength() {
        return this.startGuardedLength == 0;
    }

    private boolean isZeroEndGuardedLength() {
        return this.endGuardedLength == 0;
    }

    private int getGuardedStartOffset() {
        return this.isRootFold() ? this.getStartOffset() : this.guardedStartPos.getOffset();
    }

    private int getGuardedEndOffset() {
        return this.isRootFold() ? this.getEndOffset() : this.guardedEndPos.getOffset();
    }

    void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getOffset() + documentEvent.getLength() == this.getGuardedStartOffset()) {
            try {
                this.updateGuardedStartPos(documentEvent.getDocument(), this.getStartOffset());
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
        }
    }

    void removeUpdate(DocumentEvent documentEvent) {
        try {
            if (this.getStartOffset() == this.getGuardedStartOffset()) {
                this.updateGuardedStartPos(documentEvent.getDocument(), this.getStartOffset());
            }
            if (this.getEndOffset() == this.getGuardedEndOffset()) {
                this.updateGuardedEndPos(documentEvent.getDocument(), this.getEndOffset());
            }
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
    }

    boolean isStartDamaged() {
        return !this.isZeroStartGuardedLength() && this.getInnerStartOffset() - this.getStartOffset() != this.startGuardedLength;
    }

    boolean isEndDamaged() {
        return !this.isZeroEndGuardedLength() && this.getEndOffset() - this.getInnerEndOffset() != this.endGuardedLength;
    }

    boolean isExpandNecessary() {
        return this.isZeroStartGuardedLength() && this.getStartOffset() == this.getGuardedStartOffset() || this.isZeroEndGuardedLength() && this.getEndOffset() == this.getGuardedEndOffset();
    }

    private int getInnerStartOffset() {
        return this.isZeroStartGuardedLength() ? this.getStartOffset() : this.getGuardedStartOffset();
    }

    private int getInnerEndOffset() {
        return this.isZeroEndGuardedLength() ? this.getEndOffset() : this.getGuardedEndOffset();
    }

    int getRawIndex() {
        return this.rawIndex;
    }

    void setRawIndex(int n) {
        this.rawIndex = n;
    }

    void updateRawIndex(int n) {
        this.rawIndex += n;
    }

    public String toString() {
        return FoldUtilitiesImpl.foldToString(this) + ", [" + this.getInnerStartOffset() + ", " + this.getInnerEndOffset() + "] {" + this.getGuardedStartOffset() + ", " + this.getGuardedEndOffset() + '}';
    }
}

