/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.GlyphGutter;
import org.netbeans.editor.PopupManager;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakTimerListener;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ToolTipContext;

public class ToolTipSupport
extends MouseAdapter
implements MouseMotionListener,
ActionListener,
PropertyChangeListener,
SettingsChangeListener,
FocusListener {
    public static final String PROP_TOOL_TIP = "toolTip";
    public static final String PROP_TOOL_TIP_TEXT = "toolTipText";
    public static final String PROP_STATUS = "status";
    public static final String PROP_ENABLED = "enabled";
    public static final String PROP_INITIAL_DELAY = "initialDelay";
    public static final String PROP_DISMISS_DELAY = "dismissDelay";
    protected static final String UI_PREFIX = "ToolTip";
    public static final int INITIAL_DELAY = 200;
    public static final int DISMISS_DELAY = 60000;
    public static final int STATUS_HIDDEN = 0;
    public static final int STATUS_VISIBILITY_ENABLED = 1;
    public static final int STATUS_TEXT_VISIBLE = 2;
    public static final int STATUS_COMPONENT_VISIBLE = 3;
    private static final int MOUSE_EXTRA_HEIGHT = 5;
    private ExtEditorUI extEditorUI;
    private JComponent toolTip;
    private String toolTipText;
    private Timer enterTimer;
    private Timer exitTimer;
    private boolean enabled;
    private int status;
    protected MouseEvent lastMouseEvent;
    private PropertyChangeSupport pcs;
    private PopupManager.HorizontalBounds horizontalBounds = PopupManager.ViewPortBounds;
    private PopupManager.Placement placement = PopupManager.AbovePreferred;
    private int verticalAdjustment;
    private int horizontalAdjustment;
    private boolean glyphListenerAdded = false;

    public ToolTipSupport(ExtEditorUI extEditorUI) {
        this.extEditorUI = extEditorUI;
        this.enterTimer = new Timer(200, new WeakTimerListener(this));
        this.enterTimer.setRepeats(false);
        this.exitTimer = new Timer(60000, new WeakTimerListener(this));
        this.exitTimer.setRepeats(false);
        Settings.addSettingsChangeListener(this);
        extEditorUI.addPropertyChangeListener(this);
        this.setEnabled(true);
    }

    public final JComponent getToolTip() {
        if (this.toolTip == null) {
            this.setToolTip(this.createDefaultToolTip());
        }
        return this.toolTip;
    }

    public void setToolTip(JComponent jComponent) {
        this.setToolTip(jComponent, PopupManager.ViewPortBounds, PopupManager.AbovePreferred, ToolTipContext.MOUSE);
    }

    public void setToolTip(JComponent jComponent, ToolTipContext toolTipContext) {
        this.setToolTip(jComponent, PopupManager.ViewPortBounds, PopupManager.AbovePreferred, toolTipContext);
    }

    public void setToolTip(JComponent jComponent, PopupManager.HorizontalBounds horizontalBounds, PopupManager.Placement placement, ToolTipContext toolTipContext) {
        this.setToolTip(jComponent, PopupManager.ViewPortBounds, PopupManager.AbovePreferred, 0, 0, toolTipContext);
    }

    public void setToolTip(JComponent jComponent, PopupManager.HorizontalBounds horizontalBounds, PopupManager.Placement placement, int n, int n2, ToolTipContext toolTipContext) {
        JComponent jComponent2 = this.toolTip;
        this.toolTip = jComponent;
        this.horizontalBounds = horizontalBounds;
        this.placement = placement;
        this.horizontalAdjustment = n;
        this.verticalAdjustment = n2;
        if (this.status >= 1) {
            this.ensureVisibility(toolTipContext);
        }
        this.firePropertyChange(PROP_TOOL_TIP, jComponent2, this.toolTip);
    }

    protected JComponent createDefaultToolTip() {
        return this.createTextToolTip();
    }

    protected JTextArea createTextToolTip() {
        JTextArea jTextArea = new JTextArea(){

            @Override
            public void setSize(int n, int n2) {
                int n3 = this.getDocument().getLength();
                if (n3 > 0) {
                    this.setLineWrap(false);
                    Dimension dimension = this.getPreferredSize();
                    if (n > dimension.width) {
                        n = dimension.width;
                        n2 = n2 >= dimension.height ? dimension.height : -1;
                    } else {
                        this.setLineWrap(true);
                        super.setSize(n, 100000);
                        try {
                            Rectangle rectangle = this.modelToView(n3 - 1);
                            int n4 = rectangle.y + rectangle.height;
                            n2 = n4 < n2 ? n4 : -1;
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                }
                if (n2 >= 0) {
                    super.setSize(n, n2);
                } else {
                    this.putClientProperty(PopupManager.Placement.class, null);
                }
            }
        };
        jTextArea.setActionMap(new ActionMap());
        jTextArea.setInputMap(1, null);
        Font font = UIManager.getFont("ToolTip.font");
        Color color = UIManager.getColor("ToolTip.background");
        Color color2 = UIManager.getColor("ToolTip.foreground");
        if (font != null) {
            jTextArea.setFont(font);
        }
        if (color2 != null) {
            jTextArea.setForeground(color2);
        }
        if (color != null) {
            jTextArea.setBackground(color);
        }
        jTextArea.setOpaque(true);
        jTextArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(jTextArea.getForeground()), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        return jTextArea;
    }

    @Override
    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JComponent jComponent;
        String string = propertyChangeEvent.getPropertyName();
        if ("component".equals(string)) {
            jComponent = (JTextComponent)propertyChangeEvent.getNewValue();
            if (jComponent != null) {
                jComponent.addPropertyChangeListener(this);
                this.disableSwingToolTip(jComponent);
                jComponent.addFocusListener(this);
                if (jComponent.hasFocus()) {
                    this.focusGained(new FocusEvent(jComponent, 1004));
                }
                this.registerMouseListeners((JTextComponent)jComponent);
                GlyphGutter glyphGutter = this.extEditorUI.getGlyphGutter();
                if (glyphGutter != null && !this.glyphListenerAdded) {
                    this.glyphListenerAdded = true;
                    glyphGutter.addMouseListener(this);
                    glyphGutter.addMouseMotionListener(this);
                }
            } else {
                jComponent = (JTextComponent)propertyChangeEvent.getOldValue();
                jComponent.removeFocusListener(this);
                jComponent.removePropertyChangeListener(this);
                this.unregisterMouseListeners((JTextComponent)jComponent);
                GlyphGutter glyphGutter = this.extEditorUI.getGlyphGutter();
                if (glyphGutter != null) {
                    glyphGutter.removeMouseListener(this);
                    glyphGutter.removeMouseMotionListener(this);
                }
                this.setToolTipVisible(false);
            }
        }
        if ("ToolTipText".equals(string)) {
            jComponent = (JComponent)propertyChangeEvent.getSource();
            this.disableSwingToolTip(jComponent);
            this.componentToolTipTextChanged(propertyChangeEvent);
        }
    }

    protected void unregisterMouseListeners(JTextComponent jTextComponent) {
        jTextComponent.removeMouseListener(this);
        jTextComponent.removeMouseMotionListener(this);
    }

    protected void registerMouseListeners(JTextComponent jTextComponent) {
        jTextComponent.addMouseListener(this);
        jTextComponent.addMouseMotionListener(this);
    }

    private void disableSwingToolTip(final JComponent jComponent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ToolTipManager.sharedInstance().unregisterComponent(jComponent);
                GlyphGutter glyphGutter = ToolTipSupport.this.extEditorUI.getGlyphGutter();
                if (glyphGutter != null) {
                    ToolTipManager.sharedInstance().unregisterComponent(glyphGutter);
                }
            }
        });
    }

    protected void updateToolTip() {
        ExtEditorUI extEditorUI = this.extEditorUI;
        if (extEditorUI == null) {
            return;
        }
        JTextComponent jTextComponent = extEditorUI.getComponent();
        if (jTextComponent == null) {
            return;
        }
        if (this.isGlyphGutterMouseEvent(this.lastMouseEvent)) {
            this.setToolTipText(this.extEditorUI.getGlyphGutter().getToolTipText(this.lastMouseEvent));
        } else {
            Action action;
            BaseKit baseKit = Utilities.getKit(jTextComponent);
            if (baseKit != null && (action = baseKit.getActionByName("build-tool-tip")) != null) {
                action.actionPerformed(new ActionEvent(jTextComponent, 0, ""));
            }
        }
    }

    protected void setToolTipVisible(boolean bl) {
        this.setToolTipVisible(bl, null, ToolTipContext.MOUSE);
    }

    protected void setToolTipVisibleByKeyboard(boolean bl, String string) {
        this.setToolTipVisible(bl, string, ToolTipContext.KEYBOARD);
    }

    protected void setToolTipVisible(boolean bl, String string, ToolTipContext toolTipContext) {
        if (!bl) {
            this.enterTimer.stop();
            this.exitTimer.stop();
        }
        if (bl && this.status < 1 || !bl && this.status >= 1) {
            if (bl) {
                if (this.enabled) {
                    this.setStatus(1);
                    toolTipContext.updateToolTip(this, string);
                }
            } else {
                if (this.toolTip != null && this.toolTip.isVisible()) {
                    this.toolTip.setVisible(false);
                    PopupManager popupManager = this.extEditorUI.getPopupManager();
                    if (popupManager != null) {
                        popupManager.uninstall(this.toolTip);
                    }
                }
                this.setStatus(0);
            }
        }
    }

    public boolean isToolTipVisible() {
        return this.status > 1;
    }

    public final int getStatus() {
        return this.status;
    }

    private void setStatus(int n) {
        if (this.status != n) {
            int n2 = this.status;
            this.status = n;
            this.firePropertyChange(PROP_STATUS, new Integer(n2), new Integer(this.status));
        }
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    private static String makeDisplayable(String string, Font font) {
        if (string == null || font == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray = string.toCharArray();
        block7: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\t': {
                    stringBuffer.append(c);
                    continue block7;
                }
                case '\n': {
                    stringBuffer.append(c);
                    continue block7;
                }
                case '\r': {
                    stringBuffer.append(c);
                    continue block7;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block7;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block7;
                }
                default: {
                    if (font == null || font.canDisplay(c)) {
                        stringBuffer.append(c);
                        continue block7;
                    }
                    stringBuffer.append("\\u");
                    String string2 = Integer.toHexString(c);
                    for (int j = 0; j < 4 - string2.length(); ++j) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(string2);
                }
            }
        }
        return stringBuffer.toString();
    }

    public void setToolTipText(String string) {
        this.setToolTipText(string, ToolTipContext.MOUSE);
    }

    void setToolTipText(String string, final ToolTipContext toolTipContext) {
        final String string2 = ToolTipSupport.makeDisplayable(string, UIManager.getFont("ToolTip.font"));
        Utilities.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                String string = ToolTipSupport.this.toolTipText;
                ToolTipSupport.this.toolTipText = string2;
                ToolTipSupport.this.firePropertyChange(ToolTipSupport.PROP_TOOL_TIP_TEXT, string, ToolTipSupport.this.toolTipText);
                if (ToolTipSupport.this.toolTipText != null) {
                    JTextArea jTextArea = ToolTipSupport.this.createTextToolTip();
                    jTextArea.setText(ToolTipSupport.this.toolTipText);
                    ToolTipSupport.this.setToolTip(jTextArea, toolTipContext);
                } else if (ToolTipSupport.this.status == 2) {
                    ToolTipSupport.this.setToolTipVisible(false);
                }
            }
        });
    }

    private void applyToolTipText() {
        JComponent jComponent = this.getToolTip();
        if (jComponent != null) {
            if (jComponent instanceof JLabel) {
                ((JLabel)jComponent).setText(this.toolTipText);
            } else if (jComponent instanceof JTextComponent) {
                ((JTextComponent)jComponent).setText(this.toolTipText);
            } else if (jComponent instanceof JToolTip) {
                ((JToolTip)jComponent).setTipText(this.toolTipText);
            } else {
                try {
                    Method method = jComponent.getClass().getMethod("setText", String.class);
                    if (method != null) {
                        method.invoke((Object)this.toolTip, this.toolTipText);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isGlyphGutterMouseEvent(MouseEvent mouseEvent) {
        return mouseEvent != null && mouseEvent.getSource() == this.extEditorUI.getGlyphGutter();
    }

    private void ensureVisibility(ToolTipContext toolTipContext) {
        JTextComponent jTextComponent = this.extEditorUI.getComponent();
        if (jTextComponent != null) {
            int n = toolTipContext.getModelPosition(jTextComponent, this.getLastMouseEventPoint());
            Rectangle rectangle = null;
            if (n >= 0) {
                try {
                    rectangle = jTextComponent.modelToView(n);
                    if (this.horizontalBounds != PopupManager.ScrollBarBounds) {
                        if (this.placement == PopupManager.AbovePreferred || this.placement == PopupManager.Above) {
                            rectangle.y -= 5;
                            rectangle.height += 10;
                        } else if (this.placement == PopupManager.BelowPreferred || this.placement == PopupManager.Below) {
                            rectangle.y = rectangle.y + rectangle.height + 5 + 1;
                            rectangle.height += 5;
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (rectangle == null) {
                rectangle = new Rectangle(this.getLastMouseEventPoint(), new Dimension(1, 1));
            }
            final PopupManager popupManager = this.extEditorUI.getPopupManager();
            final Rectangle rectangle2 = rectangle;
            if (this.toolTip != null && this.toolTip.isVisible()) {
                this.toolTip.setVisible(false);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ToolTipSupport.this.toolTip != null) {
                        popupManager.install(ToolTipSupport.this.toolTip, rectangle2, ToolTipSupport.this.placement, ToolTipSupport.this.horizontalBounds, ToolTipSupport.this.horizontalAdjustment, ToolTipSupport.this.verticalAdjustment);
                        ToolTipSupport.this.toolTip.setVisible(true);
                    }
                }
            });
        }
        this.exitTimer.restart();
    }

    public String getIdentifierUnderCursor() {
        String string = null;
        if (!this.isGlyphGutterMouseEvent(this.lastMouseEvent)) {
            try {
                JTextComponent jTextComponent = this.extEditorUI.getComponent();
                BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
                Point point = this.getLastMouseEventPoint();
                int n = baseTextUI.viewToModel(jTextComponent, point);
                if (n >= 0) {
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    int n2 = Utilities.getRowEnd(baseDocument, n);
                    Rectangle rectangle = baseTextUI.modelToView(jTextComponent, n2);
                    int n3 = this.extEditorUI.getLineHeight();
                    if (point.x <= rectangle.x && point.y <= rectangle.y + n3) {
                        string = Utilities.getIdentifier(baseDocument, n);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return string;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        if (bl != this.enabled) {
            this.enabled = bl;
            this.firePropertyChange(PROP_ENABLED, bl ? Boolean.FALSE : Boolean.TRUE, bl ? Boolean.TRUE : Boolean.FALSE);
            if (!bl) {
                this.setToolTipVisible(false);
            }
        }
    }

    public int getInitialDelay() {
        return this.enterTimer.getDelay();
    }

    public void setInitialDelay(int n) {
        if (this.enterTimer.getDelay() != n) {
            int n2 = this.enterTimer.getDelay();
            this.enterTimer.setDelay(n);
            this.firePropertyChange(PROP_INITIAL_DELAY, new Integer(n2), new Integer(this.enterTimer.getDelay()));
        }
    }

    public int getDismissDelay() {
        return this.exitTimer.getDelay();
    }

    public void setDismissDelay(int n) {
        if (this.exitTimer.getDelay() != n) {
            int n2 = this.exitTimer.getDelay();
            this.exitTimer.setDelay(n);
            this.firePropertyChange(PROP_DISMISS_DELAY, new Integer(n2), new Integer(this.exitTimer.getDelay()));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.enterTimer) {
            this.setToolTipVisible(true);
        } else if (actionEvent.getSource() == this.exitTimer) {
            this.setToolTipVisible(false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.lastMouseEvent = mouseEvent;
        this.setToolTipVisible(false);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.lastMouseEvent = mouseEvent;
        this.setToolTipVisible(false);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.lastMouseEvent = mouseEvent;
        this.setToolTipVisible(false);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.lastMouseEvent = mouseEvent;
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.lastMouseEvent = mouseEvent;
        if (this.toolTip == null || !this.toolTip.isShowing()) {
            this.setToolTipVisible(false);
        } else {
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, (Component)mouseEvent.getSource());
            Rectangle rectangle = this.toolTip.getBounds();
            Point point2 = this.toolTip.getLocationOnScreen();
            rectangle.x = point2.x;
            rectangle.y = point2.y;
            if (!rectangle.contains(point)) {
                this.setToolTipVisible(false);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.lastMouseEvent = mouseEvent;
        this.setToolTipVisible(false);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.setToolTipVisible(false);
        if (this.enabled) {
            this.enterTimer.restart();
        }
        this.lastMouseEvent = mouseEvent;
    }

    public final MouseEvent getLastMouseEvent() {
        return this.lastMouseEvent;
    }

    private Point getLastMouseEventPoint() {
        Point point = null;
        MouseEvent mouseEvent = this.lastMouseEvent;
        if (mouseEvent != null) {
            JTextComponent jTextComponent;
            point = mouseEvent.getPoint();
            if (mouseEvent.getSource() == this.extEditorUI.getGlyphGutter() && (jTextComponent = this.extEditorUI.getComponent()) != null && jTextComponent.getParent() instanceof JViewport) {
                JViewport jViewport = (JViewport)jTextComponent.getParent();
                point = new Point(jViewport.getViewPosition().x, point.y);
            }
        }
        return point;
    }

    protected void componentToolTipTextChanged(PropertyChangeEvent propertyChangeEvent) {
        JComponent jComponent = (JComponent)propertyChangeEvent.getSource();
        this.setToolTipText(jComponent.getToolTipText());
    }

    private synchronized PropertyChangeSupport getPCS() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPCS().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPCS().removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.getPCS().firePropertyChange(string, object, object2);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        GlyphGutter glyphGutter = this.extEditorUI.getGlyphGutter();
        if (glyphGutter != null && !this.glyphListenerAdded) {
            this.glyphListenerAdded = true;
            glyphGutter.addMouseListener(this);
            glyphGutter.addMouseMotionListener(this);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }
}

