/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.editor.ext.ListCompletionView;
import org.netbeans.editor.ext.java.JCCellRenderer;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCResultItem;
import org.netbeans.editor.ext.java.JavaFastImportPanel;
import org.netbeans.editor.ext.java.JavaSyntaxSupport;

public abstract class JavaFastImport
implements ActionListener {
    public static final int IMPORT_CLASS = 0;
    public static final int IMPORT_PACKAGE = 1;
    public static final int IMPORT_FQN = 2;
    protected JTextComponent target;
    private String exp;
    private JavaFastImportPanel panel;
    private ListCellRenderer cellRenderer;
    private JList resultList;
    private Dialog dialog;
    private JButton[] buttons;
    private int[] block;
    private int importType;

    public JavaFastImport(JTextComponent jTextComponent) {
        Object object;
        this.target = jTextComponent;
        try {
            this.block = Utilities.getIdentifierBlock(jTextComponent, jTextComponent.getCaret().getDot());
            object = jTextComponent.getDocument();
            this.exp = this.block != null ? object.getText(this.block[0], this.block[1] - this.block[0]) : null;
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.importType = this.getPackageImportSetting();
        if (this.exp != null) {
            object = this.exp;
            this.exp = this.exp.trim();
            int n = ((String)object).indexOf(this.exp);
            int n2 = ((String)object).length() - this.exp.length() - n;
            this.block[0] = this.block[0] + n;
            this.block[1] = this.block[1] - n2;
        }
    }

    private int getPackageImportSetting() {
        Class clazz = Utilities.getKitClass(this.target);
        if (clazz != null) {
            return SettingsUtil.getInteger(clazz, "fast-import-selection", ExtSettingsDefaults.defaultFastImportSelection);
        }
        return ExtSettingsDefaults.defaultFastImportSelection;
    }

    public void setDialogVisible(boolean bl) {
        List list = null;
        if (bl) {
            list = this.evaluate();
            if (list == null || list.size() == 0) {
                return;
            }
            this.populate(list);
        }
        if (this.dialog == null) {
            this.dialog = this.createDialog();
        }
        this.getResultList().requestFocus();
        this.dialog.setVisible(bl);
        if (bl) {
            this.getPanel().popupNotify();
        } else {
            this.dialog.dispose();
        }
    }

    protected boolean isAlreadyImported(JCClass jCClass) {
        BaseDocument baseDocument = Utilities.getDocument(this.target);
        if (baseDocument == null) {
            return false;
        }
        JavaSyntaxSupport javaSyntaxSupport = (JavaSyntaxSupport)baseDocument.getSyntaxSupport().get(JavaSyntaxSupport.class);
        if (javaSyntaxSupport == null) {
            return false;
        }
        javaSyntaxSupport.refreshJavaImport();
        return javaSyntaxSupport.isImported(jCClass);
    }

    protected void updateImport(Object object) {
    }

    protected ListCellRenderer createCellRenderer() {
        JCCellRenderer jCCellRenderer = new JCCellRenderer();
        return jCCellRenderer;
    }

    protected JList createResultList() {
        final ListCompletionView listCompletionView = new ListCompletionView(this.getCellRenderer());
        listCompletionView.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    JavaFastImport.this.actionPerformed(new ActionEvent(JavaFastImport.this.getButtons()[0], 0, ""));
                }
            }
        });
        listCompletionView.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JavaFastImport.this.getPanel().setPackageImportEnabled(!JavaFastImport.this.isInnerClass(listCompletionView.getSelectedValue()));
            }
        });
        return listCompletionView;
    }

    protected boolean isInnerClass(Object object) {
        return false;
    }

    private JButton[] getButtons() {
        if (this.buttons == null) {
            this.buttons = new JButton[]{new JButton(LocaleSupport.getString("JFI_import", "Import")), new JButton(LocaleSupport.getString("JFI_cancelButton", "Cancel"))};
            this.buttons[0].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFI_import"));
            this.buttons[1].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFI_cancelButton"));
        }
        return this.buttons;
    }

    private Dialog createDialog() {
        String string = LocaleSupport.getString("JFI_title", "Import Class");
        Dialog dialog = DialogSupport.createDialog(string, this.getPanel(), true, this.getButtons(), false, 0, 1, this);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                Utilities.returnFocus();
            }
        });
        return dialog;
    }

    private JavaFastImportPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JavaFastImportPanel(this, this.importType);
        }
        return this.panel;
    }

    ListCellRenderer getCellRenderer() {
        if (this.cellRenderer == null) {
            this.cellRenderer = this.createCellRenderer();
        }
        return this.cellRenderer;
    }

    JList getResultList() {
        if (this.resultList == null) {
            this.resultList = this.createResultList();
        }
        return this.resultList;
    }

    protected abstract List findClasses(String var1, int var2);

    List evaluate() {
        return this.exp != null && this.exp.length() > 0 ? this.findClasses(this.exp, this.getPanel().getImportType()) : null;
    }

    void populate(List list) {
        if (list != null && this.getResultList() instanceof ListCompletionView) {
            ((ListCompletionView)this.getResultList()).setResult(list);
        }
    }

    protected void setFastImportSettings(int n) {
    }

    protected String getItemFQN(Object object) {
        if (object instanceof JCClass) {
            return ((JCClass)object).getFullName();
        }
        if (object instanceof JCResultItem) {
            return ((JCResultItem)object).getItemText();
        }
        return object.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pasteFQN(String string) {
        block8: {
            try {
                Document document = this.target.getDocument();
                if (document instanceof BaseDocument) {
                    BaseDocument baseDocument = (BaseDocument)document;
                    try {
                        baseDocument.atomicLock();
                        try {
                            baseDocument.remove(this.block[0], this.block[1] - this.block[0]);
                            baseDocument.insertString(this.block[0], string, null);
                            this.target.getCaret().setDot(this.block[0] + string.length());
                            break block8;
                        }
                        finally {
                            baseDocument.atomicUnlock();
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                    break block8;
                }
                document.remove(this.block[0], this.block[1] - this.block[0]);
                document.insertString(this.block[0], string, null);
                this.target.getCaret().setDot(this.block[0] + string.length());
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.buttons != null && object == this.buttons[0]) {
            int n = this.getPanel().getImportType();
            switch (n) {
                case 0: 
                case 1: {
                    int n2 = this.getResultList().getSelectedIndex();
                    if (n2 < 0) break;
                    this.updateImport(this.getResultList().getModel().getElementAt(n2));
                    break;
                }
                case 2: {
                    int n3 = this.getResultList().getSelectedIndex();
                    if (n3 < 0) {
                        return;
                    }
                    Object e = this.getResultList().getModel().getElementAt(n3);
                    String string = this.getItemFQN(e);
                    this.pasteFQN(string);
                }
            }
            this.setFastImportSettings(n);
            this.setDialogVisible(false);
        } else if (this.buttons != null && object == this.buttons[this.buttons.length - 1]) {
            this.setDialogVisible(false);
        }
    }
}

