/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.fold;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.AbstractDocument;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldStateChange;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.modules.editor.fold.ApiPackageAccessor;

public final class FoldUtilitiesImpl {
    private FoldUtilitiesImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void collapseOrExpand(FoldHierarchy foldHierarchy, Collection collection, boolean bl) {
        AbstractDocument abstractDocument = (AbstractDocument)foldHierarchy.getComponent().getDocument();
        abstractDocument.readLock();
        try {
            foldHierarchy.lock();
            try {
                List list = FoldUtilitiesImpl.findRecursive(null, foldHierarchy.getRootFold(), collection);
                if (bl) {
                    foldHierarchy.collapse(list);
                } else {
                    foldHierarchy.expand(list);
                }
            }
            finally {
                foldHierarchy.unlock();
            }
        }
        finally {
            abstractDocument.readUnlock();
        }
    }

    public static int findFoldStartIndex(Fold fold, int n, boolean bl) {
        int n2 = fold.getFoldCount();
        int n3 = 0;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = (n3 + n4) / 2;
            Fold fold2 = fold.getFold(n5);
            int n6 = fold2.getStartOffset();
            if (n6 < n) {
                n3 = n5 + 1;
                continue;
            }
            if (n6 > n) {
                n4 = n5 - 1;
                continue;
            }
            if (bl) {
                --n5;
                while (n5 >= 0 && (fold.getFold(n5).getStartOffset() == n || fold.getFold(n5).getEndOffset() == n)) {
                    --n5;
                }
                ++n5;
            } else {
                ++n5;
                while (n5 < n2 && fold.getFold(n5).getStartOffset() == n) {
                    ++n5;
                }
                --n5;
            }
            return n5;
        }
        return n4;
    }

    public static int findFoldInsertIndex(Fold fold, int n) {
        return FoldUtilitiesImpl.findFoldStartIndex(fold, n, false) + 1;
    }

    public static int findFoldEndIndex(Fold fold, int n) {
        int n2 = fold.getFoldCount();
        int n3 = 0;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = (n3 + n4) / 2;
            Fold fold2 = fold.getFold(n5);
            int n6 = fold2.getEndOffset();
            if (n6 < n) {
                n3 = n5 + 1;
                continue;
            }
            if (n6 > n) {
                n4 = n5 - 1;
                continue;
            }
            ++n5;
            while (n5 < n2 && fold.getFold(n5).getEndOffset() <= n) {
                ++n5;
            }
            return n5;
        }
        return n3;
    }

    public static List childrenAsList(Fold fold, int n, int n2) {
        ArrayList<Fold> arrayList = new ArrayList<Fold>(n2);
        while (--n2 >= 0) {
            arrayList.add(fold.getFold(n));
            ++n;
        }
        return arrayList;
    }

    public static List find(Fold fold, Collection collection) {
        ArrayList<Fold> arrayList = new ArrayList<Fold>();
        int n = fold.getFoldCount();
        for (int i = 0; i < n; ++i) {
            Fold fold2 = fold.getFold(i);
            if (collection != null && !collection.contains(fold2.getType())) continue;
            arrayList.add(fold2);
        }
        return arrayList;
    }

    public static List findRecursive(List arrayList, Fold fold, Collection collection) {
        if (arrayList == null) {
            arrayList = new ArrayList<Fold>();
        }
        int n = fold.getFoldCount();
        for (int i = 0; i < n; ++i) {
            Fold fold2 = fold.getFold(i);
            if (collection == null || collection.contains(fold2.getType())) {
                arrayList.add(fold2);
            }
            FoldUtilitiesImpl.findRecursive(arrayList, fold2, collection);
        }
        return arrayList;
    }

    public static Fold findOffsetFold(FoldHierarchy foldHierarchy, int n) {
        Fold fold;
        int n2 = Integer.MAX_VALUE;
        Fold fold2 = fold = foldHierarchy.getRootFold();
        boolean bl = true;
        while (bl) {
            int n3 = FoldUtilitiesImpl.findFoldStartIndex(fold2, n, false);
            if (n3 >= 0) {
                Fold fold3 = fold2.getFold(n3);
                int n4 = fold3.getStartOffset();
                int n5 = fold3.getEndOffset();
                if (n4 <= n && n <= n5) {
                    fold2 = fold3;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = false;
        }
        return fold2 != fold ? fold2 : null;
    }

    public static Fold findNearestFold(FoldHierarchy foldHierarchy, int n, int n2) {
        Fold fold = null;
        int n3 = Integer.MAX_VALUE;
        Fold fold2 = foldHierarchy.getRootFold();
        boolean bl = true;
        while (bl) {
            int n4 = fold2.getFoldCount();
            int n5 = FoldUtilitiesImpl.findFoldEndIndex(fold2, n);
            if (n5 < n4) {
                int n6;
                Fold fold3;
                Fold fold4 = fold2.getFold(n5);
                int n7 = fold4.getStartOffset();
                if (n7 >= n2) break;
                if (n7 < n) {
                    fold3 = ++n5 < n4 ? fold2.getFold(n5) : null;
                    fold2 = fold4;
                } else {
                    fold3 = fold4;
                    bl = false;
                }
                if (fold3 == null || (n6 = fold3.getStartOffset() - n) >= n3) continue;
                n3 = n6;
                fold = fold3;
                continue;
            }
            bl = false;
        }
        return fold;
    }

    public static Fold findFirstCollapsedFold(FoldHierarchy foldHierarchy, int n, int n2) {
        Fold fold = foldHierarchy.getRootFold();
        Fold fold2 = null;
        int n3 = 0;
        while (true) {
            int n4;
            if ((n4 = FoldUtilitiesImpl.findFoldEndIndex(fold, n)) >= fold.getFoldCount()) {
                if (fold2 != null) {
                    return FoldUtilitiesImpl.findCollapsedRec(fold2, n3 + 1, n2);
                }
                return null;
            }
            Fold fold3 = fold.getFold(n4);
            if (fold3.isCollapsed()) {
                return fold3;
            }
            if (fold3.getStartOffset() >= n) {
                return FoldUtilitiesImpl.findCollapsedRec(fold, n4, n2);
            }
            fold2 = fold;
            n3 = n4;
            fold = fold3;
        }
    }

    public static Iterator collapsedFoldIterator(FoldHierarchy foldHierarchy, int n, int n2) {
        return new CollapsedFoldIterator(FoldUtilitiesImpl.findFirstCollapsedFold(foldHierarchy, n, n2), n2);
    }

    public static Fold findNextCollapsedFold(Fold fold, int n) {
        if (FoldUtilities.isRootFold(fold)) {
            return FoldUtilitiesImpl.findCollapsedRec(fold, 0, n);
        }
        Fold fold2 = fold.getParent();
        return FoldUtilitiesImpl.findCollapsedRec(fold2, fold2.getFoldIndex(fold) + 1, n);
    }

    private static Fold findCollapsedRec(Fold fold, int n, int n2) {
        return FoldUtilitiesImpl.findCollapsedRec(fold, n, n2, true);
    }

    private static Fold findCollapsedRec(Fold fold, int n, int n2, boolean bl) {
        Fold fold2;
        if (fold.getStartOffset() > n2) {
            return null;
        }
        int n3 = fold.getFoldCount();
        while (n < n3) {
            fold2 = fold.getFold(n);
            if (fold2.isCollapsed()) {
                return fold2;
            }
            Fold fold3 = FoldUtilitiesImpl.findCollapsedRec(fold2, 0, n2, false);
            if (fold3 != null) {
                return fold3;
            }
            ++n;
        }
        if (FoldUtilities.isRootFold(fold) || !bl) {
            return null;
        }
        fold2 = fold.getParent();
        return FoldUtilitiesImpl.findCollapsedRec(fold2, fold2.getFoldIndex(fold) + 1, n2, true);
    }

    public static String foldToString(Fold fold) {
        return "[" + fold.getType() + "] " + (fold.isCollapsed() ? "C" : "E") + (FoldUtilities.isRootFold(fold) ? "" : Integer.toString(ApiPackageAccessor.get().foldGetOperation(fold).getPriority())) + " <" + fold.getStartOffset() + "," + fold.getEndOffset() + ">" + (FoldUtilities.isRootFold(fold) ? "" : ", desc='" + fold.getDescription() + "'");
    }

    public static void appendSpaces(StringBuffer stringBuffer, int n) {
        while (--n >= 0) {
            stringBuffer.append(' ');
        }
    }

    public static String foldToStringChildren(Fold fold, int n) {
        n += 4;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(fold);
        stringBuffer.append('\n');
        int n2 = fold.getFoldCount();
        for (int i = 0; i < n2; ++i) {
            FoldUtilitiesImpl.appendSpaces(stringBuffer, n);
            stringBuffer.append('[');
            stringBuffer.append(i);
            stringBuffer.append("]: ");
            stringBuffer.append(FoldUtilitiesImpl.foldToStringChildren(fold.getFold(i), n));
        }
        return stringBuffer.toString();
    }

    public static String foldHierarchyEventToString(FoldHierarchyEvent foldHierarchyEvent) {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = foldHierarchyEvent.getRemovedFoldCount();
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer.append("R[");
            stringBuffer.append(n2);
            stringBuffer.append("]: ");
            stringBuffer.append(foldHierarchyEvent.getRemovedFold(n2));
            stringBuffer.append('\n');
        }
        n2 = foldHierarchyEvent.getAddedFoldCount();
        for (n = 0; n < n2; ++n) {
            stringBuffer.append("A[");
            stringBuffer.append(n);
            stringBuffer.append("]: ");
            stringBuffer.append(foldHierarchyEvent.getAddedFold(n));
            stringBuffer.append('\n');
        }
        n = foldHierarchyEvent.getFoldStateChangeCount();
        for (int i = 0; i < n; ++i) {
            FoldStateChange foldStateChange = foldHierarchyEvent.getFoldStateChange(i);
            stringBuffer.append("SC[");
            stringBuffer.append(i);
            stringBuffer.append("]: ");
            stringBuffer.append(foldStateChange);
            stringBuffer.append('\n');
        }
        if (n == 0) {
            stringBuffer.append("No FoldStateChange\n");
        }
        stringBuffer.append("affected: <");
        stringBuffer.append(foldHierarchyEvent.getAffectedStartOffset());
        stringBuffer.append(",");
        stringBuffer.append(foldHierarchyEvent.getAffectedEndOffset());
        stringBuffer.append(">\n");
        return stringBuffer.toString();
    }

    public static String foldStateChangeToString(FoldStateChange foldStateChange) {
        StringBuffer stringBuffer = new StringBuffer();
        if (foldStateChange.isCollapsedChanged()) {
            stringBuffer.append("C");
        }
        if (foldStateChange.isDescriptionChanged()) {
            stringBuffer.append("D");
        }
        if (foldStateChange.isEndOffsetChanged()) {
            stringBuffer.append("E");
        }
        stringBuffer.append(" fold=");
        stringBuffer.append(foldStateChange.getFold());
        return stringBuffer.toString();
    }

    private static final class CollapsedFoldIterator
    implements Iterator {
        private Fold nextFold;
        private int endOffset;

        public CollapsedFoldIterator(Fold fold, int n) {
            this.nextFold = fold;
            this.endOffset = n;
        }

        @Override
        public boolean hasNext() {
            return this.nextFold != null;
        }

        public Object next() {
            Fold fold = this.nextFold;
            this.nextFold = FoldUtilitiesImpl.findNextCollapsedFold(this.nextFold, this.endOffset);
            return fold;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

