/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.hadoop.io.Writable;

public class MWArrayWritable
implements Writable {
    private static short TYPE_NOTSUPPORTED = 0;
    private static short JAVA_STRING = 1;
    private static short JAVA_LONG = (short)2;
    private static short JAVA_INT = (short)3;
    private static short JAVA_DOUBLE = (short)4;
    private static short JAVA_CHAR = (short)5;
    private static short JAVA_BYTE = (short)6;
    private static short JAVA_BOOLEAN = (short)7;
    private static short JAVA_FLOAT = (short)8;
    private static short JAVA_SHORT = (short)9;
    private static short num_types = (short)9;
    private short type = TYPE_NOTSUPPORTED;
    private Object instance = null;
    private int length = -1;

    public MWArrayWritable() {
    }

    public MWArrayWritable(Class<?> componentType) {
        this.setType(componentType);
    }

    public MWArrayWritable(Object value) {
        this.set(value);
    }

    private static void checkArray(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("null value not allowed");
        }
        if (!value.getClass().isArray()) {
            throw new IllegalArgumentException("non-array value of class " + value.getClass() + " not allowed");
        }
    }

    private void setType(Class<?> theClass) {
        if (theClass.equals(String.class)) {
            this.type = JAVA_STRING;
        } else if (theClass.equals(Long.TYPE)) {
            this.type = JAVA_LONG;
        } else if (theClass.equals(Integer.TYPE)) {
            this.type = JAVA_INT;
        } else if (theClass.equals(Double.TYPE)) {
            this.type = JAVA_DOUBLE;
        } else if (theClass.equals(Character.TYPE)) {
            this.type = JAVA_CHAR;
        } else if (theClass.equals(Byte.TYPE)) {
            this.type = JAVA_BYTE;
        } else if (theClass.equals(Boolean.TYPE)) {
            this.type = JAVA_BOOLEAN;
        } else if (theClass.equals(Float.TYPE)) {
            this.type = JAVA_FLOAT;
        } else if (theClass.equals(Short.TYPE)) {
            this.type = JAVA_SHORT;
        } else {
            throw new IllegalArgumentException("The array class type " + theClass.getName() + " not supported by MWArrayWritable");
        }
    }

    public Object get() {
        return this.instance;
    }

    public void set(Object value) {
        MWArrayWritable.checkArray(value);
        Class<?> componentType = value.getClass().getComponentType();
        this.setType(componentType);
        this.instance = value;
        this.length = Array.getLength(this.instance);
    }

    public void write(DataOutput out) throws IOException {
        out.writeShort(this.type);
        out.writeInt(this.length);
        if (this.type == JAVA_STRING) {
            this.writeStringArray(out);
        } else if (this.type == JAVA_LONG) {
            this.writeLongArray(out);
        } else if (this.type == JAVA_INT) {
            this.writeIntArray(out);
        } else if (this.type == JAVA_DOUBLE) {
            this.writeDoubleArray(out);
        } else if (this.type == JAVA_BYTE) {
            this.writeByteArray(out);
        } else if (this.type == JAVA_CHAR) {
            this.writeCharArray(out);
        } else if (this.type == JAVA_BOOLEAN) {
            this.writeBooleanArray(out);
        } else if (this.type == JAVA_FLOAT) {
            this.writeFloatArray(out);
        } else if (this.type == JAVA_SHORT) {
            this.writeShortArray(out);
        } else {
            throw new IOException("Component type " + this.type + " is set as the output type, but no encoding is implemented " + "for this type (needs to be between 1 and " + num_types + ", inclusive).");
        }
    }

    public void readFields(DataInput in) throws IOException {
        short mytype = in.readShort();
        if (mytype < 1 || mytype > num_types) {
            throw new IOException("encoded array component type " + mytype + "is not a candidate primitive type (needs to be 0-" + num_types + "7)");
        }
        int mylength = in.readInt();
        if (mylength < 0) {
            throw new IOException("encoded array length is negative " + mylength);
        }
        this.type = mytype;
        this.length = mylength;
        if (this.type == JAVA_STRING) {
            this.instance = new String[this.length];
            this.readStringArray(in);
        } else if (this.type == JAVA_LONG) {
            this.instance = new long[this.length];
            this.readLongArray(in);
        } else if (this.type == JAVA_INT) {
            this.instance = new int[this.length];
            this.readIntArray(in);
        } else if (this.type == JAVA_DOUBLE) {
            this.instance = new double[this.length];
            this.readDoubleArray(in);
        } else if (this.type == JAVA_BYTE) {
            this.instance = new byte[this.length];
            this.readByteArray(in);
        } else if (this.type == JAVA_CHAR) {
            this.instance = new char[this.length];
            this.readCharArray(in);
        } else if (this.type == JAVA_BOOLEAN) {
            this.instance = new boolean[this.length];
            this.readBooleanArray(in);
        } else if (this.type == JAVA_FLOAT) {
            this.instance = new float[this.length];
            this.readFloatArray(in);
        } else if (this.type == JAVA_SHORT) {
            this.instance = new short[this.length];
            this.readShortArray(in);
        } else {
            throw new IOException("Encoded type " + this.type + " is not implemented (needs to be 0-" + num_types + "7).");
        }
    }

    private void writeStringArray(DataOutput out) throws IOException {
        String[] v = (String[])this.instance;
        for (int i = 0; i < this.length; ++i) {
            out.writeUTF(v[i]);
        }
    }

    private void writeBooleanArray(DataOutput out) throws IOException {
        boolean[] v = (boolean[])this.instance;
        for (int i = 0; i < this.length; ++i) {
            out.writeBoolean(v[i]);
        }
    }

    private void writeCharArray(DataOutput out) throws IOException {
        char[] v = (char[])this.instance;
        for (int i = 0; i < this.length; ++i) {
            out.writeChar(v[i]);
        }
    }

    private void writeByteArray(DataOutput out) throws IOException {
        out.write((byte[])this.instance, 0, this.length);
    }

    private void writeIntArray(DataOutput out) throws IOException {
        int[] v = (int[])this.instance;
        for (int i = 0; i < this.length; ++i) {
            out.writeInt(v[i]);
        }
    }

    private void writeLongArray(DataOutput out) throws IOException {
        long[] v = (long[])this.instance;
        for (int i = 0; i < this.length; ++i) {
            out.writeLong(v[i]);
        }
    }

    private void writeFloatArray(DataOutput out) throws IOException {
        float[] v = (float[])this.instance;
        for (int i = 0; i < this.length; ++i) {
            out.writeFloat(v[i]);
        }
    }

    private void writeShortArray(DataOutput out) throws IOException {
        short[] v = (short[])this.instance;
        for (int i = 0; i < this.length; ++i) {
            out.writeShort(v[i]);
        }
    }

    private void writeDoubleArray(DataOutput out) throws IOException {
        double[] v = (double[])this.instance;
        for (int i = 0; i < this.length; ++i) {
            out.writeDouble(v[i]);
        }
    }

    private void readStringArray(DataInput in) throws IOException {
        String[] v = (String[])this.instance;
        for (int i = 0; i < this.length; ++i) {
            v[i] = in.readUTF();
        }
    }

    private void readBooleanArray(DataInput in) throws IOException {
        boolean[] v = (boolean[])this.instance;
        for (int i = 0; i < this.length; ++i) {
            v[i] = in.readBoolean();
        }
    }

    private void readCharArray(DataInput in) throws IOException {
        char[] v = (char[])this.instance;
        for (int i = 0; i < this.length; ++i) {
            v[i] = in.readChar();
        }
    }

    private void readByteArray(DataInput in) throws IOException {
        in.readFully((byte[])this.instance, 0, this.length);
    }

    private void readIntArray(DataInput in) throws IOException {
        int[] v = (int[])this.instance;
        for (int i = 0; i < this.length; ++i) {
            v[i] = in.readInt();
        }
    }

    private void readLongArray(DataInput in) throws IOException {
        long[] v = (long[])this.instance;
        for (int i = 0; i < this.length; ++i) {
            v[i] = in.readLong();
        }
    }

    private void readFloatArray(DataInput in) throws IOException {
        float[] v = (float[])this.instance;
        for (int i = 0; i < this.length; ++i) {
            v[i] = in.readFloat();
        }
    }

    private void readDoubleArray(DataInput in) throws IOException {
        double[] v = (double[])this.instance;
        for (int i = 0; i < this.length; ++i) {
            v[i] = in.readDouble();
        }
    }

    private void readShortArray(DataInput in) throws IOException {
        short[] v = (short[])this.instance;
        for (int i = 0; i < this.length; ++i) {
            v[i] = in.readShort();
        }
    }

    public String toString() {
        String out = null;
        if (this.instance != null && this.length > 0) {
            if (this.type == JAVA_STRING) {
                String[] objs = (String[])this.instance;
                out = "[" + objs[0];
                for (int i = 1; i < this.length; ++i) {
                    out = out + "," + objs[i];
                }
                out = out + "]";
            } else if (this.type == JAVA_LONG) {
                out = Arrays.toString((long[])this.instance);
            } else if (this.type == JAVA_INT) {
                out = Arrays.toString((int[])this.instance);
            } else if (this.type == JAVA_DOUBLE) {
                out = Arrays.toString((double[])this.instance);
            } else if (this.type == JAVA_BYTE) {
                out = Arrays.toString((byte[])this.instance);
            } else if (this.type == JAVA_CHAR) {
                out = Arrays.toString((char[])this.instance);
            } else if (this.type == JAVA_BOOLEAN) {
                out = Arrays.toString((boolean[])this.instance);
            } else if (this.type == JAVA_FLOAT) {
                out = Arrays.toString((float[])this.instance);
            } else if (this.type == JAVA_SHORT) {
                out = Arrays.toString((short[])this.instance);
            }
        }
        return out;
    }
}

