/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder.caching;

import com.mathworks.toolbox.javabuilder.caching.BidirectionalHashMap;
import com.mathworks.toolbox.javabuilder.caching.BidirectionalMap;
import com.mathworks.toolbox.javabuilder.caching.Cache;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public final class SoftReferenceCache<K, V>
implements Cache<K, V> {
    private BidirectionalMap<K, Reference<? extends Future<V>>> fCache = new BidirectionalHashMap<K, Reference<? extends Future<V>>>();
    private ReferenceQueue<Future<V>> fQueue = new ReferenceQueue();

    private synchronized void removeStaleValues() {
        Reference<Future<V>> reference = this.fQueue.poll();
        while (reference != null) {
            this.fCache.removeValue(reference);
            reference = this.fQueue.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<V> get(K k, Callable<V> callable) throws InterruptedException, ExecutionException {
        FutureTask<V> futureTask = null;
        FutureTask<V> futureTask2 = null;
        SoftReferenceCache softReferenceCache = this;
        synchronized (softReferenceCache) {
            this.removeStaleValues();
            SoftReference<Future<V>> softReference = (SoftReference<Future<V>>)this.fCache.get(k);
            if (null != softReference) {
                futureTask = (FutureTask<V>)((Reference)softReference).get();
            }
            if (null == futureTask) {
                futureTask = futureTask2 = new FutureTask<V>(callable);
                softReference = new SoftReference<Future<V>>(futureTask, this.fQueue);
                this.fCache.put(k, softReference);
            }
            this.removeStaleValues();
        }
        if (null != futureTask2) {
            futureTask2.run();
        }
        return futureTask;
    }
}

