/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.HWndProvider;
import com.mathworks.util.Log;
import com.mathworks.util.NativeJavaSwitch;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.peer.ComponentPeer;
import java.io.File;
import java.io.FileDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.Nullable;

public class NativeJava {
    private static boolean sNativeLibraryExists = false;
    private static Map<Long, Window> sWindowReferenceTable = new Hashtable<Long, Window>(5);
    private static String sWinProfileDir = null;
    private static final int DEFAULT_CARET_BLINKRATE = 500;
    public static final Object[] EMPTY = new Object[0];

    private NativeJava() {
    }

    public static boolean nativeLibraryExists() {
        return sNativeLibraryExists;
    }

    public static String getSystemCharEncoding() {
        return NativeJava.nativeGetCharEncoding();
    }

    private static native String nativeGetCharEncoding();

    public static String getNormalizedWindowsPath(File file) {
        char[] cArray = file.getAbsolutePath().toCharArray();
        int n = cArray.length;
        char[] cArray2 = new char[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (i > 1 && c == '\\' && cArray[i - 1] == '\\') continue;
            cArray2[n2++] = c;
        }
        return new String(cArray2, 0, n2);
    }

    public static boolean canWrite(File file) {
        if (PlatformInfo.isWindows()) {
            File file2;
            for (file2 = file; file2 != null && !file2.exists(); file2 = file2.getParentFile()) {
            }
            if (file2 == null) {
                throw new IllegalArgumentException("canWrite shouldn't be called for a file that has no existing parents: " + file);
            }
            return NativeJava.canWriteAccordingToWindows(NativeJava.getNormalizedWindowsPath(file2));
        }
        return file.canWrite();
    }

    public static native boolean checkWindowsHiddenFilePreference();

    private static native boolean canWriteAccordingToWindows(String var0);

    private static native void tellJavaVersion(boolean var0);

    public static long getHWnd(Frame frame) {
        return NativeJava.getHWnd(frame, "sun.awt.windows.WFramePeer");
    }

    public static long getHWnd(Dialog dialog) {
        return NativeJava.getHWnd(dialog, "sun.awt.windows.WDialogPeer");
    }

    public static long getHWnd(Window window) {
        return NativeJava.getHWnd(window, "sun.awt.windows.WWindowPeer");
    }

    private static long getHWnd(Window window, String string) {
        Validate.notNull((Object)window, (String)"'window' cannot be null");
        long l = 0L;
        ComponentPeer componentPeer = window.getPeer();
        if (PlatformInfo.isWindows() && componentPeer != null && componentPeer.getClass().getName().equals(string)) {
            try {
                Method method = componentPeer.getClass().getMethod("getHWnd", new Class[0]);
                l = (Long)method.invoke((Object)componentPeer, new Object[0]);
            }
            catch (Exception exception) {
                Log.logException(exception);
            }
        }
        return l;
    }

    public static native long hWndFromTitle(String var0);

    public static native String getFileTypeDescription(String var0, boolean var1);

    public static native long getFileIconIndex(String var0, boolean var1, boolean var2);

    public static native boolean getFileIcon(String var0, boolean var1, boolean var2, int[] var3);

    public static native boolean getNonLockingInputHandle(String var0, FileDescriptor var1);

    public static native boolean listFiles(String var0, AsyncReceiver<StatEntry> var1);

    public static native boolean findFilesWindows(String var0, String var1, boolean var2, AsyncReceiver<StatEntry> var3);

    public static native void makeExecutable(String var0);

    public static native File resolveMappedDriveToUnc(String var0);

    public static native File createShortcutOrLink(String var0, String var1);

    public static native StatEntry getStat(String var0);

    public static long hWndFromWindow(Window window) {
        if (!PlatformInfo.isWindows()) {
            throw new IllegalStateException("This method may be called only on Windows.");
        }
        if (window == null) {
            throw new IllegalArgumentException();
        }
        if (window instanceof HWndProvider) {
            return ((HWndProvider)((Object)window)).getHWnd();
        }
        return 0L;
    }

    public static long hWndFromComponent(Component component) {
        if (!PlatformInfo.isWindows()) {
            throw new IllegalStateException("This method may be called only on Windows.");
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (!(component instanceof Window)) {
            component = SwingUtilities.windowForComponent(component);
        }
        if (component instanceof Window) {
            return NativeJava.hWndFromWindow((Window)component);
        }
        return 0L;
    }

    private static native long getNSWindowFromComponent(Object var0);

    public static long getNativeWindowFromComponent(Component component) {
        if (component == null) {
            return 0L;
        }
        if (PlatformInfo.isWindows()) {
            return NativeJava.hWndFromComponent(component);
        }
        if (PlatformInfo.isMacintosh()) {
            Component component2 = SwingUtilities.getRoot(component);
            return NativeJava.getNSWindowFromComponent(component2);
        }
        throw new IllegalStateException("This method may be called only on Windows or Mac");
    }

    public static native boolean hWndIsEnabled(long var0);

    public static native boolean isThisProcessInForeground(long var0);

    public static native int drawMenuBar(long var0);

    public static native long getMenuBar(long var0);

    public static native long getSubmenu(long var0, int var2);

    public static native int setMenuItemLabel(long var0, int var2, String var3);

    public static native Object showNativeFileDialogMulti(long var0, boolean var2, String var3, String var4, String var5, String var6, boolean var7, boolean var8, String var9, int var10);

    public static native void changeFileAttribute(String var0, String var1);

    public static native boolean setPermissions(String var0, long var1);

    public static native void shellExecuteExplore(String var0);

    private static native void AttachThreadInput();

    public static void attachThreadInput() {
        if (PlatformInfo.isWindows()) {
            NativeJava.AttachThreadInput();
        }
    }

    private static native void DetachThreadInput();

    public static void detachThreadInput() {
        if (PlatformInfo.isWindows()) {
            NativeJava.DetachThreadInput();
        }
    }

    public static native int recycleFile(long var0, String var2);

    public static native boolean trashFile(String var0);

    public static native String followIfMacAlias(String var0);

    public static String getAcrobatPath() {
        if (!PlatformInfo.isWindows()) {
            throw new IllegalStateException("This method may be called only on Windows.");
        }
        return NativeJava.GetAcrobatPath();
    }

    private static native String GetAcrobatPath();

    public static native String toAbsolutePath(String var0);

    private static native int GetSystemCaretBlinkRate();

    public static int getCaretBlinkRate() {
        int n = 500;
        if (sNativeLibraryExists && PlatformInfo.isWindows()) {
            n = NativeJava.GetSystemCaretBlinkRate();
            if (n < 0) {
                n = 500;
            }
        } else {
            Object object = Toolkit.getDefaultToolkit().getDesktopProperty("awt.cursorBlinkRate");
            if (object instanceof Integer) {
                n = (Integer)object;
            }
        }
        return n;
    }

    private static void addToWindowReferenceTable(Window window, long l) {
        sWindowReferenceTable.put(l, window);
    }

    public static Window windowReferenceFromHWND(long l) {
        NativeJava.checkHWnd(l);
        return sWindowReferenceTable.get(l);
    }

    private static native void nativeEnableFrameEvents(Window var0, long var1);

    private static native void nativeDisableFrameEvents(@Nullable Window var0, long var1);

    private static native void nativeEnableDialogEvents(Window var0, long var1, boolean var3);

    private static native void SetNextModalParent(long var0);

    public static void setNextModalParent(long l) {
        if (sNativeLibraryExists && PlatformInfo.getPlatform() == 1) {
            NativeJava.SetNextModalParent(l);
        }
    }

    public static void enableNativeEvents(Window window, long l) {
        if (sNativeLibraryExists && PlatformInfo.isWindows()) {
            NativeJava.checkHWnd(l);
            NativeJava.addToWindowReferenceTable(window, l);
            NativeJava.nativeEnableFrameEvents(window, l);
        }
    }

    public static void enableNativeDialogEvents(Window window, long l) {
        NativeJava.enableNativeDialogEvents(window, l, true);
    }

    public static void enableNativeDialogEvents(Window window, long l, boolean bl) {
        if (sNativeLibraryExists && PlatformInfo.isWindows()) {
            NativeJava.checkHWnd(l);
            NativeJava.addToWindowReferenceTable(window, l);
            NativeJava.nativeEnableDialogEvents(window, l, bl);
        }
    }

    public static void disableNativeEvents(long l) {
        if (sNativeLibraryExists && PlatformInfo.isWindows()) {
            NativeJava.checkHWnd(l);
            sWindowReferenceTable.remove(l);
            NativeJava.nativeDisableFrameEvents(null, l);
        }
    }

    public static synchronized String getWinProfileDir() {
        if (sWinProfileDir == null) {
            if (!PlatformInfo.isWindows()) {
                throw new IllegalStateException("This method may be called only on Windows.");
            }
            sWinProfileDir = NativeJava.GetWinProfileDir();
        }
        return sWinProfileDir;
    }

    private static native long nativeGetLastModification(String var0);

    public static long getLastModification(File file) {
        if (PlatformInfo.isWindows()) {
            return NativeJava.nativeGetLastModification(file.getName());
        }
        return file.lastModified();
    }

    private static native String GetWinProfileDir();

    private static native boolean isMinimized(long var0);

    public static boolean isMinimized(Window window) {
        boolean bl = false;
        if (PlatformInfo.isWindows()) {
            if (sNativeLibraryExists) {
                try {
                    bl = NativeJava.isMinimized(NativeJava.hWndFromWindow(window));
                }
                catch (IllegalStateException illegalStateException) {}
            }
        } else if (PlatformInfo.isMacintosh() && window instanceof Frame) {
            try {
                Class<?>[] classArray = null;
                Field field = Frame.class.getField("ICONIFIED");
                Method method = Frame.class.getMethod("getState", classArray);
                if (method != null) {
                    Object[] objectArray = EMPTY;
                    Integer n = (Integer)method.invoke((Object)window, objectArray);
                    bl = n.intValue() == field.getInt(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    private static native boolean isMaximized(long var0);

    public static boolean isMaximized(Window window) {
        boolean bl = false;
        if (PlatformInfo.isWindows() && sNativeLibraryExists) {
            try {
                bl = NativeJava.isMaximized(NativeJava.hWndFromWindow(window));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return bl;
    }

    private static native void minimize(long var0);

    private static native void maximize(long var0);

    private static native void restore(long var0);

    private static native void SetFocus(long var0);

    private static native String GetWindowTitle(long var0);

    public static void setfocus(long l) {
        if (sNativeLibraryExists) {
            NativeJava.SetFocus(l);
        }
    }

    public static String getWindowTitle(long l) {
        String string = "";
        if (PlatformInfo.isWindows() && sNativeLibraryExists) {
            string = NativeJava.GetWindowTitle(l);
        }
        return string;
    }

    public static void setMinimized(long l, boolean bl) {
        if (PlatformInfo.isWindows() && sNativeLibraryExists) {
            if (bl) {
                NativeJava.minimize(l);
            } else if (NativeJava.isMinimized(l)) {
                NativeJava.restore(l);
            }
        }
    }

    public static void setMinimized(Window window, boolean bl) {
        if (PlatformInfo.isWindows()) {
            if (sNativeLibraryExists) {
                long l;
                Dimension dimension = NativeJava.getRestoredSize(window);
                Point point = NativeJava.getRestoredLocation(window);
                try {
                    l = NativeJava.hWndFromWindow(window);
                }
                catch (IllegalStateException illegalStateException) {
                    window.addNotify();
                    window.setVisible(false);
                    l = NativeJava.hWndFromWindow(window);
                }
                assert (l != 0L);
                NativeJava.setMinimized(NativeJava.hWndFromWindow(window), bl);
                NativeJava.setRestoredSize(window, dimension.width, dimension.height);
                NativeJava.setRestoredLocation(window, point.x, point.y);
            }
        } else if (PlatformInfo.isMacintosh() && window instanceof Frame) {
            try {
                Class[] classArray = new Class[]{Integer.TYPE};
                Field field = Frame.class.getField("ICONIFIED");
                Method method = Frame.class.getMethod("setState", classArray);
                if (method != null) {
                    Object[] objectArray = new Object[]{field.get(null)};
                    method.invoke((Object)window, objectArray);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void setMaximized(long l, boolean bl) {
        if (bl) {
            NativeJava.maximize(l);
        } else if (NativeJava.isMaximized(l)) {
            NativeJava.restore(l);
        }
    }

    public static void setMaximized(Window window, boolean bl) {
        if (PlatformInfo.isWindows() && sNativeLibraryExists) {
            long l;
            Dimension dimension = NativeJava.getRestoredSize(window);
            Point point = NativeJava.getRestoredLocation(window);
            try {
                l = NativeJava.hWndFromWindow(window);
            }
            catch (IllegalStateException illegalStateException) {
                window.addNotify();
                window.setVisible(false);
                l = NativeJava.hWndFromWindow(window);
            }
            assert (l != 0L);
            NativeJava.setMaximized(NativeJava.hWndFromWindow(window), bl);
            NativeJava.setRestoredSize(window, dimension.width, dimension.height);
            NativeJava.setRestoredLocation(window, point.x, point.y);
        }
    }

    private static native Dimension getRestoredSize(long var0);

    public static Dimension getRestoredSize(Window window) {
        if (sNativeLibraryExists && NativeJava.isMaximized(window)) {
            return NativeJava.getRestoredSize(NativeJava.hWndFromWindow(window));
        }
        return window.getSize();
    }

    private static native void setRestoredSize(long var0, int var2, int var3);

    public static void setRestoredSize(Window window, int n, int n2) {
        if (sNativeLibraryExists && NativeJava.isMaximized(window)) {
            NativeJava.setRestoredSize(NativeJava.hWndFromWindow(window), n, n2);
        } else {
            window.setSize(n, n2);
        }
    }

    public static void setRestoredSize(Window window, Dimension dimension) {
        NativeJava.setRestoredSize(window, dimension.width, dimension.height);
    }

    private static native Point getRestoredLocation(long var0);

    public static Point getRestoredLocation(Window window) {
        if (sNativeLibraryExists && NativeJava.isMaximized(window)) {
            return NativeJava.getRestoredLocation(NativeJava.hWndFromWindow(window));
        }
        return window.getLocation();
    }

    private static native void setRestoredLocation(long var0, int var2, int var3);

    public static void setRestoredLocation(Window window, int n, int n2) {
        if (sNativeLibraryExists && NativeJava.isMaximized(window)) {
            NativeJava.setRestoredLocation(NativeJava.hWndFromWindow(window), n, n2);
        } else {
            window.setLocation(n, n2);
        }
    }

    public static void setRestoredLocation(Window window, Point point) {
        NativeJava.setRestoredLocation(window, point.x, point.y);
    }

    private static native void setBounds(long var0, int var2, int var3, int var4, int var5);

    public static void setBounds(Window window, int n, int n2, int n3, int n4) {
        NativeJava.setBounds(NativeJava.hWndFromWindow(window), n, n2, n3, n4);
    }

    public static native byte[] getImageData(Object var0);

    public static native void copyPrivateEventData(Object var0, Object var1);

    private static native void GetWindowsTextMetric(long var0, String var2, int var3, int var4, Object var5);

    public static void getWindowsTextMetric(long l, String string, int n, int n2, Object object) {
        if (!PlatformInfo.isWindows()) {
            throw new IllegalStateException("This method may be called only on Windows.");
        }
        long l2 = NativeJava.GetWindowsDC(l);
        NativeJava.GetWindowsTextMetric(l2, string, n, n2, object);
        NativeJava.ReleaseWindowsDC(l, l2);
    }

    private static native long GetWindowsDC(long var0);

    private static native void ReleaseWindowsDC(long var0, long var2);

    public static native boolean winClipboardHasText();

    public static native long winSendMessage(long var0, int var2, long var3, long var5);

    public static native void winPostMessage(long var0, int var2, long var3, long var5);

    public static String nativeBrowseForFolder(Component component, String string, File file) {
        if (PlatformInfo.isWindows() || PlatformInfo.isMacintosh()) {
            return NativeJava.browseForFolder(NativeJava.getNativeWindowFromComponent(component), string, file == null ? null : file.getAbsolutePath());
        }
        throw new IllegalStateException("This method may be called only on Windows or Mac.");
    }

    private static native String browseForFolder(long var0, String var2, String var3);

    public static native boolean isSymbolicLink(String var0);

    public static native int getMouseButtonState();

    private static void checkHWnd(long l) {
        assert (l != 0L) : "Must only be called with a non-zero hWnd";
    }

    public static native int getMacControlTint();

    public static native void macActivateIgnoringOtherApps();

    public static native boolean isPackage(String var0);

    private static native Object colorFromSystemColor(String var0);

    public static Color componentColorFromSystemColor(String string) {
        if (!PlatformInfo.isMacintosh()) {
            throw new IllegalStateException("componentColorFromSystemColor is only valid on the Macintosh platform.");
        }
        return (Color)NativeJava.colorFromSystemColor(string);
    }

    public static native void setDefaultMenuBar();

    public static native void disposeLingeringWindowsMac();

    public static String getPhysicalFontName(Font font) {
        if (!PlatformInfo.isMacintosh()) {
            throw new IllegalStateException("getPhysicalFontName is implemented specifically for the Macintosh Platform");
        }
        return (String)NativeJava.getMacPhysicalFontName(font);
    }

    private static native Object getMacPhysicalFontName(Font var0);

    public static String showPageSetupDialog(String string) {
        if (!PlatformInfo.isMacintosh()) {
            throw new IllegalStateException("showPageSetupDialog is implemented specifically for the Macintosh Platform");
        }
        return (String)NativeJava.showMacPageSetupDialog(string);
    }

    private static native Object showMacPageSetupDialog(String var0);

    public static native void nativeCheckDisplay();

    public static int showAlert(Component component, int n, String string, String string2, String string3, String[] stringArray) {
        if (!PlatformInfo.isMacintosh() && !PlatformInfo.isWindowsVistaAndAbove()) {
            throw new IllegalStateException("showAlert is not supported on this platform");
        }
        return NativeJava.showNativeAlert(NativeJava.getNativeWindowFromComponent(component), n, string, string2, string3, stringArray);
    }

    private static native int showNativeAlert(long var0, int var2, String var3, String var4, String var5, String[] var6);

    public static native String getCurrentDirectory();

    public static native boolean fileExists(String var0);

    static {
        if (NativeJavaSwitch.isLoadingEnabled()) {
            try {
                System.loadLibrary("nativejava");
                sNativeLibraryExists = true;
                if (PlatformInfo.isWindows()) {
                    NativeJava.tellJavaVersion(System.getProperty("java.version").startsWith("1.1"));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class StatEntry {
        public final long st_dev;
        public final long st_ino;
        public final long st_mode;
        public final long st_nlink;
        public final long st_uid;
        public final long st_gid;
        public final long st_rdev;
        public final long st_size;
        public final long st_atime;
        public final long st_mtime;
        public final long st_ctime;
        public final boolean s_isdir;
        private final String fName;
        private final boolean fHiddenFlag;

        public StatEntry(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, boolean bl, boolean bl2) {
            this(null, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, bl, bl2);
        }

        public StatEntry(@Nullable String string, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, boolean bl, boolean bl2) {
            this.fName = string;
            this.st_dev = l;
            this.st_ino = l2;
            this.st_mode = l3;
            this.st_nlink = l4;
            this.st_uid = l5;
            this.st_gid = l6;
            this.st_rdev = l7;
            this.st_size = l8;
            this.st_atime = l9;
            this.st_mtime = l10;
            this.st_ctime = l11;
            this.s_isdir = bl;
            this.fHiddenFlag = bl2;
        }

        public String getName() {
            return this.fName;
        }

        public boolean isHidden() {
            return this.fHiddenFlag;
        }
    }
}

