/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util.jarloader;

import com.mathworks.util.jarloader.JarInfo;
import com.mathworks.util.jarloader.Manifest;
import com.mathworks.util.jarloader.MessageHeader;
import com.mathworks.util.jarloader.SimpleClassLoader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarLoader {
    private static boolean debug = false;
    private InputStream jarStream;
    private String jarName;
    private SimpleClassLoader loader;
    private static boolean warnedAboutNoBeans;

    public JarLoader(String string) throws FileNotFoundException {
        JarLoader.debug("(" + string + ")");
        this.jarName = string;
        FileInputStream fileInputStream = new FileInputStream(string);
        this.jarStream = new BufferedInputStream(fileInputStream);
        this.loader = SimpleClassLoader.ourLoader;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    private String guessContentTypeFromStream(InputStream inputStream) throws IOException {
        String string = URLConnection.guessContentTypeFromStream(inputStream);
        if (string == null) {
            inputStream.mark(10);
            int n = inputStream.read();
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            int n4 = inputStream.read();
            int n5 = inputStream.read();
            int n6 = inputStream.read();
            inputStream.reset();
            if (n == 172 && n2 == 237) {
                string = "application/java-serialized-object";
            }
        }
        return string;
    }

    public JarInfo loadJar() throws IOException {
        Object object;
        ZipInputStream zipInputStream = null;
        Manifest manifest = null;
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = new Vector<Object>();
        byte[] byArray = new byte[1024];
        boolean bl = true;
        try {
            zipInputStream = new ZipInputStream(this.jarStream);
            object = null;
            while ((object = zipInputStream.getNextEntry()) != null) {
                Object object2;
                int n;
                bl = false;
                String string = ((ZipEntry)object).getName();
                String string2 = null;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n = zipInputStream.read(byArray)) >= 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                int n2 = byArray2.length;
                if (Manifest.isManifestName(string)) {
                    string2 = "manifest/manifest";
                }
                if (string2 == null) {
                    object2 = new ByteArrayInputStream(byArray2);
                    string2 = this.guessContentTypeFromStream((InputStream)object2);
                    ((InputStream)object2).close();
                }
                if (string2 == null) {
                    string2 = "input-stream/input-stream";
                }
                if (string2.startsWith("application/java-serialized-object") || string2.startsWith("application/x-java-serialized-object")) {
                    this.loader.putLocalResource(string, byArray2, string2);
                    object2 = string.substring(0, string.length() - 4);
                    object2 = ((String)object2).replace('/', '.');
                    vector2.addElement(object2);
                    continue;
                }
                if (string2.startsWith("application/java-vm") || string2.startsWith("application/x-java-vm")) {
                    this.loader.putClassResource(string, string2);
                    object2 = string.substring(0, string.length() - 6);
                    object2 = ((String)object2).replace('/', '.');
                    this.loader.defineClassFromBytes((String)object2, byArray2);
                    vector.addElement(object2);
                    continue;
                }
                if (string2.equals("manifest/manifest")) {
                    manifest = new Manifest(byArray2);
                    continue;
                }
                this.loader.putLocalResource(string, byArray2, string2);
            }
        }
        catch (IOException iOException) {
            JarLoader.debug("IOException loading archive: " + iOException);
            throw iOException;
        }
        catch (Throwable throwable) {
            JarLoader.debug("Caught " + throwable + " in loadit()");
            throwable.printStackTrace();
            throw new IOException("loadJar caught: " + throwable);
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        if (bl) {
            throw new IOException("JAR file is corrupt or empty");
        }
        object = this.createJarInfo(vector, vector2, manifest);
        return object;
    }

    private JarInfo createJarInfo(Vector vector, Vector vector2, Manifest manifest) {
        Object object;
        Object object2;
        Object object3;
        String[] stringArray;
        Hashtable<Object, Boolean> hashtable;
        Hashtable<Object, Object> hashtable2 = new Hashtable<Object, Object>();
        if (manifest == null) {
            hashtable = new Hashtable<Object, Boolean>();
        } else {
            hashtable = new Hashtable();
            stringArray = manifest.entries();
            while (stringArray.hasMoreElements()) {
                Object object4;
                object3 = (MessageHeader)stringArray.nextElement();
                object2 = ((MessageHeader)object3).findValue("Name");
                object = ((MessageHeader)object3).findValue("Java-Bean");
                if (object == null || !((String)object).equalsIgnoreCase("True")) continue;
                boolean bl = true;
                if (((String)object2).endsWith(".class")) {
                    bl = false;
                    object4 = ((String)object2).substring(0, ((String)object2).length() - 6);
                } else {
                    object4 = ((String)object2).endsWith(".ser") ? ((String)object2).substring(0, ((String)object2).length() - 4) : object2;
                }
                object4 = ((String)object4).replace('/', '.');
                hashtable.put(object4, new Boolean(bl));
                hashtable2.put(object4, object3);
            }
        }
        stringArray = new String[hashtable.size()];
        object3 = new boolean[hashtable.size()];
        object2 = new MessageHeader[hashtable.size()];
        object = hashtable.keys();
        int n = 0;
        while (object.hasMoreElements()) {
            String string;
            stringArray[n] = string = (String)object.nextElement();
            object3[n] = (Boolean)hashtable.get(string);
            object2[n] = (MessageHeader)hashtable2.get(string);
            ++n;
        }
        return new JarInfo(this.jarName, this.loader, stringArray, (boolean[])object3, (MessageHeader[])object2);
    }

    private static void debug(String string) {
        if (debug) {
            System.err.println("JarLoader:: " + string);
        }
    }
}

