/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util.types;

import com.mathworks.util.types.UnsignedNumber;
import java.math.BigInteger;

public class UnsignedLong
extends UnsignedNumber {
    private final long fValue;
    private static final long MASK = -1L;
    public static final long MIN_VALUE = 0L;
    public static final long MAX_VALUE = -1L;
    public static final Class<Long> TYPE = Long.TYPE;

    public UnsignedLong(byte by) {
        this.fValue = (long)by & 0xFFL;
    }

    public UnsignedLong(short s) {
        this.fValue = (long)s & 0xFFFFL;
    }

    public UnsignedLong(int n) {
        this.fValue = (long)n & 0xFFFFFFFFL;
    }

    public UnsignedLong(long l) {
        this.fValue = l;
    }

    @Override
    public double doubleValue() {
        if (this.fValue >= 0L) {
            return this.fValue;
        }
        return 9.223372036854776E18 + (double)(this.fValue & Long.MAX_VALUE);
    }

    @Override
    public float floatValue() {
        if (this.fValue >= 0L) {
            return this.fValue;
        }
        return 9.223372E18f + (float)(this.fValue & Long.MAX_VALUE);
    }

    @Override
    public int intValue() {
        return (int)this.fValue;
    }

    @Override
    public long longValue() {
        return this.fValue;
    }

    public BigInteger bigValue() {
        if (this.fValue >= 0L) {
            return BigInteger.valueOf(this.fValue);
        }
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)(this.fValue >> 56 - 8 * i);
        }
        return new BigInteger(1, byArray);
    }

    public static UnsignedLong valueOf(long l) {
        return new UnsignedLong(l);
    }
}

