/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.clients.cloudcenter;

import com.mathworks.webservices.clients.cloudcenter.InvalidArgumentException;

public enum TerminationPolicy {
    MATLAB_SESSION_END(false, -1L),
    NEVER(false, -1L),
    FIXED_DURATION(true, 86400L),
    ON_QUEUE_IDLE(false, -1L);

    private final boolean requiresDuration;
    private final Long defaultRuntimeInSeconds;

    public boolean requiresDuration() {
        return this.requiresDuration;
    }

    public void validateDuration(Long duration) {
        if (this.requiresDuration && duration <= 0L) {
            throw new InvalidArgumentException("Invalid duration.");
        }
    }

    private TerminationPolicy(boolean requiresDuration, Long duration) {
        this.requiresDuration = requiresDuration;
        this.defaultRuntimeInSeconds = duration;
    }

    public Long getDefaultRuntimeInSeconds() {
        return this.defaultRuntimeInSeconds;
    }
}

