/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.parallel.pctutil.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryFlag;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public final class ACLPermissionSetter {
    private static final Set<AclEntryPermission> ACL_READ_ONLY = EnumSet.of(AclEntryPermission.READ_ACL, new AclEntryPermission[]{AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.READ_DATA, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.LIST_DIRECTORY, AclEntryPermission.EXECUTE, AclEntryPermission.SYNCHRONIZE});
    private static final Set<AclEntryPermission> ACL_WRITABLE = EnumSet.allOf(AclEntryPermission.class);

    private ACLPermissionSetter() {
    }

    public static void setReadOnlyExclusive(Path path, String string) throws IOException {
        ACLPermissionSetter.setPermissions(path, string, ACL_READ_ONLY, true);
    }

    public static void setWritableExclusive(Path path, String string) throws IOException {
        ACLPermissionSetter.setPermissions(path, string, ACL_WRITABLE, true);
    }

    public static void setReadOnly(Path path, String string) throws IOException {
        ACLPermissionSetter.setPermissions(path, string, ACL_READ_ONLY, false);
    }

    public static void setWritable(Path path, String string) throws IOException {
        ACLPermissionSetter.setPermissions(path, string, ACL_WRITABLE, false);
    }

    private static void setPermissions(Path path, String string, Set<AclEntryPermission> set, boolean bl) throws IOException {
        AclFileAttributeView aclFileAttributeView = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
        UserPrincipal userPrincipal = path.getFileSystem().getUserPrincipalLookupService().lookupPrincipalByName(string);
        AclEntry aclEntry = AclEntry.newBuilder().setType(AclEntryType.ALLOW).setPrincipal(userPrincipal).setPermissions(set).setFlags(AclEntryFlag.DIRECTORY_INHERIT, AclEntryFlag.FILE_INHERIT).build();
        List<AclEntry> list = aclFileAttributeView.getAcl();
        if (bl) {
            list.clear();
        }
        list.add(0, aclEntry);
        aclFileAttributeView.setAcl(list);
    }
}

