/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.parallel.pctutil.logging;

import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public final class DistcompSimpleFormatter
extends Formatter {
    private final ThreadLocal<SimpleDateFormat> fThreadLocalDateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            super.initialValue();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy MM dd HH:mm:ss.SSS z");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return simpleDateFormat;
        }
    };

    @Override
    public String format(LogRecord logRecord) {
        long l = logRecord.getMillis();
        String string = this.getTimeStamp(l);
        int n = DistcompLevel.getValueFromLevel(logRecord.getLevel());
        String string2 = Integer.toString(n);
        String string3 = logRecord.getMessage();
        String string4 = string + " | " + string2 + " | ";
        if (n >= DistcompLevel.getValueFromLevel(DistcompLevel.SIX)) {
            string4 = string4 + logRecord.getSourceClassName() + "." + logRecord.getSourceMethodName() + ": ";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string4).append(string3).append("\n");
        Throwable throwable = logRecord.getThrown();
        while (throwable != null) {
            stringBuilder.append(string4).append("Exception: ").append(throwable.toString()).append("\n");
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                stringBuilder.append(string4).append("[").append(i).append("] ").append(stackTraceElementArray[i].getClassName()).append(".").append(stackTraceElementArray[i].getMethodName()).append("(): ");
                if (stackTraceElementArray[i].getLineNumber() > 0) {
                    stringBuilder.append(stackTraceElementArray[i].getLineNumber());
                }
                stringBuilder.append("\n");
            }
            if ((throwable = throwable.getCause()) == null) continue;
            stringBuilder.append(string4).append("Caused by ").append("\n");
        }
        return stringBuilder.toString();
    }

    private String getTimeStamp(long l) {
        Date date = new Date(l);
        SimpleDateFormat simpleDateFormat = this.fThreadLocalDateFormat.get();
        return simpleDateFormat.format(date);
    }
}

