/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.parallel.pctutil.logging;

import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import com.mathworks.toolbox.parallel.pctutil.logging.Log;
import com.mathworks.toolbox.parallel.util.concurrent.Predicate;
import com.mathworks.toolbox.parallel.util.concurrent.PredicateCondition;
import com.mathworks.toolbox.parallel.util.concurrent.ReentrantLock;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public final class RotatingFileHandler
extends FileHandler {
    private final int fLimit;
    private Behavior fBehavior = Behavior.PUBLISHING;
    private final ReentrantLock fLock = new ReentrantLock();
    private final PredicateCondition fChangedToPublishing = this.fLock.newPredicateCondition((Predicate)new PublishingStarted());
    private final BlockingDeque<LogRecord> fQueue = new LinkedBlockingDeque<LogRecord>();
    private final NamedThreadFactory fThreadFactory = NamedThreadFactory.createDaemonThreadFactory("Log Rotator", Log.LOG);
    private static final Method ROTATE_METHOD;
    private static final Field WRITER_FIELD;
    private static final Field DONE_HEADER_FIELD;
    private static final Field METER_FIELD;
    private static final Field WRITTEN_FIELD;

    public RotatingFileHandler(String string, int n, int n2, boolean bl) throws IOException {
        super(string, n, n2, bl);
        this.fLimit = n;
    }

    private Behavior getBehavior() {
        assert (this.fLock.isHeldByCurrentThread()) : "fLock is not held by the current thread.";
        return this.fBehavior;
    }

    private Behavior getAndSetBehavior(Behavior behavior) {
        assert (this.fLock.isHeldByCurrentThread()) : "fLock is not held by the current thread.";
        Behavior behavior2 = this.fBehavior;
        this.fBehavior = behavior;
        return behavior2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord logRecord) {
        this.fLock.lock();
        try {
            this.getBehavior().publish(this, logRecord);
        }
        finally {
            this.fLock.unlock();
        }
    }

    private void enqueueLogRecord(LogRecord logRecord) {
        assert (this.fLock.isHeldByCurrentThread()) : "fLock is not held by the current thread.";
        boolean bl = this.fQueue.offer(logRecord);
        assert (bl) : "offer() should always succeed on an unbounded queue, but failed";
    }

    private synchronized void streamHandlerPublishAndFlush(LogRecord logRecord) {
        this.streamHandlerPublish(logRecord);
        this.streamHandlerFlush();
    }

    private synchronized void streamHandlerPublish(LogRecord logRecord) {
        String string;
        Writer writer;
        if (!this.isLoggable(logRecord)) {
            return;
        }
        try {
            writer = this.getWriter();
        }
        catch (WriterIsNullException writerIsNullException) {
            return;
        }
        Formatter formatter = this.getFormatter();
        try {
            string = formatter.format(logRecord);
        }
        catch (Exception exception) {
            this.reportError("Could not format " + logRecord, exception, 5);
            return;
        }
        try {
            if (!this.getDoneHeader()) {
                writer.write(formatter.getHead(this));
                this.setDoneHeader(true);
            }
            writer.write(string);
        }
        catch (Exception exception) {
            this.reportError("Could not write " + string, exception, 1);
        }
    }

    private synchronized void streamHandlerFlush() {
        Writer writer;
        try {
            writer = this.getWriter();
        }
        catch (WriterIsNullException writerIsNullException) {
            return;
        }
        try {
            writer.flush();
        }
        catch (Exception exception) {
            this.reportError("Could not flush writer.", exception, 2);
        }
    }

    private void checkRotateAndQueue() {
        assert (this.fLock.isHeldByCurrentThread()) : "fLock is not held by the current thread.";
        if (this.shouldRotateAndQueue()) {
            this.stopPublishingStartQueuing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldRotateAndQueue() {
        assert (this.fLock.isHeldByCurrentThread()) : "fLock is not held by the current thread.";
        assert (Behavior.PUBLISHING == this.getBehavior()) : "shouldRotateAndQueue() should only be called if the current behavior is PUBLISHING not " + (Object)((Object)this.getBehavior());
        RotatingFileHandler rotatingFileHandler = this;
        synchronized (rotatingFileHandler) {
            int n = this.getFileHandlerWritten();
            return this.fLimit > 0 && n >= this.fLimit;
        }
    }

    private void stopPublishingStartQueuing() {
        assert (this.fLock.isHeldByCurrentThread()) : "fLock is not held by the current thread.";
        this.changeBehaviorFromPublishingToQueuing();
        this.startRotatorThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeBehaviorFromPublishingToQueuing() {
        this.fLock.lock();
        try {
            Behavior behavior = this.getAndSetBehavior(Behavior.QUEUING);
            assert (behavior == Behavior.PUBLISHING) : "Old behavior was " + (Object)((Object)behavior) + " not " + (Object)((Object)Behavior.PUBLISHING);
            this.logInline(Level.INFO, "Changed this logger to QUEUING.");
        }
        finally {
            this.fLock.unlock();
        }
    }

    private void startRotatorThread() {
        Thread thread = this.fThreadFactory.newThread(new Rotator(this));
        this.logInline(Level.INFO, "Starting " + thread);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitChangedToPublishing() throws InterruptedException {
        this.fLock.lock();
        try {
            this.fChangedToPublishing.await();
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopQueuingStartPublishing() {
        this.publishQueue();
        this.fLock.lock();
        try {
            this.publishQueue();
            Behavior behavior = this.getAndSetBehavior(Behavior.PUBLISHING);
            assert (behavior == Behavior.QUEUING) : "Old state was " + (Object)((Object)behavior) + " not " + (Object)((Object)Behavior.QUEUING);
            assert (this.fQueue.isEmpty()) : "fQueue should be empty but still contains " + this.fQueue;
            this.logInline(Level.INFO, "fQueue is empty. Changed this logger to PUBLISHING.");
            this.fChangedToPublishing.signalAll();
        }
        finally {
            this.fLock.unlock();
        }
    }

    private void publishQueue() {
        this.logInline(Level.INFO, "fQueue accumulated " + this.fQueue.size() + " LogRecords while rotating logs.");
        while (!this.fQueue.isEmpty()) {
            LogRecord logRecord = this.fQueue.poll();
            if (null != logRecord) {
                this.streamHandlerPublish(logRecord);
                continue;
            }
            assert (false) : "null record in publishQueue(). Two threads may be draining the queue concurrently.";
        }
        this.streamHandlerFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.publish(new LogRecord(Level.INFO, "RotatingFileHandler.close() called"));
        this.fLock.lock();
        try {
            this.awaitChangedToPublishing();
            super.close();
        }
        catch (InterruptedException interruptedException) {
            this.reportError("Interrupted while closing " + this, interruptedException, 3);
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        this.publish(new LogRecord(Level.INFO, "RotatingFileHandler.flush() called"));
        this.fLock.lock();
        try {
            this.awaitChangedToPublishing();
            super.flush();
        }
        catch (InterruptedException interruptedException) {
            this.reportError("Interrupted while closing " + this, interruptedException, 2);
        }
        finally {
            this.fLock.unlock();
        }
        this.publish(new LogRecord(Level.INFO, "RotatingFileHandler.flush() complete"));
    }

    private synchronized void fileHandlerFlush() {
        super.flush();
    }

    private synchronized void fileHandlerRotate() {
        this.invokeMethod(this, ROTATE_METHOD, new Object[0]);
    }

    private synchronized int getFileHandlerWritten() {
        Object object = this.getFieldValue(this, METER_FIELD);
        return (Integer)this.getFieldValue(object, WRITTEN_FIELD);
    }

    private synchronized boolean getDoneHeader() {
        return (Boolean)this.getFieldValue(this, DONE_HEADER_FIELD);
    }

    private synchronized void setDoneHeader(boolean bl) {
        this.setFieldValue(this, DONE_HEADER_FIELD, bl);
    }

    private synchronized Writer getWriter() throws WriterIsNullException {
        Writer writer = (Writer)this.getFieldValue(this, WRITER_FIELD);
        if (null == writer) {
            throw new WriterIsNullException();
        }
        return writer;
    }

    public String toString() {
        return "RotatingFileHandler{" + super.toString() + ", fBehavior=" + (Object)((Object)this.fBehavior) + '}';
    }

    private void logInline(Level level, String string) {
        LogRecord logRecord = new LogRecord(level, string);
        this.streamHandlerPublishAndFlush(logRecord);
    }

    private void invokeMethod(Object object, Method method, Object ... objectArray) {
        try {
            method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RotatingFileHandlerException("Someone installed a security manager preventing a call to " + method, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RotatingFileHandlerException("Exception while invoking " + method, invocationTargetException);
        }
    }

    private Object getFieldValue(Object object, Field field) {
        try {
            return field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RotatingFileHandlerException("Someone installed a security manager preventing getting the field " + field, illegalAccessException);
        }
    }

    private void setFieldValue(Object object, Field field, Object object2) {
        try {
            field.set(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RotatingFileHandlerException("Someone installed a security manager preventing setting the field " + field, illegalAccessException);
        }
    }

    private static Field getField(Class<?> clazz, String string) {
        try {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RotatingFileHandlerException("Oracle changed the implementation of " + clazz + "'s " + string + " field.", noSuchFieldException);
        }
    }

    static {
        try {
            ROTATE_METHOD = FileHandler.class.getDeclaredMethod("rotate", new Class[0]);
            ROTATE_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RotatingFileHandlerException("Oracle changed the implementation of " + FileHandler.class + "'s rotate method.", noSuchMethodException);
        }
        WRITER_FIELD = RotatingFileHandler.getField(StreamHandler.class, "writer");
        DONE_HEADER_FIELD = RotatingFileHandler.getField(StreamHandler.class, "doneHeader");
        METER_FIELD = RotatingFileHandler.getField(FileHandler.class, "meter");
        WRITTEN_FIELD = RotatingFileHandler.getField(METER_FIELD.getType(), "written");
    }

    private static final class WriterIsNullException
    extends Exception {
        private WriterIsNullException() {
        }
    }

    private static final class RotatingFileHandlerException
    extends RuntimeException {
        RotatingFileHandlerException(String string, Exception exception) {
            super(string, exception);
        }
    }

    private static final class Rotator
    implements Runnable {
        private final RotatingFileHandler fRotatingFileHandler;

        Rotator(RotatingFileHandler rotatingFileHandler) {
            this.fRotatingFileHandler = rotatingFileHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                RotatingFileHandler rotatingFileHandler = this.fRotatingFileHandler;
                synchronized (rotatingFileHandler) {
                    this.fRotatingFileHandler.logInline(Level.INFO, "About to rotate this log. This is the last message.");
                    this.fRotatingFileHandler.fileHandlerFlush();
                    this.fRotatingFileHandler.fileHandlerRotate();
                    this.fRotatingFileHandler.logInline(Level.INFO, "Finished rotating this log. This is the first message.");
                }
            }
            finally {
                this.fRotatingFileHandler.stopQueuingStartPublishing();
            }
        }
    }

    private static enum Behavior {
        PUBLISHING{

            @Override
            void publish(RotatingFileHandler rotatingFileHandler, LogRecord logRecord) {
                rotatingFileHandler.streamHandlerPublishAndFlush(logRecord);
                rotatingFileHandler.checkRotateAndQueue();
            }
        }
        ,
        QUEUING{

            @Override
            void publish(RotatingFileHandler rotatingFileHandler, LogRecord logRecord) {
                rotatingFileHandler.enqueueLogRecord(logRecord);
            }
        };


        abstract void publish(RotatingFileHandler var1, LogRecord var2);
    }

    private final class PublishingStarted
    implements Predicate {
        private PublishingStarted() {
        }

        public boolean test() {
            return Behavior.PUBLISHING == RotatingFileHandler.this.getBehavior();
        }
    }
}

