/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.Converter;
import com.mathworks.util.Holder;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.Predicate;
import java.util.Iterator;

public final class AsyncReceiverUtils {
    private AsyncReceiverUtils() {
    }

    public static <T> AsyncReceiver<T> filter(final AsyncReceiver<T> asyncReceiver, final Predicate<T> predicate) {
        return new AsyncReceiver<T>(){

            @Override
            public boolean receive(T t) {
                return !predicate.accept(t) || asyncReceiver.receive(t);
            }

            @Override
            public void finished() {
                asyncReceiver.finished();
            }
        };
    }

    public static <T> void chainInvoke(final Iterator<ParameterRunnable<AsyncReceiver<T>>> iterator, final AsyncReceiver<T> asyncReceiver) {
        if (!iterator.hasNext()) {
            asyncReceiver.finished();
        } else {
            final Holder<Boolean> holder = new Holder<Boolean>();
            holder.set(false);
            iterator.next().run(new AsyncReceiver<T>(){

                @Override
                public boolean receive(T t) {
                    if (!asyncReceiver.receive(t)) {
                        holder.set(true);
                    }
                    return (Boolean)holder.get() == false;
                }

                @Override
                public void finished() {
                    if (!((Boolean)holder.get()).booleanValue()) {
                        AsyncReceiverUtils.chainInvoke(iterator, asyncReceiver);
                    }
                }
            });
        }
    }

    public static <T, U> AsyncReceiver<U> convert(final AsyncReceiver<T> asyncReceiver, final Converter<U, T> converter) {
        return new AsyncReceiver<U>(){

            @Override
            public boolean receive(U u) {
                Object y = converter.convert(u);
                return y == null || asyncReceiver.receive(y);
            }

            @Override
            public void finished() {
                asyncReceiver.finished();
            }
        };
    }
}

