/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.util.HashMap;
import org.h2.util.StringUtils;

public class Mode {
    public static final String REGULAR = "REGULAR";
    private static final HashMap MODES = new HashMap();
    public boolean nullConcatIsNull;
    public boolean convertInsertNullToZero;
    public boolean convertOnlyToSmallerScale;
    public boolean roundWhenConvertToLong;
    public boolean lowerCaseIdentifiers;
    public boolean indexDefinitionInCreateTable;
    public boolean systemColumns;
    public boolean squareBracketQuotedNames;
    public boolean uniqueIndexSingleNull;
    public boolean uniqueIndexSingleNullExceptAllColumnsAreNull;
    public boolean supportOffsetFetch;
    private String name;

    private Mode(String string) {
        this.name = string;
    }

    private static void add(Mode mode) {
        MODES.put(StringUtils.toUpperEnglish(mode.name), mode);
    }

    public static Mode getInstance(String string) {
        return (Mode)MODES.get(StringUtils.toUpperEnglish(string));
    }

    public String getName() {
        return this.name;
    }

    static {
        Mode mode = new Mode(REGULAR);
        Mode.add(mode);
        mode = new Mode("PostgreSQL");
        mode.nullConcatIsNull = true;
        mode.roundWhenConvertToLong = true;
        mode.systemColumns = true;
        Mode.add(mode);
        mode = new Mode("MySQL");
        mode.convertInsertNullToZero = true;
        mode.roundWhenConvertToLong = true;
        mode.lowerCaseIdentifiers = true;
        mode.indexDefinitionInCreateTable = true;
        Mode.add(mode);
        mode = new Mode("HSQLDB");
        mode.nullConcatIsNull = true;
        mode.convertOnlyToSmallerScale = true;
        mode.uniqueIndexSingleNull = true;
        Mode.add(mode);
        mode = new Mode("MSSQLServer");
        mode.squareBracketQuotedNames = true;
        mode.uniqueIndexSingleNull = true;
        Mode.add(mode);
        mode = new Mode("Derby");
        mode.uniqueIndexSingleNull = true;
        Mode.add(mode);
        mode = new Mode("Oracle");
        mode.uniqueIndexSingleNullExceptAllColumnsAreNull = true;
        Mode.add(mode);
        mode = new Mode("DB2");
        Mode.add(mode);
    }
}

