/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.compare.concr;

import com.mathworks.comparisons.compare.concr.AsynchronousComparison;
import com.mathworks.comparisons.compare.concr.ListComparisonGenerator;
import com.mathworks.comparisons.compare.concr.ListComparisonUtilities;
import com.mathworks.comparisons.source.ComparisonSource;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.w3c.dom.Element;

public class ComparisonQueue {
    private Vector<AsynchronousComparison> fQueue;
    private Thread fThread;
    private AsynchronousComparison fCurrent;
    private ListComparisonGenerator fParent;

    public ComparisonQueue(ListComparisonGenerator listComparisonGenerator) {
        this.fParent = listComparisonGenerator;
    }

    public synchronized void add(ComparisonSource comparisonSource, ComparisonSource comparisonSource2, Element element) {
        if (this.fQueue == null) {
            this.fQueue = new Vector();
        }
        this.fQueue.add(new AsynchronousComparison(this.fParent, comparisonSource, comparisonSource2, element));
    }

    public void start() {
        if (this.fThread == null) {
            this.fThread = new Thread(ListComparisonUtilities.getThreadGroup(), new Runnable(){

                @Override
                public void run() {
                    ComparisonQueue.this.run();
                }
            });
            this.fThread.start();
        }
    }

    public synchronized int getQueueSize() {
        return this.fQueue == null ? 0 : this.fQueue.size();
    }

    public void cancelCurrent() {
        if (this.fCurrent != null) {
            this.fCurrent.cancel();
            assert (this.fThread != null);
            this.fThread.interrupt();
        }
    }

    public synchronized void cancelAll() {
        if (this.fQueue != null) {
            Iterator<AsynchronousComparison> iterator = this.fQueue.iterator();
            while (iterator.hasNext()) {
                iterator.next().cancel();
            }
        }
        this.cancelCurrent();
    }

    private void run() {
        assert (!SwingUtilities.isEventDispatchThread());
        while (!this.fQueue.isEmpty()) {
            this.fCurrent = this.getNext();
            Thread.interrupted();
            this.fCurrent.run();
            this.fCurrent = null;
        }
        this.fThread = null;
    }

    private synchronized AsynchronousComparison getNext() {
        return this.fQueue.remove(0);
    }
}

