/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.decorator.htmlreport.toolstrip;

import com.mathworks.comparisons.decorator.actionid.ActionIDHelp;
import com.mathworks.comparisons.decorator.actionid.ActionIDNext;
import com.mathworks.comparisons.decorator.actionid.ActionIDPrevious;
import com.mathworks.comparisons.decorator.actionid.ActionIdMerge;
import com.mathworks.comparisons.decorator.actionid.ActionIdRedo;
import com.mathworks.comparisons.decorator.actionid.ActionIdSaveRightFile;
import com.mathworks.comparisons.decorator.actionid.ActionIdSaveRightFileAs;
import com.mathworks.comparisons.decorator.actionid.ActionIdUndoMerge;
import com.mathworks.comparisons.decorator.impl.ComparisonHelpAction;
import com.mathworks.comparisons.report.ActionManager;
import com.mathworks.comparisons.report.toolstrip.ComparisonToolstripTabConfiguration;
import com.mathworks.comparisons.report.toolstrip.ComparisonToolstripUtils;
import com.mathworks.comparisons.report.toolstrip.DefaultHelpToolSetFactory;
import com.mathworks.comparisons.report.toolstrip.DefaultNavigateToolSetFactory;
import com.mathworks.comparisons.report.toolstrip.TSTabConfigurationFactory;
import com.mathworks.comparisons.report.toolstrip.ToolSetFactory;
import com.mathworks.comparisons.report.toolstrip.ToolstripTabConfiguration;
import com.mathworks.comparisons.report.toolstrip.ToolstripTabConfigurationFactory;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.toolstrip.factory.TSTabConfiguration;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;

public class TextComparisonTabConfigurationFactory
implements ToolstripTabConfigurationFactory {
    private static final String RESOURCE_BUNDLE_NAME = "com.mathworks.comparisons.decorator.htmlreport.toolstrip.resources.RES_Text_Comparison_Toolstrip";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.mathworks.comparisons.decorator.htmlreport.toolstrip.resources.RES_Text_Comparison_Toolstrip");
    private final TSToolSetContents fMergeToolSetContents = TSToolSetContents.readToolSetContents(TextComparisonTabConfigurationFactory.class, (String)"resources/MergeComparisonToolset.xml");
    private final ActionManager fActionManager;
    private final ToolstripTabConfiguration fTabConfiguration;
    private TSToolSet fToolSet;

    public TextComparisonTabConfigurationFactory(ToolstripTabConfiguration toolstripTabConfiguration, ActionManager actionManager) {
        this.fTabConfiguration = toolstripTabConfiguration;
        this.fActionManager = actionManager;
        this.configureHelp();
        this.configureNavigateSection();
        this.configureMergeSection();
    }

    @Override
    public ToolstripTabConfiguration createConfiguration() {
        return new ComparisonToolstripTabConfiguration(this.fTabConfiguration.getTabName(), this.getTSTabConfigurationFactory(), this.getToolSetFactories());
    }

    private TSTabConfigurationFactory getTSTabConfigurationFactory() {
        return new TSTabConfigurationFactory(){

            @Override
            public TSTabConfiguration createConfiguration() {
                TSTabConfiguration tSTabConfiguration = ComparisonToolstripUtils.readTabConfiguration(TextComparisonTabConfigurationFactory.class, "TextComparisonTab.xml");
                if (!TextComparisonTabConfigurationFactory.this.isMergeSupported()) {
                    tSTabConfiguration.removeSection("merge");
                }
                return tSTabConfiguration;
            }
        };
    }

    private boolean isMergeSupported() {
        return this.fActionManager.hasAction(ActionIdMerge.getInstance().getName());
    }

    private void configureHelp() {
        final TSToolSet tSToolSet = new DefaultHelpToolSetFactory().createToolSet();
        ComparisonHelpAction comparisonHelpAction = new ComparisonHelpAction("matlab_env_textcomparison");
        tSToolSet.getContents().configure("help", (Action)((Object)comparisonHelpAction));
        comparisonHelpAction.putValue("ShortDescription", RESOURCE_BUNDLE.getString("Tool.help.Description"));
        this.fActionManager.addAction(ActionIDHelp.getInstance().getName(), (Action)((Object)comparisonHelpAction));
        tSToolSet.addAction("help", (Action)new ChildAction((Action)((Object)comparisonHelpAction)));
        this.fTabConfiguration.addToolSetFactory(new ToolSetFactory(){

            @Override
            public TSToolSet createToolSet() {
                return tSToolSet;
            }
        });
    }

    private void configureNavigateSection() {
        this.fToolSet = new DefaultNavigateToolSetFactory().createToolSet();
        this.fToolSet.configureAndAdd("previous", (Action)new ChildAction(this.fActionManager.getAction(ActionIDPrevious.getInstance().getName())));
        this.fToolSet.configureAndAdd("next", (Action)new ChildAction(this.fActionManager.getAction(ActionIDNext.getInstance().getName())));
    }

    private void configureMergeSection() {
        this.fTabConfiguration.addToolSetFactory(new ToolSetFactory(){

            @Override
            public TSToolSet createToolSet() {
                TSToolSet tSToolSet = new TSToolSet(TextComparisonTabConfigurationFactory.this.fMergeToolSetContents);
                tSToolSet.configureAndAdd("merge_selected", (Action)new ChildAction(TextComparisonTabConfigurationFactory.this.fActionManager.getAction(ActionIdMerge.getInstance().getName())));
                tSToolSet.configureAndAdd("undo", (Action)new ChildAction(TextComparisonTabConfigurationFactory.this.fActionManager.getAction(ActionIdUndoMerge.getInstance().getName())));
                tSToolSet.configureAndAdd("redo", (Action)new ChildAction(TextComparisonTabConfigurationFactory.this.fActionManager.getAction(ActionIdRedo.getInstance().getName())));
                tSToolSet.configureAndAdd("save", (Action)new ChildAction(TextComparisonTabConfigurationFactory.this.fActionManager.getAction(ActionIdSaveRightFile.getInstance().getName())));
                tSToolSet.configureAndAdd("save_right_file", (Action)new ChildAction(TextComparisonTabConfigurationFactory.this.fActionManager.getAction(ActionIdSaveRightFile.getInstance().getName())));
                tSToolSet.configureAndAdd("save_right_file_as", (Action)new ChildAction(TextComparisonTabConfigurationFactory.this.fActionManager.getAction(ActionIdSaveRightFileAs.getInstance().getName())));
                return tSToolSet;
            }
        });
    }

    private List<ToolSetFactory> getToolSetFactories() {
        ArrayList<ToolSetFactory> arrayList = new ArrayList<ToolSetFactory>();
        arrayList.addAll(this.fTabConfiguration.getToolSetFactories());
        arrayList.add(new ToolSetFactory(){

            @Override
            public TSToolSet createToolSet() {
                return TextComparisonTabConfigurationFactory.this.fToolSet;
            }
        });
        return arrayList;
    }
}

