/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.gui.filter;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.comparisons.filter.list.FileNameFilter;
import com.mathworks.comparisons.filter.list.ListComparisonFilterState;
import com.mathworks.comparisons.filter.list.StringFilter;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.widgets.ButtonFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListComparisonFilterDialog
extends MJPanel {
    private final MJButton fRemoveButton;
    private final MJList fList;
    private final DefaultListModel fModel;
    private final ListComparisonFilterState fFilters;
    private final Collection<FiltersModificationAction> fActions = new ArrayList<FiltersModificationAction>();

    private ListComparisonFilterDialog(ListComparisonFilterState listComparisonFilterState) {
        StringFilter stringFilter2;
        this.fFilters = listComparisonFilterState;
        this.fModel = new DefaultListModel();
        for (StringFilter stringFilter2 : listComparisonFilterState.getFilters()) {
            this.fModel.addElement(new FilterBackedListItem(stringFilter2));
        }
        this.fList = new MJList((ListModel)this.fModel);
        this.fList.setName("FiltersList");
        this.fList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListComparisonFilterDialog.this.fRemoveButton.setEnabled(!ListComparisonFilterDialog.this.fList.getSelectionModel().isSelectionEmpty());
            }
        });
        this.fList.setSelectionMode(0);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n = ListComparisonFilterDialog.this.fList.locationToIndex(mouseEvent.getPoint());
                    ListComparisonFilterDialog.this.edit(n);
                }
            }
        };
        this.fList.addMouseListener((MouseListener)mouseAdapter);
        this.fList.setToolTipText(ResourceManager.getString("filters.doubleclickprompt"));
        stringFilter2 = new MJButton((Action)((Object)new AddFilterAction()));
        stringFilter2.setName("AddFilterButton");
        this.fRemoveButton = new MJButton((Action)((Object)new RemoveFilterAction()));
        this.fRemoveButton.setName("RemoveFilterButton");
        this.fRemoveButton.setEnabled(false);
        JComponent jComponent = ButtonFactory.makeComponentUtilityButtonGroup((AbstractButton[])new AbstractButton[]{stringFilter2, this.fRemoveButton});
        JLabel jLabel = new JLabel(ResourceManager.getString("filters.prompt"));
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("p, 0dlu:grow", "p, 1dlu, fill:p:grow, 1dlu, p"));
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)jLabel, cellConstraints.xyw(1, 1, 2));
        panelBuilder.add((Component)new MJScrollPane((Component)this.fList), cellConstraints.xyw(1, 3, 2));
        panelBuilder.add((Component)jComponent, cellConstraints.xy(1, 5));
        this.setLayout(new BorderLayout());
        this.add(panelBuilder.getPanel(), "Center");
    }

    public static MJFrame getFrame(Component component, ListComparisonFilterState listComparisonFilterState) {
        ListComparisonFilterDialog listComparisonFilterDialog = new ListComparisonFilterDialog(listComparisonFilterState);
        MJFrame mJFrame = new MJFrame(ResourceManager.getString("filters.title"));
        mJFrame.setName("FiltersDialog");
        mJFrame.setContentPane((Container)((Object)listComparisonFilterDialog));
        listComparisonFilterDialog.attachToFrame(mJFrame);
        mJFrame.pack();
        mJFrame.setLocationRelativeTo(component);
        mJFrame.setAlwaysOnTop(true);
        mJFrame.setVisible(true);
        return mJFrame;
    }

    private void attachToFrame(MJFrame mJFrame) {
        MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout(2));
        OKAction oKAction = new OKAction(mJFrame);
        MJButton mJButton = new MJButton((Action)((Object)oKAction));
        mJButton.setName("FiltersOkButton");
        mJPanel.add((Component)mJButton);
        CancelAction cancelAction = new CancelAction(mJFrame);
        MJButton mJButton2 = new MJButton((Action)((Object)cancelAction));
        mJButton2.setName("FiltersCancelButton");
        mJPanel.add((Component)mJButton2);
        MJButton mJButton3 = new MJButton((Action)((Object)new ApplyAction()));
        mJButton3.setName("FiltersApplyButton");
        mJPanel.add((Component)mJButton3);
        this.add((Component)mJPanel, "South");
        this.setBorder(new EmptyBorder(5, 5, 0, 5));
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        mJFrame.getRootPane().registerKeyboardAction((ActionListener)((Object)cancelAction), keyStroke, 2);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(10, 0);
        mJFrame.getRootPane().registerKeyboardAction((ActionListener)((Object)oKAction), keyStroke2, 2);
    }

    public void apply() {
        for (FiltersModificationAction filtersModificationAction : this.fActions) {
            filtersModificationAction.modifyFilters(this.fFilters);
        }
        this.fFilters.saveToPreferences();
    }

    public void edit(int n) {
        String string;
        FilterBackedListItem filterBackedListItem = (FilterBackedListItem)this.fModel.get(n);
        StringFilter stringFilter = this.showEditDialog(filterBackedListItem, string = ResourceManager.getString("filters.editfilter"));
        if (stringFilter != null) {
            this.fActions.add(new FiltersModificationRemoveAction(filterBackedListItem));
            this.fActions.add(new FiltersModificationAddAction(stringFilter));
            this.fModel.setElementAt(new FilterBackedListItem(stringFilter), n);
        }
    }

    public StringFilter showEditDialog(FilterBackedListItem filterBackedListItem, String string) {
        FileNameFilter fileNameFilter = null;
        while (true) {
            String string2 = ResourceManager.getString("filters.enterfilter");
            String string3 = (String)MJOptionPane.showInputDialog((Component)((Object)this), (Object)string2, (String)string, (int)3, null, null, (Object)(filterBackedListItem == null ? null : filterBackedListItem.toString()));
            try {
                if (string3 == null) break;
                fileNameFilter = new FileNameFilter(string3);
            }
            catch (Exception exception) {
                MJOptionPane.showMessageDialog((Component)((Object)this), (Object)exception.getMessage());
                continue;
            }
            break;
        }
        return fileNameFilter;
    }

    private static class FiltersModificationRemoveAction
    implements FiltersModificationAction {
        private final FilterBackedListItem fFilter;

        protected FiltersModificationRemoveAction(FilterBackedListItem filterBackedListItem) {
            this.fFilter = filterBackedListItem;
        }

        @Override
        public void modifyFilters(ListComparisonFilterState listComparisonFilterState) {
            listComparisonFilterState.removeFilter(this.fFilter.getFilter());
        }
    }

    private static class FiltersModificationAddAction
    implements FiltersModificationAction {
        private final StringFilter fFilter;

        protected FiltersModificationAddAction(StringFilter stringFilter) {
            this.fFilter = stringFilter;
        }

        @Override
        public void modifyFilters(ListComparisonFilterState listComparisonFilterState) {
            listComparisonFilterState.addFilter(this.fFilter);
        }
    }

    private static interface FiltersModificationAction {
        public void modifyFilters(ListComparisonFilterState var1);
    }

    private static class FilterBackedListItem {
        private final StringFilter fFilter;

        protected FilterBackedListItem(StringFilter stringFilter) {
            this.fFilter = stringFilter;
        }

        public StringFilter getFilter() {
            return this.fFilter;
        }

        public String toString() {
            return this.fFilter.getName();
        }
    }

    private static class CancelAction
    extends MJAbstractAction {
        private final MJFrame fFrame;

        protected CancelAction(MJFrame mJFrame) {
            super(MJUtilities.intlString((String)"labelCancel"));
            this.fFrame = mJFrame;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.fFrame.dispose();
        }
    }

    private class OKAction
    extends MJAbstractAction {
        private final MJFrame fFrame;

        OKAction(MJFrame mJFrame) {
            super(MJUtilities.intlString((String)"labelOK"));
            this.fFrame = mJFrame;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ListComparisonFilterDialog.this.apply();
            this.fFrame.dispose();
        }
    }

    private class ApplyAction
    extends MJAbstractAction {
        protected ApplyAction() {
            super(MJUtilities.intlString((String)"labelApply"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ListComparisonFilterDialog.this.apply();
        }
    }

    private class AddFilterAction
    extends MJAbstractAction {
        protected AddFilterAction() {
            super("", (Icon)MiscellaneousIcon.ADD_ENTRY.getIcon());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ResourceManager.getString("filters.addfilter");
            StringFilter stringFilter = ListComparisonFilterDialog.this.showEditDialog(null, string);
            if (stringFilter != null) {
                ListComparisonFilterDialog.this.fActions.add(new FiltersModificationAddAction(stringFilter));
                ListComparisonFilterDialog.this.fModel.addElement(new FilterBackedListItem(stringFilter));
            }
        }
    }

    private class RemoveFilterAction
    extends MJAbstractAction {
        protected RemoveFilterAction() {
            super("", (Icon)MiscellaneousIcon.REMOVE_ENTRY.getIcon());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = ListComparisonFilterDialog.this.fList.getSelectionModel().getLeadSelectionIndex();
            FilterBackedListItem filterBackedListItem = (FilterBackedListItem)ListComparisonFilterDialog.this.fModel.getElementAt(n);
            if (filterBackedListItem != null) {
                ListComparisonFilterDialog.this.fActions.add(new FiltersModificationRemoveAction(filterBackedListItem));
                ListComparisonFilterDialog.this.fModel.remove(n);
            }
        }
    }
}

