/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.report;

import com.mathworks.comparisons.event.ComparisonEvent;
import com.mathworks.comparisons.event.ComparisonEventListener;
import com.mathworks.comparisons.event.ComparisonEventSupport;
import com.mathworks.comparisons.event.data.CEventDataRefresh;
import com.mathworks.comparisons.event.data.CEventDataReportClosed;
import com.mathworks.comparisons.event.data.CEventDataReportClosing;
import com.mathworks.comparisons.event.data.CEventDataReportCreated;
import com.mathworks.comparisons.event.data.CEventDataReportOpened;
import com.mathworks.comparisons.report.toolstrip.ComparisonToolstripConfigurationProvider;
import com.mathworks.comparisons.report.toolstrip.ToolstripConfiguration;
import com.mathworks.comparisons.report.toolstrip.ToolstripTabConfiguration;
import com.mathworks.comparisons.selection.dialog.SourceSelectionDialog;
import com.mathworks.comparisons.util.CheckNullArgument;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.MComponentInputMap;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.factory.TSFactory;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTClientProperty;
import com.mathworks.widgets.desk.DTGroupPropertyProvider;
import com.mathworks.widgets.desk.Desktop;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.apache.commons.lang.Validate;

public class ComparisonReport
extends DTClientBase {
    public static final String COMPONENT_CLIENT_NAME = "Comparison Report";
    public static final String CONTEXT_ACTION_PROPERTY_NAME = "IsContextAction";
    private final Desktop fDesktop;
    private final ComparisonEventSupport fEventSupport = new ComparisonEventSupport();
    private final DTClientListener fReportListener = new ComparisonReportListener();
    private final Collection<ToolstripTab> fToolstripTabs = new ArrayList<ToolstripTab>();
    private ToolstripConfiguration fToolstripConfiguration;
    private SourceSelectionDialog fSelectionDialog = null;
    private String fTitle = ResourceManager.getString("comparisonreport.initialtitle");
    private String fShortTitle = null;
    private Component fCentralComponent = null;
    private Object fClientClosingEventData = null;

    public static void createComparisonReport(final Desktop desktop, final DTGroupPropertyProvider dTGroupPropertyProvider, final ComparisonEventListener comparisonEventListener, final SourceSelectionDialog sourceSelectionDialog) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ComparisonReport comparisonReport = new ComparisonReport(desktop, dTGroupPropertyProvider, comparisonEventListener, sourceSelectionDialog);
                desktop.addClient((Component)((Object)comparisonReport), comparisonReport.getTitle());
            }
        });
    }

    private ComparisonReport(Desktop desktop, DTGroupPropertyProvider dTGroupPropertyProvider, ComparisonEventListener comparisonEventListener, SourceSelectionDialog sourceSelectionDialog) {
        CheckNullArgument.check(desktop, "desktop");
        CheckNullArgument.check(comparisonEventListener, "mainEventListener");
        this.fDesktop = desktop;
        this.fSelectionDialog = sourceSelectionDialog;
        ComparisonToolstripConfigurationProvider comparisonToolstripConfigurationProvider = new ComparisonToolstripConfigurationProvider(this.fEventSupport, this.fDesktop, this);
        this.fToolstripConfiguration = comparisonToolstripConfigurationProvider.getConfiguration();
        this.setName(COMPONENT_CLIENT_NAME);
        this.setMultipleInstances(true);
        if (dTGroupPropertyProvider != null) {
            this.setGroup(dTGroupPropertyProvider);
        }
        this.putClientProperty(DTClientProperty.DONT_REOPEN, Boolean.TRUE);
        this.fEventSupport.addComparisonEventListener(comparisonEventListener);
        desktop.addClientListener((Component)((Object)this), this.fReportListener);
        this.initLayout();
        this.fEventSupport.fireComparisonEvent(new ComparisonEvent((Object)this, CEventDataReportCreated.getInstance()));
    }

    public void close() {
        this.fDesktop.closeClient((Component)((Object)this));
    }

    public void addReportListener(ComparisonEventListener comparisonEventListener) {
        this.fEventSupport.addComparisonEventListener(comparisonEventListener);
    }

    public void removeReportListener(ComparisonEventListener comparisonEventListener) {
        this.fEventSupport.removeComparisonEventListener(comparisonEventListener);
    }

    public String getTitle() {
        return this.fTitle;
    }

    public void setTitle(String string) {
        CheckNullArgument.check(string, "title");
        super.setTitle(string);
        this.fTitle = string;
    }

    public String getShortTitle() {
        return this.fShortTitle;
    }

    public void setShortTitle(String string) {
        CheckNullArgument.check(string, "shortTitle");
        super.setShortTitle(string);
        this.fShortTitle = string;
    }

    public Component getCentralComponent() {
        return this.fCentralComponent;
    }

    public void setCentralComponent(Component component) {
        CheckNullArgument.check(component, "component");
        this.fCentralComponent = component;
        this.add(this.fCentralComponent, "Center");
    }

    public void showDialog() {
        if (this.fSelectionDialog != null) {
            this.fSelectionDialog.showDialog();
        }
    }

    public void disposeDialog() {
        if (this.fSelectionDialog != null) {
            this.fSelectionDialog.dispose();
            this.fSelectionDialog = null;
        }
    }

    public void approveClose() {
        this.approveClose(this.fClientClosingEventData);
    }

    public void vetoCloseWithData() {
        this.vetoClose(this.fClientClosingEventData);
    }

    public ToolstripConfiguration getToolstripConfiguration() {
        return this.fToolstripConfiguration;
    }

    public void setToolstripConfiguration(ToolstripConfiguration toolstripConfiguration) {
        Validate.notNull((Object)toolstripConfiguration);
        this.fToolstripConfiguration = toolstripConfiguration;
        this.updateToolstrip();
    }

    public void refresh() {
        this.fEventSupport.fireComparisonEvent(new ComparisonEvent((Object)this, CEventDataRefresh.getInstance()));
    }

    private void initLayout() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("controlLtHighlight")));
        this.setBackground(ColorPrefs.getBackgroundColor());
        this.updateToolstrip();
    }

    private void updateToolstrip() {
        this.disposeToolstrip();
        List<ToolstripTab> list = this.fToolstripConfiguration.createTabs();
        this.fToolstripTabs.clear();
        this.fToolstripTabs.addAll(list);
        this.registerKeyBindings();
        this.registerContextActions();
        this.setToolstripTabs(list.toArray(new ToolstripTab[list.size()]));
    }

    private void disposeToolstrip() {
        for (ToolstripTab toolstripTab : this.fToolstripTabs) {
            TSFactory.disposeTab((ToolstripTab)toolstripTab);
        }
    }

    private void registerKeyBindings() {
        MComponentInputMap mComponentInputMap = new MComponentInputMap((JComponent)((Object)this));
        for (ToolstripTabConfiguration toolstripTabConfiguration : this.fToolstripConfiguration.getTabConfigurations()) {
            List<TSToolSet> list = toolstripTabConfiguration.createToolSets();
            TSFactory.populate((ExtendedInputMap)mComponentInputMap, (ActionMap)this.getActionMap(), (KeyBindingManager)MatlabKeyBindings.getManager(), (TSToolSet[])list.toArray(new TSToolSet[list.size()]));
        }
        this.setInputMap(2, (InputMap)mComponentInputMap);
    }

    private void registerContextActions() {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        for (Action action : this.getActionsFromToolstrip()) {
            if (action.getValue(CONTEXT_ACTION_PROPERTY_NAME) != Boolean.valueOf(true)) continue;
            arrayList.add(action);
        }
        this.setContextActions(arrayList.toArray(new Action[arrayList.size()]));
    }

    private Collection<Action> getActionsFromToolstrip() {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        for (ToolstripTabConfiguration toolstripTabConfiguration : this.fToolstripConfiguration.getTabConfigurations()) {
            List<TSToolSet> list = toolstripTabConfiguration.createToolSets();
            for (TSToolSet tSToolSet : list) {
                Iterator iterator = tSToolSet.getActions().iterator();
                while (iterator.hasNext()) {
                    arrayList.add((Action)((Map.Entry)iterator.next()).getValue());
                }
            }
        }
        return arrayList;
    }

    private class ComparisonReportListener
    extends DTClientAdapter {
        private boolean fFirstTimeActivated = false;

        private ComparisonReportListener() {
        }

        public void clientOpened(DTClientEvent dTClientEvent) {
            this.fFirstTimeActivated = true;
        }

        public void clientActivated(DTClientEvent dTClientEvent) {
            if (this.fFirstTimeActivated) {
                this.fFirstTimeActivated = false;
                this.handleReportOpened();
            }
        }

        public void clientUndocked(DTClientEvent dTClientEvent) {
            this.handleReportDockingChanged();
            ComparisonReport.this.updateToolstrip();
        }

        public void clientDocked(DTClientEvent dTClientEvent) {
            this.handleReportDockingChanged();
            ComparisonReport.this.updateToolstrip();
        }

        public void clientRelocated(DTClientEvent dTClientEvent) {
            this.handleReportDockingChanged();
        }

        public void clientClosed(DTClientEvent dTClientEvent) {
            this.handleReportClosed();
        }

        public void clientClosing(DTClientEvent dTClientEvent) {
            ComparisonReport.this.fClientClosingEventData = dTClientEvent.getData();
            ComparisonReport.this.deferClose();
            this.handleReportClosing();
        }

        private synchronized void dispose() {
            ComparisonReport.this.disposeDialog();
            ComparisonReport.this.fEventSupport.removeAllComparisonEventListeners();
            ComparisonReport.this.fDesktop.removeClientListener((Component)((Object)ComparisonReport.this), ComparisonReport.this.fReportListener);
            ComparisonReport.this.fDesktop.removeClient((Component)((Object)ComparisonReport.this));
            ComparisonReport.this.disposeToolstrip();
        }

        private void handleReportOpened() {
            if (ComparisonReport.this.fSelectionDialog != null) {
                ComparisonReport.this.fSelectionDialog.attach(ComparisonReport.this);
            }
            ComparisonReport.this.fEventSupport.fireComparisonEvent(new ComparisonEvent((Object)this, CEventDataReportOpened.getInstance()));
        }

        private void handleReportDockingChanged() {
            if (ComparisonReport.this.fSelectionDialog != null) {
                ComparisonReport.this.fSelectionDialog.attach(ComparisonReport.this);
            }
        }

        private void handleReportClosed() {
            ComparisonReport.this.fEventSupport.fireComparisonEvent(new ComparisonEvent((Object)this, CEventDataReportClosed.getInstance()));
            this.dispose();
        }

        private void handleReportClosing() {
            ComparisonReport.this.fEventSupport.fireComparisonEvent(new ComparisonEvent((Object)this, CEventDataReportClosing.getInstance()));
        }
    }
}

