/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.report.toolstrip;

import com.mathworks.comparisons.report.toolstrip.ToolstripConfiguration;
import com.mathworks.comparisons.report.toolstrip.ToolstripTabConfiguration;
import com.mathworks.toolstrip.ToolstripTab;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;

public class ComparisonToolstripConfiguration
implements ToolstripConfiguration {
    private final List<ToolstripTabConfiguration> fTabConfigurations = new ArrayList<ToolstripTabConfiguration>();

    @Override
    public void addTab(ToolstripTabConfiguration toolstripTabConfiguration) {
        Validate.notNull((Object)toolstripTabConfiguration);
        if (this.containsTab(toolstripTabConfiguration.getTabName())) {
            this.replaceTab(toolstripTabConfiguration);
        } else {
            this.fTabConfigurations.add(toolstripTabConfiguration);
        }
    }

    @Override
    public List<ToolstripTab> createTabs() {
        ArrayList<ToolstripTab> arrayList = new ArrayList<ToolstripTab>();
        for (ToolstripTabConfiguration toolstripTabConfiguration : this.fTabConfigurations) {
            arrayList.add(toolstripTabConfiguration.createTab());
        }
        return arrayList;
    }

    @Override
    public ToolstripTabConfiguration getTabConfiguration(String string) {
        for (ToolstripTabConfiguration toolstripTabConfiguration : this.fTabConfigurations) {
            if (!toolstripTabConfiguration.getTabName().equals(string)) continue;
            return toolstripTabConfiguration;
        }
        return null;
    }

    @Override
    public List<ToolstripTabConfiguration> getTabConfigurations() {
        return new ArrayList<ToolstripTabConfiguration>(this.fTabConfigurations);
    }

    @Override
    public void removeTab(String string) {
        ToolstripTabConfiguration toolstripTabConfiguration = this.getTabConfiguration(string);
        if (toolstripTabConfiguration != null) {
            this.fTabConfigurations.remove(toolstripTabConfiguration);
        }
    }

    private boolean containsTab(String string) {
        return this.getTabConfiguration(string) != null;
    }

    private void replaceTab(ToolstripTabConfiguration toolstripTabConfiguration) {
        ToolstripTabConfiguration toolstripTabConfiguration2 = this.getTabConfiguration(toolstripTabConfiguration.getTabName());
        if (toolstripTabConfiguration2 == null) {
            return;
        }
        int n = this.fTabConfigurations.indexOf(toolstripTabConfiguration2);
        this.fTabConfigurations.remove(toolstripTabConfiguration2);
        this.fTabConfigurations.add(n, toolstripTabConfiguration);
    }
}

