/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.report.toolstrip;

import com.mathworks.comparisons.filter.ComparisonFilterState;
import com.mathworks.comparisons.filter.ComparisonFilterStateProvider;
import com.mathworks.comparisons.filter.Filter;
import com.mathworks.comparisons.prefs.impl.FilteringModePreference;
import com.mathworks.comparisons.report.toolstrip.DefaultFilterToolSetFactory;
import com.mathworks.comparisons.report.toolstrip.ToolSetFactory;
import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.toolstrip.components.popups.ListActionEvent;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.toolstrip.factory.TSFactory;
import com.mathworks.toolstrip.factory.TSToolSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;

public class FilterToolSetFactory
implements ToolSetFactory {
    private static final String RESOURCE_BUNDLE_NAME = "com.mathworks.comparisons.report.toolstrip.resources.RES_Filter_Comparison_Toolstrip";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.mathworks.comparisons.report.toolstrip.resources.RES_Filter_Comparison_Toolstrip");
    private final ComparisonFilterStateProvider<Filter> fFiltersProvider;
    private final Map<Filter, Boolean> fFilterStates = new HashMap<Filter, Boolean>();
    private final ActionListener fFilterActionListener;
    private final MJAbstractAction fApplyFilters;
    private final Collection<ListItem> fFilterItems = new ArrayList<ListItem>();
    private final TSToolSet.ListDecorator fDecorator;
    private boolean fIsAutoExecuteOn = FilteringModePreference.getInstance().isAutoModeOn();
    private ComparisonFilterState<Filter> fFilters;

    public FilterToolSetFactory(ComparisonFilterStateProvider<Filter> comparisonFilterStateProvider, ActionListener actionListener) {
        this(comparisonFilterStateProvider, actionListener, null);
    }

    public FilterToolSetFactory(ComparisonFilterStateProvider<Filter> comparisonFilterStateProvider, ActionListener actionListener, TSToolSet.ListDecorator listDecorator) {
        this.fFiltersProvider = comparisonFilterStateProvider;
        this.fFilterActionListener = actionListener;
        this.fDecorator = listDecorator;
        this.fApplyFilters = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterToolSetFactory.allowMultiSelect(actionEvent);
                FilterToolSetFactory.this.triggerFiltering();
            }
        };
    }

    @Override
    public TSToolSet createToolSet() {
        TSToolSet tSToolSet = new DefaultFilterToolSetFactory().createToolSet();
        tSToolSet.configureAndAdd("apply_filter", (Action)new ChildAction((Action)this.fApplyFilters));
        tSToolSet.addListDecorator("filters", new TSToolSet.ListDecorator(){

            public void decorateList(PopupList popupList) {
                FilterToolSetFactory.this.fFilters = FilterToolSetFactory.this.fFiltersProvider.getFilters();
                FilterToolSetFactory.this.decorateFilterList(popupList);
                if (FilterToolSetFactory.this.fDecorator != null) {
                    FilterToolSetFactory.this.fDecorator.decorateList(popupList);
                }
                FilterToolSetFactory.this.setInitialEnabledStates(popupList);
            }
        });
        tSToolSet.configureAndAdd("auto_mode", (Action)new ChildAction(this.createAutoModeAction()));
        return tSToolSet;
    }

    private void decorateFilterList(PopupList popupList) {
        this.initFilterStates();
        DefaultListModel defaultListModel = (DefaultListModel)popupList.getModel();
        int n = 1;
        defaultListModel.add(n++, FilterToolSetFactory.createHeaderItem());
        if (this.fFilters.getFilters().isEmpty()) {
            defaultListModel.add(n, FilterToolSetFactory.createNoFiltersItem());
        } else {
            this.createFilterItems();
            for (ListItem listItem : this.fFilterItems) {
                defaultListModel.add(n++, listItem);
            }
        }
        popupList.setModel((ListModel)defaultListModel);
        popupList.setName("FiltersPopupList");
        popupList.addListActionListener((ListActionListener)new TSFactory.ListListenerBridge());
    }

    private Filter getFilterFromItem(ListItem listItem) {
        for (Filter filter : this.fFilters.getFilters()) {
            if (!filter.getID().equals(listItem.getName())) continue;
            return filter;
        }
        return null;
    }

    private void initFilterStates() {
        if (this.fFilterStates.isEmpty()) {
            for (Filter filter : this.fFilters.getFilters()) {
                this.fFilterStates.put(filter, this.fFilters.isEnabled(filter));
            }
        }
    }

    private Action createAutoModeAction() {
        return new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterToolSetFactory.allowMultiSelect(actionEvent);
                if (!(actionEvent instanceof ListActionEvent)) {
                    return;
                }
                ListItem listItem = ((ListActionEvent)actionEvent).getListItem();
                if (listItem == null) {
                    return;
                }
                boolean bl = (Boolean)listItem.getAttributes().getAttribute((Attribute)ListItem.CHECKVALUE_STATE);
                FilterToolSetFactory.this.fIsAutoExecuteOn = !bl;
                FilteringModePreference.getInstance().setIsAutoModeOn(FilterToolSetFactory.this.fIsAutoExecuteOn);
                PopupList popupList = (PopupList)actionEvent.getSource();
                if (FilterToolSetFactory.this.fIsAutoExecuteOn) {
                    FilterToolSetFactory.this.resetFilterStates();
                    FilterToolSetFactory.setApplyFiltersEnabledState(popupList, false);
                } else if (!FilterToolSetFactory.this.fFilterItems.isEmpty()) {
                    FilterToolSetFactory.setApplyFiltersEnabledState(popupList, true);
                }
            }
        };
    }

    private void setInitialEnabledStates(PopupList popupList) {
        ListItem listItem;
        boolean bl = FilteringModePreference.getInstance().isAutoModeOn();
        ListItem listItem2 = FilterToolSetFactory.getListItemByName(popupList, "auto_mode");
        if (listItem2 != null) {
            listItem2.setAttribute((Attribute)ListItem.CHECKVALUE_STATE, (Object)bl);
        }
        if ((listItem = FilterToolSetFactory.getListItemByName(popupList, "apply_filter")) != null) {
            if (this.fFilterItems.isEmpty()) {
                listItem.setAttribute((Attribute)ListItem.ENABLED_STATE, (Object)false);
            } else {
                listItem.setAttribute((Attribute)ListItem.ENABLED_STATE, (Object)(!bl ? 1 : 0));
            }
        }
    }

    private static ListItem getListItemByName(PopupList popupList, String string) {
        ListModel listModel = popupList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            ListItem listItem = (ListItem)listModel.getElementAt(i);
            if (!string.equals(listItem.getName())) continue;
            return listItem;
        }
        return null;
    }

    private static void setApplyFiltersEnabledState(PopupList popupList, boolean bl) {
        ListItem listItem = FilterToolSetFactory.getListItemByName(popupList, "apply_filter");
        if (listItem != null) {
            listItem.setAttribute((Attribute)ListItem.ENABLED_STATE, (Object)bl);
        }
    }

    private void resetFilterStates() {
        this.fFilterStates.clear();
        this.initFilterStates();
        for (ListItem listItem : this.fFilterItems) {
            Filter filter = this.getFilterFromItem(listItem);
            listItem.setAttribute((Attribute)ListItem.CHECKVALUE_STATE, (Object)this.fFilterStates.get(filter));
        }
    }

    private static ListItem createHeaderItem() {
        return ListItem.newHeader((String)"filters_group", (String)RESOURCE_BUNDLE.getString("Tool.filters_group.Label"), null);
    }

    private static ListItem createNoFiltersItem() {
        ListItem listItem = new ListItem("no_filters");
        listItem.setAttribute((Attribute)ListItem.TITLE, (Object)RESOURCE_BUNDLE.getString("List.filter.no.filters.available"));
        listItem.setAttribute((Attribute)ListItem.ENABLED_STATE, (Object)false);
        return listItem;
    }

    private void createFilterItems() {
        this.fFilterItems.clear();
        for (Filter filter : this.fFilters.getFilters()) {
            if (!this.fFilters.isVisible(filter)) continue;
            this.fFilterItems.add(this.createFilterItem(filter));
        }
    }

    private ListItem createFilterItem(final Filter filter) {
        final ListItem listItem = new ListItem(filter.getID());
        listItem.setAttribute((Attribute)ListItem.TITLE, (Object)filter.getName());
        listItem.setAttribute((Attribute)ListItem.HAS_CHECKBOX, (Object)true);
        listItem.setAttribute((Attribute)ListItem.CHECKVALUE_STATE, (Object)this.fFilterStates.get(filter));
        MJAbstractAction mJAbstractAction = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterToolSetFactory.allowMultiSelect(actionEvent);
                boolean bl = (Boolean)listItem.getAttributes().getAttribute((Attribute)ListItem.CHECKVALUE_STATE);
                FilterToolSetFactory.this.fFilterStates.put(filter, !bl);
                if (FilterToolSetFactory.this.fIsAutoExecuteOn) {
                    FilterToolSetFactory.this.triggerFiltering();
                }
            }
        };
        listItem.setAttribute(TSFactory.ACTION_ATTRIBUTE, (Object)mJAbstractAction);
        return listItem;
    }

    private static void allowMultiSelect(ActionEvent actionEvent) {
        if (!(actionEvent.getSource() instanceof Component)) {
            return;
        }
        Component component = (Component)actionEvent.getSource();
        OverlayManager overlayManager = OverlayManagers.get((Component)component);
        if (overlayManager != null) {
            overlayManager.setAllowMultiSelect(component, true);
        }
    }

    private void triggerFiltering() {
        this.updateFilterStates();
        this.notifyListener();
    }

    private void updateFilterStates() {
        for (Map.Entry<Filter, Boolean> entry : this.fFilterStates.entrySet()) {
            Filter filter = entry.getKey();
            boolean bl = entry.getValue();
            this.updateFilterState(filter, bl);
        }
    }

    private void updateFilterState(Filter filter, boolean bl) {
        for (Filter filter2 : this.fFilters.getFilters()) {
            if (!filter2.getID().equals(filter.getID())) continue;
            this.fFilters.setEnabled(filter2, bl);
        }
    }

    private void notifyListener() {
        this.fFilterActionListener.actionPerformed(new ActionEvent(this.fFilters, 0, "filters"));
        this.fFilterStates.clear();
    }
}

