/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.util;

import com.mathworks.comparisons.prefs.ColorProfile;
import com.mathworks.comparisons.prefs.ColorProfileSerializer;
import com.mathworks.comparisons.util.ComparisonColors;
import java.util.List;

public class ColorManager {
    private static ColorManager sColorManagerInstance = null;
    private static ColorProfile sCurrentProfile;

    private ColorManager() {
    }

    public static synchronized ColorManager getInstance() {
        if (sColorManagerInstance == null) {
            sColorManagerInstance = new ColorManager();
        }
        return sColorManagerInstance;
    }

    public void initializeCurrentProfileColors() {
        sCurrentProfile = this.getInitialProfile();
        this.updateColors();
    }

    public void updateCurrentProfile(ColorProfile colorProfile) {
        sCurrentProfile = colorProfile;
        this.updateColors();
    }

    public static synchronized ColorProfile getCurrentProfile() {
        return sCurrentProfile;
    }

    private void updateColors() {
        ComparisonColors.setAddedColor(sCurrentProfile.getRightDifferenceColor());
        ComparisonColors.setRemovedColor(sCurrentProfile.getLeftDifferenceColor());
        ComparisonColors.setModifiedLineColor(sCurrentProfile.getModifiedLineColor());
        ComparisonColors.setModifiedContentColor(sCurrentProfile.getModifiedContentColor());
        ComparisonColors.setMergedColor(sCurrentProfile.getMergedColor());
    }

    public ColorProfile getInitialProfile() {
        if (!this.doesSettingsFileExist()) {
            return this.getDefaultProfile();
        }
        return this.getLastChosenProfile();
    }

    public ColorProfile getProfileByName(String string) {
        return ColorProfileSerializer.getProfileByName(string);
    }

    public void saveProfile(ColorProfile colorProfile) {
        this.createNewSettingsFileIfItIsMissing();
        ColorProfileSerializer.saveProfile(colorProfile);
    }

    public void removeProfileByName(String string) {
        ColorProfileSerializer.removeProfileByName(string);
    }

    public List<String> getProfileNames() {
        this.createNewSettingsFileIfItIsMissing();
        return ColorProfileSerializer.getProfileNames();
    }

    public ColorProfile getLastChosenProfile() {
        return ColorProfileSerializer.getLastChosenProfile();
    }

    public void setLastChosenProfileName(String string) {
        ColorProfileSerializer.setLastChosenProfileName(string);
    }

    public ColorProfile getDefaultProfile() {
        return ColorProfileSerializer.getDefaultProfile();
    }

    private void createNewSettingsFileIfItIsMissing() {
        if (!this.doesSettingsFileExist()) {
            ColorProfileSerializer.createNewSettingsFile();
        }
    }

    private boolean doesSettingsFileExist() {
        return ColorProfileSerializer.doesSettingsFileExist();
    }
}

