/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.AbstractToolbuttonPeer;
import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.FigurePeer;
import com.mathworks.hg.peer.FigureValidator;
import com.mathworks.hg.util.HGPeerQueueUser;
import com.mathworks.hg.util.HGPeerRunnable;
import com.mathworks.hg.util.HGUtils;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicBorders;

public class ToolbarPeer
implements HGPeerQueueUser {
    MJToolBar fToolBar;
    FigurePeer fParentFigure = null;
    private static MJToolBar sDummyToolbar;
    private static MJButton sDummyButton;
    private static Dimension sToolbarMinimumSize;
    private static Dimension sToolButtonMinimumSize;
    private static Border sToolbarBorder;
    private static final int sFirstMethodIndex = 0;
    protected static final int sAddToolbarView = 0;
    protected static final int sRemoveToolbarView = 1;
    protected static final int sSetToolbarVisible = 2;
    protected static final int sCreateToolbarPeer = 3;
    protected static final int sAddToolbarComponent = 4;
    protected static final int sRemoveToolbarComponent = 5;
    protected static final int sSetComponentName = 6;
    private static final int sLastMethodIndex = 5;
    private static final String[] sLogMessages;

    public ToolbarPeer() {
        HGUtils.invokeLater(new HGPeerRunnable(this, 3, 2){

            @Override
            public void run() {
                ToolbarPeer.this.doCreateToolbarPeer();
            }
        });
    }

    protected void doCreateToolbarPeer() {
        assert (SwingUtilities.isEventDispatchThread());
        this.fToolBar = new MJToolBar(0);
        ToolbarPeer.configureToolbar(this.fToolBar);
    }

    static void configureToolbar(MJToolBar mJToolBar) {
        mJToolBar.setVisible(false);
        mJToolBar.setFloatable(false);
        mJToolBar.setEnabled(true);
        mJToolBar.setCursor(Cursor.getDefaultCursor());
        mJToolBar.setPreferredSize(ToolbarPeer.getPreferredToolbarMinimumSize());
        if (PlatformInfo.isVersion14() && null != sToolbarBorder) {
            if (PlatformInfo.isWindows()) {
                mJToolBar.setBorder((Border)BorderFactory.createCompoundBorder(sToolbarBorder, mJToolBar.getBorder()));
            } else {
                mJToolBar.setBorder(sToolbarBorder);
            }
        }
    }

    static void configureButton(MJButton mJButton) {
        MJToolBar.configureButton((MJButton)mJButton);
    }

    static void configureButton(MJToggleButton mJToggleButton) {
        MJToolBar.configureButton((MJToggleButton)mJToggleButton, (boolean)false);
        if (PlatformInfo.isMacintosh()) {
            mJToggleButton.setBorderPainted(true);
        }
    }

    public void add(Component component) {
        this.add(component, -1);
    }

    void add(final Component component, final int n) {
        if (this.doPreAdd(component, n)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 4, 0, false){

                @Override
                public void run() {
                    ToolbarPeer.this.doAdd(component, n);
                }
            });
        }
    }

    protected boolean doPreAdd(Component component, int n) {
        this.addLogMessage(4);
        return true;
    }

    protected void doAdd(Component component, int n) {
        if (null != this.fToolBar) {
            this.fToolBar.add(component, n);
            if (PlatformInfo.isXWindows()) {
                this.fToolBar.repaint();
            }
        }
    }

    public void remove(final Component component) {
        if (this.doPreRemove(component)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 5, 1, false){

                @Override
                public void run() {
                    ToolbarPeer.this.doRemove(component);
                }
            });
        }
    }

    protected boolean doPreRemove(Component component) {
        this.addLogMessage(5);
        return true;
    }

    protected void doRemove(Component component) {
        if (null != this.fToolBar) {
            this.fToolBar.remove(component);
            this.fToolBar.repaint();
        }
    }

    public MJToolBar getComponentPeer() {
        return this.fToolBar;
    }

    @Override
    public FigureValidator getParentFigureValidator() {
        return this.fParentFigure;
    }

    @Override
    public int getUserLastMethodID() {
        return ToolbarPeer.getLastMethodIndex();
    }

    @Override
    public String getUserMethodDescription(int n) {
        String string = null;
        if (n >= 0 && n <= 5) {
            string = sLogMessages[n - 0];
        }
        return string;
    }

    protected static int getLastMethodIndex() {
        return 5;
    }

    static Dimension getPreferredToolbarMinimumSize() {
        return sToolbarMinimumSize;
    }

    static Dimension getPreferredToolButtonMinimumSize() {
        return sToolButtonMinimumSize;
    }

    public final void addToolbar(final FigurePeer figurePeer) {
        if (this.doPreAddToolbar(figurePeer)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 0, 0){

                @Override
                public void run() {
                    ToolbarPeer.this.doAddToolbar(figurePeer);
                }
            });
        }
    }

    public final void removeToolbar() {
        if (this.doPreRemoveToolbar()) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 1, 1){

                @Override
                public void run() {
                    ToolbarPeer.this.doRemoveToolbar();
                }
            });
        }
    }

    public final void setToolbarVisible(final boolean bl) {
        if (this.doPreSetToolbarVisible(bl)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 2){

                @Override
                public void run() {
                    ToolbarPeer.this.doSetToolbarVisible(bl);
                }
            });
        }
    }

    public final void setComponentName(final String string) {
        if (this.doPreSetName(string)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 6){

                @Override
                public void run() {
                    ToolbarPeer.this.doSetName(string);
                }
            });
        }
    }

    protected boolean doPreAddToolbar(FigurePeer figurePeer) {
        this.addLogMessage(0);
        return true;
    }

    protected void doAddToolbar(FigurePeer figurePeer) {
        this.fParentFigure = figurePeer;
        if (this.fToolBar.isVisible()) {
            this.fParentFigure.addToolBar((JToolBar)this.fToolBar);
        }
    }

    protected boolean doPreRemoveToolbar() {
        this.addLogMessage(1);
        return true;
    }

    protected void doRemoveToolbar() {
        if (null != this.fToolBar) {
            this.fToolBar.removeAll();
        }
        if (this.fParentFigure != null) {
            this.fParentFigure.removeToolBar((JToolBar)this.fToolBar);
            this.fParentFigure = null;
        }
    }

    protected boolean doPreSetToolbarVisible(boolean bl) {
        this.addLogMessage(2);
        return true;
    }

    protected void doSetToolbarVisible(boolean bl) {
        if (this.fToolBar.isVisible() != bl) {
            this.fToolBar.setVisible(bl);
            if (this.fParentFigure != null) {
                if (bl) {
                    this.fParentFigure.addToolBar((JToolBar)this.fToolBar);
                } else {
                    this.fParentFigure.removeToolBar((JToolBar)this.fToolBar);
                }
            }
        }
    }

    protected boolean doPreSetName(String string) {
        this.addLogMessage(6);
        return true;
    }

    protected void doSetName(String string) {
        this.fToolBar.setName(string);
    }

    FigurePeer getParentFigure() {
        return this.fParentFigure;
    }

    public final void addLogMessage(int n) {
        if (DebugUtilities.isDebugOptions() && n <= ToolbarPeer.getLastMethodIndex()) {
            DebugUtilities.logMessage(32, this.getClass().getName() + "." + this.getUserMethodDescription(n), this);
        }
    }

    public final void addLogMessage(String string) {
        if (DebugUtilities.isDebugOptions()) {
            DebugUtilities.logMessage(32, string, this);
        }
    }

    static {
        sToolbarBorder = null;
        sLogMessages = new String[]{"addToolbar", "removeToolbar", "setToolbarVisible", "createToolbar", "addToolbarComponent", "removeToolbarComponent", "setComponentName"};
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n;
                assert (SwingUtilities.isEventDispatchThread());
                sDummyToolbar = new MJToolBar();
                ToolbarPeer.configureToolbar(sDummyToolbar);
                sDummyButton = new MJButton((Icon)new ImageIcon(ToolbarPeer.class.getResource("resources/dummy.gif")));
                ToolbarPeer.configureButton(sDummyButton);
                sDummyButton.setMargin(AbstractToolbuttonPeer.sMinimumToolInsets);
                sDummyToolbar.add((Component)sDummyButton);
                sToolbarMinimumSize = sDummyToolbar.getPreferredSize();
                sToolButtonMinimumSize = sDummyButton.getPreferredSize();
                sToolButtonMinimumSize.width = n = Math.max(sToolButtonMinimumSize.width, sToolButtonMinimumSize.height);
                sToolButtonMinimumSize.height = n;
                if (PlatformInfo.isVersion14()) {
                    sToolbarBorder = BasicBorders.getMenuBarBorder();
                }
            }
        });
    }
}

