/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer.event;

import com.mathworks.hg.peer.UITreeNode;
import com.mathworks.hg.peer.UITreePeer;
import com.mathworks.hg.peer.event.NodeDroppedEvent;
import java.awt.Point;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import javax.swing.tree.TreePath;

public class UITreeDropListener
extends DropTargetAdapter {
    private UITreePeer fUITree;
    private boolean fLastDragAccepted = false;

    public UITreeDropListener(UITreePeer uITreePeer) {
        this.fUITree = uITreePeer;
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Point point = dropTargetDropEvent.getLocation();
        TreePath treePath = this.fUITree.getTree().getPathForLocation(point.x, point.y);
        UITreeNode uITreeNode = null;
        if (null != treePath) {
            uITreeNode = (UITreeNode)treePath.getLastPathComponent();
        }
        UITreeNode[] uITreeNodeArray = this.fUITree.getSelectedNodes();
        if (null != uITreeNode && null != uITreeNodeArray[0]) {
            this.fUITree.fireNodeDropped(new NodeDroppedEvent(uITreeNodeArray[0], uITreeNode));
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        super.dragExit(dropTargetEvent);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        super.dragOver(dropTargetDragEvent);
        Point point = new Point(dropTargetDragEvent.getLocation().x, dropTargetDragEvent.getLocation().y);
        this.fUITree.getTree().drawDragImage(point, this.fLastDragAccepted);
    }

    public void acceptDrag(DropTargetDragEvent dropTargetDragEvent, int n) {
        this.fLastDragAccepted = true;
        dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
    }

    public void rejectDrag(DropTargetDragEvent dropTargetDragEvent) {
        this.fLastDragAccepted = false;
        dropTargetDragEvent.rejectDrag();
    }
}

